/*
 * Decompiled with CFR 0.152.
 */
package com.github.amlcurran.showcaseview;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.text.DynamicLayout;
import android.text.Layout;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.TextAppearanceSpan;
import com.github.amlcurran.showcaseview.R;

class TextDrawer {
    private static final int INDEX_TEXT_START_X = 0;
    private static final int INDEX_TEXT_START_Y = 1;
    private static final int INDEX_TEXT_WIDTH = 2;
    private final TextPaint titlePaint;
    private final TextPaint textPaint;
    private final Context context;
    private final float padding;
    private final float actionBarOffset;
    private Layout.Alignment detailTextAlignment = Layout.Alignment.ALIGN_NORMAL;
    private Layout.Alignment titleTextAlignment = Layout.Alignment.ALIGN_NORMAL;
    private CharSequence mTitle;
    private CharSequence mDetails;
    private float[] mBestTextPosition = new float[3];
    private DynamicLayout mDynamicTitleLayout;
    private DynamicLayout mDynamicDetailLayout;
    private TextAppearanceSpan mTitleSpan;
    private TextAppearanceSpan mDetailSpan;
    private boolean hasRecalculated;
    private int forcedTextPosition = -1;

    public TextDrawer(Resources resources, Context context) {
        this.padding = resources.getDimension(R.dimen.text_padding);
        this.actionBarOffset = resources.getDimension(R.dimen.action_bar_offset);
        this.context = context;
        this.titlePaint = new TextPaint();
        this.titlePaint.setAntiAlias(true);
        this.textPaint = new TextPaint();
        this.textPaint.setAntiAlias(true);
    }

    public void draw(Canvas canvas) {
        if (this.shouldDrawText()) {
            float[] textPosition = this.getBestTextPosition();
            if (!TextUtils.isEmpty((CharSequence)this.mTitle)) {
                canvas.save();
                if (this.hasRecalculated) {
                    this.mDynamicTitleLayout = new DynamicLayout(this.mTitle, this.titlePaint, (int)this.mBestTextPosition[2], this.titleTextAlignment, 1.0f, 1.0f, true);
                }
                if (this.mDynamicTitleLayout != null) {
                    canvas.translate(textPosition[0], textPosition[1]);
                    this.mDynamicTitleLayout.draw(canvas);
                    canvas.restore();
                }
            }
            if (!TextUtils.isEmpty((CharSequence)this.mDetails)) {
                float offsetForTitle;
                canvas.save();
                if (this.hasRecalculated) {
                    this.mDynamicDetailLayout = new DynamicLayout(this.mDetails, this.textPaint, (int)this.mBestTextPosition[2], this.detailTextAlignment, 1.2f, 1.0f, true);
                }
                float f = offsetForTitle = this.mDynamicTitleLayout != null ? (float)this.mDynamicTitleLayout.getHeight() : 0.0f;
                if (this.mDynamicDetailLayout != null) {
                    canvas.translate(textPosition[0], textPosition[1] + offsetForTitle);
                    this.mDynamicDetailLayout.draw(canvas);
                    canvas.restore();
                }
            }
        }
        this.hasRecalculated = false;
    }

    public void setContentText(CharSequence details) {
        if (details != null) {
            SpannableString ssbDetail = new SpannableString(details);
            ssbDetail.setSpan((Object)this.mDetailSpan, 0, ssbDetail.length(), 0);
            this.mDetails = ssbDetail;
        }
    }

    public void setContentTitle(CharSequence title) {
        if (title != null) {
            SpannableString ssbTitle = new SpannableString(title);
            ssbTitle.setSpan((Object)this.mTitleSpan, 0, ssbTitle.length(), 0);
            this.mTitle = ssbTitle;
        }
    }

    public void calculateTextPosition(int canvasW, int canvasH, boolean shouldCentreText, Rect showcase) {
        int[] areas = new int[]{showcase.left * canvasH, showcase.top * canvasW, (canvasW - showcase.right) * canvasH, (canvasH - showcase.bottom) * canvasW};
        int largest = 0;
        for (int i = 1; i < areas.length; ++i) {
            if (areas[i] <= areas[largest]) continue;
            largest = i;
        }
        if (this.forcedTextPosition != -1) {
            largest = this.forcedTextPosition;
        }
        switch (largest) {
            case 0: {
                this.mBestTextPosition[0] = this.padding;
                this.mBestTextPosition[1] = this.padding;
                this.mBestTextPosition[2] = (float)showcase.left - 2.0f * this.padding;
                break;
            }
            case 1: {
                this.mBestTextPosition[0] = this.padding;
                this.mBestTextPosition[1] = this.padding + this.actionBarOffset;
                this.mBestTextPosition[2] = (float)canvasW - 2.0f * this.padding;
                break;
            }
            case 2: {
                this.mBestTextPosition[0] = (float)showcase.right + this.padding;
                this.mBestTextPosition[1] = this.padding;
                this.mBestTextPosition[2] = (float)(canvasW - showcase.right) - 2.0f * this.padding;
                break;
            }
            case 3: {
                this.mBestTextPosition[0] = this.padding;
                this.mBestTextPosition[1] = (float)showcase.bottom + this.padding;
                this.mBestTextPosition[2] = (float)canvasW - 2.0f * this.padding;
            }
        }
        if (shouldCentreText) {
            switch (largest) {
                case 0: 
                case 2: {
                    this.mBestTextPosition[1] = this.mBestTextPosition[1] + (float)(canvasH / 4);
                    break;
                }
                case 1: 
                case 3: {
                    this.mBestTextPosition[2] = this.mBestTextPosition[2] / 2.0f;
                    this.mBestTextPosition[0] = this.mBestTextPosition[0] + (float)(canvasW / 4);
                }
            }
        } else {
            switch (largest) {
                case 0: 
                case 2: {
                    this.mBestTextPosition[1] = this.mBestTextPosition[1] + this.actionBarOffset;
                }
            }
        }
        this.hasRecalculated = true;
    }

    public void setTitleStyling(int styleId) {
        this.mTitleSpan = new TextAppearanceSpan(this.context, styleId);
        this.setContentTitle(this.mTitle);
    }

    public void setDetailStyling(int styleId) {
        this.mDetailSpan = new TextAppearanceSpan(this.context, styleId);
        this.setContentText(this.mDetails);
    }

    public float[] getBestTextPosition() {
        return this.mBestTextPosition;
    }

    public boolean shouldDrawText() {
        return !TextUtils.isEmpty((CharSequence)this.mTitle) || !TextUtils.isEmpty((CharSequence)this.mDetails);
    }

    public void setContentPaint(TextPaint contentPaint) {
        this.textPaint.set(contentPaint);
    }

    public void setTitlePaint(TextPaint textPaint) {
        this.titlePaint.set(textPaint);
    }

    public void setDetailTextAlignment(Layout.Alignment textAlignment) {
        this.detailTextAlignment = textAlignment;
    }

    public void setTitleTextAlignment(Layout.Alignment titleTextAlignment) {
        this.titleTextAlignment = titleTextAlignment;
    }

    public void forceTextPosition(int textPosition) {
        if (textPosition > 3 || textPosition < -1) {
            throw new IllegalArgumentException("ShowcaseView text was forced with an invalid position");
        }
        this.forcedTextPosition = textPosition;
    }
}

