/*
 * Decompiled with CFR 0.152.
 */
package com.github.amlcurran.showcaseview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.graphics.Point;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import com.github.amlcurran.showcaseview.AnimationFactory;
import com.github.amlcurran.showcaseview.ShowcaseView;

@TargetApi(value=11)
class AnimatorAnimationFactory
implements AnimationFactory {
    private static final String ALPHA = "alpha";
    private static final float INVISIBLE = 0.0f;
    private static final float VISIBLE = 1.0f;
    private final AccelerateDecelerateInterpolator interpolator = new AccelerateDecelerateInterpolator();

    @Override
    public void fadeInView(View target, long duration, final AnimationFactory.AnimationStartListener listener) {
        ObjectAnimator oa = ObjectAnimator.ofFloat((Object)target, (String)ALPHA, (float[])new float[]{0.0f, 1.0f});
        oa.setDuration(duration).addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animator) {
                listener.onAnimationStart();
            }
        });
        oa.start();
    }

    @Override
    public void fadeOutView(View target, long duration, final AnimationFactory.AnimationEndListener listener) {
        ObjectAnimator oa = ObjectAnimator.ofFloat((Object)target, (String)ALPHA, (float[])new float[]{0.0f});
        oa.setDuration(duration).addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                listener.onAnimationEnd();
            }
        });
        oa.start();
    }

    @Override
    public void animateTargetToPoint(ShowcaseView showcaseView, Point point) {
        AnimatorSet set = new AnimatorSet();
        ObjectAnimator xAnimator = ObjectAnimator.ofInt((Object)showcaseView, (String)"showcaseX", (int[])new int[]{point.x});
        ObjectAnimator yAnimator = ObjectAnimator.ofInt((Object)showcaseView, (String)"showcaseY", (int[])new int[]{point.y});
        set.playTogether(new Animator[]{xAnimator, yAnimator});
        set.setInterpolator((TimeInterpolator)this.interpolator);
        set.start();
    }
}

