/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import org.apache.commons.collections4.bloomfilter.BitMapExtractor;
import org.apache.commons.collections4.bloomfilter.BloomFilter;
import org.apache.commons.collections4.bloomfilter.BloomFilterExtractor;
import org.apache.commons.collections4.bloomfilter.Hasher;
import org.apache.commons.collections4.bloomfilter.IndexExtractor;
import org.apache.commons.collections4.bloomfilter.LayerManager;
import org.apache.commons.collections4.bloomfilter.SetOperations;
import org.apache.commons.collections4.bloomfilter.Shape;
import org.apache.commons.collections4.bloomfilter.SimpleBloomFilter;

public class LayeredBloomFilter<T extends BloomFilter<T>>
implements BloomFilter<LayeredBloomFilter<T>>,
BloomFilterExtractor {
    private final Shape shape;
    private final LayerManager<T> layerManager;

    public LayeredBloomFilter(Shape shape, LayerManager<T> layerManager) {
        this.shape = shape;
        this.layerManager = layerManager;
    }

    @Override
    public int cardinality() {
        return SetOperations.cardinality(this);
    }

    @Override
    public int characteristics() {
        return 0;
    }

    public void cleanup() {
        this.layerManager.cleanup();
    }

    @Override
    public final void clear() {
        this.layerManager.clear();
    }

    @Override
    public boolean contains(BitMapExtractor bitMapExtractor) {
        return this.contains((BloomFilter)this.createFilter(bitMapExtractor));
    }

    @Override
    public boolean contains(BloomFilter other) {
        return other instanceof BloomFilterExtractor ? this.contains((BloomFilterExtractor)((Object)other)) : !this.processBloomFilters(x -> !x.contains(other));
    }

    public boolean contains(BloomFilterExtractor bloomFilterExtractor) {
        boolean[] result = new boolean[]{true};
        return bloomFilterExtractor.processBloomFilters(x -> {
            result[0] = result[0] & this.contains((BloomFilter)x);
            return result[0];
        });
    }

    @Override
    public boolean contains(Hasher hasher2) {
        return this.contains((BloomFilter)this.createFilter(hasher2));
    }

    @Override
    public boolean contains(IndexExtractor indexExtractor) {
        return this.contains((BloomFilter)this.createFilter(indexExtractor));
    }

    @Override
    public LayeredBloomFilter<T> copy() {
        return new LayeredBloomFilter<T>(this.shape, this.layerManager.copy());
    }

    private SimpleBloomFilter createFilter(BitMapExtractor bitMapExtractor) {
        SimpleBloomFilter bf = new SimpleBloomFilter(this.shape);
        bf.merge(bitMapExtractor);
        return bf;
    }

    private SimpleBloomFilter createFilter(Hasher hasher2) {
        SimpleBloomFilter bf = new SimpleBloomFilter(this.shape);
        bf.merge(hasher2);
        return bf;
    }

    private SimpleBloomFilter createFilter(IndexExtractor indexExtractor) {
        SimpleBloomFilter bf = new SimpleBloomFilter(this.shape);
        bf.merge(indexExtractor);
        return bf;
    }

    @Override
    public int estimateN() {
        return this.flatten().estimateN();
    }

    @Override
    public int estimateUnion(BloomFilter other) {
        Objects.requireNonNull(other, "other");
        SimpleBloomFilter cpy = this.flatten();
        cpy.merge(other);
        return cpy.estimateN();
    }

    public int[] find(BitMapExtractor bitMapExtractor) {
        SimpleBloomFilter bf = new SimpleBloomFilter(this.shape);
        bf.merge(bitMapExtractor);
        return this.find(bf);
    }

    public int[] find(BloomFilter bf) {
        Finder finder = new Finder(bf);
        this.processBloomFilters(finder);
        return finder.getResult();
    }

    public int[] find(Hasher hasher2) {
        SimpleBloomFilter bf = new SimpleBloomFilter(this.shape);
        bf.merge(hasher2);
        return this.find(bf);
    }

    public int[] find(IndexExtractor indexExtractor) {
        SimpleBloomFilter bf = new SimpleBloomFilter(this.shape);
        bf.merge(indexExtractor);
        return this.find(bf);
    }

    @Override
    public SimpleBloomFilter flatten() {
        SimpleBloomFilter bf = new SimpleBloomFilter(this.shape);
        this.processBloomFilters(bf::merge);
        return bf;
    }

    public T get(int depth) {
        return this.layerManager.get(depth);
    }

    public final int getDepth() {
        return this.layerManager.getDepth();
    }

    @Override
    public final Shape getShape() {
        return this.shape;
    }

    @Override
    public boolean isEmpty() {
        return this.processBloomFilters(BloomFilter::isEmpty);
    }

    @Override
    public boolean merge(BitMapExtractor bitMapExtractor) {
        return this.layerManager.getTarget().merge(bitMapExtractor);
    }

    @Override
    public boolean merge(BloomFilter bf) {
        return this.layerManager.getTarget().merge(bf);
    }

    @Override
    public boolean merge(IndexExtractor indexExtractor) {
        return this.layerManager.getTarget().merge(indexExtractor);
    }

    public void next() {
        this.layerManager.next();
    }

    @Override
    public boolean processBitMaps(LongPredicate predicate) {
        return this.flatten().processBitMaps(predicate);
    }

    @Override
    public final boolean processBloomFilters(Predicate<BloomFilter> bloomFilterPredicate) {
        return this.layerManager.processBloomFilters(bloomFilterPredicate);
    }

    @Override
    public boolean processIndices(IntPredicate predicate) {
        return this.processBloomFilters(bf -> bf.processIndices(predicate));
    }

    private class Finder
    implements Predicate<BloomFilter> {
        int[] result;
        int bfIdx;
        int resultIdx;
        BloomFilter<?> bf;

        Finder(BloomFilter<?> bf) {
            this.result = new int[LayeredBloomFilter.this.layerManager.getDepth()];
            this.bf = bf;
        }

        int[] getResult() {
            return Arrays.copyOf(this.result, this.resultIdx);
        }

        @Override
        public boolean test(BloomFilter x) {
            if (x.contains(this.bf)) {
                this.result[this.resultIdx++] = this.bfIdx;
            }
            ++this.bfIdx;
            return true;
        }
    }
}

