/*
 * Decompiled with CFR 0.152.
 */
package amf.agentcard.internal.plugins.parse.schema;

import amf.shapes.internal.plugins.parser.schema.JsonSchemaBasedSpecSchema;
import scala.Predef$;
import scala.collection.immutable.StringOps;

public final class AgentCardSchema$
extends JsonSchemaBasedSpecSchema {
    public static AgentCardSchema$ MODULE$;

    static {
        new AgentCardSchema$();
    }

    public String schema() {
        return new StringOps(Predef$.MODULE$.augmentString("{\n      |  \"$schema\": \"http://json-schema.org/draft-07/schema#\",\n      |  \"description\": \"The AgentCard is a self-describing manifest for an agent. It provides essential\\nmetadata including the agent's identity, capabilities, skills, supported\\ncommunication methods, and security requirements.\",\n      |  \"properties\": {\n      |    \"additionalInterfaces\": {\n      |      \"description\": \"A list of additional supported interfaces (transport and URL combinations).\\nThis allows agents to expose multiple transports, potentially at different URLs.\\n\\nBest practices:\\n- SHOULD include all supported transports for completeness\\n- SHOULD include an entry matching the main 'url' and 'preferredTransport'\\n- MAY reuse URLs if multiple transports are available at the same endpoint\\n- MUST accurately declare the transport available at each URL\\n\\nClients can select any interface from this list based on their transport capabilities\\nand preferences. This enables transport negotiation and fallback scenarios.\",\n      |      \"items\": {\n      |        \"$ref\": \"#/definitions/AgentInterface\"\n      |      },\n      |      \"type\": \"array\"\n      |    },\n      |    \"capabilities\": {\n      |      \"$ref\": \"#/definitions/AgentCapabilities\",\n      |      \"description\": \"A declaration of optional capabilities supported by the agent.\"\n      |    },\n      |    \"defaultInputModes\": {\n      |      \"description\": \"Default set of supported input MIME types for all skills, which can be\\noverridden on a per-skill basis.\",\n      |      \"items\": {\n      |        \"type\": \"string\"\n      |      },\n      |      \"type\": \"array\"\n      |    },\n      |    \"defaultOutputModes\": {\n      |      \"description\": \"Default set of supported output MIME types for all skills, which can be\\noverridden on a per-skill basis.\",\n      |      \"items\": {\n      |        \"type\": \"string\"\n      |      },\n      |      \"type\": \"array\"\n      |    },\n      |    \"description\": {\n      |      \"description\": \"A human-readable description of the agent, assisting users and other agents\\nin understanding its purpose.\",\n      |      \"examples\": [\n      |        \"Agent that helps users with recipes and cooking.\"\n      |      ],\n      |      \"type\": \"string\"\n      |    },\n      |    \"documentationUrl\": {\n      |      \"description\": \"An optional URL to the agent's documentation.\",\n      |      \"type\": \"string\"\n      |    },\n      |    \"iconUrl\": {\n      |      \"description\": \"An optional URL to an icon for the agent.\",\n      |      \"type\": \"string\"\n      |    },\n      |    \"name\": {\n      |      \"description\": \"A human-readable name for the agent.\",\n      |      \"examples\": [\n      |        \"Recipe Agent\"\n      |      ],\n      |      \"type\": \"string\"\n      |    },\n      |    \"preferredTransport\": {\n      |      \"default\": \"JSONRPC\",\n      |      \"description\": \"The transport protocol for the preferred endpoint (the main 'url' field).\\nIf not specified, defaults to 'JSONRPC'.\\n\\nIMPORTANT: The transport specified here MUST be available at the main 'url'.\\nThis creates a binding between the main URL and its supported transport protocol.\\nClients should prefer this transport and URL combination when both are supported.\",\n      |      \"examples\": [\n      |        \"JSONRPC\",\n      |        \"GRPC\",\n      |        \"HTTP+JSON\"\n      |      ],\n      |      \"type\": \"string\"\n      |    },\n      |    \"protocolVersion\": {\n      |      \"default\": \"0.2.6\",\n      |      \"description\": \"The version of the A2A protocol this agent supports.\",\n      |      \"type\": \"string\"\n      |    },\n      |    \"provider\": {\n      |      \"$ref\": \"#/definitions/AgentProvider\",\n      |      \"description\": \"Information about the agent's service provider.\"\n      |    },\n      |    \"security\": {\n      |      \"description\": \"A list of security requirement objects that apply to all agent interactions. Each object\\nlists security schemes that can be used. Follows the OpenAPI 3.0 Security Requirement Object.\",\n      |      \"items\": {\n      |        \"additionalProperties\": {\n      |          \"items\": {\n      |            \"type\": \"string\"\n      |          },\n      |          \"type\": \"array\"\n      |        },\n      |        \"type\": \"object\"\n      |      },\n      |      \"type\": \"array\"\n      |    },\n      |    \"securitySchemes\": {\n      |      \"additionalProperties\": {\n      |        \"$ref\": \"#/definitions/SecurityScheme\"\n      |      },\n      |      \"description\": \"A declaration of the security schemes available to authorize requests. The key is the\\nscheme name. Follows the OpenAPI 3.0 Security Scheme Object.\",\n      |      \"type\": \"object\"\n      |    },\n      |    \"signatures\": {\n      |      \"description\": \"JSON Web Signatures computed for this AgentCard.\",\n      |      \"items\": {\n      |        \"$ref\": \"#/definitions/AgentCardSignature\"\n      |      },\n      |      \"type\": \"array\"\n      |    },\n      |    \"skills\": {\n      |      \"description\": \"The set of skills, or distinct capabilities, that the agent can perform.\",\n      |      \"items\": {\n      |        \"$ref\": \"#/definitions/AgentSkill\"\n      |      },\n      |      \"type\": \"array\"\n      |    },\n      |    \"supportsAuthenticatedExtendedCard\": {\n      |      \"description\": \"If true, the agent can provide an extended agent card with additional details\\nto authenticated users. Defaults to false.\",\n      |      \"type\": \"boolean\"\n      |    },\n      |    \"url\": {\n      |      \"description\": \"The preferred endpoint URL for interacting with the agent.\\nThis URL MUST support the transport specified by 'preferredTransport'.\",\n      |      \"examples\": [\n      |        \"https://api.example.com/a2a/v1\"\n      |      ],\n      |      \"type\": \"string\"\n      |    },\n      |    \"version\": {\n      |      \"description\": \"The agent's own version number. The format is defined by the provider.\",\n      |      \"examples\": [\n      |        \"1.0.0\"\n      |      ],\n      |      \"type\": \"string\"\n      |    }\n      |  },\n      |  \"required\": [\n      |    \"capabilities\",\n      |    \"defaultInputModes\",\n      |    \"defaultOutputModes\",\n      |    \"description\",\n      |    \"name\",\n      |    \"protocolVersion\",\n      |    \"skills\",\n      |    \"url\",\n      |    \"version\"\n      |  ],\n      |  \"type\": \"object\",\n      |  \"definitions\": {\n      |    \"AgentCapabilities\": {\n      |      \"description\": \"Defines optional capabilities supported by an agent.\",\n      |      \"properties\": {\n      |        \"extensions\": {\n      |          \"description\": \"A list of protocol extensions supported by the agent.\",\n      |          \"items\": {\n      |            \"$ref\": \"#/definitions/AgentExtension\"\n      |          },\n      |          \"type\": \"array\"\n      |        },\n      |        \"pushNotifications\": {\n      |          \"description\": \"Indicates if the agent supports sending push notifications for asynchronous task updates.\",\n      |          \"type\": \"boolean\"\n      |        },\n      |        \"stateTransitionHistory\": {\n      |          \"description\": \"Indicates if the agent provides a history of state transitions for a task.\",\n      |          \"type\": \"boolean\"\n      |        },\n      |        \"streaming\": {\n      |          \"description\": \"Indicates if the agent supports Server-Sent Events (SSE) for streaming responses.\",\n      |          \"type\": \"boolean\"\n      |        }\n      |      },\n      |      \"type\": \"object\"\n      |    },\n      |    \"APIKeySecurityScheme\": {\n      |      \"description\": \"Defines a security scheme using an API key.\",\n      |      \"properties\": {\n      |        \"description\": {\n      |          \"description\": \"An optional description for the security scheme.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"in\": {\n      |          \"description\": \"The location of the API key.\",\n      |          \"enum\": [\n      |            \"cookie\",\n      |            \"header\",\n      |            \"query\"\n      |          ],\n      |          \"type\": \"string\"\n      |        },\n      |        \"name\": {\n      |          \"description\": \"The name of the header, query, or cookie parameter to be used.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"type\": {\n      |          \"const\": \"apiKey\",\n      |          \"description\": \"The type of the security scheme. Must be 'apiKey'.\",\n      |          \"type\": \"string\"\n      |        }\n      |      },\n      |      \"required\": [\n      |        \"in\",\n      |        \"name\",\n      |        \"type\"\n      |      ],\n      |      \"type\": \"object\"\n      |    },\n      |    \"HTTPAuthSecurityScheme\": {\n      |      \"description\": \"Defines a security scheme using HTTP authentication.\",\n      |      \"properties\": {\n      |        \"bearerFormat\": {\n      |          \"description\": \"A hint to the client to identify how the bearer token is formatted (e.g., \\\"JWT\\\").\\nThis is primarily for documentation purposes.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"description\": {\n      |          \"description\": \"An optional description for the security scheme.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"scheme\": {\n      |          \"description\": \"The name of the HTTP Authentication scheme to be used in the Authorization header,\\nas defined in RFC7235 (e.g., \\\"Bearer\\\").\\nThis value should be registered in the IANA Authentication Scheme registry.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"type\": {\n      |          \"const\": \"http\",\n      |          \"description\": \"The type of the security scheme. Must be 'http'.\",\n      |          \"type\": \"string\"\n      |        }\n      |      },\n      |      \"required\": [\n      |        \"scheme\",\n      |        \"type\"\n      |      ],\n      |      \"type\": \"object\"\n      |    },\n      |    \"OAuth2SecurityScheme\": {\n      |      \"description\": \"Defines a security scheme using OAuth 2.0.\",\n      |      \"properties\": {\n      |        \"description\": {\n      |          \"description\": \"An optional description for the security scheme.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"flows\": {\n      |          \"$ref\": \"#/definitions/OAuthFlows\",\n      |          \"description\": \"An object containing configuration information for the supported OAuth 2.0 flows.\"\n      |        },\n      |        \"type\": {\n      |          \"const\": \"oauth2\",\n      |          \"description\": \"The type of the security scheme. Must be 'oauth2'.\",\n      |          \"type\": \"string\"\n      |        }\n      |      },\n      |      \"required\": [\n      |        \"flows\",\n      |        \"type\"\n      |      ],\n      |      \"type\": \"object\"\n      |    },\n      |    \"OAuthFlows\": {\n      |      \"description\": \"Defines the configuration for the supported OAuth 2.0 flows.\",\n      |      \"properties\": {\n      |        \"authorizationCode\": {\n      |          \"$ref\": \"#/definitions/AuthorizationCodeOAuthFlow\",\n      |          \"description\": \"Configuration for the OAuth Authorization Code flow. Previously called accessCode in OpenAPI 2.0.\"\n      |        },\n      |        \"clientCredentials\": {\n      |          \"$ref\": \"#/definitions/ClientCredentialsOAuthFlow\",\n      |          \"description\": \"Configuration for the OAuth Client Credentials flow. Previously called application in OpenAPI 2.0.\"\n      |        },\n      |        \"implicit\": {\n      |          \"$ref\": \"#/definitions/ImplicitOAuthFlow\",\n      |          \"description\": \"Configuration for the OAuth Implicit flow.\"\n      |        },\n      |        \"password\": {\n      |          \"$ref\": \"#/definitions/PasswordOAuthFlow\",\n      |          \"description\": \"Configuration for the OAuth Resource Owner Password flow.\"\n      |        }\n      |      },\n      |      \"type\": \"object\"\n      |    },\n      |    \"PasswordOAuthFlow\": {\n      |      \"description\": \"Defines configuration details for the OAuth 2.0 Resource Owner Password flow.\",\n      |      \"properties\": {\n      |        \"refreshUrl\": {\n      |          \"description\": \"The URL to be used for obtaining refresh tokens. This MUST be a URL.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"scopes\": {\n      |          \"additionalProperties\": {\n      |            \"type\": \"string\"\n      |          },\n      |          \"description\": \"The available scopes for the OAuth2 security scheme. A map between the scope\\nname and a short description for it.\",\n      |          \"type\": \"object\"\n      |        },\n      |        \"tokenUrl\": {\n      |          \"description\": \"The token URL to be used for this flow. This MUST be a URL.\",\n      |          \"type\": \"string\"\n      |        }\n      |      },\n      |      \"required\": [\n      |        \"scopes\",\n      |        \"tokenUrl\"\n      |      ],\n      |      \"type\": \"object\"\n      |    },\n      |    \"ImplicitOAuthFlow\": {\n      |      \"description\": \"Defines configuration details for the OAuth 2.0 Implicit flow.\",\n      |      \"properties\": {\n      |        \"authorizationUrl\": {\n      |          \"description\": \"The authorization URL to be used for this flow. This MUST be a URL.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"refreshUrl\": {\n      |          \"description\": \"The URL to be used for obtaining refresh tokens. This MUST be a URL.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"scopes\": {\n      |          \"additionalProperties\": {\n      |            \"type\": \"string\"\n      |          },\n      |          \"description\": \"The available scopes for the OAuth2 security scheme. A map between the scope\\nname and a short description for it.\",\n      |          \"type\": \"object\"\n      |        }\n      |      },\n      |      \"required\": [\n      |        \"authorizationUrl\",\n      |        \"scopes\"\n      |      ],\n      |      \"type\": \"object\"\n      |    },\n      |    \"OpenIdConnectSecurityScheme\": {\n      |      \"description\": \"Defines a security scheme using OpenID Connect.\",\n      |      \"properties\": {\n      |        \"description\": {\n      |          \"description\": \"An optional description for the security scheme.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"openIdConnectUrl\": {\n      |          \"description\": \"The OpenID Connect Discovery URL for the OIDC provider's metadata.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"type\": {\n      |          \"const\": \"openIdConnect\",\n      |          \"description\": \"The type of the security scheme. Must be 'openIdConnect'.\",\n      |          \"type\": \"string\"\n      |        }\n      |      },\n      |      \"required\": [\n      |        \"openIdConnectUrl\",\n      |        \"type\"\n      |      ],\n      |      \"type\": \"object\"\n      |    },\n      |    \"SecurityScheme\": {\n      |      \"anyOf\": [\n      |        {\n      |          \"$ref\": \"#/definitions/APIKeySecurityScheme\"\n      |        },\n      |        {\n      |          \"$ref\": \"#/definitions/HTTPAuthSecurityScheme\"\n      |        },\n      |        {\n      |          \"$ref\": \"#/definitions/OAuth2SecurityScheme\"\n      |        },\n      |        {\n      |          \"$ref\": \"#/definitions/OpenIdConnectSecurityScheme\"\n      |        }\n      |      ],\n      |      \"description\": \"Defines a security scheme that can be used to secure an agent's endpoints.\\nThis is a discriminated union type based on the OpenAPI 3.0 Security Scheme Object.\"\n      |    },\n      |    \"AgentCardSignature\": {\n      |      \"description\": \"AgentCardSignature represents a JWS signature of an AgentCard.\\nThis follows the JSON format of an RFC 7515 JSON Web Signature (JWS).\",\n      |      \"properties\": {\n      |        \"header\": {\n      |          \"additionalProperties\": {},\n      |          \"description\": \"The unprotected JWS header values.\",\n      |          \"type\": \"object\"\n      |        },\n      |        \"protected\": {\n      |          \"description\": \"The protected JWS header for the signature. This is a Base64url-encoded\\nJSON object, as per RFC 7515.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"signature\": {\n      |          \"description\": \"The computed signature, Base64url-encoded.\",\n      |          \"type\": \"string\"\n      |        }\n      |      },\n      |      \"required\": [\n      |        \"protected\",\n      |        \"signature\"\n      |      ],\n      |      \"type\": \"object\"\n      |    },\n      |    \"AgentExtension\": {\n      |      \"description\": \"A declaration of a protocol extension supported by an Agent.\",\n      |      \"examples\": [\n      |        {\n      |          \"description\": \"Google OAuth 2.0 authentication\",\n      |          \"required\": false,\n      |          \"uri\": \"https://developers.google.com/identity/protocols/oauth2\"\n      |        }\n      |      ],\n      |      \"properties\": {\n      |        \"description\": {\n      |          \"description\": \"A human-readable description of how this agent uses the extension.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"params\": {\n      |          \"additionalProperties\": {},\n      |          \"description\": \"Optional, extension-specific configuration parameters.\",\n      |          \"type\": \"object\"\n      |        },\n      |        \"required\": {\n      |          \"description\": \"If true, the client must understand and comply with the extension's requirements\\nto interact with the agent.\",\n      |          \"type\": \"boolean\"\n      |        },\n      |        \"uri\": {\n      |          \"description\": \"The unique URI identifying the extension.\",\n      |          \"type\": \"string\"\n      |        }\n      |      },\n      |      \"required\": [\n      |        \"uri\"\n      |      ],\n      |      \"type\": \"object\"\n      |    },\n      |    \"AgentInterface\": {\n      |      \"description\": \"Declares a combination of a target URL and a transport protocol for interacting with the agent.\\nThis allows agents to expose the same functionality over multiple transport mechanisms.\",\n      |      \"properties\": {\n      |        \"transport\": {\n      |          \"description\": \"The transport protocol supported at this URL.\",\n      |          \"examples\": [\n      |            \"JSONRPC\",\n      |            \"GRPC\",\n      |            \"HTTP+JSON\"\n      |          ],\n      |          \"type\": \"string\"\n      |        },\n      |        \"url\": {\n      |          \"description\": \"The URL where this interface is available. Must be a valid absolute HTTPS URL in production.\",\n      |          \"examples\": [\n      |            \"https://api.example.com/a2a/v1\",\n      |            \"https://grpc.example.com/a2a\",\n      |            \"https://rest.example.com/v1\"\n      |          ],\n      |          \"type\": \"string\"\n      |        }\n      |      },\n      |      \"required\": [\n      |        \"transport\",\n      |        \"url\"\n      |      ],\n      |      \"type\": \"object\"\n      |    },\n      |    \"AgentProvider\": {\n      |      \"description\": \"Represents the service provider of an agent.\",\n      |      \"examples\": [\n      |        {\n      |          \"organization\": \"Google\",\n      |          \"url\": \"https://ai.google.dev\"\n      |        }\n      |      ],\n      |      \"properties\": {\n      |        \"organization\": {\n      |          \"description\": \"The name of the agent provider's organization.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"url\": {\n      |          \"description\": \"A URL for the agent provider's website or relevant documentation.\",\n      |          \"type\": \"string\"\n      |        }\n      |      },\n      |      \"required\": [\n      |        \"organization\",\n      |        \"url\"\n      |      ],\n      |      \"type\": \"object\"\n      |    },\n      |    \"AgentSkill\": {\n      |      \"description\": \"Represents a distinct capability or function that an agent can perform.\",\n      |      \"properties\": {\n      |        \"description\": {\n      |          \"description\": \"A detailed description of the skill, intended to help clients or users\\nunderstand its purpose and functionality.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"examples\": {\n      |          \"description\": \"Example prompts or scenarios that this skill can handle. Provides a hint to\\nthe client on how to use the skill.\",\n      |          \"examples\": [\n      |            [\n      |              \"I need a recipe for bread\"\n      |            ]\n      |          ],\n      |          \"items\": {\n      |            \"type\": \"string\"\n      |          },\n      |          \"type\": \"array\"\n      |        },\n      |        \"id\": {\n      |          \"description\": \"A unique identifier for the agent's skill.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"inputModes\": {\n      |          \"description\": \"The set of supported input MIME types for this skill, overriding the agent's defaults.\",\n      |          \"items\": {\n      |            \"type\": \"string\"\n      |          },\n      |          \"type\": \"array\"\n      |        },\n      |        \"name\": {\n      |          \"description\": \"A human-readable name for the skill.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"outputModes\": {\n      |          \"description\": \"The set of supported output MIME types for this skill, overriding the agent's defaults.\",\n      |          \"items\": {\n      |            \"type\": \"string\"\n      |          },\n      |          \"type\": \"array\"\n      |        },\n      |        \"tags\": {\n      |          \"description\": \"A set of keywords describing the skill's capabilities.\",\n      |          \"examples\": [\n      |            [\n      |              \"cooking\",\n      |              \"customer support\",\n      |              \"billing\"\n      |            ]\n      |          ],\n      |          \"items\": {\n      |            \"type\": \"string\"\n      |          },\n      |          \"type\": \"array\"\n      |        }\n      |      },\n      |      \"required\": [\n      |        \"description\",\n      |        \"id\",\n      |        \"name\",\n      |        \"tags\"\n      |      ],\n      |      \"type\": \"object\"\n      |    },\n      |    \"Artifact\": {\n      |      \"description\": \"Represents a file, data structure, or other resource generated by an agent during a task.\",\n      |      \"properties\": {\n      |        \"artifactId\": {\n      |          \"description\": \"A unique identifier for the artifact within the scope of the task.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"description\": {\n      |          \"description\": \"An optional, human-readable description of the artifact.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"extensions\": {\n      |          \"description\": \"The URIs of extensions that are relevant to this artifact.\",\n      |          \"items\": {\n      |            \"type\": \"string\"\n      |          },\n      |          \"type\": \"array\"\n      |        },\n      |        \"metadata\": {\n      |          \"additionalProperties\": {},\n      |          \"description\": \"Optional metadata for extensions. The key is an extension-specific identifier.\",\n      |          \"type\": \"object\"\n      |        },\n      |        \"name\": {\n      |          \"description\": \"An optional, human-readable name for the artifact.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"parts\": {\n      |          \"description\": \"An array of content parts that make up the artifact.\",\n      |          \"items\": {\n      |            \"$ref\": \"#/definitions/Part\"\n      |          },\n      |          \"type\": \"array\"\n      |        }\n      |      },\n      |      \"required\": [\n      |        \"artifactId\",\n      |        \"parts\"\n      |      ],\n      |      \"type\": \"object\"\n      |    },\n      |    \"Part\": {\n      |\n      |      \"anyOf\": [\n      |        {\n      |          \"$ref\": \"#/definitions/TextPart\"\n      |        },\n      |        {\n      |          \"$ref\": \"#/definitions/FilePart\"\n      |        },\n      |        {\n      |          \"$ref\": \"#/definitions/DataPart\"\n      |        }\n      |      ],\n      |      \"description\": \"A discriminated union representing a part of a message or artifact, which can\\nbe text, a file, or structured data.\"\n      |    },\n      |    \"TextPart\": {\n      |      \"description\": \"Represents a text segment within a message or artifact.\",\n      |      \"properties\": {\n      |        \"kind\": {\n      |          \"const\": \"text\",\n      |          \"description\": \"The type of this part, used as a discriminator. Always 'text'.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"metadata\": {\n      |          \"additionalProperties\": {},\n      |          \"description\": \"Optional metadata associated with this part.\",\n      |          \"type\": \"object\"\n      |        },\n      |        \"text\": {\n      |          \"description\": \"The string content of the text part.\",\n      |          \"type\": \"string\"\n      |        }\n      |      },\n      |      \"required\": [\n      |        \"kind\",\n      |        \"text\"\n      |      ],\n      |      \"type\": \"object\"\n      |    },\n      |    \"FilePart\": {\n      |      \"description\": \"Represents a file segment within a message or artifact. The file content can be\\nprovided either directly as bytes or as a URI.\",\n      |      \"properties\": {\n      |        \"file\": {\n      |          \"anyOf\": [\n      |            {\n      |              \"$ref\": \"#/definitions/FileWithBytes\"\n      |            },\n      |            {\n      |              \"$ref\": \"#/definitions/FileWithUri\"\n      |            }\n      |          ],\n      |          \"description\": \"The file content, represented as either a URI or as base64-encoded bytes.\"\n      |        },\n      |        \"kind\": {\n      |          \"const\": \"file\",\n      |          \"description\": \"The type of this part, used as a discriminator. Always 'file'.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"metadata\": {\n      |          \"additionalProperties\": {},\n      |          \"description\": \"Optional metadata associated with this part.\",\n      |          \"type\": \"object\"\n      |        }\n      |      },\n      |      \"required\": [\n      |        \"file\",\n      |        \"kind\"\n      |      ],\n      |      \"type\": \"object\"\n      |    },\n      |    \"FileWithBytes\": {\n      |      \"description\": \"Represents a file with its content provided directly as a base64-encoded string.\",\n      |      \"properties\": {\n      |        \"bytes\": {\n      |          \"description\": \"The base64-encoded content of the file.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"mimeType\": {\n      |          \"description\": \"The MIME type of the file (e.g., \\\"application/pdf\\\").\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"name\": {\n      |          \"description\": \"An optional name for the file (e.g., \\\"document.pdf\\\").\",\n      |          \"type\": \"string\"\n      |        }\n      |      },\n      |      \"required\": [\n      |        \"bytes\"\n      |      ],\n      |      \"type\": \"object\"\n      |    },\n      |    \"FileWithUri\": {\n      |      \"description\": \"Represents a file with its content located at a specific URI.\",\n      |      \"properties\": {\n      |        \"mimeType\": {\n      |          \"description\": \"The MIME type of the file (e.g., \\\"application/pdf\\\").\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"name\": {\n      |          \"description\": \"An optional name for the file (e.g., \\\"document.pdf\\\").\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"uri\": {\n      |          \"description\": \"A URL pointing to the file's content.\",\n      |          \"type\": \"string\"\n      |        }\n      |      },\n      |      \"required\": [\n      |        \"uri\"\n      |      ],\n      |      \"type\": \"object\"\n      |    },\n      |    \"DataPart\": {\n      |      \"description\": \"Represents a structured data segment (e.g., JSON) within a message or artifact.\",\n      |      \"properties\": {\n      |        \"data\": {\n      |          \"additionalProperties\": {},\n      |          \"description\": \"The structured data content.\",\n      |          \"type\": \"object\"\n      |        },\n      |        \"kind\": {\n      |          \"const\": \"data\",\n      |          \"description\": \"The type of this part, used as a discriminator. Always 'data'.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"metadata\": {\n      |          \"additionalProperties\": {},\n      |          \"description\": \"Optional metadata associated with this part.\",\n      |          \"type\": \"object\"\n      |        }\n      |      },\n      |      \"required\": [\n      |        \"data\",\n      |        \"kind\"\n      |      ],\n      |      \"type\": \"object\"\n      |    },\n      |    \"AuthorizationCodeOAuthFlow\": {\n      |      \"description\": \"Defines configuration details for the OAuth 2.0 Authorization Code flow.\",\n      |      \"properties\": {\n      |        \"authorizationUrl\": {\n      |          \"description\": \"The authorization URL to be used for this flow.\\nThis MUST be a URL and use TLS.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"refreshUrl\": {\n      |          \"description\": \"The URL to be used for obtaining refresh tokens.\\nThis MUST be a URL and use TLS.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"scopes\": {\n      |          \"additionalProperties\": {\n      |            \"type\": \"string\"\n      |          },\n      |          \"description\": \"The available scopes for the OAuth2 security scheme. A map between the scope\\nname and a short description for it.\",\n      |          \"type\": \"object\"\n      |        },\n      |        \"tokenUrl\": {\n      |          \"description\": \"The token URL to be used for this flow.\\nThis MUST be a URL and use TLS.\",\n      |          \"type\": \"string\"\n      |        }\n      |      },\n      |      \"required\": [\n      |        \"authorizationUrl\",\n      |        \"scopes\",\n      |        \"tokenUrl\"\n      |      ],\n      |      \"type\": \"object\"\n      |    },\n      |    \"ClientCredentialsOAuthFlow\": {\n      |      \"description\": \"Defines configuration details for the OAuth 2.0 Client Credentials flow.\",\n      |      \"properties\": {\n      |        \"refreshUrl\": {\n      |          \"description\": \"The URL to be used for obtaining refresh tokens. This MUST be a URL.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"scopes\": {\n      |          \"additionalProperties\": {\n      |            \"type\": \"string\"\n      |          },\n      |          \"description\": \"The available scopes for the OAuth2 security scheme. A map between the scope\\nname and a short description for it.\",\n      |          \"type\": \"object\"\n      |        },\n      |        \"tokenUrl\": {\n      |          \"description\": \"The token URL to be used for this flow. This MUST be a URL.\",\n      |          \"type\": \"string\"\n      |        }\n      |      },\n      |      \"required\": [\n      |        \"scopes\",\n      |        \"tokenUrl\"\n      |      ],\n      |      \"type\": \"object\"\n      |    }\n      |  }\n      |}\n      |")).stripMargin();
    }

    private AgentCardSchema$() {
        MODULE$ = this;
    }
}

