/*
 * Decompiled with CFR 0.152.
 */
package amf.agentdomain.internal.plugins.parse.schema;

import amf.shapes.internal.plugins.parser.schema.JsonSchemaBasedSpecSchema;
import scala.Predef$;
import scala.collection.immutable.StringOps;

public final class AgentDomainSchema$
extends JsonSchemaBasedSpecSchema {
    public static AgentDomainSchema$ MODULE$;

    static {
        new AgentDomainSchema$();
    }

    public String schema() {
        return new StringOps(Predef$.MODULE$.augmentString("{\n      |  \"$schema\": \"http://json-schema.org/draft-07/schema#\",\n      |  \"title\": \"Agent domain\",\n      |  \"type\": \"object\",\n      |  \"required\": [\n      |    \"schemaVersion\",\n      |    \"agents\",\n      |    \"services\"\n      |  ],\n      |  \"properties\": {\n      |    \"schemaVersion\": {\n      |      \"type\": \"string\",\n      |      \"const\": \"0.1.0-beta\",\n      |      \"description\": \"The schema version for this file\",\n      |      \"pattern\": \"^(0|[1-9]\\\\d*)\\\\.(0|[1-9]\\\\d*)\\\\.(0|[1-9]\\\\d*)(?:-((?:0|[1-9]\\\\d*|\\\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\\\.(?:0|[1-9]\\\\d*|\\\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\\\+([0-9a-zA-Z-]+(?:\\\\.[0-9a-zA-Z-]+)*))?$\",\n      |      \"additionalProperties\": false\n      |    },\n      |    \"agents\": {\n      |      \"type\": \"object\",\n      |      \"description\": \"The agents defined as part of this domain\",\n      |      \"patternProperties\": {\n      |        \"^[a-zA-Z_][a-zA-Z0-9_.-]*$\": {\n      |          \"$ref\": \"#/definitions/Agent\"\n      |        }\n      |      },\n      |      \"propertyNames\": {\n      |        \"not\": {\n      |          \"enum\": [\n      |            \"default\",\n      |            \"defaults\",\n      |            \"system\",\n      |            \"local\"\n      |          ]\n      |        }\n      |      },\n      |      \"additionalProperties\": false\n      |    },\n      |    \"services\": {\n      |      \"$ref\": \"#/definitions/Services\",\n      |      \"description\": \"The external services consumed by the agents in this domain\"\n      |    }\n      |  },\n      |  \"additionalProperties\": false,\n      |  \"definitions\": {\n      |    \"AgentSpec\": {\n      |      \"type\": \"object\",\n      |      \"required\": [\n      |        \"llm\",\n      |        \"instructions\"\n      |      ],\n      |      \"properties\": {\n      |        \"llm\": {\n      |          \"type\": \"string\",\n      |          \"description\": \"A reference to the LLM used for reasoning and orchestration\"\n      |        },\n      |        \"instructions\": {\n      |          \"type\": \"array\",\n      |          \"description\": \"Set of custom instructions that will inform the orchestration\",\n      |          \"items\": {\n      |            \"type\": \"string\"\n      |          }\n      |        },\n      |        \"maxNumberOfLoops\": {\n      |          \"type\": \"integer\",\n      |          \"description\": \"The maximum number of steps that a task can take. Useful for keeping orchestrations from running too long and consuming too many tokens\",\n      |          \"default\": 25\n      |        },\n      |        \"maxConsecutiveErrors\": {\n      |          \"type\": \"integer\",\n      |          \"description\": \"The maximum number of errors that the orchestrator will attempt to recover from before returning a failed status.\",\n      |          \"default\": 3\n      |        },\n      |        \"tools\": {\n      |          \"type\": \"array\",\n      |          \"description\": \"The tools available to this agent\",\n      |          \"items\": {\n      |            \"type\": \"object\",\n      |            \"properties\": {\n      |              \"mcp\": {\n      |                \"type\": \"object\",\n      |                \"required\": [\n      |                  \"server\"\n      |                ],\n      |                \"properties\": {\n      |                  \"server\": {\n      |                    \"type\": \"string\",\n      |                    \"description\": \"A reference to the MCP server serving the tools\"\n      |                  },\n      |                  \"allowed\": {\n      |                    \"type\": \"array\",\n      |                    \"description\": \"Filters the list of tools advertised by the MCP server to only those in this list. Mutually exclusive with 'denied'\",\n      |                    \"items\": {\n      |                      \"type\": \"string\"\n      |                    }\n      |                  },\n      |                  \"denied\": {\n      |                    \"type\": \"array\",\n      |                    \"description\": \"Filters the list of tools advertised by the MCP server to not include those in this list. Mutually exclusive with 'allowed'\",\n      |                    \"items\": {\n      |                      \"type\": \"string\"\n      |                    }\n      |                  }\n      |                }\n      |              }\n      |            }\n      |          }\n      |        },\n      |        \"links\": {\n      |          \"type\": \"array\",\n      |          \"description\": \"Defines which of the other agents defined in this domain can be orchestrated by this conductor\",\n      |          \"items\": {\n      |            \"type\": \"object\",\n      |            \"patternProperties\": {\n      |              \"^[a-zA-Z_][a-zA-Z0-9_.-]*$\": {\n      |                \"type\": \"object\",\n      |                \"properties\": {\n      |                  \"authentication\": {\n      |                    \"$ref\": \"#/definitions/Authentication\"\n      |                  }\n      |                }\n      |              }\n      |            },\n      |            \"additionalProperties\": false\n      |          }\n      |        }\n      |      }\n      |    },\n      |    \"Agent\": {\n      |      \"type\": \"object\",\n      |      \"properties\": {\n      |        \"card\": {\n      |          \"$ref\": \"#/definitions/AgentCard\"\n      |        },\n      |        \"spec\": {\n      |          \"$ref\": \"#/definitions/AgentSpec\"\n      |        }\n      |      },\n      |      \"required\": [\n      |        \"card\",\n      |        \"spec\"\n      |      ]\n      |    },\n      |    \"BasicAuth\": {\n      |      \"type\": \"object\",\n      |      \"title\": \"Basic Authentication\",\n      |      \"description\": \"Properties for Basic Authentication.\",\n      |      \"properties\": {\n      |        \"type\": {\n      |          \"const\": \"basic\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"username\": {\n      |          \"type\": \"string\",\n      |          \"description\": \"The username for authentication.\"\n      |        },\n      |        \"password\": {\n      |          \"type\": \"string\",\n      |          \"description\": \"The password for authentication.\"\n      |        }\n      |      },\n      |      \"required\": [\n      |        \"type\",\n      |        \"username\",\n      |        \"password\"\n      |      ]\n      |    },\n      |    \"AnypointClientCredentialsAuth\": {\n      |      \"type\": \"object\",\n      |      \"properties\": {\n      |        \"type\": {\n      |          \"const\": \"apikey-client-credentials\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"clientId\": {\n      |          \"type\": \"string\",\n      |          \"description\": \"The client ID.\"\n      |        },\n      |        \"clientSecret\": {\n      |          \"type\": \"string\",\n      |          \"description\": \"The client secret.\"\n      |        }\n      |      }\n      |    },\n      |    \"OAuth2ClientCredentialsAuth\": {\n      |      \"type\": \"object\",\n      |      \"title\": \"OAuth 2.0 Client Credentials Grant\",\n      |      \"description\": \"Properties for the OAuth 2.0 Client Credentials Grant Type.\",\n      |      \"properties\": {\n      |        \"type\": {\n      |          \"const\": \"oauth2-client-credentials\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"clientId\": {\n      |          \"type\": \"string\",\n      |          \"description\": \"The client ID.\"\n      |        },\n      |        \"clientSecret\": {\n      |          \"type\": \"string\",\n      |          \"description\": \"The client secret.\"\n      |        },\n      |        \"tokenUrl\": {\n      |          \"type\": \"string\",\n      |          \"description\": \"The URL of the token endpoint to obtain the access token.\"\n      |        },\n      |        \"scopes\": {\n      |          \"type\": \"array\",\n      |          \"items\": {\n      |            \"type\": \"string\"\n      |          },\n      |          \"description\": \"An array of scopes to request.\"\n      |        }\n      |      },\n      |      \"required\": [\n      |        \"type\",\n      |        \"clientId\",\n      |        \"clientSecret\",\n      |        \"tokenUrl\"\n      |      ]\n      |    },\n      |    \"Authentication\": {\n      |      \"anyOf\": [\n      |        {\n      |          \"$ref\": \"#/definitions/OAuth2ClientCredentialsAuth\"\n      |        },\n      |        {\n      |          \"$ref\": \"#/definitions/BasicAuth\"\n      |        },\n      |        {\n      |          \"$ref\": \"#/definitions/AnypointClientCredentialsAuth\"\n      |        }\n      |      ]\n      |    },\n      |    \"ExternalAgent\": {\n      |      \"type\": \"object\",\n      |      \"description\": \"Defines an agent that exists outside of this domain\",\n      |      \"properties\": {\n      |        \"cardUrl\": {\n      |          \"type\": \"string\"\n      |        },\n      |        \"authentication\": {\n      |          \"$ref\": \"#/definitions/Authentication\"\n      |        }\n      |      }\n      |    },\n      |    \"EinsteinLLM\": {\n      |      \"type\": \"object\",\n      |      \"description\": \"Configuration for using Salesforce Einstein as the reasoning LLM\",\n      |      \"required\": [\n      |        \"clientId\",\n      |        \"clientSecret\",\n      |        \"baseUrl\",\n      |        \"modelName\"\n      |      ],\n      |      \"properties\": {\n      |        \"type\": {\n      |          \"type\": \"string\",\n      |          \"const\": \"einstein\"\n      |        },\n      |        \"clientId\": {\n      |          \"type\": \"string\",\n      |          \"description\": \"The Client Id\"\n      |        },\n      |        \"clientSecret\": {\n      |          \"type\": \"string\",\n      |          \"description\": \"The Client Secret\"\n      |        },\n      |        \"baseUrl\": {\n      |          \"type\": \"string\",\n      |          \"description\": \"The base URL for the Einstein instance\"\n      |        },\n      |        \"modelName\": {\n      |          \"type\": \"string\",\n      |          \"description\": \"The name of the language model to use\"\n      |        },\n      |        \"probability\": {\n      |          \"type\": \"number\",\n      |          \"description\": \"The Einstein probability setting\"\n      |        },\n      |        \"locale\": {\n      |          \"type\": \"string\",\n      |          \"description\": \"The locale to use\",\n      |          \"default\": \"en_US\"\n      |        }\n      |      }\n      |    },\n      |    \"SseTransport\": {\n      |      \"required\": [\n      |        \"sse\"\n      |      ],\n      |      \"properties\": {\n      |        \"sse\": {\n      |          \"type\": \"object\",\n      |          \"properties\": {\n      |            \"ssePath\": {\n      |              \"type\": \"string\",\n      |              \"description\": \"Path to the SSE endpoint\"\n      |            },\n      |            \"messagesPath\": {\n      |              \"type\": \"string\",\n      |              \"description\": \"Path to the messages endpoint\"\n      |            }\n      |          }\n      |        }\n      |      }\n      |    },\n      |    \"StreamableHttpTransport\": {\n      |      \"required\": [\n      |        \"streamableHttp\"\n      |      ],\n      |      \"properties\": {\n      |        \"streamableHttp\": {\n      |          \"type\": \"object\",\n      |          \"properties\": {\n      |            \"path\": {\n      |              \"type\": \"string\",\n      |              \"description\": \"Path to the mcp endpoint\"\n      |            }\n      |          }\n      |        }\n      |      }\n      |    },\n      |    \"MCPTransport\": {\n      |      \"type\": \"object\",\n      |      \"oneOf\": [\n      |        {\n      |          \"$ref\": \"#/definitions/SseTransport\"\n      |        },\n      |        {\n      |          \"$ref\": \"#/definitions/StreamableHttpTransport\"\n      |        }\n      |      ]\n      |    },\n      |    \"MCPServer\": {\n      |      \"type\": \"object\",\n      |      \"required\": [\n      |        \"url\",\n      |        \"transport\"\n      |      ],\n      |      \"properties\": {\n      |        \"url\": {\n      |          \"type\": \"string\",\n      |          \"format\": \"uri\",\n      |          \"description\": \"The base URL for the MCP server\"\n      |        },\n      |        \"transport\": {\n      |          \"$ref\": \"#/definitions/MCPTransport\"\n      |        },\n      |        \"tools\": {\n      |          \"type\": \"object\",\n      |          \"properties\": {\n      |            \"allowed\": {\n      |              \"type\": \"array\",\n      |              \"description\": \"Filters the list of tools advertised by the MCP server to only those in this list. Mutually exclusive with 'denied'\",\n      |              \"items\": {\n      |                \"type\": \"string\"\n      |              }\n      |            },\n      |            \"denied\": {\n      |              \"type\": \"array\",\n      |              \"description\": \"Filters the list of tools advertised by the MCP server to those not in this list. Mutually exclusive with 'allowed'\",\n      |              \"items\": {\n      |                \"type\": \"string\"\n      |              }\n      |            }\n      |          }\n      |        },\n      |        \"authentication\": {\n      |          \"$ref\": \"#/definitions/Authentication\"\n      |        }\n      |      }\n      |    },\n      |    \"Services\": {\n      |      \"type\": \"object\",\n      |      \"description\": \"The external services consumed by the agents in this domain\",\n      |      \"required\": [\n      |        \"llm-providers\"\n      |      ],\n      |      \"properties\": {\n      |        \"external-agents\": {\n      |          \"type\": \"object\",\n      |          \"patternProperties\": {\n      |            \"^[a-zA-Z_][a-zA-Z0-9_.-]*$\": {\n      |              \"$ref\": \"#/definitions/ExternalAgent\"\n      |            }\n      |          },\n      |          \"additionalProperties\": false\n      |        },\n      |        \"llm-providers\": {\n      |          \"type\": \"object\",\n      |          \"description\": \"The LLMs available to the agents in this domain\",\n      |          \"patternProperties\": {\n      |            \"^[a-zA-Z_][a-zA-Z0-9_.-]*$\": {\n      |              \"$ref\": \"#/definitions/EinsteinLLM\"\n      |            }\n      |          },\n      |          \"additionalProperties\": false\n      |        },\n      |        \"mcp-servers\": {\n      |          \"type\": \"array\",\n      |          \"description\": \"The MCP servers available to the agents in this domain\",\n      |          \"items\": {\n      |            \"type\": \"object\",\n      |            \"patternProperties\": {\n      |              \"^[a-zA-Z_][a-zA-Z0-9_.-]*$\": {\n      |                \"$ref\": \"#/definitions/MCPServer\"\n      |              }\n      |            },\n      |            \"additionalProperties\": false\n      |          }\n      |        }\n      |      }\n      |    },\n      |    \"AgentCard\": {\n      |      \"description\": \"An AgentCard conveys key information:\\n- Overall details (version, name, description, uses)\\n- Skills: A set of capabilities the agent can perform\\n- Default modalities/content types supported by the agent.\\n- Authentication requirements\",\n      |      \"properties\": {\n      |        \"additionalInterfaces\": {\n      |          \"description\": \"Announcement of additional supported transports. Client can use any of\\nthe supported transports.\",\n      |          \"items\": {\n      |            \"$ref\": \"#/definitions/AgentInterface\"\n      |          },\n      |          \"type\": \"array\"\n      |        },\n      |        \"capabilities\": {\n      |          \"$ref\": \"#/definitions/AgentCapabilities\",\n      |          \"description\": \"Optional capabilities supported by the agent.\"\n      |        },\n      |        \"defaultInputModes\": {\n      |          \"description\": \"The set of interaction modes that the agent supports across all skills. This can be overridden per-skill.\\nSupported media types for input.\",\n      |          \"items\": {\n      |            \"type\": \"string\"\n      |          },\n      |          \"type\": \"array\"\n      |        },\n      |        \"defaultOutputModes\": {\n      |          \"description\": \"Supported media types for output.\",\n      |          \"items\": {\n      |            \"type\": \"string\"\n      |          },\n      |          \"type\": \"array\"\n      |        },\n      |        \"description\": {\n      |          \"description\": \"A human-readable description of the agent. Used to assist users and\\nother agents in understanding what the agent can do.\",\n      |          \"examples\": [\n      |            \"Agent that helps users with recipes and cooking.\"\n      |          ],\n      |          \"type\": \"string\"\n      |        },\n      |        \"documentationUrl\": {\n      |          \"description\": \"A URL to documentation for the agent.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"iconUrl\": {\n      |          \"description\": \"A URL to an icon for the agent.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"name\": {\n      |          \"description\": \"Human readable name of the agent.\",\n      |          \"examples\": [\n      |            \"Recipe Agent\"\n      |          ],\n      |          \"type\": \"string\"\n      |        },\n      |        \"preferredTransport\": {\n      |          \"description\": \"The transport of the preferred endpoint. If empty, defaults to JSONRPC.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"protocolVersion\": {\n      |          \"default\": \"0.2.5\",\n      |          \"description\": \"The version of the A2A protocol this agent supports.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"provider\": {\n      |          \"$ref\": \"#/definitions/AgentProvider\",\n      |          \"description\": \"The service provider of the agent\"\n      |        },\n      |        \"security\": {\n      |          \"description\": \"Security requirements for contacting the agent.\",\n      |          \"items\": {\n      |            \"additionalProperties\": {\n      |              \"items\": {\n      |                \"type\": \"string\"\n      |              },\n      |              \"type\": \"array\"\n      |            },\n      |            \"type\": \"object\"\n      |          },\n      |          \"type\": \"array\"\n      |        },\n      |        \"securitySchemes\": {\n      |          \"additionalProperties\": {\n      |            \"$ref\": \"#/definitions/SecurityScheme\"\n      |          },\n      |          \"description\": \"Security scheme details used for authenticating with this agent.\",\n      |          \"type\": \"object\"\n      |        },\n      |        \"skills\": {\n      |          \"description\": \"Skills are a unit of capability that an agent can perform.\",\n      |          \"items\": {\n      |            \"$ref\": \"#/definitions/AgentSkill\"\n      |          },\n      |          \"type\": \"array\"\n      |        },\n      |        \"supportsAuthenticatedExtendedCard\": {\n      |          \"description\": \"true if the agent supports providing an extended agent card when the user is authenticated.\\nDefaults to false if not specified.\",\n      |          \"type\": \"boolean\"\n      |        },\n      |        \"url\": {\n      |          \"description\": \"A URL to the address the agent is hosted at. This represents the\\npreferred endpoint as declared by the agent.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"version\": {\n      |          \"description\": \"The version of the agent - format is up to the provider.\",\n      |          \"examples\": [\n      |            \"1.0.0\"\n      |          ],\n      |          \"type\": \"string\"\n      |        }\n      |      },\n      |      \"required\": [\n      |        \"capabilities\",\n      |        \"defaultInputModes\",\n      |        \"defaultOutputModes\",\n      |        \"description\",\n      |        \"name\",\n      |        \"protocolVersion\",\n      |        \"skills\",\n      |        \"url\",\n      |        \"version\"\n      |      ],\n      |      \"type\": \"object\"\n      |    },\n      |    \"AgentInterface\": {\n      |      \"description\": \"AgentInterface provides a declaration of a combination of the\\ntarget url and the supported transport to interact with the agent.\",\n      |      \"properties\": {\n      |        \"transport\": {\n      |          \"description\": \"The transport supported this url. This is an open form string, to be\\neasily extended for many transport protocols. The core ones officially\\nsupported are JSONRPC, GRPC and HTTP+JSON.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"url\": {\n      |          \"type\": \"string\"\n      |        }\n      |      },\n      |      \"required\": [\n      |        \"transport\",\n      |        \"url\"\n      |      ],\n      |      \"type\": \"object\"\n      |    },\n      |    \"AgentCapabilities\": {\n      |      \"description\": \"Defines optional capabilities supported by an agent.\",\n      |      \"properties\": {\n      |        \"extensions\": {\n      |          \"description\": \"extensions supported by this agent.\",\n      |          \"items\": {\n      |            \"$ref\": \"#/definitions/AgentExtension\"\n      |          },\n      |          \"type\": \"array\"\n      |        },\n      |        \"pushNotifications\": {\n      |          \"description\": \"true if the agent can notify updates to client.\",\n      |          \"type\": \"boolean\"\n      |        },\n      |        \"stateTransitionHistory\": {\n      |          \"description\": \"true if the agent exposes status change history for tasks.\",\n      |          \"type\": \"boolean\"\n      |        },\n      |        \"streaming\": {\n      |          \"description\": \"true if the agent supports SSE.\",\n      |          \"type\": \"boolean\"\n      |        }\n      |      },\n      |      \"type\": \"object\"\n      |    },\n      |    \"AgentExtension\": {\n      |      \"description\": \"A declaration of an extension supported by an Agent.\",\n      |      \"examples\": [\n      |        {\n      |          \"description\": \"Google OAuth 2.0 authentication\",\n      |          \"required\": false,\n      |          \"uri\": \"https://developers.google.com/identity/protocols/oauth2\"\n      |        }\n      |      ],\n      |      \"properties\": {\n      |        \"description\": {\n      |          \"description\": \"A description of how this agent uses this extension.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"params\": {\n      |          \"additionalProperties\": {},\n      |          \"description\": \"Optional configuration for the extension.\",\n      |          \"type\": \"object\"\n      |        },\n      |        \"required\": {\n      |          \"description\": \"Whether the client must follow specific requirements of the extension.\",\n      |          \"type\": \"boolean\"\n      |        },\n      |        \"uri\": {\n      |          \"description\": \"The URI of the extension.\",\n      |          \"type\": \"string\"\n      |        }\n      |      },\n      |      \"required\": [\n      |        \"uri\"\n      |      ],\n      |      \"type\": \"object\"\n      |    },\n      |    \"AgentProvider\": {\n      |      \"description\": \"Represents the service provider of an agent.\",\n      |      \"examples\": [\n      |        {\n      |          \"organization\": \"Google\",\n      |          \"url\": \"https://ai.google.dev\"\n      |        }\n      |      ],\n      |      \"properties\": {\n      |        \"organization\": {\n      |          \"description\": \"Agent provider's organization name.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"url\": {\n      |          \"description\": \"Agent provider's URL.\",\n      |          \"type\": \"string\"\n      |        }\n      |      },\n      |      \"required\": [\n      |        \"organization\",\n      |        \"url\"\n      |      ],\n      |      \"type\": \"object\"\n      |    },\n      |    \"SecurityScheme\": {\n      |      \"anyOf\": [\n      |        {\n      |          \"$ref\": \"#/definitions/APIKeySecurityScheme\"\n      |        },\n      |        {\n      |          \"$ref\": \"#/definitions/HTTPAuthSecurityScheme\"\n      |        },\n      |        {\n      |          \"$ref\": \"#/definitions/OAuth2SecurityScheme\"\n      |        },\n      |        {\n      |          \"$ref\": \"#/definitions/OpenIdConnectSecurityScheme\"\n      |        }\n      |      ],\n      |      \"description\": \"Mirrors the OpenAPI Security Scheme Object\\n(https://swagger.io/specification/#security-scheme-object)\"\n      |    },\n      |    \"APIKeySecurityScheme\": {\n      |      \"description\": \"API Key security scheme.\",\n      |      \"properties\": {\n      |        \"description\": {\n      |          \"description\": \"Description of this security scheme.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"in\": {\n      |          \"description\": \"The location of the API key. Valid values are \\\"query\\\", \\\"header\\\", or \\\"cookie\\\".\",\n      |          \"enum\": [\n      |            \"cookie\",\n      |            \"header\",\n      |            \"query\"\n      |          ],\n      |          \"type\": \"string\"\n      |        },\n      |        \"name\": {\n      |          \"description\": \"The name of the header, query or cookie parameter to be used.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"type\": {\n      |          \"const\": \"apiKey\",\n      |          \"type\": \"string\"\n      |        }\n      |      },\n      |      \"required\": [\n      |        \"in\",\n      |        \"name\",\n      |        \"type\"\n      |      ],\n      |      \"type\": \"object\"\n      |    },\n      |    \"HTTPAuthSecurityScheme\": {\n      |      \"description\": \"HTTP Authentication security scheme.\",\n      |      \"properties\": {\n      |        \"bearerFormat\": {\n      |          \"description\": \"A hint to the client to identify how the bearer token is formatted. Bearer tokens are usually\\ngenerated by an authorization server, so this information is primarily for documentation\\npurposes.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"description\": {\n      |          \"description\": \"Description of this security scheme.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"scheme\": {\n      |          \"description\": \"The name of the HTTP Authentication scheme to be used in the Authorization header as defined\\nin RFC7235. The values used SHOULD be registered in the IANA Authentication Scheme registry.\\nThe value is case-insensitive, as defined in RFC7235.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"type\": {\n      |          \"const\": \"http\",\n      |          \"type\": \"string\"\n      |        }\n      |      },\n      |      \"required\": [\n      |        \"scheme\",\n      |        \"type\"\n      |      ],\n      |      \"type\": \"object\"\n      |    },\n      |    \"OAuth2SecurityScheme\": {\n      |      \"description\": \"OAuth2.0 security scheme configuration.\",\n      |      \"properties\": {\n      |        \"description\": {\n      |          \"description\": \"Description of this security scheme.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"flows\": {\n      |          \"$ref\": \"#/definitions/OAuthFlows\",\n      |          \"description\": \"An object containing configuration information for the flow types supported.\"\n      |        },\n      |        \"type\": {\n      |          \"const\": \"oauth2\",\n      |          \"type\": \"string\"\n      |        }\n      |      },\n      |      \"required\": [\n      |        \"flows\",\n      |        \"type\"\n      |      ],\n      |      \"type\": \"object\"\n      |    },\n      |    \"OAuthFlows\": {\n      |      \"description\": \"Allows configuration of the supported OAuth Flows\",\n      |      \"properties\": {\n      |        \"authorizationCode\": {\n      |          \"$ref\": \"#/definitions/AuthorizationCodeOAuthFlow\",\n      |          \"description\": \"Configuration for the OAuth Authorization Code flow. Previously called accessCode in OpenAPI 2.0.\"\n      |        },\n      |        \"clientCredentials\": {\n      |          \"$ref\": \"#/definitions/ClientCredentialsOAuthFlow\",\n      |          \"description\": \"Configuration for the OAuth Client Credentials flow. Previously called application in OpenAPI 2.0\"\n      |        },\n      |        \"implicit\": {\n      |          \"$ref\": \"#/definitions/ImplicitOAuthFlow\",\n      |          \"description\": \"Configuration for the OAuth Implicit flow\"\n      |        },\n      |        \"password\": {\n      |          \"$ref\": \"#/definitions/PasswordOAuthFlow\",\n      |          \"description\": \"Configuration for the OAuth Resource Owner Password flow\"\n      |        }\n      |      },\n      |      \"type\": \"object\"\n      |    },\n      |    \"AuthorizationCodeOAuthFlow\": {\n      |      \"description\": \"Configuration details for a supported OAuth Flow\",\n      |      \"properties\": {\n      |        \"authorizationUrl\": {\n      |          \"description\": \"The authorization URL to be used for this flow. This MUST be in the form of a URL. The OAuth2\\nstandard requires the use of TLS\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"refreshUrl\": {\n      |          \"description\": \"The URL to be used for obtaining refresh tokens. This MUST be in the form of a URL. The OAuth2\\nstandard requires the use of TLS.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"scopes\": {\n      |          \"additionalProperties\": {\n      |            \"type\": \"string\"\n      |          },\n      |          \"description\": \"The available scopes for the OAuth2 security scheme. A map between the scope name and a short\\ndescription for it. The map MAY be empty.\",\n      |          \"type\": \"object\"\n      |        },\n      |        \"tokenUrl\": {\n      |          \"description\": \"The token URL to be used for this flow. This MUST be in the form of a URL. The OAuth2 standard\\nrequires the use of TLS.\",\n      |          \"type\": \"string\"\n      |        }\n      |      },\n      |      \"required\": [\n      |        \"authorizationUrl\",\n      |        \"scopes\",\n      |        \"tokenUrl\"\n      |      ],\n      |      \"type\": \"object\"\n      |    },\n      |    \"ClientCredentialsOAuthFlow\": {\n      |      \"description\": \"Configuration details for a supported OAuth Flow\",\n      |      \"properties\": {\n      |        \"refreshUrl\": {\n      |          \"description\": \"The URL to be used for obtaining refresh tokens. This MUST be in the form of a URL. The OAuth2\\nstandard requires the use of TLS.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"scopes\": {\n      |          \"additionalProperties\": {\n      |            \"type\": \"string\"\n      |          },\n      |          \"description\": \"The available scopes for the OAuth2 security scheme. A map between the scope name and a short\\ndescription for it. The map MAY be empty.\",\n      |          \"type\": \"object\"\n      |        },\n      |        \"tokenUrl\": {\n      |          \"description\": \"The token URL to be used for this flow. This MUST be in the form of a URL. The OAuth2 standard\\nrequires the use of TLS.\",\n      |          \"type\": \"string\"\n      |        }\n      |      },\n      |      \"required\": [\n      |        \"scopes\",\n      |        \"tokenUrl\"\n      |      ],\n      |      \"type\": \"object\"\n      |    },\n      |    \"ImplicitOAuthFlow\": {\n      |      \"description\": \"Configuration details for a supported OAuth Flow\",\n      |      \"properties\": {\n      |        \"authorizationUrl\": {\n      |          \"description\": \"The authorization URL to be used for this flow. This MUST be in the form of a URL. The OAuth2\\nstandard requires the use of TLS\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"refreshUrl\": {\n      |          \"description\": \"The URL to be used for obtaining refresh tokens. This MUST be in the form of a URL. The OAuth2\\nstandard requires the use of TLS.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"scopes\": {\n      |          \"additionalProperties\": {\n      |            \"type\": \"string\"\n      |          },\n      |          \"description\": \"The available scopes for the OAuth2 security scheme. A map between the scope name and a short\\ndescription for it. The map MAY be empty.\",\n      |          \"type\": \"object\"\n      |        }\n      |      },\n      |      \"required\": [\n      |        \"authorizationUrl\",\n      |        \"scopes\"\n      |      ],\n      |      \"type\": \"object\"\n      |    },\n      |    \"PasswordOAuthFlow\": {\n      |      \"description\": \"Configuration details for a supported OAuth Flow\",\n      |      \"properties\": {\n      |        \"refreshUrl\": {\n      |          \"description\": \"The URL to be used for obtaining refresh tokens. This MUST be in the form of a URL. The OAuth2\\nstandard requires the use of TLS.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"scopes\": {\n      |          \"additionalProperties\": {\n      |            \"type\": \"string\"\n      |          },\n      |          \"description\": \"The available scopes for the OAuth2 security scheme. A map between the scope name and a short\\ndescription for it. The map MAY be empty.\",\n      |          \"type\": \"object\"\n      |        },\n      |        \"tokenUrl\": {\n      |          \"description\": \"The token URL to be used for this flow. This MUST be in the form of a URL. The OAuth2 standard\\nrequires the use of TLS.\",\n      |          \"type\": \"string\"\n      |        }\n      |      },\n      |      \"required\": [\n      |        \"scopes\",\n      |        \"tokenUrl\"\n      |      ],\n      |      \"type\": \"object\"\n      |    },\n      |    \"OpenIdConnectSecurityScheme\": {\n      |      \"description\": \"OpenID Connect security scheme configuration.\",\n      |      \"properties\": {\n      |        \"description\": {\n      |          \"description\": \"Description of this security scheme.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"openIdConnectUrl\": {\n      |          \"description\": \"Well-known URL to discover the [[OpenID-Connect-Discovery]] provider metadata.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"type\": {\n      |          \"const\": \"openIdConnect\",\n      |          \"type\": \"string\"\n      |        }\n      |      },\n      |      \"required\": [\n      |        \"openIdConnectUrl\",\n      |        \"type\"\n      |      ],\n      |      \"type\": \"object\"\n      |    },\n      |    \"AgentSkill\": {\n      |      \"description\": \"Represents a unit of capability that an agent can perform.\",\n      |      \"properties\": {\n      |        \"description\": {\n      |          \"description\": \"Description of the skill - will be used by the client or a human\\nas a hint to understand what the skill does.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"examples\": {\n      |          \"description\": \"The set of example scenarios that the skill can perform.\\nWill be used by the client as a hint to understand how the skill can be used.\",\n      |          \"examples\": [\n      |            [\n      |              \"I need a recipe for bread\"\n      |            ]\n      |          ],\n      |          \"items\": {\n      |            \"type\": \"string\"\n      |          },\n      |          \"type\": \"array\"\n      |        },\n      |        \"id\": {\n      |          \"description\": \"Unique identifier for the agent's skill.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"inputModes\": {\n      |          \"description\": \"The set of interaction modes that the skill supports\\n(if different than the default).\\nSupported media types for input.\",\n      |          \"items\": {\n      |            \"type\": \"string\"\n      |          },\n      |          \"type\": \"array\"\n      |        },\n      |        \"name\": {\n      |          \"description\": \"Human readable name of the skill.\",\n      |          \"type\": \"string\"\n      |        },\n      |        \"outputModes\": {\n      |          \"description\": \"Supported media types for output.\",\n      |          \"items\": {\n      |            \"type\": \"string\"\n      |          },\n      |          \"type\": \"array\"\n      |        },\n      |        \"tags\": {\n      |          \"description\": \"Set of tagwords describing classes of capabilities for this specific skill.\",\n      |          \"examples\": [\n      |            [\n      |              \"cooking\",\n      |              \"customer support\",\n      |              \"billing\"\n      |            ]\n      |          ],\n      |          \"items\": {\n      |            \"type\": \"string\"\n      |          },\n      |          \"type\": \"array\"\n      |        }\n      |      },\n      |      \"required\": [\n      |        \"description\",\n      |        \"id\",\n      |        \"name\",\n      |        \"tags\"\n      |      ],\n      |      \"type\": \"object\"\n      |    }\n      |  }\n      |}\n      |")).stripMargin();
    }

    private AgentDomainSchema$() {
        MODULE$ = this;
    }
}

