/*
 * Decompiled with CFR 0.152.
 */
package amf.apicontract.internal.transformation.compatibility.common;

import amf.apicontract.client.scala.model.domain.security.ApiKeySettings;
import amf.apicontract.client.scala.model.domain.security.OAuth1Settings;
import amf.apicontract.client.scala.model.domain.security.OAuth2Settings;
import amf.apicontract.client.scala.model.domain.security.OpenIdConnectSettings;
import amf.apicontract.client.scala.model.domain.security.SecurityScheme;
import amf.apicontract.client.scala.model.domain.security.Settings;
import amf.core.client.scala.errorhandling.AMFErrorHandler;
import amf.core.client.scala.model.document.BaseUnit;
import amf.core.client.scala.model.document.DeclaresModel;
import amf.core.client.scala.model.domain.DomainElement;
import amf.core.client.scala.model.domain.NamedDomainElement;
import amf.core.client.scala.transform.stages.TransformationStep;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001%4Q\u0001C\u0005\u0002\u0002YAQA\u000b\u0001\u0005\u0002-BQA\f\u0001\u0007\u0002=BQ!\u0011\u0001\u0005\u0002\tCQ\u0001\u0014\u0001\u0005\n5CQ\u0001\u0014\u0001\u0005\n=CQ!\u0017\u0001\u0005\u0002iCQA\t\u0001\u0005Bq\u0013acU3dkJLG/_*fiRLgnZ:NCB\u0004XM\u001d\u0006\u0003\u0015-\taaY8n[>t'B\u0001\u0007\u000e\u00035\u0019w.\u001c9bi&\u0014\u0017\u000e\\5us*\u0011abD\u0001\u000fiJ\fgn\u001d4pe6\fG/[8o\u0015\t\u0001\u0012#\u0001\u0005j]R,'O\\1m\u0015\t\u00112#A\u0006ba&\u001cwN\u001c;sC\u000e$(\"\u0001\u000b\u0002\u0007\u0005lgm\u0001\u0001\u0014\u0007\u00019R\u0004\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0004B]f\u0014VM\u001a\t\u0003=!j\u0011a\b\u0006\u0003A\u0005\naa\u001d;bO\u0016\u001c(B\u0001\u0012$\u0003%!(/\u00198tM>\u0014XN\u0003\u0002\u001bI)\u0011QEJ\u0001\u0007G2LWM\u001c;\u000b\u0005\u001d\u001a\u0012\u0001B2pe\u0016L!!K\u0010\u0003%Q\u0013\u0018M\\:g_Jl\u0017\r^5p]N#X\r]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00031\u0002\"!\f\u0001\u000e\u0003%\t\u0011BZ5y\u001f\u0006,H\u000f\u001b\u001a\u0015\u0005A\u001a\u0004C\u0001\r2\u0013\t\u0011\u0014D\u0001\u0003V]&$\b\"\u0002\u001b\u0003\u0001\u0004)\u0014AB8bkRD'\u0007\u0005\u00027\u007f5\tqG\u0003\u00029s\u0005A1/Z2ve&$\u0018P\u0003\u0002;w\u00051Am\\7bS:T!\u0001P\u001f\u0002\u000b5|G-\u001a7\u000b\u0005iq$BA\u0013\u0012\u0013\t\u0001uG\u0001\bP\u0003V$\bNM*fiRLgnZ:\u0002\u0013\u0019L\u00070\u00119j\u0017\u0016LHc\u0001\u0019D\u000f\")\u0001h\u0001a\u0001\tB\u0011a'R\u0005\u0003\r^\u0012abU3dkJLG/_*dQ\u0016lW\rC\u0003I\u0007\u0001\u0007\u0011*\u0001\u0004ba&\\U-\u001f\t\u0003m)K!aS\u001c\u0003\u001d\u0005\u0003\u0018nS3z'\u0016$H/\u001b8hg\u0006Ya-\u001b=TKR$\u0018N\\4t)\t\u0001d\nC\u00039\t\u0001\u0007A\t\u0006\u00021!\")\u0011+\u0002a\u0001%\u0006\tA\r\u0005\u0002T/6\tAK\u0003\u0002V-\u0006AAm\\2v[\u0016tGO\u0003\u0002=G%\u0011\u0001\f\u0016\u0002\u000e\t\u0016\u001cG.\u0019:fg6{G-\u001a7\u00021I,Wn\u001c<f+:\u001cX\u000f\u001d9peR,GmU2iK6,7\u000f\u0006\u0002S7\")\u0011K\u0002a\u0001%R\u0019Q\fY1\u0011\u0005Ms\u0016BA0U\u0005!\u0011\u0015m]3V]&$\b\"\u0002\u001f\b\u0001\u0004i\u0006\"\u00022\b\u0001\u0004\u0019\u0017\u0001D3se>\u0014\b*\u00198eY\u0016\u0014\bC\u00013h\u001b\u0005)'B\u00014$\u00035)'O]8sQ\u0006tG\r\\5oO&\u0011\u0001.\u001a\u0002\u0010\u000363UI\u001d:pe\"\u000bg\u000e\u001a7fe\u0002")
public abstract class SecuritySettingsMapper
implements TransformationStep {
    public abstract void fixOauth2(OAuth2Settings var1);

    public void fixApiKey(SecurityScheme security, ApiKeySettings apiKey) {
        if (security.queryParameters().nonEmpty()) {
            apiKey.withIn("query");
            apiKey.withName(((NamedDomainElement)security.queryParameters().head()).name().value());
        } else if (security.headers().nonEmpty()) {
            apiKey.withIn("header");
            apiKey.withName(((NamedDomainElement)security.headers().head()).name().value());
        } else {
            apiKey.withIn("query");
            apiKey.withName("");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void fixSettings(SecurityScheme security) {
        Settings settings = security.settings();
        if (settings instanceof OAuth2Settings) {
            OAuth2Settings oAuth2Settings = (OAuth2Settings)settings;
            this.fixOauth2(oAuth2Settings);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (settings instanceof ApiKeySettings) {
            ApiKeySettings apiKeySettings = (ApiKeySettings)settings;
            this.fixApiKey(security, apiKeySettings);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (settings == null) {
            Object object = security.type().option().getOrElse((Function0 & java.io.Serializable & Serializable)() -> "");
            String string = "x-amf-apiKey";
            if (!(object != null ? !object.equals(string) : string != null)) {
                this.fixApiKey(security, security.withApiKeySettings());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void fixSettings(DeclaresModel d) {
        d.declares().foreach((Function1 & java.io.Serializable & Serializable)x0$1 -> {
            SecuritySettingsMapper.$anonfun$fixSettings$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public DeclaresModel removeUnsupportedSchemes(DeclaresModel d) {
        Seq filteredDeclarations = (Seq)d.declares().filter((Function1 & java.io.Serializable & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SecuritySettingsMapper.$anonfun$removeUnsupportedSchemes$1(x0$1)));
        return d.withDeclares(filteredDeclarations, d.withDeclares$default$2());
    }

    public BaseUnit transform(BaseUnit model, AMFErrorHandler errorHandler) {
        BaseUnit baseUnit;
        BaseUnit baseUnit2 = model;
        if (baseUnit2 instanceof DeclaresModel) {
            BaseUnit baseUnit3 = baseUnit2;
            try {
                this.fixSettings((DeclaresModel)baseUnit3);
            }
            catch (Throwable throwable) {}
            baseUnit = model;
        } else {
            baseUnit = model;
        }
        return baseUnit;
    }

    public static final /* synthetic */ void $anonfun$fixSettings$2(SecuritySettingsMapper $this, DomainElement x0$1) {
        DomainElement domainElement = x0$1;
        if (domainElement instanceof SecurityScheme) {
            SecurityScheme securityScheme = (SecurityScheme)domainElement;
            $this.fixSettings(securityScheme);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$removeUnsupportedSchemes$1(DomainElement x0$1) {
        boolean bl;
        DomainElement domainElement = x0$1;
        if (domainElement instanceof SecurityScheme) {
            SecurityScheme securityScheme = (SecurityScheme)domainElement;
            Settings settings = securityScheme.settings();
            boolean bl2 = settings instanceof OAuth1Settings ? false : !(settings instanceof OpenIdConnectSettings);
            bl = bl2;
        } else {
            bl = true;
        }
        return bl;
    }
}

