package amf.apicontract.internal.spec.common.parser

import amf.aml.internal.parse.common.DeclarationContext
import amf.aml.internal.semantic.{SemanticExtensionsFacade, SemanticExtensionsFacadeBuilder}
import amf.apicontract.internal.spec.common.WebApiDeclarations
import amf.apicontract.internal.spec.common.emitter.SpecAwareContext
import amf.core.client.scala.config.ParsingOptions
import amf.core.client.scala.model.domain.{AmfObject, Shape}
import amf.core.client.scala.parse.document.{ParsedReference, ParserContext}
import amf.core.internal.parser._
import amf.core.internal.plugins.syntax.SyamlAMFErrorHandler
import amf.core.internal.remote.Spec
import amf.core.internal.unsafe.PlatformSecrets
import amf.core.internal.utils.{AliasCounter, QName}
import amf.shapes.client.scala.model.domain.AnyShape
import amf.shapes.internal.spec.common.parser._
import amf.shapes.internal.spec.common.{JSONSchemaDraft4SchemaVersion, SchemaVersion}
import amf.shapes.internal.spec.contexts.JsonSchemaRefGuide
import amf.shapes.internal.spec.jsonschema.ref.{AstFinder, AstIndex, AstIndexBuilder, JsonSchemaInference}
import org.mulesoft.common.client.lexical.SourceLocation
import org.yaml.model._

import scala.collection.mutable

abstract class WebApiContext(
    loc: String,
    refs: Seq[ParsedReference],
    options: ParsingOptions,
    wrapped: ParserContext,
    declarationsOption: Option[WebApiDeclarations] = None,
    nodeRefIds: mutable.Map[YNode, String] = mutable.Map.empty,
    specSettings: SpecSettings
) extends ShapeParserContext(loc, refs, options, wrapped, declarationsOption, nodeRefIds, specSettings)
    with DeclarationContext
    with SpecAwareContext {

  override val declarations: WebApiDeclarations = declarationsOption.getOrElse({
    val decls = new WebApiDeclarations(None, errorHandler = eh, futureDeclarations = futureDeclarations)
    decls.extensions ++= computeExtensions
    decls
  })

  protected val closedShapeValidator: ClosedShapeValidator = specSettings.closedShapeValidator

  protected def setJsonSchemaRefGuide(refGuide: JsonSchemaRefGuide): Unit = jsonSchemaRefGuide = refGuide

  def autoGeneratedAnnotation(s: Shape): Unit

  def getEntryKey(entry: YMapEntry): String = {
    entry.key.asOption[YScalar].map(_.text).getOrElse(entry.key.toString)
  }
}
