/*
 * Decompiled with CFR 0.152.
 */
package amf.apicontract.internal.transformation.compatibility.common;

import amf.apicontract.client.scala.model.domain.security.ApiKeySettings;
import amf.apicontract.client.scala.model.domain.security.OAuth1Settings;
import amf.apicontract.client.scala.model.domain.security.OAuth2Settings;
import amf.apicontract.client.scala.model.domain.security.OpenIdConnectSettings;
import amf.apicontract.client.scala.model.domain.security.SecurityScheme;
import amf.apicontract.client.scala.model.domain.security.Settings;
import amf.core.client.scala.AMFGraphConfiguration;
import amf.core.client.scala.errorhandling.AMFErrorHandler;
import amf.core.client.scala.model.document.BaseUnit;
import amf.core.client.scala.model.document.DeclaresModel;
import amf.core.client.scala.model.domain.DomainElement;
import amf.core.client.scala.model.domain.NamedDomainElement;
import amf.core.client.scala.transform.TransformationStep;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000154Q\u0001C\u0005\u0002\u0002YAQ\u0001\u000b\u0001\u0005\u0002%BQ\u0001\f\u0001\u0007\u00025BQa\u0010\u0001\u0005\u0002\u0001CQA\u0013\u0001\u0005\n-CQA\u0013\u0001\u0005\n5CQa\u0016\u0001\u0005\u0002aCQ\u0001\t\u0001\u0005Bi\u0013acU3dkJLG/_*fiRLgnZ:NCB\u0004XM\u001d\u0006\u0003\u0015-\taaY8n[>t'B\u0001\u0007\u000e\u00035\u0019w.\u001c9bi&\u0014\u0017\u000e\\5us*\u0011abD\u0001\u000fiJ\fgn\u001d4pe6\fG/[8o\u0015\t\u0001\u0012#\u0001\u0005j]R,'O\\1m\u0015\t\u00112#A\u0006ba&\u001cwN\u001c;sC\u000e$(\"\u0001\u000b\u0002\u0007\u0005lgm\u0001\u0001\u0014\u0007\u00019R\u0004\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0004B]f\u0014VM\u001a\t\u0003=\u0019j\u0011a\b\u0006\u0003A\u0005\n\u0011\u0002\u001e:b]N4wN]7\u000b\u0005i\u0011#BA\u0012%\u0003\u0019\u0019G.[3oi*\u0011QeE\u0001\u0005G>\u0014X-\u0003\u0002(?\t\u0011BK]1og\u001a|'/\\1uS>t7\u000b^3q\u0003\u0019a\u0014N\\5u}Q\t!\u0006\u0005\u0002,\u00015\t\u0011\"A\u0005gSb|\u0015-\u001e;ieQ\u0011a&\r\t\u00031=J!\u0001M\r\u0003\tUs\u0017\u000e\u001e\u0005\u0006e\t\u0001\raM\u0001\u0007_\u0006,H\u000f\u001b\u001a\u0011\u0005QjT\"A\u001b\u000b\u0005Y:\u0014\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005aJ\u0014A\u00023p[\u0006LgN\u0003\u0002;w\u0005)Qn\u001c3fY*\u0011!\u0004\u0010\u0006\u0003GEI!AP\u001b\u0003\u001d=\u000bU\u000f\u001e53'\u0016$H/\u001b8hg\u0006Ia-\u001b=Ba&\\U-\u001f\u000b\u0004]\u0005+\u0005\"\u0002\u001c\u0004\u0001\u0004\u0011\u0005C\u0001\u001bD\u0013\t!UG\u0001\bTK\u000e,(/\u001b;z'\u000eDW-\\3\t\u000b\u0019\u001b\u0001\u0019A$\u0002\r\u0005\u0004\u0018nS3z!\t!\u0004*\u0003\u0002Jk\tq\u0011\t]5LKf\u001cV\r\u001e;j]\u001e\u001c\u0018a\u00034jqN+G\u000f^5oON$\"A\f'\t\u000bY\"\u0001\u0019\u0001\"\u0015\u00059r\u0005\"B(\u0006\u0001\u0004\u0001\u0016!\u00013\u0011\u0005E+V\"\u0001*\u000b\u0005M#\u0016\u0001\u00033pGVlWM\u001c;\u000b\u0005i\n\u0013B\u0001,S\u00055!Um\u00197be\u0016\u001cXj\u001c3fY\u0006A\"/Z7pm\u0016,fn];qa>\u0014H/\u001a3TG\",W.Z:\u0015\u0005AK\u0006\"B(\u0007\u0001\u0004\u0001F\u0003B._?\u001e\u0004\"!\u0015/\n\u0005u\u0013&\u0001\u0003\"bg\u0016,f.\u001b;\t\u000bi:\u0001\u0019A.\t\u000b\u0001<\u0001\u0019A1\u0002\u0019\u0015\u0014(o\u001c:IC:$G.\u001a:\u0011\u0005\t,W\"A2\u000b\u0005\u0011\f\u0013!D3se>\u0014\b.\u00198eY&tw-\u0003\u0002gG\ny\u0011)\u0014$FeJ|'\u000fS1oI2,'\u000fC\u0003i\u000f\u0001\u0007\u0011.A\u0007d_:4\u0017nZ;sCRLwN\u001c\t\u0003U.l\u0011!I\u0005\u0003Y\u0006\u0012Q#Q'G\u000fJ\f\u0007\u000f[\"p]\u001aLw-\u001e:bi&|g\u000e")
public abstract class SecuritySettingsMapper
implements TransformationStep {
    public abstract void fixOauth2(OAuth2Settings var1);

    public void fixApiKey(SecurityScheme security, ApiKeySettings apiKey) {
        if (security.queryParameters().nonEmpty()) {
            apiKey.withIn("query");
            apiKey.withName(((NamedDomainElement)security.queryParameters().head()).name().value());
        } else if (security.headers().nonEmpty()) {
            apiKey.withIn("header");
            apiKey.withName(((NamedDomainElement)security.headers().head()).name().value());
        } else {
            apiKey.withIn("query");
            apiKey.withName("");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void fixSettings(SecurityScheme security) {
        Settings settings = security.settings();
        if (settings instanceof OAuth2Settings) {
            OAuth2Settings oAuth2Settings = (OAuth2Settings)settings;
            this.fixOauth2(oAuth2Settings);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (settings instanceof ApiKeySettings) {
            ApiKeySettings apiKeySettings = (ApiKeySettings)settings;
            this.fixApiKey(security, apiKeySettings);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (settings == null) {
            Object object = security.type().option().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            String string = "x-amf-apiKey";
            if (!(object != null ? !object.equals(string) : string != null)) {
                this.fixApiKey(security, security.withApiKeySettings());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void fixSettings(DeclaresModel d) {
        d.declares().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SecuritySettingsMapper.$anonfun$fixSettings$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public DeclaresModel removeUnsupportedSchemes(DeclaresModel d) {
        Seq filteredDeclarations = (Seq)d.declares().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SecuritySettingsMapper.$anonfun$removeUnsupportedSchemes$1(x0$1)));
        return d.withDeclares(filteredDeclarations, d.withDeclares$default$2());
    }

    public BaseUnit transform(BaseUnit model, AMFErrorHandler errorHandler, AMFGraphConfiguration configuration) {
        BaseUnit baseUnit;
        BaseUnit baseUnit2 = model;
        if (baseUnit2 instanceof DeclaresModel) {
            BaseUnit baseUnit3 = baseUnit2;
            try {
                this.fixSettings((DeclaresModel)baseUnit3);
            }
            catch (Throwable throwable) {}
            baseUnit = model;
        } else {
            baseUnit = model;
        }
        return baseUnit;
    }

    public static final /* synthetic */ void $anonfun$fixSettings$2(SecuritySettingsMapper $this, DomainElement x0$1) {
        DomainElement domainElement = x0$1;
        if (domainElement instanceof SecurityScheme) {
            SecurityScheme securityScheme = (SecurityScheme)domainElement;
            $this.fixSettings(securityScheme);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$removeUnsupportedSchemes$1(DomainElement x0$1) {
        boolean bl;
        DomainElement domainElement = x0$1;
        if (domainElement instanceof SecurityScheme) {
            SecurityScheme securityScheme = (SecurityScheme)domainElement;
            Settings settings = securityScheme.settings();
            boolean bl2 = settings instanceof OAuth1Settings ? false : !(settings instanceof OpenIdConnectSettings);
            bl = bl2;
        } else {
            bl = true;
        }
        return bl;
    }
}

