package amf.apicontract.internal.spec.oas.parser.context

import amf.apicontract.internal.spec.common.parser.{CustomSyntax, SpecNode}
import amf.core.client.common.validation.SeverityLevels
import amf.core.client.scala.model.domain.{AmfObject, Shape}
import amf.core.internal.remote.Spec
import amf.shapes.internal.spec.common.parser
import amf.shapes.internal.spec.common.parser.{
  ClosedShapeValidator,
  DefaultClosedShapeValidator,
  IgnoreCriteria,
  SpecSyntax,
  UnknownShapeValidator
}
import org.yaml.model.{YMap, YNode, YPart}

class CustomClosedShapeContextDecorator(decorated: OasLikeWebApiContext, customSyntax: CustomSyntax)
    extends OasLikeWebApiContext(
      decorated.loc,
      decorated.refs,
      decorated.options,
      decorated,
      Some(decorated.declarations),
      specSettings = decorated.specSettings
    ) {

  override def syntax: SpecSyntax             = decorated.syntax
  override def spec: Spec                     = decorated.spec
  override def ignoreCriteria: IgnoreCriteria = decorated.ignoreCriteria

  override def closedShape(node: AmfObject, ast: YMap, shape: String): Unit =
    closedShapeValidator.evaluate(node, ast, shape)(syamleh)

  override protected val closedShapeValidator: ClosedShapeValidator = parser.DefaultClosedShapeValidator(
    ignoreCriteria,
    spec,
    syntax,
    createCustomValidator()
  )

  private def createCustomValidator() =
    SecuritySchemeClosedShapeValidator(customSyntax, spec, ignoreCriteria, UnknownShapeValidator(spec))

  override def link(node: YNode): Either[String, YNode] = decorated.link(node)

  override def autoGeneratedAnnotation(s: Shape): Unit = decorated.autoGeneratedAnnotation(s)

  override val factory: OasLikeSpecVersionFactory = decorated.factory

  override def makeCopy(): OasLikeWebApiContext = decorated.makeCopy()

  private def getAstEntry(ast: YMap, entry: String): YPart =
    ast.entries.find(yMapEntry => yMapEntry.key.asScalar.map(_.text).get == entry).get
}
