/*
 * Decompiled with CFR 0.152.
 */
package amf.core.client.scala.validation;

import amf.core.client.common.validation.AmfProfile$;
import amf.core.client.common.validation.ProfileName;
import amf.core.client.scala.AMFGraphConfiguration;
import amf.core.client.scala.model.document.BaseUnit;
import amf.core.client.scala.validation.AMFValidationReport;
import amf.core.client.scala.validation.VendorToProfile$;
import amf.core.internal.plugins.AMFPlugin$;
import amf.core.internal.plugins.validation.AMFValidatePlugin;
import amf.core.internal.plugins.validation.ValidationInfo;
import amf.core.internal.plugins.validation.ValidationOptions;
import amf.core.internal.remote.Spec;
import amf.core.internal.validation.EffectiveValidations;
import amf.core.internal.validation.EffectiveValidations$;
import amf.core.internal.validation.FailFastValidationRunner;
import amf.core.internal.validation.ValidationConfiguration;
import amf.core.internal.validation.core.ValidationProfile;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.concurrent.Future;
import scala.runtime.BoxesRunTime;

public final class AMFValidator$ {
    public static AMFValidator$ MODULE$;

    static {
        new AMFValidator$();
    }

    public Future<AMFValidationReport> validate(BaseUnit baseUnit, AMFGraphConfiguration conf) {
        ProfileName profileName = (ProfileName)baseUnit.sourceSpec().map((Function1<Spec, ProfileName> & Serializable & scala.Serializable)spec -> VendorToProfile$.MODULE$.mapOrDefault((Spec)spec)).getOrElse((Function0<AmfProfile$> & Serializable & scala.Serializable)() -> AmfProfile$.MODULE$);
        List plugins = (List)((SeqLike)conf.registry().plugins().validatePlugins().filter((Function1<AMFValidatePlugin, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(x$1.applies(new ValidationInfo(baseUnit, profileName))))).sorted(AMFPlugin$.MODULE$.ordering());
        EffectiveValidations constraints = this.computeApplicableConstraints(profileName, conf.registry().constraintsRules());
        ValidationOptions options = new ValidationOptions(profileName, constraints, new ValidationConfiguration(conf));
        FailFastValidationRunner runner = new FailFastValidationRunner(plugins, options);
        return runner.run(baseUnit, conf.getExecutionContext());
    }

    private EffectiveValidations computeApplicableConstraints(ProfileName profileName, Map<ProfileName, ValidationProfile> constraints) {
        Seq<ValidationProfile> profiles = this.findProfileHierarchy(profileName, constraints, this.findProfileHierarchy$default$3());
        EffectiveValidations applicable = EffectiveValidations$.MODULE$.apply();
        return profiles.foldLeft(applicable, (Function2<EffectiveValidations, ValidationProfile, EffectiveValidations> & Serializable & scala.Serializable)(acc, curr) -> acc.someEffective((ValidationProfile)curr));
    }

    private Seq<ValidationProfile> findProfileHierarchy(ProfileName profileName, Map<ProfileName, ValidationProfile> constraints, Set<ProfileName> seen) {
        if (seen.contains(profileName)) {
            return (Seq)Seq$.MODULE$.empty();
        }
        return (Seq)((MapLike)constraints.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            ProfileName key = (ProfileName)tuple2._1();
            ValidationProfile value = (ValidationProfile)tuple2._2();
            Tuple2<String, ValidationProfile> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key.p()), value);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom())).get(profileName.p()).map((Function1<ValidationProfile, Seq> & Serializable & scala.Serializable)profile -> ((TraversableLike)profile.baseProfile().map((Function1<ProfileName, Seq> & Serializable & scala.Serializable)base -> MODULE$.findProfileHierarchy((ProfileName)base, constraints, (Set)seen.$plus(profile.name()))).getOrElse((Function0<Seq> & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty())).$plus$plus(Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ValidationProfile[]{profile})), Seq$.MODULE$.canBuildFrom())).getOrElse((Function0<Seq> & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
    }

    private Set<ProfileName> findProfileHierarchy$default$3() {
        return Predef$.MODULE$.Set().empty();
    }

    private AMFValidator$() {
        MODULE$ = this;
    }
}

