/*
 * Decompiled with CFR 0.152.
 */
package amf.apicontract.internal.spec.oas.parser.domain;

import amf.apicontract.client.scala.model.domain.security.ApiKeySettings;
import amf.apicontract.client.scala.model.domain.security.HttpSettings;
import amf.apicontract.client.scala.model.domain.security.OAuth1Settings;
import amf.apicontract.client.scala.model.domain.security.OAuth2Flow;
import amf.apicontract.client.scala.model.domain.security.OAuth2Flow$;
import amf.apicontract.client.scala.model.domain.security.OAuth2Settings;
import amf.apicontract.client.scala.model.domain.security.OpenIdConnectSettings;
import amf.apicontract.client.scala.model.domain.security.SecurityScheme;
import amf.apicontract.client.scala.model.domain.security.Settings;
import amf.apicontract.internal.metamodel.domain.security.HttpSettingsModel$;
import amf.apicontract.internal.metamodel.domain.security.OAuth2FlowModel$;
import amf.apicontract.internal.metamodel.domain.security.OAuth2SettingsModel$;
import amf.apicontract.internal.metamodel.domain.security.OpenIdConnectSettingsModel$;
import amf.apicontract.internal.spec.common.parser.Oas3SettingsProducers$;
import amf.apicontract.internal.spec.common.parser.SettingsProducers;
import amf.apicontract.internal.spec.common.parser.WebApiShapeParserContextAdapter;
import amf.apicontract.internal.spec.oas.parser.context.OasWebApiContext;
import amf.apicontract.internal.spec.oas.parser.domain.OAuth2FlowValidations$;
import amf.apicontract.internal.spec.oas.parser.domain.OasLikeSecuritySettingsParser;
import amf.core.client.scala.model.domain.AmfArray;
import amf.core.client.scala.model.domain.AmfElement;
import amf.core.client.scala.model.domain.AmfScalar;
import amf.core.internal.parser.domain.Annotations$;
import amf.core.internal.parser.domain.ScalarNode$;
import amf.core.internal.utils.package$;
import amf.shapes.internal.spec.common.parser.AnnotationParser;
import amf.shapes.internal.spec.common.parser.AnnotationParser$;
import java.io.Serializable;
import org.yaml.convert.YRead$YMapYRead$;
import org.yaml.model.YMap;
import org.yaml.model.YMapEntry;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001\u0002\u0007\u000e\u0001qA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tY\u0001\u0011\t\u0011)A\u0005[!A\u0011\b\u0001B\u0001B\u0003-!\bC\u0003A\u0001\u0011\u0005\u0011\tC\u0003H\u0001\u0011\u0005\u0003\nC\u0003R\u0001\u0011\u0005!\u000bC\u0003Y\u0001\u0011\u0005\u0011\fC\u0003_\u0001\u0011\u0005s\fC\u0003e\u0001\u0011%Q\rC\u0003p\u0001\u0011%\u0001\u000fC\u0004\u0002\b\u0001!\t%!\u0003\u00035=\u000b7oM*fGV\u0014\u0018\u000e^=TKR$\u0018N\\4t!\u0006\u00148/\u001a:\u000b\u00059y\u0011A\u00023p[\u0006LgN\u0003\u0002\u0011#\u00051\u0001/\u0019:tKJT!AE\n\u0002\u0007=\f7O\u0003\u0002\u0015+\u0005!1\u000f]3d\u0015\t1r#\u0001\u0005j]R,'O\\1m\u0015\tA\u0012$A\u0006ba&\u001cwN\u001c;sC\u000e$(\"\u0001\u000e\u0002\u0007\u0005lgm\u0001\u0001\u0014\u0005\u0001i\u0002C\u0001\u0010 \u001b\u0005i\u0011B\u0001\u0011\u000e\u0005uy\u0015m\u001d'jW\u0016\u001cVmY;sSRL8+\u001a;uS:<7\u000fU1sg\u0016\u0014\u0018aA7baB\u00111EK\u0007\u0002I)\u0011QEJ\u0001\u0006[>$W\r\u001c\u0006\u0003O!\nA!_1nY*\t\u0011&A\u0002pe\u001eL!a\u000b\u0013\u0003\tek\u0015\r]\u0001\u0007g\u000eDW-\\3\u0011\u00059:T\"A\u0018\u000b\u0005A\n\u0014\u0001C:fGV\u0014\u0018\u000e^=\u000b\u00059\u0011$BA\u00134\u0015\t!T'A\u0003tG\u0006d\u0017M\u0003\u00027/\u000511\r\\5f]RL!\u0001O\u0018\u0003\u001dM+7-\u001e:jif\u001c6\r[3nK\u0006\u00191\r\u001e=\u0011\u0005mrT\"\u0001\u001f\u000b\u0005uz\u0011aB2p]R,\u0007\u0010^\u0005\u0003\u007fq\u0012\u0001cT1t/\u0016\u0014\u0017\t]5D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\r\u0011UI\u0012\u000b\u0003\u0007\u0012\u0003\"A\b\u0001\t\u000be\"\u00019\u0001\u001e\t\u000b\u0005\"\u0001\u0019\u0001\u0012\t\u000b1\"\u0001\u0019A\u0017\u0002\u000bA\f'o]3\u0015\u0003%\u00032A\u0013'O\u001b\u0005Y%\"\u0001\u001b\n\u00055[%AB(qi&|g\u000e\u0005\u0002/\u001f&\u0011\u0001k\f\u0002\t'\u0016$H/\u001b8hg\u0006Q\u0002/\u0019:tK>\u0003XM\\%e\u0007>tg.Z2u'\u0016$H/\u001b8hgR\u00111K\u0016\t\u0003]QK!!V\u0018\u0003+=\u0003XM\\%e\u0007>tg.Z2u'\u0016$H/\u001b8hg\")qK\u0002a\u0001'\u0006A1/\u001a;uS:<7/A\tqCJ\u001cX\r\u0013;uaN+G\u000f^5oON$\"AW/\u0011\u00059Z\u0016B\u0001/0\u00051AE\u000f\u001e9TKR$\u0018N\\4t\u0011\u00159v\u00011\u0001[\u0003M\u0001\u0018M]:f\u001f\u0006,H\u000f\u001b\u001aTKR$\u0018N\\4t)\t\u00017\r\u0005\u0002/C&\u0011!m\f\u0002\u000f\u001f\u0006+H\u000f\u001b\u001aTKR$\u0018N\\4t\u0011\u00159\u0006\u00021\u0001a\u0003)\u0001\u0018M]:f\r2|wo\u001d\u000b\u0004M&t\u0007C\u0001&h\u0013\tA7J\u0001\u0003V]&$\b\"\u00026\n\u0001\u0004Y\u0017!B3oiJL\bCA\u0012m\u0013\tiGEA\u0005Z\u001b\u0006\u0004XI\u001c;ss\")q+\u0003a\u0001A\u0006I\u0001/\u0019:tK\u001acwn\u001e\u000b\u0005cR\f\u0019\u0001\u0005\u0002/e&\u00111o\f\u0002\u000b\u001f\u0006+H\u000f\u001b\u001aGY><\b\"B;\u000b\u0001\u00041\u0018A\u00029be\u0016tG\u000f\u0005\u0002x}:\u0011\u0001\u0010 \t\u0003s.k\u0011A\u001f\u0006\u0003wn\ta\u0001\u0010:p_Rt\u0014BA?L\u0003\u0019\u0001&/\u001a3fM&\u0019q0!\u0001\u0003\rM#(/\u001b8h\u0015\ti8\n\u0003\u0004\u0002\u0006)\u0001\ra[\u0001\nM2|w/\u00128uef\fqD^3oI>\u00148\u000b]3dS\u001aL7mU3ui&twm\u001d)s_\u0012,8-\u001a:t)\t\tY\u0001\u0005\u0003\u0002\u000e\u0005UQBAA\b\u0015\r\u0001\u0012\u0011\u0003\u0006\u0004\u0003'\u0019\u0012AB2p[6|g.\u0003\u0003\u0002\u0018\u0005=!!E*fiRLgnZ:Qe>$WoY3sg\u0002")
public class Oas3SecuritySettingsParser
extends OasLikeSecuritySettingsParser {
    private final YMap map;
    private final OasWebApiContext ctx;

    @Override
    public Option<Settings> parse() {
        return this.produceSettings().map((Function1<Settings, Settings> & Serializable & scala.Serializable)settings -> {
            Settings settings2;
            Settings settings3 = settings;
            if (settings3 instanceof OAuth1Settings) {
                OAuth1Settings oAuth1Settings = (OAuth1Settings)settings3;
                settings2 = this.parseOauth1Settings(oAuth1Settings);
            } else if (settings3 instanceof OAuth2Settings) {
                OAuth2Settings oAuth2Settings = (OAuth2Settings)settings3;
                settings2 = this.parseOauth2Settings(oAuth2Settings);
            } else if (settings3 instanceof ApiKeySettings) {
                ApiKeySettings apiKeySettings = (ApiKeySettings)settings3;
                settings2 = this.parseApiKeySettings(apiKeySettings);
            } else if (settings3 instanceof OpenIdConnectSettings) {
                OpenIdConnectSettings openIdConnectSettings = (OpenIdConnectSettings)settings3;
                settings2 = this.parseOpenIdConnectSettings(openIdConnectSettings);
            } else if (settings3 instanceof HttpSettings) {
                HttpSettings httpSettings = (HttpSettings)settings3;
                settings2 = this.parseHttpSettings(httpSettings);
            } else {
                settings2 = (Settings)amf.core.internal.parser.package$.MODULE$.YMapOps($this.map).key(package$.MODULE$.AmfStrings("settings").asOasExtension()).map((Function1<YMapEntry, Settings> & Serializable & scala.Serializable)entry -> this.parseDynamicSettings(entry.value().as(YRead$YMapYRead$.MODULE$, $this.ctx), settings3, Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).getOrElse((Function0<Settings> & Serializable & scala.Serializable)() -> settings3);
            }
            OAuth1Settings parsedSettings = settings2;
            return this.parseAnnotations(parsedSettings);
        });
    }

    public OpenIdConnectSettings parseOpenIdConnectSettings(OpenIdConnectSettings settings) {
        amf.core.internal.parser.package$.MODULE$.YMapOps(this.map).key("openIdConnectUrl", this.FieldOps(OpenIdConnectSettingsModel$.MODULE$.Url(), this.ctx).in(settings));
        amf.core.internal.parser.package$.MODULE$.YMapOps(this.map).key(package$.MODULE$.AmfStrings("settings").asOasExtension(), (Function1<YMapEntry, BoxedUnit>)(Function1<YMapEntry, Object> & Serializable & scala.Serializable)entry -> {
            this.parseDynamicSettings(entry.value().as(YRead$YMapYRead$.MODULE$, this.ctx), settings, Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            return BoxedUnit.UNIT;
        });
        return settings;
    }

    public HttpSettings parseHttpSettings(HttpSettings settings) {
        amf.core.internal.parser.package$.MODULE$.YMapOps(this.map).key("scheme", this.FieldOps(HttpSettingsModel$.MODULE$.Scheme(), this.ctx).in(settings));
        amf.core.internal.parser.package$.MODULE$.YMapOps(this.map).key("bearerFormat", this.FieldOps(HttpSettingsModel$.MODULE$.BearerFormat(), this.ctx).in(settings));
        return settings;
    }

    @Override
    public OAuth2Settings parseOauth2Settings(OAuth2Settings settings) {
        amf.core.internal.parser.package$.MODULE$.YMapOps(this.map).key("flows", (Function1<YMapEntry, BoxedUnit>)(Function1<YMapEntry, Object> & Serializable & scala.Serializable)x$1 -> {
            this.parseFlows(x$1, settings);
            return BoxedUnit.UNIT;
        });
        amf.core.internal.parser.package$.MODULE$.YMapOps(this.map).key(package$.MODULE$.AmfStrings("settings").asOasExtension(), (Function1<YMapEntry, BoxedUnit>)(Function1<YMapEntry, Object> & Serializable & scala.Serializable)entry -> {
            this.parseDynamicSettings(entry.value().as(YRead$YMapYRead$.MODULE$, this.ctx), settings, Predef$.MODULE$.wrapRefArray((Object[])new String[]{"authorizationGrants"}));
            return BoxedUnit.UNIT;
        });
        new AnnotationParser(settings, this.map, AnnotationParser$.MODULE$.apply$default$3(), new WebApiShapeParserContextAdapter(this.ctx)).parseOrphanNode("flows");
        return settings;
    }

    private void parseFlows(YMapEntry entry, OAuth2Settings settings) {
        IndexedSeq<AmfElement> flows = entry.value().as(YRead$YMapYRead$.MODULE$, this.ctx).entries().map((Function1<YMapEntry, OAuth2Flow> & Serializable & scala.Serializable)x$2 -> this.parseFlow(settings.id(), (YMapEntry)x$2), IndexedSeq$.MODULE$.canBuildFrom());
        settings.setWithoutId(OAuth2SettingsModel$.MODULE$.Flows(), new AmfArray(flows, Annotations$.MODULE$.apply(entry.value())), Annotations$.MODULE$.apply(entry));
    }

    /*
     * WARNING - void declaration
     */
    private OAuth2Flow parseFlow(String parent, YMapEntry flowEntry) {
        void var3_3;
        OAuth2Flow flow = OAuth2Flow$.MODULE$.apply(flowEntry);
        YMap flowMap = flowEntry.value().as(YRead$YMapYRead$.MODULE$, this.ctx);
        AmfScalar flowKey = (AmfScalar)ScalarNode$.MODULE$.apply(flowEntry.key(), this.ctx).string();
        flow.setWithoutId(OAuth2FlowModel$.MODULE$.Flow(), flowKey, Annotations$.MODULE$.apply(flowEntry.key()));
        amf.core.internal.parser.package$.MODULE$.YMapOps(flowMap).key("authorizationUrl", this.FieldOps(OAuth2FlowModel$.MODULE$.AuthorizationUri(), this.ctx).in(flow));
        amf.core.internal.parser.package$.MODULE$.YMapOps(flowMap).key("tokenUrl", this.FieldOps(OAuth2FlowModel$.MODULE$.AccessTokenUri(), this.ctx).in(flow));
        amf.core.internal.parser.package$.MODULE$.YMapOps(flowMap).key("refreshUrl", this.FieldOps(OAuth2FlowModel$.MODULE$.RefreshUri(), this.ctx).in(flow));
        this.parseScopes(flow, flowMap);
        OAuth2FlowValidations$.MODULE$.validateFlowFields(flow, this.ctx.eh(), flowEntry);
        this.ctx.closedShape(flow, flowMap, flow.flow().value());
        return var3_3;
    }

    @Override
    public SettingsProducers vendorSpecificSettingsProducers() {
        return Oas3SettingsProducers$.MODULE$;
    }

    public Oas3SecuritySettingsParser(YMap map, SecurityScheme scheme, OasWebApiContext ctx) {
        this.map = map;
        this.ctx = ctx;
        super(map, scheme, ctx);
    }
}

