/*
 * Decompiled with CFR 0.152.
 */
package amf.cli.internal.commands;

import amf.aml.client.scala.AMLBaseUnitClient;
import amf.aml.client.scala.AMLConfiguration;
import amf.aml.client.scala.AMLDialectResult;
import amf.aml.internal.utils.VocabulariesRegister$;
import amf.apicontract.client.scala.AMFConfiguration;
import amf.apicontract.internal.convert.ApiRegister$;
import amf.cli.internal.commands.ParserConfig;
import amf.core.client.common.transform.PipelineId$;
import amf.core.client.common.transform.PipelineName$;
import amf.core.client.scala.AMFGraphBaseUnitClient;
import amf.core.client.scala.AMFGraphConfiguration;
import amf.core.client.scala.AMFResult;
import amf.core.client.scala.config.RenderOptions;
import amf.core.client.scala.config.RenderOptions$;
import amf.core.client.scala.model.document.BaseUnit;
import amf.core.internal.parser.AMFCompiler$;
import amf.core.internal.parser.CompilerConfiguration;
import amf.core.internal.remote.Cache$;
import amf.core.internal.remote.Context$;
import amf.core.internal.remote.Platform;
import amf.core.internal.remote.Vendor$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005UaaB\u0006\r!\u0003\r\t!\u0006\u0005\u00069\u0001!\t!\b\u0005\bC\u0001\u0011\rQ\"\u0001#\u0011\u0015a\u0003\u0001\"\u0001.\u0011\u0015i\u0004\u0001\"\u0001?\u0011\u0015a\u0005\u0001\"\u0005N\u0011\u0015q\u0006\u0001\"\u0005`\u0011\u0015\u0019\b\u0001\"\u0005u\u0011\u0015I\b\u0001\"\u0005{\u0011\u0015q\b\u0001\"\u0001\u0000\u0011\u001d\ty\u0001\u0001C\u0001\u0003#\u0011QbQ8n[\u0006tG\rS3ma\u0016\u0014(BA\u0007\u000f\u0003!\u0019w.\\7b]\u0012\u001c(BA\b\u0011\u0003!Ig\u000e^3s]\u0006d'BA\t\u0013\u0003\r\u0019G.\u001b\u0006\u0002'\u0005\u0019\u0011-\u001c4\u0004\u0001M\u0011\u0001A\u0006\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\r\u0011Jg.\u001b;%)\u0005q\u0002CA\f \u0013\t\u0001\u0003D\u0001\u0003V]&$\u0018\u0001\u00039mCR4wN]7\u0016\u0003\r\u0002\"\u0001\n\u0016\u000e\u0003\u0015R!AJ\u0014\u0002\rI,Wn\u001c;f\u0015\ty\u0001F\u0003\u0002*%\u0005!1m\u001c:f\u0013\tYSE\u0001\u0005QY\u0006$hm\u001c:n\u0003\u001d\tUJR%oSR$\"A\f\u001b\u0011\u0007=\u0012d$D\u00011\u0015\t\t\u0004$\u0001\u0006d_:\u001cWO\u001d:f]RL!a\r\u0019\u0003\r\u0019+H/\u001e:f\u0011\u0015)4\u00011\u00017\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]B\u0011qgO\u0007\u0002q)\u0011\u0011$\u000f\u0006\u0003u!\naa\u00197jK:$\u0018B\u0001\u001f9\u0005U\tUJR$sCBD7i\u001c8gS\u001e,(/\u0019;j_:\f\u0011\"\u001a8tkJ,WK\u001d7\u0015\u0005}R\u0005C\u0001!H\u001d\t\tU\t\u0005\u0002C15\t1I\u0003\u0002E)\u00051AH]8pizJ!A\u0012\r\u0002\rA\u0013X\rZ3g\u0013\tA\u0015J\u0001\u0004TiJLgn\u001a\u0006\u0003\rbAQa\u0013\u0003A\u0002}\n\u0011\"\u001b8qkR4\u0015\u000e\\3\u0002\u001fA\u0014xnY3tg\u0012K\u0017\r\\3diN$2AT,^!\ry#g\u0014\t\u0003!Vk\u0011!\u0015\u0006\u00033IS!AO*\u000b\u0005Q\u0013\u0012aC1qS\u000e|g\u000e\u001e:bGRL!AV)\u0003!\u0005keiQ8oM&<WO]1uS>t\u0007\"\u0002-\u0006\u0001\u0004I\u0016AB2p]\u001aLw\r\u0005\u0002[76\tA\"\u0003\u0002]\u0019\ta\u0001+\u0019:tKJ\u001cuN\u001c4jO\")Q'\u0002a\u0001\u001f\u0006Q\u0001/\u0019:tK&s\u0007/\u001e;\u0015\u0007\u0001L'\u000eE\u00020e\u0005\u0004\"AY4\u000e\u0003\rT!\u0001Z3\u0002\u0011\u0011|7-^7f]RT!A\u001a\u001d\u0002\u000b5|G-\u001a7\n\u0005!\u001c'\u0001\u0003\"bg\u0016,f.\u001b;\t\u000ba3\u0001\u0019A-\t\u000bU2\u0001\u0019A6\u0011\u00051\fX\"A7\u000b\u0005eq'B\u0001\u001ep\u0015\t\u0001(#A\u0002b[2L!A]7\u0003!\u0005kEjQ8oM&<WO]1uS>t\u0017a\u0002:fg>dg/\u001a\u000b\u0005AV4\b\u0010C\u0003Y\u000f\u0001\u0007\u0011\fC\u0003x\u000f\u0001\u0007\u0011-\u0001\u0003v]&$\b\"B\u001b\b\u0001\u00041\u0014AD4f]\u0016\u0014\u0018\r^3PkR\u0004X\u000f\u001e\u000b\u0005]mdX\u0010C\u0003Y\u0011\u0001\u0007\u0011\fC\u0003x\u0011\u0001\u0007\u0011\rC\u00036\u0011\u0001\u0007a'\u0001\nfM\u001a,7\r^5wK6+G-[1UsB,G#B \u0002\u0002\u0005-\u0001bBA\u0002\u0013\u0001\u0007\u0011QA\u0001\n[\u0016$\u0017.\u0019+za\u0016\u0004BaFA\u0004\u007f%\u0019\u0011\u0011\u0002\r\u0003\r=\u0003H/[8o\u0011\u001d\ti!\u0003a\u0001\u0003\u000b\taA^3oI>\u0014\u0018aD3gM\u0016\u001cG/\u001b<f-\u0016tGm\u001c:\u0015\u0007}\n\u0019\u0002C\u0004\u0002\u000e)\u0001\r!!\u0002")
public interface CommandHelper {
    public Platform platform();

    public static /* synthetic */ Future AMFInit$(CommandHelper $this, AMFGraphConfiguration configuration) {
        return $this.AMFInit(configuration);
    }

    default public Future<BoxedUnit> AMFInit(AMFGraphConfiguration configuration) {
        ExecutionContext context = configuration.getExecutionContext();
        ApiRegister$.MODULE$.register(this.platform());
        VocabulariesRegister$.MODULE$.register(this.platform());
        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    public static /* synthetic */ String ensureUrl$(CommandHelper $this, String inputFile) {
        return $this.ensureUrl(inputFile);
    }

    default public String ensureUrl(String inputFile) {
        return inputFile.startsWith("file:") || inputFile.startsWith("http:") || inputFile.startsWith("https:") ? inputFile : (inputFile.startsWith("/") ? new StringBuilder(6).append("file:/").append(inputFile).toString() : new StringBuilder(7).append("file://").append(inputFile).toString());
    }

    public static /* synthetic */ Future processDialects$(CommandHelper $this, ParserConfig config, AMFConfiguration configuration) {
        return $this.processDialects(config, configuration);
    }

    default public Future<AMFConfiguration> processDialects(ParserConfig config, AMFConfiguration configuration) {
        ExecutionContext context = configuration.getExecutionContext();
        Seq dialectFutures = (Seq)config.dialects().map((Function1 & Serializable & scala.Serializable)dialect -> configuration.baseUnitClient().parseDialect(dialect), Seq$.MODULE$.canBuildFrom());
        return Future$.MODULE$.sequence((TraversableOnce)dialectFutures, Seq$.MODULE$.canBuildFrom(), context).map((Function1 & Serializable & scala.Serializable)results -> (AMFConfiguration)results.foldLeft((Object)configuration, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            AMFConfiguration conf = (AMFConfiguration)tuple2._1();
            AMLDialectResult result = (AMLDialectResult)tuple2._2();
            AMFConfiguration aMFConfiguration = conf.withDialect(result.dialect());
            return aMFConfiguration;
        }), context);
    }

    public static /* synthetic */ Future parseInput$(CommandHelper $this, ParserConfig config, AMLConfiguration configuration) {
        return $this.parseInput(config, configuration);
    }

    default public Future<BaseUnit> parseInput(ParserConfig config, AMLConfiguration configuration) {
        ExecutionContext context = configuration.getExecutionContext();
        String inputFile = this.ensureUrl((String)config.input().get());
        AMLBaseUnitClient configClient = configuration.baseUnitClient();
        Future parsed = configClient.parse(inputFile);
        String vendor = this.effectiveVendor(config.inputFormat());
        return config.resolve() ? parsed.map((Function1 & Serializable & scala.Serializable)result -> {
            AMFResult transformed = configClient.transform(result.baseUnit(), PipelineName$.MODULE$.from(Vendor$.MODULE$.apply(vendor).mediaType(), PipelineId$.MODULE$.Default()));
            return transformed.baseUnit();
        }, context) : parsed.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.baseUnit(), context);
    }

    public static /* synthetic */ Future resolve$(CommandHelper $this, ParserConfig config, BaseUnit unit, AMFGraphConfiguration configuration) {
        return $this.resolve(config, unit, configuration);
    }

    default public Future<BaseUnit> resolve(ParserConfig config, BaseUnit unit, AMFGraphConfiguration configuration) {
        Future future;
        ExecutionContext context = configuration.getExecutionContext();
        AMFGraphBaseUnitClient configClient = configuration.baseUnitClient();
        String vendor = this.effectiveVendor(config.inputFormat());
        String vendorMediaType = Vendor$.MODULE$.apply(vendor).mediaType();
        if (config.resolve() && config.validate()) {
            String inputFile = this.ensureUrl((String)config.input().get());
            Future parsed2 = AMFCompiler$.MODULE$.apply(inputFile, Option$.MODULE$.apply((Object)this.effectiveMediaType(config.inputMediaType(), config.inputFormat())), Context$.MODULE$.apply(this.platform()), Cache$.MODULE$.apply(), new CompilerConfiguration(configuration), AMFCompiler$.MODULE$.apply$default$6()).build(context);
            future = parsed2.map((Function1 & Serializable & scala.Serializable)parsed -> configClient.transform(parsed, PipelineName$.MODULE$.from(vendorMediaType, PipelineId$.MODULE$.Default())).baseUnit(), context);
        } else {
            future = config.resolve() ? Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> configClient.transform(unit, PipelineName$.MODULE$.from(vendorMediaType, PipelineId$.MODULE$.Default())).baseUnit(), context) : Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> unit, context);
        }
        return future;
    }

    public static /* synthetic */ Future generateOutput$(CommandHelper $this, ParserConfig config, BaseUnit unit, AMFGraphConfiguration configuration) {
        return $this.generateOutput(config, unit, configuration);
    }

    default public Future<BoxedUnit> generateOutput(ParserConfig config, BaseUnit unit, AMFGraphConfiguration configuration) {
        Future future;
        ExecutionContext context = configuration.getExecutionContext();
        RenderOptions generateOptions = new RenderOptions(RenderOptions$.MODULE$.apply$default$1(), RenderOptions$.MODULE$.apply$default$2(), RenderOptions$.MODULE$.apply$default$3(), RenderOptions$.MODULE$.apply$default$4(), RenderOptions$.MODULE$.apply$default$5(), RenderOptions$.MODULE$.apply$default$6(), RenderOptions$.MODULE$.apply$default$7(), RenderOptions$.MODULE$.apply$default$8(), RenderOptions$.MODULE$.apply$default$9(), RenderOptions$.MODULE$.apply$default$10(), RenderOptions$.MODULE$.apply$default$11(), RenderOptions$.MODULE$.apply$default$12(), RenderOptions$.MODULE$.apply$default$13(), RenderOptions$.MODULE$.apply$default$14());
        if (config.withSourceMaps()) {
            generateOptions = generateOptions.withSourceMaps();
        }
        if (config.withCompactNamespaces()) {
            generateOptions = generateOptions.withCompactUris();
        }
        String vendor = this.effectiveVendor(config.outputFormat());
        String mediaType = this.effectiveMediaType(config.outputMediaType(), config.outputFormat());
        String result = configuration.withRenderOptions(generateOptions).baseUnitClient().render(unit, Vendor$.MODULE$.apply(vendor).mediaType());
        Option<String> option = config.output();
        if (option instanceof Some) {
            Some some = (Some)option;
            String f = (String)some.value();
            future = this.platform().write(f, result, context);
        } else if (None$.MODULE$.equals(option)) {
            config.stdout().print(result);
            future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        } else {
            throw new MatchError(option);
        }
        return future;
    }

    public static /* synthetic */ String effectiveMediaType$(CommandHelper $this, Option mediaType, Option vendor) {
        return $this.effectiveMediaType((Option<String>)mediaType, (Option<String>)vendor);
    }

    default public String effectiveMediaType(Option<String> mediaType, Option<String> vendor) {
        String string;
        Option<String> option = mediaType;
        if (option instanceof Some) {
            String effectiveMediaType;
            Some some = (Some)option;
            string = effectiveMediaType = (String)some.value();
        } else if (None$.MODULE$.equals(option)) {
            String string2;
            Option<String> option2 = vendor;
            string = string2 = "*/*";
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    public static /* synthetic */ String effectiveVendor$(CommandHelper $this, Option vendor) {
        return $this.effectiveVendor((Option<String>)vendor);
    }

    default public String effectiveVendor(Option<String> vendor) {
        String string;
        Option<String> option = vendor;
        if (option instanceof Some) {
            String effectiveVendor;
            Some some = (Some)option;
            string = effectiveVendor = (String)some.value();
        } else if (None$.MODULE$.equals(option)) {
            string = "Unknown";
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    public static void $init$(CommandHelper $this) {
    }
}

