/*
 * Decompiled with CFR 0.152.
 */
package amf.core.client.scala.parse;

import amf.core.client.scala.AMFGraphConfiguration;
import amf.core.client.scala.AMFObjectResult;
import amf.core.client.scala.AMFParseResult;
import amf.core.client.scala.model.document.BaseUnit;
import amf.core.client.scala.parse.AMFSyntaxParsePlugin;
import amf.core.client.scala.resource.ResourceLoader;
import amf.core.client.scala.validation.AMFValidationResult;
import amf.core.internal.convert.CoreClientConverters$;
import amf.core.internal.parser.AMFCompiler;
import amf.core.internal.parser.AMFCompiler$;
import amf.core.internal.parser.AMFGraphPartialCompiler;
import amf.core.internal.parser.AmfObjectUnitContainer;
import amf.core.internal.parser.CompilerConfiguration;
import amf.core.internal.parser.CompilerContext;
import amf.core.internal.parser.CompilerContextBuilder;
import amf.core.internal.plugins.AMFPlugin$;
import amf.core.internal.remote.Cache$;
import amf.core.internal.remote.Context$;
import amf.core.internal.resource.StringResourceLoader;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

public final class AMFParser$ {
    public static AMFParser$ MODULE$;
    private final String DEFAULT_DOCUMENT_URL;

    static {
        new AMFParser$();
    }

    public Future<AMFParseResult> parse(String url, AMFGraphConfiguration configuration) {
        return this.parseAsync(url, configuration);
    }

    public Future<AMFParseResult> parseContent(String content, AMFGraphConfiguration env) {
        Option preferredSyntaxPlugin = ((TraversableLike)env.registry().plugins().syntaxParsePlugins().sorted(AMFPlugin$.MODULE$.ordering())).headOption();
        Option<String> defaultMediaType = preferredSyntaxPlugin.map((Function1<AMFSyntaxParsePlugin, String> & Serializable & scala.Serializable)x$1 -> x$1.mainMediaType());
        return this.parseContent(content, this.DEFAULT_DOCUMENT_URL(), defaultMediaType, env);
    }

    public Future<AMFParseResult> parseContent(String content, String mediaType, AMFGraphConfiguration configuration) {
        return this.parseContent(content, this.DEFAULT_DOCUMENT_URL(), new Some<String>(mediaType), configuration);
    }

    public Future<AMFObjectResult> parseStartingPoint(String graphUrl, String startingPoint, AMFGraphConfiguration env) {
        CompilerConfiguration configuration = env.compilerConfiguration();
        ExecutionContext executionContext = configuration.executionContext();
        CompilerContext context = new CompilerContextBuilder(graphUrl, CoreClientConverters$.MODULE$.platform(), configuration).withCache(Cache$.MODULE$.apply()).withFileContext(Context$.MODULE$.apply(CoreClientConverters$.MODULE$.platform())).build();
        AMFGraphPartialCompiler compiler = new AMFGraphPartialCompiler(context, startingPoint);
        return this.build(compiler, configuration, executionContext).map((Function1<AMFParseResult, AMFObjectResult> & Serializable & scala.Serializable)r -> {
            BaseUnit baseUnit = r.baseUnit();
            if (!(baseUnit instanceof AmfObjectUnitContainer)) {
                throw new UnsupportedOperationException("Unexpected result unit type for partial parsing");
            }
            AmfObjectUnitContainer amfObjectUnitContainer = (AmfObjectUnitContainer)baseUnit;
            AMFObjectResult aMFObjectResult = new AMFObjectResult(amfObjectUnitContainer.result(), r.results());
            return aMFObjectResult;
        }, executionContext);
    }

    public Future<AMFParseResult> parseContent(String content, String url, Option<String> mediaType, AMFGraphConfiguration env) {
        ResourceLoader loader = this.fromStream(url, content, mediaType);
        AMFGraphConfiguration withLoader = env.withResourceLoader(loader);
        return this.parseAsync(url, withLoader);
    }

    public Future<AMFParseResult> parseAsync(String url, AMFGraphConfiguration amfConfig) {
        CompilerConfiguration compilerConfig = amfConfig.compilerConfiguration();
        ExecutionContext executionContext = compilerConfig.executionContext();
        return this.build(AMFCompiler$.MODULE$.apply(url, Context$.MODULE$.apply(CoreClientConverters$.MODULE$.platform()), Cache$.MODULE$.apply(), compilerConfig, AMFCompiler$.MODULE$.apply$default$5()), compilerConfig, executionContext);
    }

    private Future<AMFParseResult> build(AMFCompiler compiler, CompilerConfiguration compilerConfig, ExecutionContext context) {
        return compiler.build(context).map((Function1<BaseUnit, AMFParseResult> & Serializable & scala.Serializable)model -> {
            List<AMFValidationResult> results = compilerConfig.eh().getResults();
            return new AMFParseResult((BaseUnit)model, (Seq<AMFValidationResult>)results);
        }, context);
    }

    private ResourceLoader fromStream(String url, String stream, Option<String> mediaType) {
        return new StringResourceLoader(CoreClientConverters$.MODULE$.platform().resolvePath(url), stream, mediaType);
    }

    public String DEFAULT_DOCUMENT_URL() {
        return this.DEFAULT_DOCUMENT_URL;
    }

    private AMFParser$() {
        MODULE$ = this;
        this.DEFAULT_DOCUMENT_URL = "http://a.ml/amf/default_document";
    }
}

