/*
 * Decompiled with CFR 0.152.
 */
package amf.shapes.internal.spec.jsonschema.parser.document;

import amf.core.client.scala.model.document.BaseUnit;
import amf.core.client.scala.model.document.ExternalFragment;
import amf.core.client.scala.model.domain.DomainElement;
import amf.core.client.scala.model.domain.Shape;
import amf.core.internal.parser.domain.Annotations;
import amf.core.internal.parser.domain.Annotations$;
import amf.core.internal.validation.core.ValidationSpecification;
import amf.shapes.client.scala.model.document.JsonSchemaDocument;
import amf.shapes.client.scala.model.domain.AnyShape;
import amf.shapes.internal.annotations.DocumentDeclarationKey;
import amf.shapes.internal.spec.common.JSONSchemaDraft201909SchemaVersion$;
import amf.shapes.internal.spec.common.JSONSchemaVersion;
import amf.shapes.internal.spec.common.parser.ShapeParserContext;
import amf.shapes.internal.spec.contexts.ReferenceFinder$;
import amf.shapes.internal.spec.jsonschema.JsonSchemaEntry$;
import amf.shapes.internal.spec.jsonschema.parser.document.Draft2019NameExtraction$;
import amf.shapes.internal.spec.jsonschema.parser.document.Draft4NameExtraction$;
import amf.shapes.internal.spec.jsonschema.parser.document.NameExtraction;
import amf.shapes.internal.validation.definitions.ShapeParserSideValidations$;
import java.io.Serializable;
import org.yaml.model.YNode;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class JsonSchemaLinker$ {
    public static JsonSchemaLinker$ MODULE$;

    static {
        new JsonSchemaLinker$();
    }

    public Option<AnyShape> linkShapeIn(String ref, YNode ast, ShapeParserContext ctx) {
        Option<JsonSchemaDocument> maybeDoc = this.findJsonSchemaDocument(ref, ctx);
        return maybeDoc.flatMap((Function1<JsonSchemaDocument, Option> & Serializable & scala.Serializable)document -> {
            Option<String> maybeUriFragment = ReferenceFinder$.MODULE$.getJsonReferenceFragment(ref);
            return MODULE$.linkShapeFromDocument(ref, (JsonSchemaDocument)document, maybeUriFragment, Annotations$.MODULE$.apply(ast), ctx);
        });
    }

    public Option<AnyShape> linkShapeFromDocument(String ref, JsonSchemaDocument document, Option<String> maybeUriFragment, Annotations linkAnnotations, ShapeParserContext ctx) {
        return this.computeShape(ref, document, maybeUriFragment, linkAnnotations, ctx).collect(new scala.Serializable(ref, linkAnnotations){
            public static final long serialVersionUID = 0L;
            private final String ref$3;
            private final Annotations linkAnnotations$1;

            public final <A1 extends Shape, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof AnyShape) {
                    AnyShape anyShape = (AnyShape)A1;
                    object = anyShape.link(this.ref$3, this.linkAnnotations$1);
                } else {
                    object = function1.apply(x1);
                }
                return object;
            }

            public final boolean isDefinedAt(Shape x1) {
                Shape shape = x1;
                boolean bl = shape instanceof AnyShape;
                return bl;
            }
            {
                this.ref$3 = ref$3;
                this.linkAnnotations$1 = linkAnnotations$1;
            }
        });
    }

    private Option<Shape> computeShape(String ref, JsonSchemaDocument document, Option<String> maybeUriFragment, Annotations linkAnnotations, ShapeParserContext ctx) {
        Option option;
        Option<String> option2 = maybeUriFragment;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String fragment = (String)some.value();
            String baseRef = (String)maybeUriFragment.map((Function1<String, String> & Serializable & scala.Serializable)x$2 -> (String)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])ref.split("#"))).head()).getOrElse((Function0<String> & Serializable & scala.Serializable)() -> ref);
            Either<Tuple2<ValidationSpecification, String>, AnyShape> maybeShape = this.findShapeForReference(baseRef, document, fragment, ctx);
            this.throwErrors(maybeShape, linkAnnotations, ctx);
            option = maybeShape.right().toOption();
        } else if (None$.MODULE$.equals(option2)) {
            option = new Some<Shape>(document.encodes());
        } else {
            throw new MatchError(option2);
        }
        return option;
    }

    private void throwErrors(Either<Tuple2<ValidationSpecification, String>, AnyShape> maybeShape, Annotations linkAnnotations, ShapeParserContext ctx) {
        maybeShape.left().foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> {
            JsonSchemaLinker$.$anonfun$throwErrors$1(ctx, linkAnnotations, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private Option<JsonSchemaDocument> findJsonSchemaDocument(String ref, ShapeParserContext ctx) {
        return ReferenceFinder$.MODULE$.findJsonReferencedUnit(ref, ref, ctx.refs()).collect(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends BaseUnit, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                JsonSchemaDocument jsonSchemaDocument;
                A1 A1 = x1;
                JsonSchemaDocument jsonSchemaDocument2 = A1 instanceof JsonSchemaDocument ? (jsonSchemaDocument = (JsonSchemaDocument)A1) : function1.apply(x1);
                return (B1)jsonSchemaDocument2;
            }

            public final boolean isDefinedAt(BaseUnit x1) {
                BaseUnit baseUnit = x1;
                boolean bl = baseUnit instanceof JsonSchemaDocument;
                return bl;
            }
        });
    }

    private Either<Tuple2<ValidationSpecification, String>, AnyShape> findShapeForReference(String ref, JsonSchemaDocument document, String uriFragment, ShapeParserContext ctx) {
        Either either;
        JSONSchemaVersion version = JsonSchemaEntry$.MODULE$.apply(document.schemaVersion().value()).get();
        Option<String> declarationKey = document.annotations().find(DocumentDeclarationKey.class).map((Function1<DocumentDeclarationKey, String> & Serializable & scala.Serializable)x$3 -> x$3.key());
        NameExtraction extractor = this.nameExtractorFor(version);
        Either<String, String> either2 = extractor.extract(uriFragment);
        if (either2 instanceof Left) {
            Left left = (Left)either2;
            String error = (String)left.value();
            either = package$.MODULE$.Left().apply(new Tuple2<ValidationSpecification, String>(ShapeParserSideValidations$.MODULE$.InvalidJsonSchemaReference(), error));
        } else if (either2 instanceof Right) {
            Either either3;
            Right right = (Right)either2;
            String name = (String)right.value();
            Either<Tuple2<ValidationSpecification, String>, BoxedUnit> either4 = this.validateDeclarationKey(declarationKey, uriFragment);
            if (either4 instanceof Left) {
                Left left = (Left)either4;
                Tuple2 errorTuple = (Tuple2)left.value();
                either3 = package$.MODULE$.Left().apply(errorTuple);
            } else if (either4 instanceof Right) {
                either3 = this.findShapeWithName(ref, document, name, uriFragment, ctx);
            } else {
                throw new MatchError(either4);
            }
            either = either3;
        } else {
            throw new MatchError(either2);
        }
        return either;
    }

    private Either<Tuple2<ValidationSpecification, String>, BoxedUnit> validateDeclarationKey(Option<String> declarationKey, String ref) {
        Some some;
        String dk;
        Option<String> option = declarationKey;
        Either either = option instanceof Some && !ref.contains(dk = (String)(some = (Some)option).value()) ? package$.MODULE$.Left().apply(new Tuple2<ValidationSpecification, String>(ShapeParserSideValidations$.MODULE$.IncorrectDefinitionKey(), new StringBuilder(48).append("The definition key present in the ref must be '").append(dk).append("'").toString())) : package$.MODULE$.Right().apply(BoxedUnit.UNIT);
        return either;
    }

    private Either<Tuple2<ValidationSpecification, String>, AnyShape> findShapeWithName(String ref, JsonSchemaDocument doc, String name, String uriFragment, ShapeParserContext ctx) {
        return this.findShape(ref, doc, name, ctx).toRight((Function0<Tuple2> & Serializable & scala.Serializable)() -> new Tuple2<ValidationSpecification, String>(ShapeParserSideValidations$.MODULE$.JsonSchemaDefinitionNotFound(), new StringBuilder(39).append("Couldn't find schema identified by ").append(uriFragment).append(" in ").append(doc.location().getOrElse((Function0<String> & Serializable & scala.Serializable)() -> "")).toString()));
    }

    private Option<AnyShape> findShape(String ref, JsonSchemaDocument doc, String name, ShapeParserContext ctx) {
        Some some;
        Option<BaseUnit> option = ctx.getJsonSchemaRefGuide().currentUnit();
        Option<AnyShape> option2 = option instanceof Some && (some = (Some)option).value() instanceof ExternalFragment ? this.findShapeInDoc(doc, name, ctx) : ctx.findDeclaredTypeInDocFragment(ref, name).collect(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Shape, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                AnyShape anyShape;
                A1 A1 = x1;
                AnyShape anyShape2 = A1 instanceof AnyShape ? (anyShape = (AnyShape)A1) : function1.apply(x1);
                return (B1)anyShape2;
            }

            public final boolean isDefinedAt(Shape x1) {
                Shape shape = x1;
                boolean bl = shape instanceof AnyShape;
                return bl;
            }
        });
        return option2;
    }

    private Option<AnyShape> findShapeInDoc(JsonSchemaDocument doc, String name, ShapeParserContext ctx) {
        return doc.declares().collectFirst(new scala.Serializable(name){
            public static final long serialVersionUID = 0L;
            private final String name$1;

            public final <A1 extends DomainElement, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                AnyShape anyShape;
                A1 A1 = x1;
                Object object = A1 instanceof AnyShape && (anyShape = (AnyShape)A1).name().option().contains(this.name$1) ? anyShape : function1.apply(x1);
                return object;
            }

            public final boolean isDefinedAt(DomainElement x1) {
                AnyShape anyShape;
                DomainElement domainElement = x1;
                boolean bl = domainElement instanceof AnyShape && (anyShape = (AnyShape)domainElement).name().option().contains(this.name$1);
                return bl;
            }
            {
                this.name$1 = name$1;
            }
        });
    }

    private NameExtraction nameExtractorFor(JSONSchemaVersion version) {
        return version.$greater$eq(JSONSchemaDraft201909SchemaVersion$.MODULE$) ? Draft2019NameExtraction$.MODULE$ : Draft4NameExtraction$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$throwErrors$1(ShapeParserContext ctx$2, Annotations linkAnnotations$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ValidationSpecification spec = (ValidationSpecification)tuple2._1();
        String error = (String)tuple2._2();
        ctx$2.eh().violation(spec, "", error, linkAnnotations$2);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private JsonSchemaLinker$() {
        MODULE$ = this;
    }
}

