/*
 * Decompiled with CFR 0.152.
 */
package amf.apicontract.internal.validation.shacl.graphql;

import amf.apicontract.client.scala.model.domain.EndPoint;
import amf.apicontract.client.scala.model.domain.api.WebApi;
import amf.core.client.scala.model.StrField;
import amf.core.client.scala.model.domain.AmfScalar;
import amf.core.client.scala.model.domain.DataNode;
import amf.core.client.scala.model.domain.DomainElement;
import amf.core.client.scala.model.domain.extensions.DomainExtension;
import amf.core.client.scala.model.domain.extensions.PropertyShape;
import amf.core.internal.metamodel.domain.DomainElementModel$;
import amf.core.internal.metamodel.domain.common.NameFieldSchema$;
import amf.core.internal.metamodel.domain.common.NameFieldShacl$;
import amf.core.internal.metamodel.domain.extensions.PropertyShapeModel$;
import amf.core.internal.parser.domain.Annotations;
import amf.core.internal.parser.domain.Value;
import amf.shapes.client.scala.model.domain.NodeShape;
import amf.shapes.client.scala.model.domain.ScalarShape;
import amf.shapes.client.scala.model.domain.UnionShape;
import amf.shapes.client.scala.model.domain.operations.ShapeOperation;
import amf.shapes.client.scala.model.domain.operations.ShapeParameter;
import amf.shapes.internal.domain.metamodel.operations.ShapeParameterModel$;
import amf.validation.internal.shacl.custom.CustomShaclValidator;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyBoolean;

public final class GraphQLDirectiveLocationValidator$ {
    public static GraphQLDirectiveLocationValidator$ MODULE$;

    static {
        new GraphQLDirectiveLocationValidator$();
    }

    public Seq<Option<CustomShaclValidator.ValidationInfo>> apply(Seq<DomainExtension> directiveApplications, DomainElement element, boolean appliedToDirectiveArgument) {
        return (Seq)((TraversableLike)directiveApplications.map((Function1<DomainExtension, Option> & Serializable & scala.Serializable)application -> MODULE$.validateApplication((DomainExtension)application, element, appliedToDirectiveArgument), Seq$.MODULE$.canBuildFrom())).filter((Function1<Option, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(x$1.isDefined()));
    }

    public boolean apply$default$3() {
        return false;
    }

    private Option<CustomShaclValidator.ValidationInfo> validateApplication(DomainExtension directiveApplication, DomainElement element, boolean appliedToDirectiveArgument) {
        Option option;
        LazyBoolean isValidApplicationToDirectiveArgument$lzy = new LazyBoolean();
        Seq validDomains = directiveApplication.definedBy().domain().map((Function1<StrField, String> & Serializable & scala.Serializable)x$2 -> x$2.toString(), Seq$.MODULE$.canBuildFrom());
        List<String> currentDomains = element.meta().typeIris();
        boolean isAValidLocation = currentDomains.exists((Function1<String, Object>)(Function1<Object, Object> & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean(validDomains.contains(elem)));
        if (!isAValidLocation && !GraphQLDirectiveLocationValidator$.isValidApplicationToDirectiveArgument$1(isValidApplicationToDirectiveArgument$lzy, appliedToDirectiveArgument, element, validDomains)) {
            String message = this.buildErrorMessage(directiveApplication, element, appliedToDirectiveArgument);
            option = new Some<CustomShaclValidator.ValidationInfo>(new CustomShaclValidator.ValidationInfo(DomainElementModel$.MODULE$.CustomDomainProperties(), new Some<String>(message), new Some<Annotations>(directiveApplication.annotations())));
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    private boolean validateApplication$default$3() {
        return false;
    }

    private String buildErrorMessage(DomainExtension directiveApplication, DomainElement element, boolean appliedToDirectiveArgument) {
        String string;
        String kind = this.inferGraphQLKind(element, appliedToDirectiveArgument);
        Option<String> nameOpt = this.extractName(element);
        Option<String> option = nameOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            String name = (String)some.value();
            string = new StringBuilder(33).append("Directive ").append(directiveApplication.name().value()).append(" cannot be applied to ").append(kind).append(" ").append(name).toString();
        } else {
            string = new StringBuilder(32).append("Directive ").append(directiveApplication.name().value()).append(" cannot be applied to ").append(kind).toString();
        }
        return string;
    }

    private Option<String> extractName(DomainElement element) {
        return element.fields().getValueAsOption(NameFieldSchema$.MODULE$.Name()).orElse((Function0<Option> & Serializable & scala.Serializable)() -> element.fields().getValueAsOption(NameFieldShacl$.MODULE$.Name())).flatMap((Function1<Value, Option> & Serializable & scala.Serializable)v -> {
            DomainElement domainElement = element;
            Option option = domainElement instanceof WebApi ? None$.MODULE$ : (domainElement instanceof EndPoint ? new Some<String>(new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(((AmfScalar)v.value()).toString())).stripPrefix("Query."))).stripPrefix("Mutation."))).stripPrefix("Subscription.")) : new Some<String>(((AmfScalar)v.value()).toString()));
            return option;
        }).map((Function1<String, String> & Serializable & scala.Serializable)name -> new StringBuilder(2).append("'").append((String)name).append("'").toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String inferGraphQLKind(DomainElement element, boolean appliedToDirectiveArgument) {
        boolean bl = false;
        PropertyShape propertyShape = null;
        boolean bl2 = false;
        ScalarShape scalarShape = null;
        boolean bl3 = false;
        NodeShape nodeShape = null;
        DomainElement domainElement = element;
        if (domainElement instanceof PropertyShape) {
            bl = true;
            propertyShape = (PropertyShape)domainElement;
            if (appliedToDirectiveArgument) {
                return "argument";
            }
        }
        if (bl) {
            return "field";
        }
        if (domainElement instanceof ShapeOperation) {
            return "field";
        }
        if (domainElement instanceof ShapeParameter) {
            return "argument";
        }
        if (domainElement instanceof ScalarShape) {
            bl2 = true;
            scalarShape = (ScalarShape)domainElement;
            if (scalarShape.values().nonEmpty()) {
                return "enum";
            }
        }
        if (bl2) {
            return "scalar";
        }
        if (domainElement instanceof NodeShape) {
            bl3 = true;
            nodeShape = (NodeShape)domainElement;
            if (nodeShape.isAbstract().value()) {
                return "interface";
            }
        }
        if (bl3 && nodeShape.isInputOnly().value()) {
            return "input object";
        }
        if (bl3) {
            return "object";
        }
        if (domainElement instanceof UnionShape) {
            return "union";
        }
        if (domainElement instanceof DataNode) {
            return "value";
        }
        if (domainElement instanceof EndPoint) {
            return "field";
        }
        if (!(domainElement instanceof WebApi)) return "type";
        return "schema";
    }

    private static final /* synthetic */ boolean isValidApplicationToDirectiveArgument$lzycompute$1(LazyBoolean isValidApplicationToDirectiveArgument$lzy$1, boolean appliedToDirectiveArgument$2, DomainElement element$2, Seq validDomains$1) {
        boolean bl;
        LazyBoolean lazyBoolean = isValidApplicationToDirectiveArgument$lzy$1;
        synchronized (lazyBoolean) {
            bl = isValidApplicationToDirectiveArgument$lzy$1.initialized() ? isValidApplicationToDirectiveArgument$lzy$1.value() : isValidApplicationToDirectiveArgument$lzy$1.initialize(appliedToDirectiveArgument$2 && element$2.meta() == PropertyShapeModel$.MODULE$ && ((TraversableOnce)validDomains$1.intersect(ShapeParameterModel$.MODULE$.typeIris())).nonEmpty());
        }
        return bl;
    }

    private static final boolean isValidApplicationToDirectiveArgument$1(LazyBoolean isValidApplicationToDirectiveArgument$lzy$1, boolean appliedToDirectiveArgument$2, DomainElement element$2, Seq validDomains$1) {
        return isValidApplicationToDirectiveArgument$lzy$1.initialized() ? isValidApplicationToDirectiveArgument$lzy$1.value() : GraphQLDirectiveLocationValidator$.isValidApplicationToDirectiveArgument$lzycompute$1(isValidApplicationToDirectiveArgument$lzy$1, appliedToDirectiveArgument$2, element$2, validDomains$1);
    }

    private GraphQLDirectiveLocationValidator$() {
        MODULE$ = this;
    }
}

