/*
 * Decompiled with CFR 0.152.
 */
package amf.core.internal.utils;

import amf.core.internal.remote.Platform;
import amf.core.internal.unsafe.PlatformSecrets;
import amf.core.internal.utils.Absolute$;
import amf.core.internal.utils.RelativeToIncludedFile$;
import java.net.URI;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;

public final class UriUtils$
implements PlatformSecrets {
    public static UriUtils$ MODULE$;
    private final Platform platform;

    static {
        new UriUtils$();
    }

    @Override
    public Platform platform() {
        return this.platform;
    }

    @Override
    public void amf$core$internal$unsafe$PlatformSecrets$_setter_$platform_$eq(Platform x$1) {
        this.platform = x$1;
    }

    public String resolveRelativeTo(String current, String rawUrl) {
        Option option;
        String string = rawUrl;
        Option<String> option2 = Absolute$.MODULE$.unapply(string);
        if (!option2.isEmpty()) {
            option = None$.MODULE$;
        } else {
            Option<String> option3 = RelativeToIncludedFile$.MODULE$.unapply(string);
            if (!option3.isEmpty()) {
                option = new Some<String>(current);
            } else {
                throw new MatchError((Object)string);
            }
        }
        None$ base = option;
        String encodedUrl = this.platform().encodeURI(rawUrl);
        return this.resolveWithBase(base, encodedUrl);
    }

    public String resolveWithBase(Option<String> base, String url) {
        String result = (String)base.map((Function1<String, String> & java.io.Serializable & Serializable)baseUri -> {
            String string;
            if (url.startsWith("#")) {
                string = new StringBuilder(0).append((String)baseUri).append(url).toString();
            } else {
                String baseDir = MODULE$.stripFileName((String)baseUri);
                string = MODULE$.safeConcat(baseDir, url);
            }
            return string;
        }).getOrElse((Function0<String> & java.io.Serializable & Serializable)() -> url);
        return this.resolvePath(result);
    }

    private String safeConcat(String base, String url) {
        String string;
        if (new StringOps(Predef$.MODULE$.augmentString(base)).nonEmpty() && BoxesRunTime.unboxToChar(new StringOps(Predef$.MODULE$.augmentString(base)).last()) == '/' && new StringOps(Predef$.MODULE$.augmentString(url)).nonEmpty() && BoxesRunTime.unboxToChar(new StringOps(Predef$.MODULE$.augmentString(url)).head()) == '/') {
            string = new StringBuilder(0).append(base).append(new StringOps(Predef$.MODULE$.augmentString(url)).drop(1)).toString();
        } else {
            String string2 = base;
            String string3 = "file://";
            string = !(string2 != null ? !string2.equals(string3) : string3 != null) && url.startsWith("./") ? new StringBuilder(0).append(base).append(url.substring(2)).toString() : new StringBuilder(0).append(base).append(url).toString();
        }
        return string;
    }

    public String stripFileName(String url) {
        return this.stripFileName(url, this.platform().operativeSystem());
    }

    /*
     * Unable to fully structure code
     */
    public String stripFileName(String url, String so) {
        v0 = withoutFrag = url.contains("#") != false ? (String)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])url.split("#"))).head() : url;
        if (!new StringOps(Predef$.MODULE$.augmentString(withoutFrag)).contains(BoxesRunTime.boxToCharacter('\\'))) ** GOTO lbl-1000
        v1 = so;
        var5_4 = "win";
        if (!(v1 != null ? v1.equals(var5_4) == false : var5_4 != null)) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        containsBackSlash = v2;
        containsForwardSlash = new StringOps(Predef$.MODULE$.augmentString(withoutFrag)).contains(BoxesRunTime.boxToCharacter('/'));
        if (!containsBackSlash && !containsForwardSlash) {
            return "";
        }
        sep = containsBackSlash != false ? '\\' : '/';
        lastPieceHasExtension = new StringOps(Predef$.MODULE$.augmentString((String)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(withoutFrag)).split(sep))).last())).contains(BoxesRunTime.boxToCharacter('.'));
        return lastPieceHasExtension != false ? withoutFrag.substring(0, withoutFrag.lastIndexOf(sep) + 1) : (withoutFrag.endsWith(BoxesRunTime.boxToCharacter(sep).toString()) == false ? new StringBuilder(0).append(withoutFrag).append(sep).toString() : var3_3);
    }

    public String normalizePath(String url) {
        return this.fixFilePrefix(new URI(this.platform().encodeURI(url)).normalize().toString());
    }

    public String resolvePath(String path) {
        String res = new URI(path).normalize().toString();
        return this.fixFilePrefix(res);
    }

    private String fixFilePrefix(String res) {
        return res.startsWith("file://") || res.startsWith("file:///") ? res : (res.startsWith("file:/") ? res.replace("file:/", "file:///") : res);
    }

    private UriUtils$() {
        MODULE$ = this;
        PlatformSecrets.$init$(this);
    }
}

