/*
 * Decompiled with CFR 0.152.
 */
package amf.shapes.internal.spec.jsonschema.ref;

import amf.core.client.scala.errorhandling.AMFErrorHandler;
import amf.core.client.scala.model.document.BaseUnit;
import amf.core.client.scala.model.document.ExternalFragment;
import amf.core.client.scala.model.document.Fragment;
import amf.core.client.scala.model.document.RecursiveUnit;
import amf.core.client.scala.model.domain.AmfObject;
import amf.core.client.scala.parse.document.ParsedReference;
import amf.core.client.scala.parse.document.Reference;
import amf.core.client.scala.parse.document.SchemaReference$;
import amf.core.client.scala.parse.document.SyamlParsedDocument;
import amf.core.client.scala.parse.document.SyamlParsedDocument$;
import amf.core.internal.parser.Root;
import amf.core.internal.remote.Mimes$;
import amf.shapes.internal.spec.common.parser.JsonYamlParser$;
import amf.shapes.internal.spec.jsonschema.ref.JsonReference;
import amf.shapes.internal.validation.definitions.ShapeParserSideValidations$;
import java.io.Serializable;
import org.yaml.model.YDocument$;
import org.yaml.model.YMap$;
import org.yaml.model.YNode;
import org.yaml.model.YNode$;
import org.yaml.parser.YParser;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.package$;

public final class JsonSchemaRootCreator$ {
    public static JsonSchemaRootCreator$ MODULE$;

    static {
        new JsonSchemaRootCreator$();
    }

    public Root createRootFrom(Fragment inputFragment, Option<String> pointer, AMFErrorHandler errorHandler) {
        YNode encoded = this.getYNodeFrom(inputFragment, errorHandler);
        return this.createRoot(inputFragment, pointer, encoded);
    }

    public YNode getYNodeFrom(Fragment inputFragment, AMFErrorHandler errorHandler) {
        RecursiveUnit recursiveUnit;
        YNode yNode;
        Fragment fragment = inputFragment;
        if (fragment instanceof ExternalFragment) {
            ExternalFragment externalFragment = (ExternalFragment)fragment;
            yNode = (YNode)externalFragment.encodes().parsed().getOrElse((Function0<YNode> & Serializable & scala.Serializable)() -> MODULE$.parsedFragment(inputFragment, errorHandler));
        } else if (fragment instanceof RecursiveUnit && (recursiveUnit = (RecursiveUnit)fragment).raw().isDefined()) {
            yNode = this.parsedFragment(inputFragment, errorHandler);
        } else {
            errorHandler.violation(ShapeParserSideValidations$.MODULE$.UnableToParseJsonSchema(), (AmfObject)inputFragment, None$.MODULE$, "Cannot parse JSON Schema from unit with missing syntax information");
            yNode = YNode$.MODULE$.apply(YMap$.MODULE$.apply((IndexedSeq)package$.MODULE$.IndexedSeq().apply(Nil$.MODULE$), ""));
        }
        return yNode;
    }

    private YNode parsedFragment(Fragment inputFragment, AMFErrorHandler eh) {
        YParser qual$1 = JsonYamlParser$.MODULE$.apply(inputFragment, eh);
        boolean x$1 = qual$1.document$default$1();
        return qual$1.document(x$1).node();
    }

    private Root createRoot(Fragment inputFragment, Option<String> pointer, YNode encoded) {
        YNode x$1 = encoded;
        String x$2 = YDocument$.MODULE$.apply$default$2(x$1);
        return new Root(new SyamlParsedDocument(YDocument$.MODULE$.apply(x$1, x$2), SyamlParsedDocument$.MODULE$.apply$default$2()), this.buildJsonReference(inputFragment, pointer), Mimes$.MODULE$.application$divjson(), this.toParsedReferences(inputFragment.references()), SchemaReference$.MODULE$, (String)inputFragment.raw().getOrElse((Function0<String> & Serializable & scala.Serializable)() -> ""));
    }

    private String buildJsonReference(Fragment inputFragment, Option<String> pointer) {
        String url = (String)inputFragment.location().getOrElse((Function0<String> & Serializable & scala.Serializable)() -> inputFragment.id());
        return new JsonReference(url, pointer).toString();
    }

    private Seq<ParsedReference> toParsedReferences(Seq<BaseUnit> references) {
        return references.map((Function1<BaseUnit, ParsedReference> & Serializable & scala.Serializable)ref -> new ParsedReference((BaseUnit)ref, new Reference((String)ref.location().getOrElse((Function0<String> & Serializable & scala.Serializable)() -> ""), Nil$.MODULE$), None$.MODULE$), Seq$.MODULE$.canBuildFrom());
    }

    private JsonSchemaRootCreator$() {
        MODULE$ = this;
    }
}

