/*
 * Decompiled with CFR 0.152.
 */
package amf.apicontract.internal.spec.async.emitters.domain;

import amf.apicontract.client.scala.model.domain.security.ApiKeySettings;
import amf.apicontract.client.scala.model.domain.security.HttpApiKeySettings;
import amf.apicontract.client.scala.model.domain.security.HttpSettings;
import amf.apicontract.client.scala.model.domain.security.OAuth2Settings;
import amf.apicontract.client.scala.model.domain.security.OpenIdConnectSettings;
import amf.apicontract.client.scala.model.domain.security.Settings;
import amf.apicontract.internal.spec.async.emitters.domain.ApiKeySettingsEmitters;
import amf.apicontract.internal.spec.async.emitters.domain.HttpApiKeySettingsEmitters;
import amf.apicontract.internal.spec.async.emitters.domain.HttpSettingsEmitters;
import amf.apicontract.internal.spec.async.emitters.domain.OpenIdConnectSettingsEmitters;
import amf.apicontract.internal.spec.common.emitter.AgnosticShapeEmitterContextAdapter;
import amf.apicontract.internal.spec.common.emitter.AgnosticShapeEmitterContextAdapter$;
import amf.apicontract.internal.spec.common.emitter.SpecEmitterContext;
import amf.apicontract.internal.spec.oas.emitter.domain.Oas3OAuth2SettingsEmitters;
import amf.core.internal.render.SpecOrdering;
import amf.core.internal.render.emitters.EntryEmitter;
import amf.shapes.internal.spec.common.emitter.annotations.AnnotationsEmitter;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t4A!\u0003\u0006\u00013!A\u0001\u0005\u0001B\u0001B\u0003%\u0011\u0005\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u0011!\t\u0002A!A!\u0002\u00179\u0004\"B \u0001\t\u0003\u0001\u0005\"B\u0007\u0001\t\u00039\u0005bB-\u0001\u0005\u0004%\u0019B\u0017\u0005\u0007=\u0002\u0001\u000b\u0011B.\t\u000b}\u0003A\u0011\u00021\u00039\u0005\u001b\u0018P\\2TK\u000e,(/\u001b;z'\u0016$H/\u001b8hg\u0016k\u0017\u000e\u001e;fe*\u00111\u0002D\u0001\u0007I>l\u0017-\u001b8\u000b\u00055q\u0011\u0001C3nSR$XM]:\u000b\u0005=\u0001\u0012!B1ts:\u001c'BA\t\u0013\u0003\u0011\u0019\b/Z2\u000b\u0005M!\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005U1\u0012aC1qS\u000e|g\u000e\u001e:bGRT\u0011aF\u0001\u0004C647\u0001A\n\u0003\u0001i\u0001\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011a!\u00118z%\u00164\u0017\u0001C:fiRLgnZ:\u0011\u0005\tZS\"A\u0012\u000b\u0005\u0011*\u0013\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005-1#BA\u0014)\u0003\u0015iw\u000eZ3m\u0015\ti\u0012F\u0003\u0002+)\u000511\r\\5f]RL!\u0001L\u0012\u0003\u0011M+G\u000f^5oON\f\u0001b\u001c:eKJLgn\u001a\t\u0003_Uj\u0011\u0001\r\u0006\u0003cI\naA]3oI\u0016\u0014(BA\n4\u0015\t!d#\u0001\u0003d_J,\u0017B\u0001\u001c1\u00051\u0019\u0006/Z2Pe\u0012,'/\u001b8h!\tAT(D\u0001:\u0015\tQ4(A\u0004f[&$H/\u001a:\u000b\u0005q\u0002\u0012AB2p[6|g.\u0003\u0002?s\t\u00112\u000b]3d\u000b6LG\u000f^3s\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q\u0019\u0011)\u0012$\u0015\u0005\t#\u0005CA\"\u0001\u001b\u0005Q\u0001\"B\t\u0005\u0001\b9\u0004\"\u0002\u0011\u0005\u0001\u0004\t\u0003\"B\u0017\u0005\u0001\u0004qS#\u0001%\u0011\u0007%\u000bFK\u0004\u0002K\u001f:\u00111JT\u0007\u0002\u0019*\u0011Q\nG\u0001\u0007yI|w\u000e\u001e \n\u0003uI!\u0001\u0015\u000f\u0002\u000fA\f7m[1hK&\u0011!k\u0015\u0002\u0004'\u0016\f(B\u0001)\u001d!\t)v+D\u0001W\u0015\ti\u0001'\u0003\u0002Y-\naQI\u001c;ss\u0016k\u0017\u000e\u001e;fe\u0006A1\u000f[1qK\u000e#\b0F\u0001\\!\tAD,\u0003\u0002^s\t\u0011\u0013i\u001a8pgRL7m\u00155ba\u0016,U.\u001b;uKJ\u001cuN\u001c;fqR\fE-\u00199uKJ\f\u0011b\u001d5ba\u0016\u001cE\u000f\u001f\u0011\u0002\u0017\u0015l\u0017\u000e\u001e;feN4uN\u001d\u000b\u0003\u0011\u0006DQ\u0001\t\u0005A\u0002\u0005\u0002")
public class AsyncSecuritySettingsEmitter {
    private final Settings settings;
    private final SpecOrdering ordering;
    private final SpecEmitterContext spec;
    private final AgnosticShapeEmitterContextAdapter shapeCtx;

    public Seq<EntryEmitter> emitters() {
        return this.emittersFor(this.settings);
    }

    public AgnosticShapeEmitterContextAdapter shapeCtx() {
        return this.shapeCtx;
    }

    private Seq<EntryEmitter> emittersFor(Settings settings) {
        Seq<EntryEmitter> seq;
        Settings settings2 = settings;
        if (settings2 instanceof HttpSettings) {
            HttpSettings httpSettings = (HttpSettings)settings2;
            seq = new HttpSettingsEmitters(httpSettings, this.ordering, this.spec).emitters();
        } else if (settings2 instanceof ApiKeySettings) {
            ApiKeySettings apiKeySettings = (ApiKeySettings)settings2;
            seq = new ApiKeySettingsEmitters(apiKeySettings, this.ordering, this.spec).emitters();
        } else if (settings2 instanceof HttpApiKeySettings) {
            HttpApiKeySettings httpApiKeySettings = (HttpApiKeySettings)settings2;
            seq = new HttpApiKeySettingsEmitters(httpApiKeySettings, this.ordering, this.spec).emitters();
        } else if (settings2 instanceof OpenIdConnectSettings) {
            OpenIdConnectSettings openIdConnectSettings = (OpenIdConnectSettings)settings2;
            seq = new OpenIdConnectSettingsEmitters(openIdConnectSettings, this.ordering, this.spec).emitters();
        } else if (settings2 instanceof OAuth2Settings) {
            OAuth2Settings oAuth2Settings = (OAuth2Settings)settings2;
            seq = new Oas3OAuth2SettingsEmitters(oAuth2Settings, this.ordering, this.spec).emitters();
        } else {
            seq = (Seq<EntryEmitter>)Seq$.MODULE$.apply(Nil$.MODULE$);
        }
        Seq<EntryEmitter> particularEmitters = seq;
        Seq result = particularEmitters.$plus$plus(new AnnotationsEmitter(settings, this.ordering, this.shapeCtx()).emitters(), Seq$.MODULE$.canBuildFrom());
        return this.ordering.sorted(result);
    }

    public AsyncSecuritySettingsEmitter(Settings settings, SpecOrdering ordering2, SpecEmitterContext spec) {
        this.settings = settings;
        this.ordering = ordering2;
        this.spec = spec;
        this.shapeCtx = AgnosticShapeEmitterContextAdapter$.MODULE$.apply(spec);
    }
}

