/*
 * Decompiled with CFR 0.152.
 */
package amf.core.client.scala.validation;

import amf.core.client.common.validation.ProfileName;
import amf.core.client.common.validation.SeverityLevels$;
import amf.core.client.scala.model.domain.AmfObject;
import amf.core.client.scala.validation.AMFValidationReport;
import amf.core.client.scala.validation.AMFValidationResult;
import amf.core.client.scala.validation.ReportConformance;
import amf.core.internal.annotations.LexicalInformation;
import java.io.Serializable;
import java.io.StringWriter;
import org.mulesoft.common.client.lexical.Position;
import org.mulesoft.common.client.lexical.PositionRange;
import org.mulesoft.common.io.Output;
import org.mulesoft.common.io.Output$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple2$mcII$sp;
import scala.Tuple7;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

public final class AMFValidationReportPrinter$ {
    public static AMFValidationReportPrinter$ MODULE$;
    private final int DefaultMax;

    static {
        new AMFValidationReportPrinter$();
    }

    public int DefaultMax() {
        return this.DefaultMax;
    }

    public String print(AMFValidationReport report, int max) {
        StringWriter output = new StringWriter();
        this.print(report, output, max, Output$.MODULE$.outputWriter());
        return output.toString();
    }

    public <W> void print(AMFValidationReport report, W writer, int max, Output<W> evidence$1) {
        AMFValidationReport aMFValidationReport = report;
        if (aMFValidationReport == null) {
            throw new MatchError(aMFValidationReport);
        }
        String model = aMFValidationReport.model();
        ProfileName profile = aMFValidationReport.profile();
        Tuple2<String, ProfileName> tuple2 = new Tuple2<String, ProfileName>(model, profile);
        Tuple2<String, ProfileName> tuple22 = tuple2;
        String model2 = tuple22._1();
        ProfileName profile2 = tuple22._2();
        Output$.MODULE$.OutputOps(writer).append(new StringBuilder(10).append("ModelId: ").append(model2).append("\n").toString(), evidence$1);
        Output$.MODULE$.OutputOps(writer).append(new StringBuilder(10).append("Profile: ").append(profile2).append("\n").toString(), evidence$1);
        this.printConformance(report, writer, max, evidence$1);
    }

    public <W> void printConformance(ReportConformance conformance, W writer, int max, Output<W> evidence$2) {
        Output$.MODULE$.OutputOps(writer).append(new StringBuilder(11).append("Conforms: ").append(conformance.conforms()).append("\n").toString(), evidence$2);
        Output$.MODULE$.OutputOps(writer).append(new StringBuilder(20).append("Number of results: ").append(conformance.results().length()).append("\n").toString(), evidence$2);
        Map groupedValidations = ((TraversableLike)((SeqLike)conformance.results().take(max)).sortWith((Function2<AMFValidationResult, AMFValidationResult, Object> & Serializable & scala.Serializable)(c1, c2) -> BoxesRunTime.boxToBoolean(AMFValidationReportPrinter$.$anonfun$printConformance$1(c1, c2)))).groupBy((Function1<AMFValidationResult, String> & Serializable & scala.Serializable)x$2 -> x$2.severityLevel());
        groupedValidations.get(SeverityLevels$.MODULE$.VIOLATION()).foreach((Function1<Seq, Object> & Serializable & scala.Serializable)violations -> {
            AMFValidationReportPrinter$.MODULE$.appendValidations(SeverityLevels$.MODULE$.VIOLATION(), violations, writer, evidence$2);
            return BoxedUnit.UNIT;
        });
        groupedValidations.get(SeverityLevels$.MODULE$.WARNING()).foreach((Function1<Seq, Object> & Serializable & scala.Serializable)violations -> {
            AMFValidationReportPrinter$.MODULE$.appendValidations(SeverityLevels$.MODULE$.WARNING(), violations, writer, evidence$2);
            return BoxedUnit.UNIT;
        });
        groupedValidations.get(SeverityLevels$.MODULE$.INFO()).foreach((Function1<Seq, Object> & Serializable & scala.Serializable)violations -> {
            AMFValidationReportPrinter$.MODULE$.appendValidations(SeverityLevels$.MODULE$.INFO(), violations, writer, evidence$2);
            return BoxedUnit.UNIT;
        });
    }

    public String print(AMFValidationResult report) {
        StringWriter output = new StringWriter();
        this.print(report, output, Output$.MODULE$.outputWriter());
        return output.toString();
    }

    public <W> void print(AMFValidationResult result, W writer, Output<W> evidence$3) {
        AMFValidationResult aMFValidationResult = result;
        if (aMFValidationResult == null) {
            throw new MatchError(aMFValidationResult);
        }
        String message = aMFValidationResult.message();
        String severityLevel = aMFValidationResult.severityLevel();
        Either<AmfObject, String> _targetNode = aMFValidationResult.targetNodeValue$access$2();
        Option<String> targetProperty = aMFValidationResult.targetProperty();
        String validationId = aMFValidationResult.validationId();
        Option<LexicalInformation> position = aMFValidationResult.position();
        Option<String> location = aMFValidationResult.location();
        Tuple7<String, String, Either<AmfObject, String>, Option<String>, String, Option<LexicalInformation>, Option<String>> tuple7 = new Tuple7<String, String, Either<AmfObject, String>, Option<String>, String, Option<LexicalInformation>, Option<String>>(message, severityLevel, _targetNode, targetProperty, validationId, position, location);
        Tuple7<String, String, Either<AmfObject, String>, Option<String>, String, Option<LexicalInformation>, Option<String>> tuple72 = tuple7;
        String message2 = tuple72._1();
        String severityLevel2 = tuple72._2();
        Either<AmfObject, String> _targetNode2 = tuple72._3();
        Option<String> targetProperty2 = tuple72._4();
        String validationId2 = tuple72._5();
        Option<LexicalInformation> position2 = tuple72._6();
        Option<String> location2 = tuple72._7();
        Output$.MODULE$.OutputOps(writer).append(new StringBuilder(15).append("- Constraint: ").append(validationId2).append("\n").toString(), evidence$3);
        Output$.MODULE$.OutputOps(writer).append(new StringBuilder(12).append("  Message: ").append(message2).append("\n").toString(), evidence$3);
        Output$.MODULE$.OutputOps(writer).append(new StringBuilder(13).append("  Severity: ").append(severityLevel2).append("\n").toString(), evidence$3);
        Output$.MODULE$.OutputOps(writer).append(new StringBuilder(11).append("  Target: ").append(result.targetNode()).append("\n").toString(), evidence$3);
        Output$.MODULE$.OutputOps(writer).append(new StringBuilder(13).append("  Property: ").append(targetProperty2.getOrElse((Function0<String> & Serializable & scala.Serializable)() -> "")).append("\n").toString(), evidence$3);
        Output$.MODULE$.OutputOps(writer).append(new StringBuilder(10).append("  Range: ").append(this.serialize(position2)).append("\n").toString(), evidence$3);
        Output$.MODULE$.OutputOps(writer).append(new StringBuilder(13).append("  Location: ").append(location2.getOrElse((Function0<String> & Serializable & scala.Serializable)() -> "")).append("\n").toString(), evidence$3);
    }

    public <W> int print$default$3() {
        return this.DefaultMax();
    }

    private String serialize(Option<LexicalInformation> maybeLexical) {
        return (String)maybeLexical.map((Function1<LexicalInformation, String> & Serializable & scala.Serializable)lexical -> {
            PositionRange positionRange = lexical.range();
            if (positionRange == null) {
                throw new MatchError(positionRange);
            }
            Position start = positionRange.start();
            Position end = positionRange.end();
            Tuple2<Position, Position> tuple2 = new Tuple2<Position, Position>(start, end);
            Tuple2<Position, Position> tuple22 = tuple2;
            Position start2 = tuple22._1();
            Position end2 = tuple22._2();
            Position position = start2;
            if (position == null) {
                throw new MatchError(position);
            }
            int startLine = position.line();
            int startCol = position.column();
            Tuple2$mcII$sp tuple2$mcII$sp = new Tuple2$mcII$sp(startLine, startCol);
            Tuple2$mcII$sp tuple2$mcII$sp2 = tuple2$mcII$sp;
            int startLine2 = ((Tuple2)tuple2$mcII$sp2)._1$mcI$sp();
            int startCol2 = ((Tuple2)tuple2$mcII$sp2)._2$mcI$sp();
            Position position2 = end2;
            if (position2 == null) {
                throw new MatchError(position2);
            }
            int endLine = position2.line();
            int endCol = position2.column();
            Tuple2$mcII$sp tuple2$mcII$sp3 = new Tuple2$mcII$sp(endLine, endCol);
            Tuple2$mcII$sp tuple2$mcII$sp4 = tuple2$mcII$sp3;
            int endLine2 = ((Tuple2)tuple2$mcII$sp4)._1$mcI$sp();
            int endCol2 = ((Tuple2)tuple2$mcII$sp4)._2$mcI$sp();
            return new StringBuilder(9).append("[(").append(startLine2).append(",").append(startCol2).append(")-(").append(endLine2).append(",").append(endCol2).append(")]").toString();
        }).getOrElse((Function0<String> & Serializable & scala.Serializable)() -> "");
    }

    private <W> void appendValidations(String level, Seq<AMFValidationResult> validations, W writer, Output<W> evidence$4) {
        Output$.MODULE$.OutputOps(writer).append(new StringBuilder(9).append("\nLevel: ").append(level).append("\n").toString(), evidence$4);
        validations.foreach((Function1<AMFValidationResult, Object> & Serializable & scala.Serializable)result -> {
            AMFValidationReportPrinter$.$anonfun$appendValidations$1(writer, evidence$4, result);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$printConformance$1(AMFValidationResult c1, AMFValidationResult c2) {
        return c1.compare(c2) < 0;
    }

    public static final /* synthetic */ void $anonfun$appendValidations$1(Object writer$2, Output evidence$4$1, AMFValidationResult result) {
        Output$.MODULE$.OutputOps(writer$2).append("\n", (Output<Object>)evidence$4$1);
        MODULE$.print(result, writer$2, evidence$4$1);
    }

    private AMFValidationReportPrinter$() {
        MODULE$ = this;
        this.DefaultMax = 30;
    }
}

