/*
 * Decompiled with CFR 0.152.
 */
package amf.apicontract.internal.spec.raml.reference;

import amf.apicontract.internal.spec.common.reference.ApiReferenceHandler;
import amf.core.client.scala.model.document.BaseUnit;
import amf.core.client.scala.model.document.ExternalFragment;
import amf.core.client.scala.model.domain.ExternalDomainElement;
import amf.core.client.scala.parse.AMFParsePlugin;
import amf.core.client.scala.parse.TaggedReferences$;
import amf.core.client.scala.parse.document.ASTRefContainer;
import amf.core.client.scala.parse.document.CompilerReferenceCollector;
import amf.core.client.scala.parse.document.ParsedReference;
import amf.core.client.scala.parse.document.ParsedReference$;
import amf.core.client.scala.parse.document.ParserContext;
import amf.core.client.scala.parse.document.RefContainer;
import amf.core.client.scala.parse.document.Reference;
import amf.core.client.scala.parse.document.ReferenceResolutionResult;
import amf.core.client.scala.parse.document.SYamlRefContainer;
import amf.core.client.scala.parse.document.SyamlParsedDocument;
import amf.core.client.scala.parse.document.SyamlParsedDocument$;
import amf.core.internal.annotations.SourceYPart;
import amf.core.internal.parser.CompilerContext;
import amf.core.internal.plugins.syntax.SYamlAMFParserErrorHandler;
import amf.core.internal.validation.CoreValidations$;
import amf.shapes.internal.validation.definitions.ShapeParserSideValidations$;
import java.io.Serializable;
import org.yaml.model.ParseErrorHandler;
import org.yaml.model.YDocument;
import org.yaml.model.YNode;
import org.yaml.model.YNode$;
import org.yaml.model.YPart;
import org.yaml.parser.YamlParser;
import org.yaml.parser.YamlParser$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005%c\u0001B\u0005\u000b\u0001]A\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\u0006Y\u0001!\t!\f\u0005\u0006c\u0001!\tE\r\u0005\u0006!\u0002!I!\u0015\u0005\u0006-\u0002!Ia\u0016\u0005\u0006a\u0002!I!\u001d\u0005\b\u00037\u0001A\u0011BA\u000f\u0011\u001d\t9\u0004\u0001C\u0005\u0003s\u0011ACU1nYJ+g-\u001a:f]\u000e,\u0007*\u00198eY\u0016\u0014(BA\u0006\r\u0003%\u0011XMZ3sK:\u001cWM\u0003\u0002\u000e\u001d\u0005!!/Y7m\u0015\ty\u0001#\u0001\u0003ta\u0016\u001c'BA\t\u0013\u0003!Ig\u000e^3s]\u0006d'BA\n\u0015\u0003-\t\u0007/[2p]R\u0014\u0018m\u0019;\u000b\u0003U\t1!Y7g\u0007\u0001\u0019\"\u0001\u0001\r\u0011\u0005eiR\"\u0001\u000e\u000b\u0005-Y\"B\u0001\u000f\u000f\u0003\u0019\u0019w.\\7p]&\u0011aD\u0007\u0002\u0014\u0003BL'+\u001a4fe\u0016t7-\u001a%b]\u0012dWM]\u0001\u0007a2,x-\u001b8\u0011\u0005\u0005RS\"\u0001\u0012\u000b\u0005\r\"\u0013!\u00029beN,'BA\u0013'\u0003\u0015\u00198-\u00197b\u0015\t9\u0003&\u0001\u0004dY&,g\u000e\u001e\u0006\u0003SQ\tAaY8sK&\u00111F\t\u0002\u000f\u000363\u0005+\u0019:tKBcWoZ5o\u0003\u0019a\u0014N\\5u}Q\u0011a\u0006\r\t\u0003_\u0001i\u0011A\u0003\u0005\u0006?\t\u0001\r\u0001I\u0001\u0007kB$\u0017\r^3\u0015\u0007M2u\t\u0006\u00025\u0003B\u0019Q'O\u001e\u000e\u0003YR!a\u000e\u001d\u0002\u0015\r|gnY;se\u0016tGOC\u0001&\u0013\tQdG\u0001\u0004GkR,(/\u001a\t\u0003y}j\u0011!\u0010\u0006\u0003}\t\n\u0001\u0002Z8dk6,g\u000e^\u0005\u0003\u0001v\u0012q\u0002U1sg\u0016$'+\u001a4fe\u0016t7-\u001a\u0005\u0006\u0005\u000e\u0001\u001daQ\u0001\u0011Kb,7-\u001e;j_:\u001cuN\u001c;fqR\u0004\"!\u000e#\n\u0005\u00153$\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011\u0015Y1\u00011\u0001<\u0011\u0015A5\u00011\u0001J\u0003=\u0019w.\u001c9jY\u0016\u00148i\u001c8uKb$\bC\u0001&O\u001b\u0005Y%B\u0001'N\u0003\u0019\u0001\u0018M]:fe*\u0011\u0011\u0003K\u0005\u0003\u001f.\u0013qbQ8na&dWM]\"p]R,\u0007\u0010^\u0001\u001bQ\u0006tG\r\\3SC6dW\t\u001f;fe:\fGN\u0012:bO6,g\u000e\u001e\u000b\u0004%R+FC\u0001\u001bT\u0011\u0015\u0011E\u0001q\u0001D\u0011\u0015YA\u00011\u0001<\u0011\u0015AE\u00011\u0001J\u0003m)g/\u00197vCR,WK\u001c:fg>dg/\u001a3SK\u001a,'/\u001a8dKR!\u0001\fX/c!\tI&,D\u00019\u0013\tY\u0006H\u0001\u0003V]&$\b\"\u0002%\u0006\u0001\u0004I\u0005\"\u00020\u0006\u0001\u0004y\u0016!\u0001:\u0011\u0005q\u0002\u0017BA1>\u0005%\u0011VMZ3sK:\u001cW\rC\u0003d\u000b\u0001\u0007A-A\u0001f!\t)WN\u0004\u0002gW:\u0011qM[\u0007\u0002Q*\u0011\u0011NF\u0001\u0007yI|w\u000e\u001e \n\u0003\u0015J!\u0001\u001c\u001d\u0002\u000fA\f7m[1hK&\u0011an\u001c\u0002\n)\"\u0014xn^1cY\u0016T!\u0001\u001c\u001d\u0002'I,7o\u001c7wKVs\u0017\u000e\u001e#pGVlWM\u001c;\u0015\u000bI\fy!!\u0005\u0011\t\u0015\u001cX/`\u0005\u0003i>\u0014a!R5uQ\u0016\u0014\bC\u0001<{\u001d\t9\b\u0010\u0005\u0002hq%\u0011\u0011\u0010O\u0001\u0007!J,G-\u001a4\n\u0005md(AB*ue&twM\u0003\u0002zqA\u0019a0a\u0003\u000e\u0003}TA!!\u0001\u0002\u0004\u0005)Qn\u001c3fY*!\u0011QAA\u0004\u0003\u0011I\u0018-\u001c7\u000b\u0005\u0005%\u0011aA8sO&\u0019\u0011QB@\u0003\u0013e#unY;nK:$\b\"B\u0006\u0007\u0001\u0004Y\u0004bBA\n\r\u0001\u0007\u0011QC\u0001\u0004GRD\bc\u0001\u001f\u0002\u0018%\u0019\u0011\u0011D\u001f\u0003\u001bA\u000b'o]3s\u0007>tG/\u001a=u\u00031I7OU1nY>\u0013\u0018,Y7m)\u0011\ty\"!\n\u0011\u0007e\u000b\t#C\u0002\u0002$a\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002(\u001d\u0001\r!!\u000b\u0002\u000f\u0015t7m\u001c3fgB!\u00111FA\u001a\u001b\t\tiC\u0003\u0003\u00020\u0005E\u0012A\u00023p[\u0006LgNC\u0002\u0002\u0002\u0011JA!!\u000e\u0002.\t)R\t\u001f;fe:\fG\u000eR8nC&tW\t\\3nK:$\u0018A\u00045bg\u0012{7-^7f]R\f5\u000b\u0016\u000b\u0005\u0003?\tY\u0004C\u0004\u0002>!\u0001\r!a\u0010\u0002\u000b=$\b.\u001a:\u0011\t\u0005\u0005\u0013QI\u0007\u0003\u0003\u0007R1APA\u0019\u0013\u0011\t9%a\u0011\u0003\u0011\t\u000b7/Z+oSR\u0004")
public class RamlReferenceHandler
extends ApiReferenceHandler {
    private final AMFParsePlugin plugin;

    @Override
    public Future<ParsedReference> update(ParsedReference reference, CompilerContext compilerContext, ExecutionContext executionContext) {
        if (reference.isExternalFragment()) {
            return this.handleRamlExternalFragment(reference, compilerContext, executionContext);
        }
        return Future$.MODULE$.successful(reference);
    }

    private Future<ParsedReference> handleRamlExternalFragment(ParsedReference reference, CompilerContext compilerContext, ExecutionContext executionContext) {
        Either<String, YDocument> either = this.resolveUnitDocument(reference, compilerContext.parserContext());
        if (either instanceof Right) {
            Right right = (Right)either;
            YDocument document = (YDocument)right.value();
            SyamlParsedDocument parsed = new SyamlParsedDocument(document, SyamlParsedDocument$.MODULE$.apply$default$2());
            CompilerReferenceCollector refs = new RamlReferenceHandler(this.plugin).collect(parsed, compilerContext.parserContext());
            CompilerContext updated = compilerContext.forReference(reference.origin().url(), compilerContext.forReference$default$2(), executionContext);
            Seq allowedSpecs = this.plugin.validSpecsToReference().$colon$plus(this.plugin.spec(), Seq$.MODULE$.canBuildFrom());
            Seq externals = refs.toReferences().map((Function1<Reference, Future> & Serializable & scala.Serializable)r -> r.resolve(updated, allowedSpecs, true, executionContext).flatMap((Function1<ReferenceResolutionResult, Future> & Serializable & scala.Serializable)x0$1 -> {
                ReferenceResolutionResult referenceResolutionResult = x0$1;
                if (referenceResolutionResult != null) {
                    Option<Throwable> option = referenceResolutionResult.exception();
                    Option<BaseUnit> option2 = referenceResolutionResult.unit();
                    if (None$.MODULE$.equals(option) && option2 instanceof Some) {
                        Some some = (Some)option2;
                        BaseUnit unit = (BaseUnit)some.value();
                        Future<ParsedReference> resolved = this.handleRamlExternalFragment(new ParsedReference(unit, (Reference)r, ParsedReference$.MODULE$.apply$default$3()), updated, executionContext);
                        TaggedReferences$.MODULE$.BuReferenceTagger(reference.unit()).tagReference((String)unit.location().getOrElse((Function0<String> & Serializable & scala.Serializable)() -> unit.id()), (Reference)r);
                        return resolved.map((Function1<ParsedReference, Object> & Serializable & scala.Serializable)res -> {
                            RamlReferenceHandler.$anonfun$handleRamlExternalFragment$4(reference, r, compilerContext, res);
                            return BoxedUnit.UNIT;
                        }, executionContext);
                    }
                }
                if (referenceResolutionResult != null) {
                    Option<Throwable> option = referenceResolutionResult.exception();
                    Option<BaseUnit> option3 = referenceResolutionResult.unit();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Throwable e = (Throwable)some.value();
                        if (None$.MODULE$.equals(option3)) {
                            this.evaluateUnresolvedReference(compilerContext, (Reference)r, e);
                            return Future$.MODULE$.apply((Function0<Nil$> & Serializable & scala.Serializable)() -> Nil$.MODULE$, executionContext);
                        }
                    }
                }
                return Future$.MODULE$.apply((Function0<Nil$> & Serializable & scala.Serializable)() -> Nil$.MODULE$, executionContext);
            }, executionContext), Seq$.MODULE$.canBuildFrom());
            return Future$.MODULE$.sequence(externals, Seq$.MODULE$.canBuildFrom(), executionContext).map((Function1<Seq, ParsedReference> & Serializable & scala.Serializable)x$1 -> {
                Some<YNode> x$12 = new Some<YNode>(document.node());
                BaseUnit x$2 = reference.copy$default$1();
                Reference x$3 = reference.copy$default$2();
                return reference.copy(x$2, x$3, x$12);
            }, executionContext);
        }
        if (either instanceof Left) {
            Left left = (Left)either;
            String raw = (String)left.value();
            reference.unit().references().foreach((Function1<BaseUnit, ParserContext> & Serializable & scala.Serializable)u -> compilerContext.parserContext().addSonRef((BaseUnit)u));
            Some<YNode> x$4 = new Some<YNode>(YNode$.MODULE$.apply(raw, (String)reference.unit().location().getOrElse((Function0<String> & Serializable & scala.Serializable)() -> "")));
            BaseUnit x$5 = reference.copy$default$1();
            Reference x$6 = reference.copy$default$2();
            return Future$.MODULE$.successful(reference.copy(x$5, x$6, x$4));
        }
        throw new MatchError(either);
    }

    private void evaluateUnresolvedReference(CompilerContext compilerContext, Reference r, Throwable e) {
        if (!r.isInferred()) {
            r.refs().foreach((Function1<RefContainer, Object> & Serializable & scala.Serializable)x0$1 -> {
                RamlReferenceHandler.$anonfun$evaluateUnresolvedReference$1(compilerContext, r, e, x0$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private Either<String, YDocument> resolveUnitDocument(ParsedReference reference, ParserContext ctx) {
        boolean bl = false;
        ExternalFragment externalFragment = null;
        BaseUnit baseUnit = reference.unit();
        if (baseUnit instanceof ExternalFragment) {
            bl = true;
            externalFragment = (ExternalFragment)baseUnit;
            if (this.isRamlOrYaml(externalFragment.encodes())) {
                YamlParser qual$1 = YamlParser$.MODULE$.apply((CharSequence)externalFragment.encodes().raw().value(), (String)externalFragment.location().getOrElse((Function0<String> & Serializable & scala.Serializable)() -> ""), ctx.parsingOptions().getMaxJsonYamlDepth(), (ParseErrorHandler)new SYamlAMFParserErrorHandler(ctx.eh())).withIncludeTag("!include");
                boolean x$1 = qual$1.document$default$1();
                return package$.MODULE$.Right().apply(qual$1.document(x$1));
            }
        }
        if (bl) {
            return package$.MODULE$.Left().apply(externalFragment.encodes().raw().value());
        }
        if (this.hasDocumentAST(baseUnit)) {
            return package$.MODULE$.Right().apply(baseUnit.annotations().find(SourceYPart.class).map((Function1<SourceYPart, YDocument> & Serializable & scala.Serializable)x$2 -> (YDocument)x$2.ast()).get());
        }
        return package$.MODULE$.Left().apply("");
    }

    private boolean isRamlOrYaml(ExternalDomainElement encodes) {
        return encodes.mediaType().option().exists((Function1<String, Object> & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean(x$3.contains("yaml")));
    }

    private boolean hasDocumentAST(BaseUnit other) {
        return other.annotations().find(SourceYPart.class).exists((Function1<SourceYPart, Object> & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean(RamlReferenceHandler.$anonfun$hasDocumentAST$1(x$4)));
    }

    public static final /* synthetic */ void $anonfun$handleRamlExternalFragment$5(ParsedReference res$1, CompilerContext compilerContext$1, RefContainer x0$2) {
        RefContainer refContainer = x0$2;
        if (refContainer instanceof SYamlRefContainer) {
            SYamlRefContainer sYamlRefContainer = (SYamlRefContainer)refContainer;
            YPart yPart = sYamlRefContainer.node();
            if (yPart instanceof YNode.MutRef) {
                YNode.MutRef mutRef = (YNode.MutRef)yPart;
                res$1.unit().references().foreach((Function1<BaseUnit, ParserContext> & Serializable & scala.Serializable)u -> compilerContext$1.parserContext().addSonRef((BaseUnit)u));
                mutRef.target_$eq(res$1.ast());
            } else {
                compilerContext$1.violation(ShapeParserSideValidations$.MODULE$.InvalidFragmentType(), "Cannot inline a fragment in a not mutable node", yPart.location());
            }
            return;
        }
        throw new MatchError(refContainer);
    }

    public static final /* synthetic */ void $anonfun$handleRamlExternalFragment$4(ParsedReference reference$1, Reference r$1, CompilerContext compilerContext$1, ParsedReference res) {
        reference$1.unit().addReference(res.unit());
        r$1.refs().foreach((Function1<RefContainer, Object> & Serializable & scala.Serializable)x0$2 -> {
            RamlReferenceHandler.$anonfun$handleRamlExternalFragment$5(res, compilerContext$1, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$evaluateUnresolvedReference$1(CompilerContext compilerContext$2, Reference r$2, Throwable e$1, RefContainer x0$1) {
        RefContainer refContainer = x0$1;
        if (refContainer instanceof ASTRefContainer) {
            ASTRefContainer aSTRefContainer = (ASTRefContainer)refContainer;
            compilerContext$2.violation(CoreValidations$.MODULE$.UnresolvedReference(), r$2.url(), e$1.getMessage(), aSTRefContainer.pos());
            return;
        }
        throw new MatchError(refContainer);
    }

    public static final /* synthetic */ boolean $anonfun$hasDocumentAST$1(SourceYPart x$4) {
        return x$4.ast() instanceof YDocument;
    }

    public RamlReferenceHandler(AMFParsePlugin plugin) {
        this.plugin = plugin;
        super(plugin.id());
    }
}

