/*
 * Decompiled with CFR 0.152.
 */
package com.damnhandy.uri.template;

import com.damnhandy.uri.template.UriTransient;
import com.damnhandy.uri.template.VarExploder;
import com.damnhandy.uri.template.VarExploderException;
import com.damnhandy.uri.template.VarName;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class DefaultVarExploder
implements VarExploder {
    private static final String GET_PREFIX = "get";
    private static final String IS_PREIX = "is";
    private Object source;
    private Map<String, Object> pairs = new TreeMap<String, Object>();

    public DefaultVarExploder(Object source) throws VarExploderException {
        this.setSource(source);
    }

    @Override
    public Map<String, Object> getNameValuePairs() {
        return this.pairs;
    }

    void setSource(Object source) throws VarExploderException {
        this.source = source;
        this.initValues();
    }

    private void initValues() throws VarExploderException {
        Method[] methods;
        Class<?> c = this.source.getClass();
        if (c.isAnnotation() || c.isArray() || c.isEnum() || c.isPrimitive()) {
            throw new IllegalArgumentException("The value must an object");
        }
        if (this.source instanceof Map) {
            this.pairs = (Map)this.source;
            return;
        }
        for (Method method : methods = c.getMethods()) {
            this.inspectGetters(method);
        }
        this.scanFields(c);
    }

    private void inspectGetters(Method method) {
        String methodName = method.getName();
        int prefixLength = 0;
        if (methodName.startsWith(GET_PREFIX)) {
            prefixLength = GET_PREFIX.length();
        }
        if (methodName.startsWith(IS_PREIX)) {
            prefixLength = IS_PREIX.length();
        }
        if (prefixLength == 0) {
            return;
        }
        String name = DefaultVarExploder.decapitalize(methodName.substring(prefixLength));
        if (!DefaultVarExploder.isValidProperty(name)) {
            return;
        }
        Class<?> propertyType = method.getReturnType();
        if (propertyType == null || propertyType == Void.TYPE) {
            return;
        }
        if (prefixLength == 2 && propertyType != Boolean.TYPE) {
            return;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes.length > 1 || paramTypes.length == 1 && paramTypes[0] != Integer.TYPE) {
            return;
        }
        if (!method.isAnnotationPresent(UriTransient.class) && !"class".equals(name)) {
            Object value = this.getValue(method);
            if (method.isAnnotationPresent(VarName.class)) {
                name = method.getAnnotation(VarName.class).value();
            }
            if (value != null) {
                this.pairs.put(name, value);
            }
        }
    }

    private static boolean isValidProperty(String propertyName) {
        return propertyName != null && propertyName.length() != 0;
    }

    static String decapitalize(String name) {
        if (name == null) {
            return null;
        }
        if (name.length() == 0 || name.length() > 1 && Character.isUpperCase(name.charAt(1))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private void scanFields(Class<?> c) {
        if (!c.isInterface()) {
            Field[] fields;
            for (Field field2 : fields = c.getDeclaredFields()) {
                String fieldName = field2.getName();
                if (!this.pairs.containsKey(fieldName)) continue;
                if (field2.isAnnotationPresent(UriTransient.class)) {
                    this.pairs.remove(fieldName);
                    continue;
                }
                if (!field2.isAnnotationPresent(VarName.class)) continue;
                String name = field2.getAnnotation(VarName.class).value();
                this.pairs.put(name, this.pairs.get(fieldName));
                this.pairs.remove(fieldName);
            }
        }
        if (!c.getSuperclass().equals(Object.class)) {
            this.scanFields(c.getSuperclass());
        }
    }

    private Object getValue(Method method) throws VarExploderException {
        try {
            if (method == null) {
                return null;
            }
            return method.invoke(this.source, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new VarExploderException(e);
        }
        catch (IllegalAccessException e) {
            throw new VarExploderException(e);
        }
        catch (InvocationTargetException e) {
            throw new VarExploderException(e);
        }
    }

    @Override
    public Collection<Object> getValues() throws VarExploderException {
        return this.pairs.values();
    }
}

