/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.Objects;
import org.apache.commons.collections4.bloomfilter.BitMapExtractor;
import org.apache.commons.collections4.bloomfilter.Hasher;
import org.apache.commons.collections4.bloomfilter.IndexExtractor;
import org.apache.commons.collections4.bloomfilter.Shape;

public interface BloomFilter<T extends BloomFilter<T>>
extends IndexExtractor,
BitMapExtractor {
    public static final int SPARSE = 1;

    public int cardinality();

    public int characteristics();

    public void clear();

    default public boolean contains(BitMapExtractor bitMapExtractor) {
        return this.processBitMapPairs(bitMapExtractor, (x, y) -> (x & y) == y);
    }

    default public boolean contains(BloomFilter<?> other) {
        Objects.requireNonNull(other, "other");
        return (this.characteristics() & 1) != 0 ? this.contains((IndexExtractor)other) : this.contains((BitMapExtractor)other);
    }

    default public boolean contains(Hasher hasher2) {
        Objects.requireNonNull(hasher2, "Hasher");
        Shape shape = this.getShape();
        return this.contains(hasher2.indices(shape));
    }

    public boolean contains(IndexExtractor var1);

    public T copy();

    default public int estimateIntersection(BloomFilter<?> other) {
        long estimate;
        Objects.requireNonNull(other, "other");
        double eThis = this.getShape().estimateN(this.cardinality());
        double eOther = this.getShape().estimateN(other.cardinality());
        if (Double.isInfinite(eThis) && Double.isInfinite(eOther)) {
            return Integer.MAX_VALUE;
        }
        if (Double.isInfinite(eThis)) {
            estimate = Math.round(eOther);
        } else if (Double.isInfinite(eOther)) {
            estimate = Math.round(eThis);
        } else {
            T union = this.copy();
            union.merge(other);
            double eUnion = this.getShape().estimateN(union.cardinality());
            if (Double.isInfinite(eUnion)) {
                throw new IllegalArgumentException("The estimated N for the union of the filters is infinite");
            }
            estimate = Math.round(eThis + eOther - eUnion);
            estimate = estimate < 0L ? 0L : estimate;
        }
        return estimate > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)estimate;
    }

    default public int estimateN() {
        double d = this.getShape().estimateN(this.cardinality());
        if (Double.isInfinite(d)) {
            return Integer.MAX_VALUE;
        }
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException("Cardinality too large: " + this.cardinality());
        }
        long l = Math.round(d);
        return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
    }

    default public int estimateUnion(BloomFilter<?> other) {
        Objects.requireNonNull(other, "other");
        T copy = this.copy();
        copy.merge(other);
        return copy.estimateN();
    }

    public Shape getShape();

    default public boolean isEmpty() {
        return this.processBitMaps(y -> y == 0L);
    }

    default public boolean isFull() {
        return this.cardinality() == this.getShape().getNumberOfBits();
    }

    public boolean merge(BitMapExtractor var1);

    default public boolean merge(BloomFilter<?> other) {
        return (this.characteristics() & 1) != 0 ? this.merge((IndexExtractor)other) : this.merge((BitMapExtractor)other);
    }

    default public boolean merge(Hasher hasher2) {
        Objects.requireNonNull(hasher2, "hasher");
        return this.merge(hasher2.indices(this.getShape()));
    }

    public boolean merge(IndexExtractor var1);

    @Override
    default public IndexExtractor uniqueIndices() {
        return this;
    }
}

