/*
 * Decompiled with CFR 0.152.
 */
package amf.core.internal.remote;

import amf.core.internal.remote.EcmaEncoder;
import scala.Array$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1$mcZI$sp;

public final class EcmaEncoder$ {
    public static EcmaEncoder$ MODULE$;
    private final int InvalidUtf8;
    private final boolean[] unEscapedFull;
    private final boolean[] unEscapedPartial;

    static {
        new EcmaEncoder$();
    }

    public String encode(String str, boolean fullUri) {
        String string;
        if (str == null) {
            string = str;
        } else {
            byte[] utf8buf = null;
            StringBuilder sb = null;
            boolean[] unEscaped = fullUri ? this.unEscapedFull() : this.unEscapedPartial();
            for (int k = 0; k < str.length(); ++k) {
                java.io.Serializable serializable;
                int C = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str), k);
                if (C < 128 && unEscaped[C]) {
                    if (sb != null) {
                        serializable = sb.append((char)C);
                        continue;
                    }
                    serializable = BoxedUnit.UNIT;
                    continue;
                }
                if (sb == null) {
                    sb = new StringBuilder(str.length() + 3);
                    sb.append(str);
                    sb.setLength(k);
                    utf8buf = (byte[])Array$.MODULE$.ofDim(6, ClassTag$.MODULE$.Byte());
                }
                if (56320 <= C && C <= 57343) {
                    throw this.uriError();
                }
                int V = 0;
                if (C < 55296 || 56319 < C) {
                    V = C;
                } else {
                    if (++k == str.length()) {
                        throw this.uriError();
                    }
                    char C2 = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str), k);
                    if ('\udc00' > C2 || C2 > '\udfff') {
                        throw this.uriError();
                    }
                    V = (C - 55296 << 10) + (C2 - 56320) + 65536;
                }
                int L = this.oneUcs4ToUtf8Char(utf8buf, V);
                for (int j = 0; j < L; ++j) {
                    int d = 0xFF & utf8buf[j];
                    sb.append('%');
                    sb.append(this.toHexChar(d >>> 4));
                    sb.append(this.toHexChar(d & 0xF));
                }
                serializable = BoxedUnit.UNIT;
            }
            string = sb == null ? str : sb.toString();
        }
        return string;
    }

    public boolean encode$default$2() {
        return true;
    }

    private char toHexChar(int i) {
        if (i >> 4 != 0) {
            throw this.uriError();
        }
        return (char)(i < 10 ? i + 48 : i - 10 + 65);
    }

    /*
     * WARNING - void declaration
     */
    private int oneUcs4ToUtf8Char(byte[] utf8Buffer, int ucs) {
        void var3_3;
        int utf8Length = 1;
        int ucs4Char = ucs;
        if ((ucs4Char & ~127) == 0) {
            utf8Buffer[0] = (byte)ucs4Char;
        } else {
            int i = 0;
            int a = ucs4Char >>> 11;
            utf8Length = 2;
            while (a != 0) {
                a >>>= 5;
                ++utf8Length;
            }
            i = utf8Length;
            while (--i > 0) {
                utf8Buffer[i] = (byte)(ucs4Char & 0x3F | 0x80);
                ucs4Char >>>= 6;
            }
            utf8Buffer[0] = (byte)(256 - (1 << 8 - utf8Length) + ucs4Char);
        }
        return (int)var3_3;
    }

    private EcmaEncoder.UriError uriError() {
        return new EcmaEncoder.UriError("Bad iri");
    }

    private final int InvalidUtf8() {
        return this.InvalidUtf8;
    }

    private int unHex(char c) {
        return 'A' <= c && c <= 'F' ? c - 65 + 10 : ('a' <= c && c <= 'f' ? c - 97 + 10 : ('0' <= c && c <= '9' ? c - 48 : -1));
    }

    private int unHex(char c1, char c2) {
        int i1 = this.unHex(c1);
        int i2 = this.unHex(c2);
        return i1 >= 0 && i2 >= 0 ? i1 << 4 | i2 : -1;
    }

    public String decode(String str, boolean fullUri) {
        char[] buf = null;
        int bufTop = 0;
        int k = 0;
        int length = str.length();
        while (k != length) {
            char C = str.charAt(k);
            if (C != '%') {
                if (buf != null) {
                    buf[++bufTop - 1] = C;
                }
                ++k;
                continue;
            }
            if (buf == null) {
                buf = (char[])Array$.MODULE$.ofDim(length, ClassTag$.MODULE$.Char());
                str.getChars(0, k, buf, 0);
                bufTop = k;
            }
            int start = k;
            if (k + 3 > length) {
                throw this.uriError();
            }
            int B = this.unHex(str.charAt(k + 1), str.charAt(k + 2));
            if (B < 0) {
                throw this.uriError();
            }
            k += 3;
            if ((B & 0x80) == 0) {
                C = (char)B;
            } else {
                int utf8Tail = 0;
                int ucs4Char = 0;
                int minUcs4Char = 0;
                if ((B & 0xC0) == 128) {
                    throw this.uriError();
                }
                if ((B & 0x20) == 0) {
                    utf8Tail = 1;
                    ucs4Char = B & 0x1F;
                    minUcs4Char = 128;
                } else if ((B & 0x10) == 0) {
                    utf8Tail = 2;
                    ucs4Char = B & 0xF;
                    minUcs4Char = 2048;
                } else if ((B & 8) == 0) {
                    utf8Tail = 3;
                    ucs4Char = B & 7;
                    minUcs4Char = 65536;
                } else if ((B & 4) == 0) {
                    utf8Tail = 4;
                    ucs4Char = B & 3;
                    minUcs4Char = 0x200000;
                } else if ((B & 2) == 0) {
                    utf8Tail = 5;
                    ucs4Char = B & 1;
                    minUcs4Char = 0x4000000;
                } else {
                    throw this.uriError();
                }
                if (k + 3 * utf8Tail > length) {
                    throw this.uriError();
                }
                int j = 0;
                while (j != utf8Tail) {
                    if (str.charAt(k) != '%') {
                        throw this.uriError();
                    }
                    B = this.unHex(str.charAt(k + 1), str.charAt(k + 2));
                    if (B < 0 || (B & 0xC0) != 128) {
                        throw this.uriError();
                    }
                    ucs4Char = ucs4Char << 6 | B & 0x3F;
                    k += 3;
                    int cfr_ignored_0 = ++j - 1;
                }
                if (ucs4Char < minUcs4Char || ucs4Char >= 55296 && ucs4Char <= 57343) {
                    ucs4Char = this.InvalidUtf8();
                } else if (ucs4Char == 65534 || ucs4Char == 65535) {
                    ucs4Char = 65533;
                }
                if (ucs4Char >= 65536) {
                    if ((ucs4Char -= 65536) > 1048575) {
                        throw this.uriError();
                    }
                    char H = (char)((ucs4Char >>> 10) + 55296);
                    C = (char)((ucs4Char & 0x3FF) + 56320);
                    buf[++bufTop - 1] = H;
                } else {
                    C = (char)ucs4Char;
                }
            }
            if (fullUri && ";/?:@&=+$,#".indexOf(C) >= 0) {
                int x = start;
                while (x != k) {
                    buf[++bufTop - 1] = str.charAt(x);
                    int cfr_ignored_1 = ++x - 1;
                }
                continue;
            }
            buf[++bufTop - 1] = C;
        }
        return buf == null ? str : new String(buf, 0, bufTop);
    }

    public boolean decode$default$2() {
        return true;
    }

    private final String UriDecodeReserved() {
        return ";/?:@&=+$,#";
    }

    private boolean encodeUnescaped(int c, boolean fullUri) {
        return 65 <= c && c <= 90 || 97 <= c && c <= 122 || 48 <= c && c <= 57 ? true : new StringOps(Predef$.MODULE$.augmentString("-_.!~*'()")).contains(BoxesRunTime.boxToInteger(c)) || fullUri && new StringOps(Predef$.MODULE$.augmentString(";/?:@&=+$,#")).contains(BoxesRunTime.boxToInteger(c));
    }

    private final boolean[] unEscapedFull() {
        return this.unEscapedFull;
    }

    private final boolean[] unEscapedPartial() {
        return this.unEscapedPartial;
    }

    private EcmaEncoder$() {
        MODULE$ = this;
        this.InvalidUtf8 = Integer.MAX_VALUE;
        this.unEscapedFull = (boolean[])((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 128).map((JFunction1$mcZI$sp & Serializable)x$1 -> MODULE$.encodeUnescaped(x$1, true), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Boolean());
        this.unEscapedPartial = (boolean[])((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 128).map((JFunction1$mcZI$sp & Serializable)x$2 -> MODULE$.encodeUnescaped(x$2, false), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Boolean());
    }
}

