/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.util.NoSuchElementException;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.NewRedBlackTree;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.sys.package$;

public final class NewRedBlackTree$ {
    public static NewRedBlackTree$ MODULE$;

    static {
        new NewRedBlackTree$();
    }

    public boolean isEmpty(NewRedBlackTree.Tree<?, ?> tree) {
        return tree == null;
    }

    public <A> boolean contains(NewRedBlackTree.Tree<A, ?> tree, A x, Ordering<A> evidence$1) {
        return this.lookup(tree, x, evidence$1) != null;
    }

    public <A, B> Option<B> get(NewRedBlackTree.Tree<A, B> tree, A x, Ordering<A> evidence$2) {
        NewRedBlackTree.Tree<A, B> tree2 = this.lookup(tree, x, evidence$2);
        Option option = tree2 == null ? None$.MODULE$ : new Some<Object>(tree2.scala$collection$immutable$NewRedBlackTree$Tree$$_value);
        return option;
    }

    public <A, B> NewRedBlackTree.Tree<A, B> lookup(NewRedBlackTree.Tree<A, B> tree, A x, Ordering<A> ordering2) {
        while (true) {
            if (tree == null) {
                return null;
            }
            int cmp = ordering2.compare(x, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key);
            if (cmp < 0) {
                tree = tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
                continue;
            }
            if (cmp <= 0) break;
            tree = tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
        }
        return tree;
    }

    public int count(NewRedBlackTree.Tree<?, ?> tree) {
        if (tree == null) {
            return 0;
        }
        return tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count & Integer.MAX_VALUE;
    }

    public <A, B, B1> NewRedBlackTree.Tree<A, B1> update(NewRedBlackTree.Tree<A, B> tree, A k, B1 v, boolean overwrite, Ordering<A> evidence$3) {
        return this.blacken(this.upd(tree, k, v, overwrite, evidence$3));
    }

    public <A, B> NewRedBlackTree.Tree<A, B> delete(NewRedBlackTree.Tree<A, B> tree, A k, Ordering<A> evidence$4) {
        return this.blacken(this.del(tree, k, evidence$4));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <A, B> NewRedBlackTree.Tree<A, B> rangeImpl(NewRedBlackTree.Tree<A, B> tree, Option<A> from, Option<A> until, Ordering<A> evidence$5) {
        Tuple2<Option<A>, Option<A>> tuple2 = new Tuple2<Option<A>, Option<A>>(from, until);
        Option<A> option = from;
        Option<A> option2 = until;
        if (option instanceof Some) {
            Object from2 = ((Some)option).value();
            if (option2 instanceof Some) {
                Object until2 = ((Some)option2).value();
                return this.range(tree, from2, until2, evidence$5);
            }
        }
        Option<A> option3 = from;
        Option<A> option4 = until;
        if (option3 instanceof Some) {
            Object from3 = ((Some)option3).value();
            if (None$.MODULE$.equals(option4)) {
                return this.from(tree, from3, evidence$5);
            }
        }
        if (tuple2 != null) {
            Option<A> option5 = from;
            Option<A> option6 = until;
            if (None$.MODULE$.equals(option5) && option6 instanceof Some) {
                Object until3 = ((Some)option6).value();
                return this.until(tree, until3, evidence$5);
            }
        }
        if (tuple2 == null) throw new MatchError(tuple2);
        Option<A> option7 = from;
        Option<A> option8 = until;
        if (!None$.MODULE$.equals(option7)) throw new MatchError(tuple2);
        if (!None$.MODULE$.equals(option8)) throw new MatchError(tuple2);
        return tree;
    }

    public <A, B> NewRedBlackTree.Tree<A, B> range(NewRedBlackTree.Tree<A, B> tree, A from, A until, Ordering<A> evidence$6) {
        return this.blacken(this.doRange(tree, from, until, evidence$6));
    }

    public <A, B> NewRedBlackTree.Tree<A, B> from(NewRedBlackTree.Tree<A, B> tree, A from, Ordering<A> evidence$7) {
        return this.blacken(this.doFrom(tree, from, evidence$7));
    }

    public <A, B> NewRedBlackTree.Tree<A, B> to(NewRedBlackTree.Tree<A, B> tree, A to, Ordering<A> evidence$8) {
        return this.blacken(this.doTo(tree, to, evidence$8));
    }

    public <A, B> NewRedBlackTree.Tree<A, B> until(NewRedBlackTree.Tree<A, B> tree, A key, Ordering<A> evidence$9) {
        return this.blacken(this.doUntil(tree, key, evidence$9));
    }

    public <A, B> NewRedBlackTree.Tree<A, B> drop(NewRedBlackTree.Tree<A, B> tree, int n, Ordering<A> evidence$10) {
        return this.blacken(this.doDrop(tree, n));
    }

    public <A, B> NewRedBlackTree.Tree<A, B> take(NewRedBlackTree.Tree<A, B> tree, int n, Ordering<A> evidence$11) {
        return this.blacken(this.doTake(tree, n));
    }

    public <A, B> NewRedBlackTree.Tree<A, B> slice(NewRedBlackTree.Tree<A, B> tree, int from, int until, Ordering<A> evidence$12) {
        return this.blacken(this.doSlice(tree, from, until));
    }

    /*
     * WARNING - void declaration
     */
    public <A, B> NewRedBlackTree.Tree<A, B> smallest(NewRedBlackTree.Tree<A, B> tree) {
        void var2_2;
        if (tree == null) {
            throw new NoSuchElementException("empty tree");
        }
        NewRedBlackTree.Tree<A, Object> result = tree;
        while (true) {
            if (result == null) {
                throw null;
            }
            if (result.scala$collection$immutable$NewRedBlackTree$Tree$$_left == null) break;
            result = result.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public <A, B> NewRedBlackTree.Tree<A, B> greatest(NewRedBlackTree.Tree<A, B> tree) {
        void var2_2;
        if (tree == null) {
            throw new NoSuchElementException("empty tree");
        }
        NewRedBlackTree.Tree<A, Object> result = tree;
        while (true) {
            if (result == null) {
                throw null;
            }
            if (result.scala$collection$immutable$NewRedBlackTree$Tree$$_right == null) break;
            result = result.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
        }
        return var2_2;
    }

    public <A, B> NewRedBlackTree.Tree<A, B> tail(NewRedBlackTree.Tree<A, B> tree) {
        return this.blacken(this._tail$1(tree));
    }

    public <A, B> NewRedBlackTree.Tree<A, B> init(NewRedBlackTree.Tree<A, B> tree) {
        return this.blacken(this._init$1(tree));
    }

    public <A, B> NewRedBlackTree.Tree<A, B> minAfter(NewRedBlackTree.Tree<A, B> tree, A x, Ordering<A> ordering2) {
        while (tree != null) {
            int cmp = ordering2.compare(x, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key);
            if (cmp == 0) {
                return tree;
            }
            if (cmp < 0) {
                NewRedBlackTree.Tree l = this.minAfter(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, x, ordering2);
                if (l != null) {
                    return l;
                }
                return tree;
            }
            tree = tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
        }
        return null;
    }

    public <A, B> NewRedBlackTree.Tree<A, B> maxBefore(NewRedBlackTree.Tree<A, B> tree, A x, Ordering<A> ordering2) {
        while (true) {
            if (tree == null) {
                return null;
            }
            if (ordering2.compare(x, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key) > 0) break;
            tree = tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
        }
        NewRedBlackTree.Tree r = this.maxBefore(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right, x, ordering2);
        if (r != null) {
            return r;
        }
        return tree;
    }

    public <A, B, U> void foreach(NewRedBlackTree.Tree<A, B> tree, Function1<Tuple2<A, B>, U> f) {
        if (tree != null) {
            this._foreach(tree, f);
        }
    }

    public <A, X, Y> boolean keysEqual(NewRedBlackTree.Tree<A, X> a, NewRedBlackTree.Tree<A, Y> b, Ordering<A> evidence$13) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        return (a.scala$collection$immutable$NewRedBlackTree$Tree$$_count & Integer.MAX_VALUE) == (b.scala$collection$immutable$NewRedBlackTree$Tree$$_count & Integer.MAX_VALUE) && new NewRedBlackTree.EqualsIterator<A, Y>(a, evidence$13).sameKeys(new NewRedBlackTree.EqualsIterator<A, Y>(b, evidence$13));
    }

    public <A, X, Y> boolean valuesEqual(NewRedBlackTree.Tree<A, X> a, NewRedBlackTree.Tree<A, Y> b, Ordering<A> evidence$14) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        return (a.scala$collection$immutable$NewRedBlackTree$Tree$$_count & Integer.MAX_VALUE) == (b.scala$collection$immutable$NewRedBlackTree$Tree$$_count & Integer.MAX_VALUE) && new NewRedBlackTree.EqualsIterator<A, Y>(a, evidence$14).sameValues(new NewRedBlackTree.EqualsIterator<A, Y>(b, evidence$14));
    }

    public <A, X, Y> boolean entriesEqual(NewRedBlackTree.Tree<A, X> a, NewRedBlackTree.Tree<A, Y> b, Ordering<A> evidence$15) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        return (a.scala$collection$immutable$NewRedBlackTree$Tree$$_count & Integer.MAX_VALUE) == (b.scala$collection$immutable$NewRedBlackTree$Tree$$_count & Integer.MAX_VALUE) && new NewRedBlackTree.EqualsIterator<A, Y>(a, evidence$15).sameEntries(new NewRedBlackTree.EqualsIterator<A, Y>(b, evidence$15));
    }

    private <A, B, U> void _foreach(NewRedBlackTree.Tree<A, B> tree, Function1<Tuple2<A, B>, U> f) {
        while (true) {
            if (tree == null) {
                throw null;
            }
            if (tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left != null) {
                this._foreach(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, f);
            }
            f.apply(new Tuple2(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_value));
            if (tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right == null) break;
            tree = tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
        }
    }

    public <A, U> void foreachKey(NewRedBlackTree.Tree<A, ?> tree, Function1<A, U> f) {
        if (tree != null) {
            this._foreachKey(tree, f);
        }
    }

    private <A, U> void _foreachKey(NewRedBlackTree.Tree<A, ?> tree, Function1<A, U> f) {
        while (true) {
            if (tree == null) {
                throw null;
            }
            if (tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left != null) {
                this._foreachKey(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, f);
            }
            f.apply(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key);
            if (tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right == null) break;
            tree = tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
        }
    }

    public <A, B, U> void foreachEntry(NewRedBlackTree.Tree<A, B> tree, Function2<A, B, U> f) {
        if (tree != null) {
            this._foreachEntry(tree, f);
        }
    }

    private <A, B, U> void _foreachEntry(NewRedBlackTree.Tree<A, B> tree, Function2<A, B, U> f) {
        while (true) {
            if (tree == null) {
                throw null;
            }
            if (tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left != null) {
                this._foreachEntry(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, f);
            }
            f.apply(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_value);
            if (tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right == null) break;
            tree = tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
        }
    }

    public <A, B> Iterator<Tuple2<A, B>> iterator(NewRedBlackTree.Tree<A, B> tree, Option<A> start, Ordering<A> evidence$16) {
        return new NewRedBlackTree.EntriesIterator<A, B>(tree, start, evidence$16);
    }

    public <A, B> None$ iterator$default$2() {
        return None$.MODULE$;
    }

    public <A> Iterator<A> keysIterator(NewRedBlackTree.Tree<A, ?> tree, Option<A> start, Ordering<A> evidence$17) {
        return new NewRedBlackTree.KeysIterator(tree, start, evidence$17);
    }

    public <A> None$ keysIterator$default$2() {
        return None$.MODULE$;
    }

    public <A, B> Iterator<B> valuesIterator(NewRedBlackTree.Tree<A, B> tree, Option<A> start, Ordering<A> evidence$18) {
        return new NewRedBlackTree.ValuesIterator<A, B>(tree, start, evidence$18);
    }

    public <A, B> None$ valuesIterator$default$2() {
        return None$.MODULE$;
    }

    public <A, B> NewRedBlackTree.Tree<A, B> nth(NewRedBlackTree.Tree<A, B> tree, int n) {
        while (true) {
            if (tree == null) {
                throw null;
            }
            int count = this.count(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left);
            if (n < count) {
                tree = tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
                continue;
            }
            if (n <= count) break;
            n = n - count - 1;
            tree = tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
        }
        return tree;
    }

    public boolean isBlack(NewRedBlackTree.Tree<?, ?> tree) {
        return tree == null || tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0;
    }

    public boolean scala$collection$immutable$NewRedBlackTree$$isRedTree(NewRedBlackTree.Tree<?, ?> tree) {
        return tree != null && tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0;
    }

    public boolean scala$collection$immutable$NewRedBlackTree$$isBlackTree(NewRedBlackTree.Tree<?, ?> tree) {
        return tree != null && tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0;
    }

    private <A, B> NewRedBlackTree.Tree<A, B> blacken(NewRedBlackTree.Tree<A, B> t) {
        if (t == null) {
            return null;
        }
        return t.black();
    }

    private <A, B> NewRedBlackTree.Tree<A, B> maybeBlacken(NewRedBlackTree.Tree<A, B> t) {
        NewRedBlackTree.Tree tree;
        if (this.isBlack(t)) {
            return t;
        }
        if (t == null) {
            throw null;
        }
        NewRedBlackTree.Tree tree2 = t.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
        if (tree2 != null && tree2.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0 || (tree = t.scala$collection$immutable$NewRedBlackTree$Tree$$_right) != null && tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
            return t.black();
        }
        return t;
    }

    private <A, B> NewRedBlackTree.Tree<A, B> mkTree(boolean isBlack, A k, B v, NewRedBlackTree.Tree<A, B> l, NewRedBlackTree.Tree<A, B> r) {
        if (isBlack) {
            return this.BlackTree(k, v, l, r);
        }
        return this.RedTree(k, v, l, r);
    }

    private <A, B1> NewRedBlackTree.Tree<A, B1> balanceLeft(NewRedBlackTree.Tree<A, B1> tree, NewRedBlackTree.Tree<A, B1> newLeft) {
        if (tree == null) {
            throw null;
        }
        if (tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left == newLeft) {
            return tree;
        }
        if (newLeft == null) {
            throw null;
        }
        if (newLeft.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
            NewRedBlackTree.Tree tree2 = newLeft.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
            NewRedBlackTree.Tree<A, ?> tree3 = newLeft.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
            if (tree2 != null && tree2.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
                NewRedBlackTree.Tree resultLeft = tree2.black();
                NewRedBlackTree.Tree<A, ?> resultRight = tree.blackWithLeft(tree3);
                return newLeft.withLeftRight(resultLeft, resultRight);
            }
            if (tree3 != null && tree3.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
                if (tree3 == null) {
                    throw null;
                }
                NewRedBlackTree.Tree tree4 = tree3.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
                NewRedBlackTree.Tree<A, ?> resultLeft = newLeft.blackWithRight(tree3.scala$collection$immutable$NewRedBlackTree$Tree$$_left);
                NewRedBlackTree.Tree<A, ?> resultRight = tree.blackWithLeft(tree4);
                return tree3.withLeftRight(resultLeft, resultRight);
            }
            return tree.withLeft(newLeft);
        }
        return tree.withLeft(newLeft);
    }

    private <A, B1> NewRedBlackTree.Tree<A, B1> balanceRight(NewRedBlackTree.Tree<A, B1> tree, NewRedBlackTree.Tree<A, B1> newRight) {
        if (tree == null) {
            throw null;
        }
        if (tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right == newRight) {
            return tree;
        }
        if (newRight == null) {
            throw null;
        }
        if (newRight.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
            NewRedBlackTree.Tree<A, ?> tree2 = newRight.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
            if (tree2 != null && tree2.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
                if (tree2 == null) {
                    throw null;
                }
                NewRedBlackTree.Tree<A, ?> resultLeft = tree.blackWithRight(tree2.scala$collection$immutable$NewRedBlackTree$Tree$$_left);
                NewRedBlackTree.Tree<A, ?> resultRight = newRight.blackWithLeft(tree2.scala$collection$immutable$NewRedBlackTree$Tree$$_right);
                return tree2.withLeftRight(resultLeft, resultRight);
            }
            NewRedBlackTree.Tree tree3 = newRight.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
            if (tree3 != null && tree3.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
                NewRedBlackTree.Tree<A, ?> resultLeft = tree.blackWithRight(tree2);
                NewRedBlackTree.Tree resultRight = tree3.black();
                return newRight.withLeftRight(resultLeft, resultRight);
            }
            return tree.withRight(newRight);
        }
        return tree.withRight(newRight);
    }

    private <A, B, B1> NewRedBlackTree.Tree<A, B1> upd(NewRedBlackTree.Tree<A, B> tree, A k, B1 v, boolean overwrite, Ordering<A> ordering2) {
        if (tree == null) {
            return this.RedTree(k, v, null, null);
        }
        if (k == tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key) {
            if (overwrite) {
                return tree.withV(v);
            }
            return tree;
        }
        int cmp = ordering2.compare(k, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key);
        if (cmp < 0) {
            return this.balanceLeft(tree, this.upd(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, k, v, overwrite, ordering2));
        }
        if (cmp > 0) {
            return this.balanceRight(tree, this.upd(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right, k, v, overwrite, ordering2));
        }
        if (overwrite || !BoxesRunTime.equals(k, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key)) {
            return tree.withKV(k, v);
        }
        return tree;
    }

    private <A, B, B1> NewRedBlackTree.Tree<A, B1> updNth(NewRedBlackTree.Tree<A, B> tree, int idx, A k, B1 v) {
        if (tree == null) {
            return this.RedTree(k, v, null, null);
        }
        int rank = this.count(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left) + 1;
        if (idx < rank) {
            return this.balanceLeft(tree, this.updNth(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, idx, k, v));
        }
        if (idx > rank) {
            return this.balanceRight(tree, this.updNth(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right, idx - rank, k, v));
        }
        return tree;
    }

    private <A, B> NewRedBlackTree.Tree<A, B> doFrom(NewRedBlackTree.Tree<A, B> tree, A from, Ordering<A> ordering2) {
        if (tree == null) {
            return null;
        }
        if (ordering2.lt(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, from)) {
            return this.doFrom(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right, from, ordering2);
        }
        NewRedBlackTree.Tree newLeft = this.doFrom(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, from, ordering2);
        if (newLeft == tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left) {
            return tree;
        }
        if (newLeft == null) {
            return this.upd(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_value, false, ordering2);
        }
        return this.join(newLeft, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_value, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right);
    }

    private <A, B> NewRedBlackTree.Tree<A, B> doTo(NewRedBlackTree.Tree<A, B> tree, A to, Ordering<A> ordering2) {
        if (tree == null) {
            return null;
        }
        if (ordering2.lt(to, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key)) {
            return this.doTo(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, to, ordering2);
        }
        NewRedBlackTree.Tree newRight = this.doTo(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right, to, ordering2);
        if (newRight == tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right) {
            return tree;
        }
        if (newRight == null) {
            return this.upd(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_value, false, ordering2);
        }
        return this.join(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_value, newRight);
    }

    private <A, B> NewRedBlackTree.Tree<A, B> doUntil(NewRedBlackTree.Tree<A, B> tree, A until, Ordering<A> ordering2) {
        if (tree == null) {
            return null;
        }
        if (ordering2.lteq(until, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key)) {
            return this.doUntil(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, until, ordering2);
        }
        NewRedBlackTree.Tree newRight = this.doUntil(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right, until, ordering2);
        if (newRight == tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right) {
            return tree;
        }
        if (newRight == null) {
            return this.upd(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_value, false, ordering2);
        }
        return this.join(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_value, newRight);
    }

    private <A, B> NewRedBlackTree.Tree<A, B> doRange(NewRedBlackTree.Tree<A, B> tree, A from, A until, Ordering<A> ordering2) {
        if (tree == null) {
            return null;
        }
        if (ordering2.lt(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, from)) {
            return this.doRange(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right, from, until, ordering2);
        }
        if (ordering2.lteq(until, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key)) {
            return this.doRange(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, from, until, ordering2);
        }
        NewRedBlackTree.Tree newLeft = this.doFrom(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, from, ordering2);
        NewRedBlackTree.Tree newRight = this.doUntil(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right, until, ordering2);
        if (newLeft == tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left && newRight == tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right) {
            return tree;
        }
        if (newLeft == null) {
            return this.upd(newRight, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_value, false, ordering2);
        }
        if (newRight == null) {
            return this.upd(newLeft, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_value, false, ordering2);
        }
        return this.join(newLeft, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_value, newRight);
    }

    private <A, B> NewRedBlackTree.Tree<A, B> doDrop(NewRedBlackTree.Tree<A, B> tree, int n) {
        int l;
        while (true) {
            if (tree == null || n <= 0) {
                return tree;
            }
            if (n >= (tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count & Integer.MAX_VALUE)) {
                return null;
            }
            l = this.count(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left);
            if (n <= l) break;
            n = n - l - 1;
            tree = tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
        }
        if (n == l) {
            return this.join(null, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_value, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right);
        }
        return this.join(this.doDrop(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, n), tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_value, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right);
    }

    private <A, B> NewRedBlackTree.Tree<A, B> doTake(NewRedBlackTree.Tree<A, B> tree, int n) {
        int l;
        while (true) {
            if (tree == null || n <= 0) {
                return null;
            }
            if (n >= (tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count & Integer.MAX_VALUE)) {
                return tree;
            }
            l = this.count(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left);
            if (n > l) break;
            tree = tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
        }
        if (n == l + 1) {
            return this.maybeBlacken(this.updNth(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, n, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_value));
        }
        return this.join(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_value, this.doTake(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right, n - l - 1));
    }

    private <A, B> NewRedBlackTree.Tree<A, B> doSlice(NewRedBlackTree.Tree<A, B> tree, int from, int until) {
        int l;
        while (true) {
            if (tree == null || from >= until || from >= (tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count & Integer.MAX_VALUE) || until <= 0) {
                return null;
            }
            if (from <= 0 && until >= (tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count & Integer.MAX_VALUE)) {
                return tree;
            }
            l = this.count(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left);
            if (until <= l) {
                tree = tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
                continue;
            }
            if (from <= l) break;
            until = until - l - 1;
            from = from - l - 1;
            tree = tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
        }
        return this.join(this.doDrop(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, from), tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_value, this.doTake(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right, until - l - 1));
    }

    public final int colourBit() {
        return Integer.MIN_VALUE;
    }

    public final int colourMask() {
        return Integer.MAX_VALUE;
    }

    public final int initialBlackCount() {
        return Integer.MIN_VALUE;
    }

    public final int initialRedCount() {
        return 0;
    }

    public <A, B> NewRedBlackTree.Tree<A, B> mutableRedTree(A key, B value, NewRedBlackTree.Tree<A, B> left, NewRedBlackTree.Tree<A, B> right) {
        return new NewRedBlackTree.Tree(key, value, left, right, 0);
    }

    public <A, B> NewRedBlackTree.Tree<A, B> mutableBlackTree(A key, B value, NewRedBlackTree.Tree<A, B> left, NewRedBlackTree.Tree<A, B> right) {
        return new NewRedBlackTree.Tree(key, value, left, right, Integer.MIN_VALUE);
    }

    public <A, B> NewRedBlackTree.Tree<A, B> RedTree(A key, B value, NewRedBlackTree.Tree<A, B> left, NewRedBlackTree.Tree<A, B> right) {
        int size = (left == null ? 0 : left.scala$collection$immutable$NewRedBlackTree$Tree$$_count & Integer.MAX_VALUE) + (right == null ? 0 : right.scala$collection$immutable$NewRedBlackTree$Tree$$_count & Integer.MAX_VALUE) + 1;
        return new NewRedBlackTree.Tree(key, value, left, right, 0 | size);
    }

    public <A, B> NewRedBlackTree.Tree<A, B> BlackTree(A key, B value, NewRedBlackTree.Tree<A, B> left, NewRedBlackTree.Tree<A, B> right) {
        int size = (left == null ? 0 : left.scala$collection$immutable$NewRedBlackTree$Tree$$_count & Integer.MAX_VALUE) + (right == null ? 0 : right.scala$collection$immutable$NewRedBlackTree$Tree$$_count & Integer.MAX_VALUE) + 1;
        return new NewRedBlackTree.Tree(key, value, left, right, Integer.MIN_VALUE | size);
    }

    private int sizeOf(NewRedBlackTree.Tree<?, ?> tree) {
        if (tree == null) {
            return 0;
        }
        return tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count & Integer.MAX_VALUE;
    }

    public <A> NewRedBlackTree.Tree<A, Null$> fromOrderedKeys(Iterator<A> xs, int size) {
        int maxUsedDepth = 32 - Integer.numberOfLeadingZeros(size);
        return this.f$1(1, size, maxUsedDepth, xs);
    }

    public <A, B> NewRedBlackTree.Tree<A, B> fromOrderedEntries(Iterator<Tuple2<A, B>> xs, int size) {
        int maxUsedDepth = 32 - Integer.numberOfLeadingZeros(size);
        return this.f$2(1, size, xs, maxUsedDepth);
    }

    public <A, B, C> NewRedBlackTree.Tree<A, C> transform(NewRedBlackTree.Tree<A, B> t, Function2<A, B, C> f) {
        if (t == null) {
            return null;
        }
        Object a = t.scala$collection$immutable$NewRedBlackTree$Tree$$_key;
        Object object = t.scala$collection$immutable$NewRedBlackTree$Tree$$_value;
        NewRedBlackTree.Tree tree = t.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
        NewRedBlackTree.Tree tree2 = t.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
        NewRedBlackTree.Tree l2 = this.transform(tree, f);
        C v2 = f.apply(a, object);
        NewRedBlackTree.Tree r2 = this.transform(tree2, f);
        if (v2 == object && l2 == tree && r2 == tree2) {
            return t;
        }
        return this.mkTree(t.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0, a, v2, l2, r2);
    }

    public <A, B> NewRedBlackTree.Tree<A, B> filterEntries(NewRedBlackTree.Tree<A, B> t, Function2<A, B, Object> f) {
        if (t == null) {
            return null;
        }
        return this.blacken(this.fk$1(t, f));
    }

    public <A, B> NewRedBlackTree.Tree<A, B> filterKeys(NewRedBlackTree.Tree<A, B> t, Function1<A, Object> f, boolean isFlipped) {
        if (t == null) {
            return null;
        }
        return this.blacken(this.fk$2(t, isFlipped, f));
    }

    public <A, B> Tuple2<NewRedBlackTree.Tree<A, B>, NewRedBlackTree.Tree<A, B>> partitionEntries(NewRedBlackTree.Tree<A, B> t, Function2<A, B, Object> p) {
        if (t == null) {
            return new Tuple2<Object, Object>(null, null);
        }
        ObjectRef<Object> tmpk = ObjectRef.create(null);
        ObjectRef<Object> tmpd = ObjectRef.create(null);
        this.fk$3(t, tmpk, tmpd, p);
        return new Tuple2<NewRedBlackTree.Tree<A, B>, NewRedBlackTree.Tree<A, B>>(this.blacken((NewRedBlackTree.Tree)tmpk.elem), this.blacken((NewRedBlackTree.Tree)tmpd.elem));
    }

    public <A, B> Tuple2<NewRedBlackTree.Tree<A, B>, NewRedBlackTree.Tree<A, B>> partitionKeys(NewRedBlackTree.Tree<A, B> t, Function1<A, Object> p) {
        if (t == null) {
            return new Tuple2<Object, Object>(null, null);
        }
        ObjectRef<Object> tmpk = ObjectRef.create(null);
        ObjectRef<Object> tmpd = ObjectRef.create(null);
        this.fk$4(t, tmpk, tmpd, p);
        return new Tuple2<NewRedBlackTree.Tree<A, B>, NewRedBlackTree.Tree<A, B>>(this.blacken((NewRedBlackTree.Tree)tmpk.elem), this.blacken((NewRedBlackTree.Tree)tmpd.elem));
    }

    private <A, B> NewRedBlackTree.Tree<A, B> del(NewRedBlackTree.Tree<A, B> tree, A k, Ordering<A> ordering2) {
        if (tree == null) {
            return null;
        }
        int cmp = ordering2.compare(k, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key);
        if (cmp < 0) {
            return this.delLeft$1(tree, k, ordering2);
        }
        if (cmp > 0) {
            return this.delRight$1(tree, k, ordering2);
        }
        return this.append(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right);
    }

    private <A, B> NewRedBlackTree.Tree<A, B> balance(A x, B xv, NewRedBlackTree.Tree<A, B> tl, NewRedBlackTree.Tree<A, B> tr) {
        if (tl != null && tl.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
            if (tr != null && tr.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
                return this.RedTree(x, xv, tl.black(), tr.black());
            }
            if (tl == null) {
                throw null;
            }
            NewRedBlackTree.Tree tree = tl.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
            if (tree != null && tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
                return this.RedTree(tl.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tl.scala$collection$immutable$NewRedBlackTree$Tree$$_value, tl.scala$collection$immutable$NewRedBlackTree$Tree$$_left.black(), this.BlackTree(x, xv, tl.scala$collection$immutable$NewRedBlackTree$Tree$$_right, tr));
            }
            NewRedBlackTree.Tree tree2 = tl.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
            if (tree2 != null && tree2.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
                NewRedBlackTree.Tree tree3 = tl.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
                if (tree3 == null) {
                    throw null;
                }
                NewRedBlackTree.Tree tree4 = tl.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
                if (tree4 == null) {
                    throw null;
                }
                NewRedBlackTree.Tree tree5 = tl.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
                if (tree5 == null) {
                    throw null;
                }
                NewRedBlackTree.Tree tree6 = tl.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
                if (tree6 == null) {
                    throw null;
                }
                return this.RedTree(tree3.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree4.scala$collection$immutable$NewRedBlackTree$Tree$$_value, this.BlackTree(tl.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tl.scala$collection$immutable$NewRedBlackTree$Tree$$_value, tl.scala$collection$immutable$NewRedBlackTree$Tree$$_left, tree5.scala$collection$immutable$NewRedBlackTree$Tree$$_left), this.BlackTree(x, xv, tree6.scala$collection$immutable$NewRedBlackTree$Tree$$_right, tr));
            }
            return this.BlackTree(x, xv, tl, tr);
        }
        if (tr != null && tr.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
            if (tr == null) {
                throw null;
            }
            NewRedBlackTree.Tree tree = tr.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
            if (tree != null && tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
                return this.RedTree(tr.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tr.scala$collection$immutable$NewRedBlackTree$Tree$$_value, this.BlackTree(x, xv, tl, tr.scala$collection$immutable$NewRedBlackTree$Tree$$_left), tr.scala$collection$immutable$NewRedBlackTree$Tree$$_right.black());
            }
            NewRedBlackTree.Tree tree7 = tr.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
            if (tree7 != null && tree7.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
                NewRedBlackTree.Tree tree8 = tr.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
                if (tree8 == null) {
                    throw null;
                }
                NewRedBlackTree.Tree tree9 = tr.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
                if (tree9 == null) {
                    throw null;
                }
                NewRedBlackTree.Tree tree10 = tr.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
                if (tree10 == null) {
                    throw null;
                }
                NewRedBlackTree.Tree tree11 = tr.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
                if (tree11 == null) {
                    throw null;
                }
                return this.RedTree(tree8.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree9.scala$collection$immutable$NewRedBlackTree$Tree$$_value, this.BlackTree(x, xv, tl, tree10.scala$collection$immutable$NewRedBlackTree$Tree$$_left), this.BlackTree(tr.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tr.scala$collection$immutable$NewRedBlackTree$Tree$$_value, tree11.scala$collection$immutable$NewRedBlackTree$Tree$$_right, tr.scala$collection$immutable$NewRedBlackTree$Tree$$_right));
            }
            return this.BlackTree(x, xv, tl, tr);
        }
        return this.BlackTree(x, xv, tl, tr);
    }

    private <A, B> NewRedBlackTree.Tree<A, B> balLeft(A x, B xv, NewRedBlackTree.Tree<A, B> tl, NewRedBlackTree.Tree<A, B> tr) {
        if (tl != null && tl.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
            return this.RedTree(x, xv, tl.black(), tr);
        }
        if (tr != null && tr.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0) {
            return this.balance(x, xv, tl, tr.red());
        }
        if (tr != null && tr.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
            if (tr == null) {
                throw null;
            }
            NewRedBlackTree.Tree tree = tr.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
            if (tree != null && tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0) {
                NewRedBlackTree.Tree tree2 = tr.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
                if (tree2 == null) {
                    throw null;
                }
                NewRedBlackTree.Tree tree3 = tr.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
                if (tree3 == null) {
                    throw null;
                }
                NewRedBlackTree.Tree tree4 = tr.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
                if (tree4 == null) {
                    throw null;
                }
                NewRedBlackTree.Tree tree5 = tr.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
                if (tree5 == null) {
                    throw null;
                }
                return this.RedTree(tree2.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree3.scala$collection$immutable$NewRedBlackTree$Tree$$_value, this.BlackTree(x, xv, tl, tree4.scala$collection$immutable$NewRedBlackTree$Tree$$_left), this.balance(tr.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tr.scala$collection$immutable$NewRedBlackTree$Tree$$_value, tree5.scala$collection$immutable$NewRedBlackTree$Tree$$_right, tr.scala$collection$immutable$NewRedBlackTree$Tree$$_right.red()));
            }
        }
        throw package$.MODULE$.error("Defect: invariance violation");
    }

    private <A, B> NewRedBlackTree.Tree<A, B> balRight(A x, B xv, NewRedBlackTree.Tree<A, B> tl, NewRedBlackTree.Tree<A, B> tr) {
        if (tr != null && tr.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
            return this.RedTree(x, xv, tl, tr.black());
        }
        if (tl != null && tl.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0) {
            return this.balance(x, xv, tl.red(), tr);
        }
        if (tl != null && tl.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
            if (tl == null) {
                throw null;
            }
            NewRedBlackTree.Tree tree = tl.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
            if (tree != null && tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0) {
                NewRedBlackTree.Tree tree2 = tl.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
                if (tree2 == null) {
                    throw null;
                }
                NewRedBlackTree.Tree tree3 = tl.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
                if (tree3 == null) {
                    throw null;
                }
                NewRedBlackTree.Tree tree4 = tl.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
                if (tree4 == null) {
                    throw null;
                }
                NewRedBlackTree.Tree tree5 = tl.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
                if (tree5 == null) {
                    throw null;
                }
                return this.RedTree(tree2.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree3.scala$collection$immutable$NewRedBlackTree$Tree$$_value, this.balance(tl.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tl.scala$collection$immutable$NewRedBlackTree$Tree$$_value, tl.scala$collection$immutable$NewRedBlackTree$Tree$$_left.red(), tree4.scala$collection$immutable$NewRedBlackTree$Tree$$_left), this.BlackTree(x, xv, tree5.scala$collection$immutable$NewRedBlackTree$Tree$$_right, tr));
            }
        }
        throw package$.MODULE$.error("Defect: invariance violation");
    }

    private <A, B> NewRedBlackTree.Tree<A, B> append(NewRedBlackTree.Tree<A, B> tl, NewRedBlackTree.Tree<A, B> tr) {
        if (tl == null) {
            return tr;
        }
        if (tr == null) {
            return tl;
        }
        if (tl.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0 && tr.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
            NewRedBlackTree.Tree bc = this.append(tl.scala$collection$immutable$NewRedBlackTree$Tree$$_right, tr.scala$collection$immutable$NewRedBlackTree$Tree$$_left);
            if (bc != null && bc.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
                if (bc == null) {
                    throw null;
                }
                return this.RedTree(bc.scala$collection$immutable$NewRedBlackTree$Tree$$_key, bc.scala$collection$immutable$NewRedBlackTree$Tree$$_value, this.RedTree(tl.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tl.scala$collection$immutable$NewRedBlackTree$Tree$$_value, tl.scala$collection$immutable$NewRedBlackTree$Tree$$_left, bc.scala$collection$immutable$NewRedBlackTree$Tree$$_left), this.RedTree(tr.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tr.scala$collection$immutable$NewRedBlackTree$Tree$$_value, bc.scala$collection$immutable$NewRedBlackTree$Tree$$_right, tr.scala$collection$immutable$NewRedBlackTree$Tree$$_right));
            }
            return this.RedTree(tl.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tl.scala$collection$immutable$NewRedBlackTree$Tree$$_value, tl.scala$collection$immutable$NewRedBlackTree$Tree$$_left, this.RedTree(tr.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tr.scala$collection$immutable$NewRedBlackTree$Tree$$_value, bc, tr.scala$collection$immutable$NewRedBlackTree$Tree$$_right));
        }
        if (tl != null && tl.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0 && tr != null && tr.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0) {
            NewRedBlackTree.Tree bc = this.append(tl.scala$collection$immutable$NewRedBlackTree$Tree$$_right, tr.scala$collection$immutable$NewRedBlackTree$Tree$$_left);
            if (bc != null && bc.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
                if (bc == null) {
                    throw null;
                }
                return this.RedTree(bc.scala$collection$immutable$NewRedBlackTree$Tree$$_key, bc.scala$collection$immutable$NewRedBlackTree$Tree$$_value, this.BlackTree(tl.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tl.scala$collection$immutable$NewRedBlackTree$Tree$$_value, tl.scala$collection$immutable$NewRedBlackTree$Tree$$_left, bc.scala$collection$immutable$NewRedBlackTree$Tree$$_left), this.BlackTree(tr.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tr.scala$collection$immutable$NewRedBlackTree$Tree$$_value, bc.scala$collection$immutable$NewRedBlackTree$Tree$$_right, tr.scala$collection$immutable$NewRedBlackTree$Tree$$_right));
            }
            return this.balLeft(tl.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tl.scala$collection$immutable$NewRedBlackTree$Tree$$_value, tl.scala$collection$immutable$NewRedBlackTree$Tree$$_left, this.BlackTree(tr.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tr.scala$collection$immutable$NewRedBlackTree$Tree$$_value, bc, tr.scala$collection$immutable$NewRedBlackTree$Tree$$_right));
        }
        if (tr != null && tr.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
            return this.RedTree(tr.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tr.scala$collection$immutable$NewRedBlackTree$Tree$$_value, this.append(tl, tr.scala$collection$immutable$NewRedBlackTree$Tree$$_left), tr.scala$collection$immutable$NewRedBlackTree$Tree$$_right);
        }
        if (tl != null && tl.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
            return this.RedTree(tl.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tl.scala$collection$immutable$NewRedBlackTree$Tree$$_value, tl.scala$collection$immutable$NewRedBlackTree$Tree$$_left, this.append(tl.scala$collection$immutable$NewRedBlackTree$Tree$$_right, tr));
        }
        throw package$.MODULE$.error(new StringBuilder(28).append("unmatched tree on append: ").append(tl).append(", ").append(tr).toString());
    }

    public <A, B> NewRedBlackTree.Tree<A, B> union(NewRedBlackTree.Tree<A, B> t1, NewRedBlackTree.Tree<A, B> t2, Ordering<A> ordering2) {
        return this.blacken(this._union(t1, t2, ordering2));
    }

    public <A, B> NewRedBlackTree.Tree<A, B> intersect(NewRedBlackTree.Tree<A, B> t1, NewRedBlackTree.Tree<A, B> t2, Ordering<A> ordering2) {
        return this.blacken(this._intersect(t1, t2, ordering2));
    }

    public <A, B> NewRedBlackTree.Tree<A, B> difference(NewRedBlackTree.Tree<A, B> t1, NewRedBlackTree.Tree<A, ?> t2, Ordering<A> ordering2) {
        return this.blacken(this._difference(t1, t2, ordering2));
    }

    private int rank(NewRedBlackTree.Tree<?, ?> t, int bh) {
        if (t == null) {
            return 0;
        }
        if (t.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0) {
            return 2 * (bh - 1);
        }
        return 2 * bh - 1;
    }

    private <A, B> NewRedBlackTree.Tree<A, B> joinRight(NewRedBlackTree.Tree<A, B> tl, A k, B v, NewRedBlackTree.Tree<A, B> tr, int bhtl, int rtr) {
        int bhtlr;
        if ((tl == null ? 0 : (tl.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0 ? 2 * (bhtl - 1) : 2 * bhtl - 1)) == rtr / 2 * 2) {
            return this.RedTree(k, v, tl, tr);
        }
        boolean bl = tl != null && tl.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0;
        int n = bhtlr = bl ? bhtl - 1 : bhtl;
        if (tl == null) {
            throw null;
        }
        NewRedBlackTree.Tree ttr = this.joinRight(tl.scala$collection$immutable$NewRedBlackTree$Tree$$_right, k, v, tr, bhtlr, rtr);
        if (bl && ttr != null && ttr.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
            if (ttr == null) {
                throw null;
            }
            NewRedBlackTree.Tree tree = ttr.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
            if (tree != null && tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
                return this.RedTree(ttr.scala$collection$immutable$NewRedBlackTree$Tree$$_key, ttr.scala$collection$immutable$NewRedBlackTree$Tree$$_value, this.BlackTree(tl.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tl.scala$collection$immutable$NewRedBlackTree$Tree$$_value, tl.scala$collection$immutable$NewRedBlackTree$Tree$$_left, ttr.scala$collection$immutable$NewRedBlackTree$Tree$$_left), ttr.scala$collection$immutable$NewRedBlackTree$Tree$$_right.black());
            }
        }
        return this.mkTree(bl, tl.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tl.scala$collection$immutable$NewRedBlackTree$Tree$$_value, tl.scala$collection$immutable$NewRedBlackTree$Tree$$_left, ttr);
    }

    private <A, B> NewRedBlackTree.Tree<A, B> joinLeft(NewRedBlackTree.Tree<A, B> tl, A k, B v, NewRedBlackTree.Tree<A, B> tr, int rtl, int bhtr) {
        int bhtrl;
        if ((tr == null ? 0 : (tr.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0 ? 2 * (bhtr - 1) : 2 * bhtr - 1)) == rtl / 2 * 2) {
            return this.RedTree(k, v, tl, tr);
        }
        boolean bl = tr != null && tr.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0;
        int n = bhtrl = bl ? bhtr - 1 : bhtr;
        if (tr == null) {
            throw null;
        }
        NewRedBlackTree.Tree<A, B> ttl = this.joinLeft(tl, k, v, tr.scala$collection$immutable$NewRedBlackTree$Tree$$_left, rtl, bhtrl);
        if (bl && ttl != null && ttl.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
            if (ttl == null) {
                throw null;
            }
            NewRedBlackTree.Tree tree = ttl.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
            if (tree != null && tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
                return this.RedTree(ttl.scala$collection$immutable$NewRedBlackTree$Tree$$_key, ttl.scala$collection$immutable$NewRedBlackTree$Tree$$_value, ttl.scala$collection$immutable$NewRedBlackTree$Tree$$_left.black(), this.BlackTree(tr.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tr.scala$collection$immutable$NewRedBlackTree$Tree$$_value, ttl.scala$collection$immutable$NewRedBlackTree$Tree$$_right, tr.scala$collection$immutable$NewRedBlackTree$Tree$$_right));
            }
        }
        return this.mkTree(bl, tr.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tr.scala$collection$immutable$NewRedBlackTree$Tree$$_value, ttl, tr.scala$collection$immutable$NewRedBlackTree$Tree$$_right);
    }

    private <A, B> NewRedBlackTree.Tree<A, B> join(NewRedBlackTree.Tree<A, B> tl, A k, B v, NewRedBlackTree.Tree<A, B> tr) {
        int bhtr;
        int bhtl = this.h$1(tl, 0);
        if (bhtl > (bhtr = this.h$1(tr, 0))) {
            NewRedBlackTree.Tree<A, B> tt = this.joinRight(tl, k, v, tr, bhtl, tr == null ? 0 : (tr.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0 ? 2 * (bhtr - 1) : 2 * bhtr - 1));
            if (tt != null && tt.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
                if (tt == null) {
                    throw null;
                }
                NewRedBlackTree.Tree tree = tt.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
                if (tree != null && tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
                    return tt.black();
                }
            }
            return tt;
        }
        if (bhtr > bhtl) {
            NewRedBlackTree.Tree<A, B> tt = this.joinLeft(tl, k, v, tr, tl == null ? 0 : (tl.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0 ? 2 * (bhtl - 1) : 2 * bhtl - 1), bhtr);
            if (tt != null && tt.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
                if (tt == null) {
                    throw null;
                }
                NewRedBlackTree.Tree tree = tt.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
                if (tree != null && tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0) {
                    return tt.black();
                }
            }
            return tt;
        }
        return this.mkTree(tl != null && tl.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0 || tr != null && tr.scala$collection$immutable$NewRedBlackTree$Tree$$_count >= 0, k, v, tl, tr);
    }

    /*
     * WARNING - void declaration
     */
    private <A, B> Tuple4<NewRedBlackTree.Tree<A, B>, NewRedBlackTree.Tree<A, B>, NewRedBlackTree.Tree<A, B>, A> split(NewRedBlackTree.Tree<A, B> t, A k2, Ordering<A> ordering2) {
        void var17_17;
        void var16_16;
        void var15_15;
        void var14_14;
        if (t == null) {
            return new Tuple4<Object, Object, Object, A>(null, null, null, k2);
        }
        int cmp = ordering2.compare(k2, t.scala$collection$immutable$NewRedBlackTree$Tree$$_key);
        if (cmp == 0) {
            return new Tuple4(t.scala$collection$immutable$NewRedBlackTree$Tree$$_left, t, t.scala$collection$immutable$NewRedBlackTree$Tree$$_right, t.scala$collection$immutable$NewRedBlackTree$Tree$$_key);
        }
        if (cmp < 0) {
            void var9_9;
            void var8_8;
            void var7_7;
            void var6_6;
            Tuple4 tuple4 = this.split(t.scala$collection$immutable$NewRedBlackTree$Tree$$_left, k2, ordering2);
            if (tuple4 == null) {
                throw new MatchError((Object)null);
            }
            NewRedBlackTree.Tree ll = tuple4._1();
            NewRedBlackTree.Tree b = tuple4._2();
            NewRedBlackTree.Tree lr = tuple4._3();
            Object k1 = tuple4._4();
            void ll2 = var6_6;
            void b2 = var7_7;
            void lr2 = var8_8;
            return new Tuple4(ll2, b2, this.join((NewRedBlackTree.Tree<A, B>)lr2, t.scala$collection$immutable$NewRedBlackTree$Tree$$_key, (B)t.scala$collection$immutable$NewRedBlackTree$Tree$$_value, t.scala$collection$immutable$NewRedBlackTree$Tree$$_right), var9_9);
        }
        Tuple4 tuple4 = this.split(t.scala$collection$immutable$NewRedBlackTree$Tree$$_right, k2, ordering2);
        if (tuple4 == null) {
            throw new MatchError((Object)null);
        }
        NewRedBlackTree.Tree rl = tuple4._1();
        NewRedBlackTree.Tree b = tuple4._2();
        NewRedBlackTree.Tree rr = tuple4._3();
        Object k1 = tuple4._4();
        void rl2 = var14_14;
        void b3 = var15_15;
        void rr2 = var16_16;
        return new Tuple4(this.join(t.scala$collection$immutable$NewRedBlackTree$Tree$$_left, t.scala$collection$immutable$NewRedBlackTree$Tree$$_key, (B)t.scala$collection$immutable$NewRedBlackTree$Tree$$_value, (NewRedBlackTree.Tree<A, B>)rl2), b3, rr2, var17_17);
    }

    /*
     * WARNING - void declaration
     */
    private <A, B> Tuple3<NewRedBlackTree.Tree<A, B>, A, B> splitLast(NewRedBlackTree.Tree<A, B> t) {
        void var5_5;
        void var4_4;
        void var3_3;
        if (t == null) {
            throw null;
        }
        if (t.scala$collection$immutable$NewRedBlackTree$Tree$$_right == null) {
            return new Tuple3(t.scala$collection$immutable$NewRedBlackTree$Tree$$_left, t.scala$collection$immutable$NewRedBlackTree$Tree$$_key, t.scala$collection$immutable$NewRedBlackTree$Tree$$_value);
        }
        Tuple3 tuple3 = this.splitLast(t.scala$collection$immutable$NewRedBlackTree$Tree$$_right);
        if (tuple3 == null) {
            throw new MatchError((Object)null);
        }
        NewRedBlackTree.Tree tt = tuple3._1();
        Object kk = tuple3._2();
        Object vv = tuple3._3();
        void tt2 = var3_3;
        return new Tuple3(this.join(t.scala$collection$immutable$NewRedBlackTree$Tree$$_left, t.scala$collection$immutable$NewRedBlackTree$Tree$$_key, (B)t.scala$collection$immutable$NewRedBlackTree$Tree$$_value, (NewRedBlackTree.Tree<A, B>)tt2), var4_4, var5_5);
    }

    /*
     * WARNING - void declaration
     */
    private <A, B> NewRedBlackTree.Tree<A, B> join2(NewRedBlackTree.Tree<A, B> tl, NewRedBlackTree.Tree<A, B> tr) {
        void var6_6;
        void var5_5;
        void var4_4;
        if (tl == null) {
            return tr;
        }
        if (tr == null) {
            return tl;
        }
        Tuple3<NewRedBlackTree.Tree<A, B>, A, B> tuple3 = this.splitLast(tl);
        if (tuple3 == null) {
            throw new MatchError((Object)null);
        }
        NewRedBlackTree.Tree<A, B> ttl = tuple3._1();
        A k = tuple3._2();
        B v = tuple3._3();
        void ttl2 = var4_4;
        return this.join((NewRedBlackTree.Tree<A, B>)ttl2, var5_5, var6_6, tr);
    }

    /*
     * WARNING - void declaration
     */
    private <A, B> NewRedBlackTree.Tree<A, B> _union(NewRedBlackTree.Tree<A, B> t1, NewRedBlackTree.Tree<A, B> t2, Ordering<A> ordering2) {
        void var7_7;
        void var6_6;
        void var5_5;
        if (t1 == null || t1 == t2) {
            return t2;
        }
        if (t2 == null) {
            return t1;
        }
        Tuple4<NewRedBlackTree.Tree<A, B>, NewRedBlackTree.Tree<A, B>, NewRedBlackTree.Tree<A, B>, A> tuple4 = this.split(t1, t2.scala$collection$immutable$NewRedBlackTree$Tree$$_key, ordering2);
        if (tuple4 == null) {
            throw new MatchError((Object)null);
        }
        NewRedBlackTree.Tree<A, B> l1 = tuple4._1();
        NewRedBlackTree.Tree<A, B> r1 = tuple4._3();
        A k1 = tuple4._4();
        void l12 = var5_5;
        void r12 = var6_6;
        NewRedBlackTree.Tree tl = this._union((NewRedBlackTree.Tree<A, B>)l12, t2.scala$collection$immutable$NewRedBlackTree$Tree$$_left, ordering2);
        NewRedBlackTree.Tree tr = this._union((NewRedBlackTree.Tree<A, B>)r12, t2.scala$collection$immutable$NewRedBlackTree$Tree$$_right, ordering2);
        return this.join(tl, var7_7, t2.scala$collection$immutable$NewRedBlackTree$Tree$$_value, tr);
    }

    /*
     * WARNING - void declaration
     */
    private <A, B> NewRedBlackTree.Tree<A, B> _intersect(NewRedBlackTree.Tree<A, B> t1, NewRedBlackTree.Tree<A, B> t2, Ordering<A> ordering2) {
        void var7_7;
        void var6_6;
        void var5_5;
        if (t1 == null || t2 == null) {
            return null;
        }
        if (t1 == t2) {
            return t1;
        }
        Tuple4<NewRedBlackTree.Tree<A, B>, NewRedBlackTree.Tree<A, B>, NewRedBlackTree.Tree<A, B>, A> tuple4 = this.split(t1, t2.scala$collection$immutable$NewRedBlackTree$Tree$$_key, ordering2);
        if (tuple4 == null) {
            throw new MatchError((Object)null);
        }
        NewRedBlackTree.Tree<A, B> l1 = tuple4._1();
        NewRedBlackTree.Tree<A, B> b = tuple4._2();
        NewRedBlackTree.Tree<A, B> r1 = tuple4._3();
        A k1 = tuple4._4();
        void l12 = var5_5;
        void b2 = var6_6;
        void r12 = var7_7;
        NewRedBlackTree.Tree tl = this._intersect((NewRedBlackTree.Tree<A, B>)l12, t2.scala$collection$immutable$NewRedBlackTree$Tree$$_left, ordering2);
        NewRedBlackTree.Tree tr = this._intersect((NewRedBlackTree.Tree<A, B>)r12, t2.scala$collection$immutable$NewRedBlackTree$Tree$$_right, ordering2);
        if (b2 != null) {
            void var8_8;
            return this.join(tl, var8_8, t2.scala$collection$immutable$NewRedBlackTree$Tree$$_value, tr);
        }
        return this.join2(tl, tr);
    }

    /*
     * WARNING - void declaration
     */
    private <A, B> NewRedBlackTree.Tree<A, B> _difference(NewRedBlackTree.Tree<A, B> t1, NewRedBlackTree.Tree<A, B> t2, Ordering<A> ordering2) {
        void var6_6;
        void var5_5;
        if (t1 == null || t2 == null) {
            return t1;
        }
        if (t1 == t2) {
            return null;
        }
        Tuple4<NewRedBlackTree.Tree<A, B>, NewRedBlackTree.Tree<A, B>, NewRedBlackTree.Tree<A, B>, A> tuple4 = this.split(t1, t2.scala$collection$immutable$NewRedBlackTree$Tree$$_key, ordering2);
        if (tuple4 == null) {
            throw new MatchError((Object)null);
        }
        NewRedBlackTree.Tree<A, B> l1 = tuple4._1();
        NewRedBlackTree.Tree<A, B> r1 = tuple4._3();
        tuple4._4();
        void l12 = var5_5;
        void r12 = var6_6;
        NewRedBlackTree.Tree tl = this._difference((NewRedBlackTree.Tree<A, B>)l12, t2.scala$collection$immutable$NewRedBlackTree$Tree$$_left, ordering2);
        NewRedBlackTree.Tree tr = this._difference((NewRedBlackTree.Tree<A, B>)r12, t2.scala$collection$immutable$NewRedBlackTree$Tree$$_right, ordering2);
        return this.join2(tl, tr);
    }

    private final NewRedBlackTree.Tree _tail$1(NewRedBlackTree.Tree tree) {
        if (tree == null) {
            throw new NoSuchElementException("empty tree");
        }
        if (tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left == null) {
            return tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
        }
        NewRedBlackTree.Tree tree2 = tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
        if (tree2 != null && tree2.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0) {
            return this.balLeft(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_value, this._tail$1(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left), tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right);
        }
        return this.RedTree(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_value, this._tail$1(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left), tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right);
    }

    private final NewRedBlackTree.Tree _init$1(NewRedBlackTree.Tree tree) {
        if (tree == null) {
            throw new NoSuchElementException("empty tree");
        }
        if (tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right == null) {
            return tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
        }
        NewRedBlackTree.Tree tree2 = tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
        if (tree2 != null && tree2.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0) {
            return this.balRight(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_value, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, this._init$1(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right));
        }
        return this.RedTree(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_value, tree.scala$collection$immutable$NewRedBlackTree$Tree$$_left, this._init$1(tree.scala$collection$immutable$NewRedBlackTree$Tree$$_right));
    }

    private final NewRedBlackTree.Tree f$1(int level, int size, int maxUsedDepth$1, Iterator xs$1) {
        switch (size) {
            case 0: {
                return null;
            }
            case 1: {
                return this.mkTree(level != maxUsedDepth$1 || level == 1, xs$1.next(), null, null, null);
            }
        }
        int leftSize = (size - 1) / 2;
        NewRedBlackTree.Tree left = this.f$1(level + 1, leftSize, maxUsedDepth$1, xs$1);
        Object x = xs$1.next();
        NewRedBlackTree.Tree right = this.f$1(level + 1, size - 1 - leftSize, maxUsedDepth$1, xs$1);
        return this.BlackTree(x, null, left, right);
    }

    /*
     * WARNING - void declaration
     */
    private final NewRedBlackTree.Tree f$2(int level, int size, Iterator xs$2, int maxUsedDepth$2) {
        void var12_12;
        void var11_11;
        switch (size) {
            case 0: {
                return null;
            }
            case 1: {
                void var7_7;
                void var6_6;
                Tuple2 tuple2 = (Tuple2)xs$2.next();
                if (tuple2 == null) {
                    throw new MatchError((Object)null);
                }
                Object k = tuple2._1();
                Object v = tuple2._2();
                return this.mkTree(level != maxUsedDepth$2 || level == 1, var6_6, var7_7, null, null);
            }
        }
        int leftSize = (size - 1) / 2;
        NewRedBlackTree.Tree left = this.f$2(level + 1, leftSize, xs$2, maxUsedDepth$2);
        Tuple2 tuple2 = (Tuple2)xs$2.next();
        if (tuple2 == null) {
            throw new MatchError((Object)null);
        }
        Object k = tuple2._1();
        Object v = tuple2._2();
        NewRedBlackTree.Tree right = this.f$2(level + 1, size - 1 - leftSize, xs$2, maxUsedDepth$2);
        return this.BlackTree(var11_11, var12_12, left, right);
    }

    private final NewRedBlackTree.Tree fk$1(NewRedBlackTree.Tree t, Function2 f$3) {
        NewRedBlackTree.Tree r2;
        if (t == null) {
            throw null;
        }
        Object a = t.scala$collection$immutable$NewRedBlackTree$Tree$$_key;
        Object object = t.scala$collection$immutable$NewRedBlackTree$Tree$$_value;
        NewRedBlackTree.Tree tree = t.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
        NewRedBlackTree.Tree tree2 = t.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
        NewRedBlackTree.Tree l2 = tree == null ? null : this.fk$1(tree, f$3);
        boolean keep = BoxesRunTime.unboxToBoolean(f$3.apply(a, object));
        NewRedBlackTree.Tree tree3 = r2 = tree2 == null ? null : this.fk$1(tree2, f$3);
        if (!keep) {
            return this.join2(l2, r2);
        }
        if (l2 == tree && r2 == tree2) {
            return t;
        }
        return this.join(l2, a, object, r2);
    }

    private final NewRedBlackTree.Tree fk$2(NewRedBlackTree.Tree t, boolean isFlipped$1, Function1 f$4) {
        NewRedBlackTree.Tree r2;
        if (t == null) {
            throw null;
        }
        Object a = t.scala$collection$immutable$NewRedBlackTree$Tree$$_key;
        NewRedBlackTree.Tree tree = t.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
        NewRedBlackTree.Tree tree2 = t.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
        NewRedBlackTree.Tree l2 = tree == null ? null : this.fk$2(tree, isFlipped$1, f$4);
        boolean keep = isFlipped$1 ^ BoxesRunTime.unboxToBoolean(f$4.apply(a));
        NewRedBlackTree.Tree tree3 = r2 = tree2 == null ? null : this.fk$2(tree2, isFlipped$1, f$4);
        if (!keep) {
            return this.join2(l2, r2);
        }
        if (l2 == tree && r2 == tree2) {
            return t;
        }
        return this.join(l2, a, t.scala$collection$immutable$NewRedBlackTree$Tree$$_value, r2);
    }

    private final void fk$3(NewRedBlackTree.Tree t, ObjectRef tmpk$1, ObjectRef tmpd$1, Function2 p$1) {
        NewRedBlackTree.Tree jk;
        if (t == null) {
            throw null;
        }
        Object a = t.scala$collection$immutable$NewRedBlackTree$Tree$$_key;
        Object object = t.scala$collection$immutable$NewRedBlackTree$Tree$$_value;
        NewRedBlackTree.Tree tree = t.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
        NewRedBlackTree.Tree tree2 = t.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
        NewRedBlackTree.Tree l2k = null;
        NewRedBlackTree.Tree l2d = null;
        NewRedBlackTree.Tree r2k = null;
        NewRedBlackTree.Tree r2d = null;
        if (tree != null) {
            this.fk$3(tree, tmpk$1, tmpd$1, p$1);
            l2k = (NewRedBlackTree.Tree)tmpk$1.elem;
            l2d = (NewRedBlackTree.Tree)tmpd$1.elem;
        }
        boolean keep = BoxesRunTime.unboxToBoolean(p$1.apply(a, object));
        if (tree2 != null) {
            this.fk$3(tree2, tmpk$1, tmpd$1, p$1);
            r2k = (NewRedBlackTree.Tree)tmpk$1.elem;
            r2d = (NewRedBlackTree.Tree)tmpd$1.elem;
        }
        NewRedBlackTree.Tree tree3 = !keep ? this.join2(l2k, r2k) : (jk = l2k == tree && r2k == tree2 ? t : this.join(l2k, a, object, r2k));
        NewRedBlackTree.Tree jd = keep ? this.join2(l2d, r2d) : (l2d == tree && r2d == tree2 ? t : this.join(l2d, a, object, r2d));
        tmpk$1.elem = jk;
        tmpd$1.elem = jd;
    }

    private final void fk$4(NewRedBlackTree.Tree t, ObjectRef tmpk$2, ObjectRef tmpd$2, Function1 p$2) {
        NewRedBlackTree.Tree jk;
        if (t == null) {
            throw null;
        }
        Object a = t.scala$collection$immutable$NewRedBlackTree$Tree$$_key;
        Object object = t.scala$collection$immutable$NewRedBlackTree$Tree$$_value;
        NewRedBlackTree.Tree tree = t.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
        NewRedBlackTree.Tree tree2 = t.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
        NewRedBlackTree.Tree l2k = null;
        NewRedBlackTree.Tree l2d = null;
        NewRedBlackTree.Tree r2k = null;
        NewRedBlackTree.Tree r2d = null;
        if (tree != null) {
            this.fk$4(tree, tmpk$2, tmpd$2, p$2);
            l2k = (NewRedBlackTree.Tree)tmpk$2.elem;
            l2d = (NewRedBlackTree.Tree)tmpd$2.elem;
        }
        boolean keep = BoxesRunTime.unboxToBoolean(p$2.apply(a));
        if (tree2 != null) {
            this.fk$4(tree2, tmpk$2, tmpd$2, p$2);
            r2k = (NewRedBlackTree.Tree)tmpk$2.elem;
            r2d = (NewRedBlackTree.Tree)tmpd$2.elem;
        }
        NewRedBlackTree.Tree tree3 = !keep ? this.join2(l2k, r2k) : (jk = l2k == tree && r2k == tree2 ? t : this.join(l2k, a, object, r2k));
        NewRedBlackTree.Tree jd = keep ? this.join2(l2d, r2d) : (l2d == tree && r2d == tree2 ? t : this.join(l2d, a, object, r2d));
        tmpk$2.elem = jk;
        tmpd$2.elem = jd;
    }

    private final NewRedBlackTree.Tree delLeft$1(NewRedBlackTree.Tree tree$1, Object k$1, Ordering ordering$1) {
        if (tree$1 == null) {
            throw null;
        }
        NewRedBlackTree.Tree tree = tree$1.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
        if (tree != null && tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0) {
            return this.balLeft(tree$1.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree$1.scala$collection$immutable$NewRedBlackTree$Tree$$_value, this.del(tree$1.scala$collection$immutable$NewRedBlackTree$Tree$$_left, k$1, ordering$1), tree$1.scala$collection$immutable$NewRedBlackTree$Tree$$_right);
        }
        return this.RedTree(tree$1.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree$1.scala$collection$immutable$NewRedBlackTree$Tree$$_value, this.del(tree$1.scala$collection$immutable$NewRedBlackTree$Tree$$_left, k$1, ordering$1), tree$1.scala$collection$immutable$NewRedBlackTree$Tree$$_right);
    }

    private final NewRedBlackTree.Tree delRight$1(NewRedBlackTree.Tree tree$1, Object k$1, Ordering ordering$1) {
        if (tree$1 == null) {
            throw null;
        }
        NewRedBlackTree.Tree tree = tree$1.scala$collection$immutable$NewRedBlackTree$Tree$$_right;
        if (tree != null && tree.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0) {
            return this.balRight(tree$1.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree$1.scala$collection$immutable$NewRedBlackTree$Tree$$_value, tree$1.scala$collection$immutable$NewRedBlackTree$Tree$$_left, this.del(tree$1.scala$collection$immutable$NewRedBlackTree$Tree$$_right, k$1, ordering$1));
        }
        return this.RedTree(tree$1.scala$collection$immutable$NewRedBlackTree$Tree$$_key, tree$1.scala$collection$immutable$NewRedBlackTree$Tree$$_value, tree$1.scala$collection$immutable$NewRedBlackTree$Tree$$_left, this.del(tree$1.scala$collection$immutable$NewRedBlackTree$Tree$$_right, k$1, ordering$1));
    }

    private final int h$1(NewRedBlackTree.Tree t, int i) {
        while (t != null) {
            i = t.scala$collection$immutable$NewRedBlackTree$Tree$$_count < 0 ? i + 1 : i;
            t = t.scala$collection$immutable$NewRedBlackTree$Tree$$_left;
        }
        return i + 1;
    }

    private NewRedBlackTree$() {
        MODULE$ = this;
    }
}

