/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.parser;

import org.mulesoft.common.client.lexical.SourceLocation;
import org.mulesoft.common.parse.ParseError;
import org.mulesoft.common.time.SimpleDateTime;
import org.mulesoft.common.time.SimpleDateTime$;
import org.yaml.model.NoMark$;
import org.yaml.model.ParseErrorHandler;
import org.yaml.model.ParseException;
import org.yaml.model.ScalarMark;
import org.yaml.model.SingleQuoteMark$;
import org.yaml.model.YTag;
import org.yaml.model.YType;
import org.yaml.model.YType$;
import org.yaml.parser.ParserResult;
import org.yaml.parser.ParserResult$;
import org.yaml.parser.ScalarParser;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.matching.Regex;

public final class ScalarParser$ {
    public static ScalarParser$ MODULE$;
    private final Regex org$yaml$parser$ScalarParser$$intRegex;
    private final Regex org$yaml$parser$ScalarParser$$octRegex;
    private final Regex org$yaml$parser$ScalarParser$$hexRegex;
    private final Regex org$yaml$parser$ScalarParser$$floatRegex;
    private final Regex org$yaml$parser$ScalarParser$$infinity;
    private final Set<String> NullTokens;
    private final Set<String> BoolTokens;

    static {
        new ScalarParser$();
    }

    public ScalarParser apply(String text, YType yType) {
        return new ScalarParser(text, yType);
    }

    public ScalarParser apply(String text) {
        return new ScalarParser(text, YType$.MODULE$.Unknown());
    }

    public Regex org$yaml$parser$ScalarParser$$intRegex() {
        return this.org$yaml$parser$ScalarParser$$intRegex;
    }

    public Regex org$yaml$parser$ScalarParser$$octRegex() {
        return this.org$yaml$parser$ScalarParser$$octRegex;
    }

    public Regex org$yaml$parser$ScalarParser$$hexRegex() {
        return this.org$yaml$parser$ScalarParser$$hexRegex;
    }

    public Regex org$yaml$parser$ScalarParser$$floatRegex() {
        return this.org$yaml$parser$ScalarParser$$floatRegex;
    }

    public Regex org$yaml$parser$ScalarParser$$infinity() {
        return this.org$yaml$parser$ScalarParser$$infinity;
    }

    public ParserResult parse(String text, ScalarMark scalarMark, YTag tag, SourceLocation loc, ParseErrorHandler eh) {
        ParserResult parserResult;
        block6: {
            try {
                if (tag == null) {
                    parserResult = this.guessType(text, scalarMark);
                    break block6;
                }
                if (tag.isUnknown()) {
                    ParserResult pr = this.guessType(text, scalarMark);
                    parserResult = new ParserResult(tag.withTag(pr.tag().tagType()), pr.value());
                    break block6;
                }
                if (tag.isEmpty()) {
                    parserResult = new ParserResult(tag.withTag(YType$.MODULE$.Str()), text);
                    break block6;
                }
                parserResult = this.parseForType(tag, text);
            }
            catch (ParseException pe) {
                eh.handle(loc, pe);
                parserResult = ParserResult$.MODULE$.from(text);
            }
            catch (Exception e) {
                eh.handle(loc, new ParseException(tag.tagType(), text, e));
                parserResult = ParserResult$.MODULE$.from(text);
            }
        }
        return parserResult;
    }

    private ParserResult guessType(String text, ScalarMark scalarMark) {
        ScalarMark scalarMark2 = scalarMark;
        ParserResult parserResult = NoMark$.MODULE$.equals(scalarMark2) ? this.guessType(text) : (SingleQuoteMark$.MODULE$.equals(scalarMark2) ? new ParserResult(YType$.MODULE$.Str().tag(), text.replace("''", "'")) : new ParserResult(YType$.MODULE$.Str().tag(), text));
        return parserResult;
    }

    private ParserResult parseForType(YTag tag, String text) {
        Object object;
        YType yType = tag.tagType();
        YType yType2 = YType$.MODULE$.Bool();
        YType yType3 = yType;
        if (!(yType2 != null ? !yType2.equals(yType3) : yType3 != null)) {
            object = BoxesRunTime.boxToBoolean(new StringOps(Predef$.MODULE$.augmentString(text)).toBoolean());
        } else {
            YType yType4 = YType$.MODULE$.Null();
            YType yType5 = yType;
            if (!(yType4 != null ? !yType4.equals(yType5) : yType5 != null) && this.NullTokens().contains(text)) {
                object = null;
            } else {
                YType yType6 = YType$.MODULE$.Float();
                YType yType7 = yType;
                if (!(yType6 != null ? !yType6.equals(yType7) : yType7 != null)) {
                    object = BoxesRunTime.boxToDouble(new StringOps(Predef$.MODULE$.augmentString(text)).toDouble());
                } else {
                    YType yType8 = YType$.MODULE$.Timestamp();
                    YType yType9 = yType;
                    if (!(yType8 != null ? !yType8.equals(yType9) : yType9 != null)) {
                        object = this.parseDateTime(text);
                    } else {
                        YType yType10 = YType$.MODULE$.Str();
                        YType yType11 = yType;
                        if (!(yType10 != null ? !yType10.equals(yType11) : yType11 != null)) {
                            object = text;
                        } else {
                            YType yType12 = YType$.MODULE$.Int();
                            YType yType13 = yType;
                            object = !(yType12 != null ? !yType12.equals(yType13) : yType13 != null) ? (text.startsWith("0o") ? BoxesRunTime.boxToLong(Long.parseLong(text, 8)) : (text.startsWith("0x") ? BoxesRunTime.boxToLong(Long.parseLong(text, 16)) : this.parseInt(text))) : text;
                        }
                    }
                }
            }
        }
        return new ParserResult(tag, object);
    }

    private ParserResult guessType(String text) {
        ParserResult parserResult;
        int l = text.length();
        if (l == 0) {
            parserResult = ParserResult$.MODULE$.Null();
        } else {
            char c;
            char c2 = c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(text), 0);
            switch (c2) {
                case 'N': 
                case 'n': 
                case '~': {
                    if (this.NullTokens().contains(text)) {
                        parserResult = ParserResult$.MODULE$.Null();
                        break;
                    }
                    parserResult = ParserResult$.MODULE$.from(text);
                    break;
                }
                case 'F': 
                case 'T': 
                case 'f': 
                case 't': {
                    if (this.BoolTokens().contains(text)) {
                        parserResult = ParserResult$.MODULE$.from(new StringOps(Predef$.MODULE$.augmentString(text)).toBoolean());
                        break;
                    }
                    parserResult = ParserResult$.MODULE$.from(text);
                    break;
                }
                case '.': {
                    if (text.equalsIgnoreCase(".nan")) {
                        parserResult = ParserResult$.MODULE$.from(Double.NaN);
                        break;
                    }
                    if (text.equalsIgnoreCase(".inf")) {
                        parserResult = ParserResult$.MODULE$.from(Double.POSITIVE_INFINITY);
                        break;
                    }
                    parserResult = ParserResult$.MODULE$.from(text);
                    break;
                }
                case '-': {
                    if (text.equalsIgnoreCase("-.inf")) {
                        parserResult = ParserResult$.MODULE$.from(Double.NEGATIVE_INFINITY);
                        break;
                    }
                    parserResult = this.guessNumber(text, this.guessNumber$default$2());
                    break;
                }
                case '+': {
                    if (text.equalsIgnoreCase("+.inf")) {
                        parserResult = ParserResult$.MODULE$.from(Double.POSITIVE_INFINITY);
                        break;
                    }
                    parserResult = this.guessNumber(text, this.guessNumber$default$2());
                    break;
                }
                case '0': {
                    if (l == 1) {
                        parserResult = ParserResult$.MODULE$.from(0L);
                        break;
                    }
                    if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(text), 1) == 'o') {
                        parserResult = this.parseFromBase(text, 8);
                        break;
                    }
                    if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(text), 1) == 'x') {
                        parserResult = this.parseFromBase(text, 16);
                        break;
                    }
                    parserResult = this.guessNumber(text, true);
                    break;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    parserResult = this.guessNumber(text, true);
                    break;
                }
                default: {
                    parserResult = ParserResult$.MODULE$.from(text);
                    break;
                }
            }
        }
        return parserResult;
    }

    private ParserResult parseFromBase(String text, int base) {
        ParserResult parserResult;
        try {
            parserResult = ParserResult$.MODULE$.from(Long.parseLong(text.substring(2), base));
        }
        catch (NumberFormatException numberFormatException) {
            parserResult = ParserResult$.MODULE$.from(text);
        }
        return parserResult;
    }

    private ParserResult guessNumber(String text, boolean tryDateTime) {
        ParserResult parserResult;
        String string = text;
        Option<List<String>> option = this.org$yaml$parser$ScalarParser$$intRegex().unapplySeq(string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(0) == 0) {
            parserResult = ParserResult$.MODULE$.apply(YType$.MODULE$.Int(), this.parseInt(text));
        } else {
            Option<List<String>> option2 = this.org$yaml$parser$ScalarParser$$floatRegex().unapplySeq(string);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(0) == 0) {
                parserResult = ParserResult$.MODULE$.from(new StringOps(Predef$.MODULE$.augmentString(text)).toDouble());
            } else {
                ParserResult parserResult2;
                if (tryDateTime) {
                    ParserResult parserResult3;
                    Either<ParseError, SimpleDateTime> either = SimpleDateTime$.MODULE$.parse(text);
                    if (either instanceof Right) {
                        Right right = (Right)either;
                        SimpleDateTime dt = (SimpleDateTime)right.value();
                        parserResult3 = ParserResult$.MODULE$.from(dt);
                    } else {
                        parserResult3 = ParserResult$.MODULE$.from(text);
                    }
                    parserResult2 = parserResult3;
                } else {
                    parserResult2 = ParserResult$.MODULE$.from(text);
                }
                parserResult = parserResult2;
            }
        }
        return parserResult;
    }

    private boolean guessNumber$default$2() {
        return false;
    }

    private Object parseInt(String text) {
        Number number;
        try {
            number = BoxesRunTime.boxToLong(Long.parseLong(text));
        }
        catch (NumberFormatException numberFormatException) {
            number = BoxesRunTime.boxToDouble(new StringOps(Predef$.MODULE$.augmentString(text)).toDouble());
        }
        return number;
    }

    private SimpleDateTime parseDateTime(String text) {
        SimpleDateTime dt;
        Either<ParseError, SimpleDateTime> either = SimpleDateTime$.MODULE$.parse(text);
        if (!(either instanceof Right)) {
            if (either instanceof Left) {
                Left left = (Left)either;
                ParseError e = (ParseError)left.value();
                throw new org.mulesoft.common.parse.ParseException(e);
            }
            throw new MatchError(either);
        }
        Right right = (Right)either;
        SimpleDateTime simpleDateTime = dt = (SimpleDateTime)right.value();
        return simpleDateTime;
    }

    private Set<String> NullTokens() {
        return this.NullTokens;
    }

    private Set<String> BoolTokens() {
        return this.BoolTokens;
    }

    private ScalarParser$() {
        MODULE$ = this;
        this.org$yaml$parser$ScalarParser$$intRegex = new StringOps(Predef$.MODULE$.augmentString("[-+]?\\d+")).r();
        this.org$yaml$parser$ScalarParser$$octRegex = new StringOps(Predef$.MODULE$.augmentString("0o([0-7]+)")).r();
        this.org$yaml$parser$ScalarParser$$hexRegex = new StringOps(Predef$.MODULE$.augmentString("0x([0-9a-fA-F]+)")).r();
        this.org$yaml$parser$ScalarParser$$floatRegex = new StringOps(Predef$.MODULE$.augmentString("-?(?:0|[1-9]\\d*)(?:\\.\\d*)?(?:[eE][-+]?\\d+)?")).r();
        this.org$yaml$parser$ScalarParser$$infinity = new StringOps(Predef$.MODULE$.augmentString("([-+])?(?:\\.inf|\\.Inf|\\.INF)")).r();
        this.NullTokens = (Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "null", "Null", "NULL", "~"}));
        this.BoolTokens = (Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"true", "True", "TRUE", "false", "False", "FALSE"}));
    }
}

