/*
 * Decompiled with CFR 0.152.
 */
package amf.apicontract.internal.spec.avro.parser.domain;

import amf.apicontract.internal.spec.avro.parser.context.AvroSchemaContext;
import amf.apicontract.internal.spec.avro.parser.domain.AvroArrayShapeParser;
import amf.apicontract.internal.spec.avro.parser.domain.AvroEnumParser;
import amf.apicontract.internal.spec.avro.parser.domain.AvroFixedShapeParser;
import amf.apicontract.internal.spec.avro.parser.domain.AvroKeyExtractor;
import amf.apicontract.internal.spec.avro.parser.domain.AvroMapShapeParser;
import amf.apicontract.internal.spec.avro.parser.domain.AvroRecordParser;
import amf.apicontract.internal.spec.avro.parser.domain.AvroTextTypeParser;
import amf.apicontract.internal.spec.avro.parser.domain.AvroUnionShapeParser;
import amf.core.internal.parser.domain.Annotations;
import amf.shapes.client.scala.model.domain.AnyShape;
import amf.shapes.client.scala.model.domain.AnyShape$;
import amf.shapes.internal.annotations.AVROSchemaType;
import java.io.Serializable;
import org.yaml.convert.YRead$SeqNodeYRead$;
import org.yaml.convert.YRead$YScalarYRead$;
import org.yaml.model.YMap;
import org.yaml.model.YNode;
import org.yaml.model.YNode$;
import org.yaml.model.YType;
import org.yaml.model.YType$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005%a\u0001\u0002\t\u0012\u0001\u0001B\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\tm\u0001\u0011\t\u0011)A\u0006o!)Q\b\u0001C\u0001}!91\t\u0001b\u0001\n\u0003!\u0005BB&\u0001A\u0003%Q\tC\u0003M\u0001\u0011\u0005Q\nC\u0003[\u0001\u0011\u00051\fC\u0003_\u0001\u0011%q\fC\u0003o\u0001\u0011%q\u000eC\u0003{\u0001\u0011%1\u0010C\u0003}\u0001\u0011%1\u0010C\u0003~\u0001\u0011%a\u0010\u0003\u0004\u0002\u0004\u0001!Ia\u001f\u0005\u0007\u0003\u000b\u0001A\u0011B>\t\r\u0005\u001d\u0001\u0001\"\u0003|\u0005=\teO]8TQ\u0006\u0004X\rU1sg\u0016\u0014(B\u0001\n\u0014\u0003\u0019!w.\\1j]*\u0011A#F\u0001\u0007a\u0006\u00148/\u001a:\u000b\u0005Y9\u0012\u0001B1we>T!\u0001G\r\u0002\tM\u0004Xm\u0019\u0006\u00035m\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u00039u\t1\"\u00199jG>tGO]1di*\ta$A\u0002b[\u001a\u001c\u0001aE\u0002\u0001C\u001d\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012a!\u00118z%\u00164\u0007C\u0001\u0015*\u001b\u0005\t\u0012B\u0001\u0016\u0012\u0005A\teO]8LKf,\u0005\u0010\u001e:bGR|'/A\u0002nCB\u0004\"!\f\u001b\u000e\u00039R!a\f\u0019\u0002\u000b5|G-\u001a7\u000b\u0005E\u0012\u0014\u0001B=b[2T\u0011aM\u0001\u0004_J<\u0017BA\u001b/\u0005\u0011IV*\u00199\u0002\u0007\r$\b\u0010\u0005\u00029w5\t\u0011H\u0003\u0002;'\u000591m\u001c8uKb$\u0018B\u0001\u001f:\u0005E\teO]8TG\",W.Y\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005}\u0012EC\u0001!B!\tA\u0003\u0001C\u00037\u0007\u0001\u000fq\u0007C\u0003,\u0007\u0001\u0007A&A\u0005usB,g+\u00197vKV\tQ\tE\u0002#\r\"K!aR\u0012\u0003\r=\u0003H/[8o!\ti\u0013*\u0003\u0002K]\t)\u0011LT8eK\u0006QA/\u001f9f-\u0006dW/\u001a\u0011\u0002\u000bA\f'o]3\u0015\u00039\u00032A\t$P!\t\u0001\u0006,D\u0001R\u0015\t\u0011\"K\u0003\u00020'*\u0011A\u0005\u0016\u0006\u0003+Z\u000baa\u00197jK:$(BA,\u001e\u0003\u0019\u0019\b.\u00199fg&\u0011\u0011,\u0015\u0002\t\u0003:L8\u000b[1qK\u0006q\u0001/\u0019:tKRK\b/Z#oiJLHC\u0001(]\u0011\u0015iv\u00011\u0001I\u0003\u00151\u0018\r\\;f\u0003)\u0001\u0018M]:f+:LwN\u001c\u000b\u0003\u001f\u0002DQ!\u0019\u0005A\u0002\t\fq!\\3nE\u0016\u00148\u000fE\u0002dW\"s!\u0001Z5\u000f\u0005\u0015DW\"\u00014\u000b\u0005\u001d|\u0012A\u0002\u001fs_>$h(C\u0001%\u0013\tQ7%A\u0004qC\u000e\\\u0017mZ3\n\u00051l'aA*fc*\u0011!nI\u0001\na\u0006\u00148/\u001a+za\u0016$\"a\u00149\t\u000bEL\u0001\u0019\u0001:\u0002\t9\fW.\u001a\t\u0003g^t!\u0001^;\u0011\u0005\u0015\u001c\u0013B\u0001<$\u0003\u0019\u0001&/\u001a3fM&\u0011\u00010\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Y\u001c\u0013a\u00039beN,'+Z2pe\u0012$\u0012aT\u0001\na\u0006\u00148/Z#ok6\f!\u0003]1sg\u0016\u0004&/[7ji&4X\rV=qKR\u0011qj \u0005\u0007\u0003\u0003a\u0001\u0019\u0001:\u0002\tQL\b/Z\u0001\u000ba\u0006\u00148/\u001a$jq\u0016$\u0017\u0001\u00039beN,W*\u00199\u0002\u0015A\f'o]3BeJ\f\u0017\u0010")
public class AvroShapeParser
implements AvroKeyExtractor {
    private final YMap map;
    private final AvroSchemaContext ctx;
    private final Option<YNode> typeValue;

    @Override
    public AvroKeyExtractor.YMapKeys YMapKeys(YMap map) {
        return AvroKeyExtractor.YMapKeys$(this, map);
    }

    @Override
    public AvroKeyExtractor.StringAvroOps StringAvroOps(String value) {
        return AvroKeyExtractor.StringAvroOps$(this, value);
    }

    public Option<YNode> typeValue() {
        return this.typeValue;
    }

    public Option<AnyShape> parse() {
        return this.typeValue().flatMap((Function1<YNode, Option> & Serializable & scala.Serializable)value -> this.parseTypeEntry((YNode)value));
    }

    public Option<AnyShape> parseTypeEntry(YNode value) {
        Tuple2<Option, String> tuple2;
        YType yType = value.tagType();
        YType yType2 = YType$.MODULE$.Seq();
        YType yType3 = yType;
        if (!(yType2 != null ? !yType2.equals(yType3) : yType3 != null)) {
            AnyShape union = this.parseUnion(value.as(YRead$SeqNodeYRead$.MODULE$, this.ctx));
            tuple2 = new Tuple2<Some<AnyShape>, String>(new Some<AnyShape>(union), "union");
        } else {
            YType yType4 = YType$.MODULE$.Str();
            YType yType5 = yType;
            if (!(yType4 != null ? !yType4.equals(yType5) : yType5 != null)) {
                String specificType = value.as(YRead$YScalarYRead$.MODULE$, this.ctx).text();
                tuple2 = new Tuple2<Some<AnyShape>, String>(new Some<AnyShape>(this.parseType(specificType)), specificType);
            } else {
                tuple2 = new Tuple2<None$, String>(None$.MODULE$, "invalid avro type");
            }
        }
        Tuple2<Option, String> tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        Option maybeShape = tuple22._1();
        String avroType = tuple22._2();
        Tuple2<Option, String> tuple23 = new Tuple2<Option, String>(maybeShape, avroType);
        Tuple2<Option, String> tuple24 = tuple23;
        Option maybeShape2 = tuple24._1();
        String avroType2 = tuple24._2();
        maybeShape2.map((Function1<AnyShape, Annotations> & Serializable & scala.Serializable)x$2 -> x$2.annotations().$plus$eq(new AVROSchemaType(avroType2)));
        return maybeShape2;
    }

    private AnyShape parseUnion(Seq<YNode> members) {
        return new AvroUnionShapeParser(members, YNode$.MODULE$.fromMap(this.map), this.ctx).parse();
    }

    private AnyShape parseType(String name) {
        String string = name;
        AnyShape anyShape = "map".equals(string) ? this.parseMap() : ("array".equals(string) ? this.parseArray() : ("record".equals(string) ? this.parseRecord() : ("enum".equals(string) ? this.parseEnum() : ("fixed".equals(string) ? this.parseFixed() : (this.StringAvroOps(name).isPrimitive() ? this.parsePrimitiveType(name) : AnyShape$.MODULE$.apply())))));
        return anyShape;
    }

    private AnyShape parseRecord() {
        return new AvroRecordParser(this.map, this.ctx).parse();
    }

    private AnyShape parseEnum() {
        return new AvroEnumParser(this.map, this.ctx).parse();
    }

    private AnyShape parsePrimitiveType(String type) {
        return new AvroTextTypeParser(type, new Some<YMap>(this.map), this.ctx).parse();
    }

    private AnyShape parseFixed() {
        return new AvroFixedShapeParser(this.map, this.ctx).parse();
    }

    private AnyShape parseMap() {
        return new AvroMapShapeParser(this.map, this.ctx).parse();
    }

    private AnyShape parseArray() {
        return new AvroArrayShapeParser(this.map, this.ctx).parse();
    }

    public AvroShapeParser(YMap map, AvroSchemaContext ctx) {
        this.map = map;
        this.ctx = ctx;
        AvroKeyExtractor.$init$(this);
        this.typeValue = this.YMapKeys(map).typeValue();
    }
}

