/*
 * Decompiled with CFR 0.152.
 */
package amf.cli.internal.export;

import amf.cli.internal.export.ExportableField;
import amf.cli.internal.export.ExportableModel;
import amf.cli.internal.export.MarkdownBuilder;
import amf.cli.internal.export.MarkdownBuilder$;
import scala.Function1;
import scala.Function2;
import scala.Serializable;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.runtime.Nothing$;

public final class MarkdownExporter$ {
    public static MarkdownExporter$ MODULE$;

    static {
        new MarkdownExporter$();
    }

    public String exportToMarkdown(String title, List<ExportableModel> models) {
        MarkdownBuilder builder2 = new MarkdownBuilder(MarkdownBuilder$.MODULE$.$lessinit$greater$default$1()).addText(title).addLine();
        MarkdownBuilder tempBuilder = this.addIndex(builder2, models);
        return models.foldLeft(tempBuilder, (Function2<MarkdownBuilder, ExportableModel, MarkdownBuilder> & java.io.Serializable & Serializable)(builder, model) -> MODULE$.exportModel((ExportableModel)model, (MarkdownBuilder)builder)).build();
    }

    private MarkdownBuilder addIndex(MarkdownBuilder builder, List<ExportableModel> models) {
        MarkdownBuilder tempBuilder = builder.addHeader(2, "Table of Contents");
        return ((LinearSeqOptimized)models.map((Function1<ExportableModel, String> & java.io.Serializable & Serializable)x -> x.name(), List$.MODULE$.canBuildFrom())).foldLeft(tempBuilder, (Function2<MarkdownBuilder, String, MarkdownBuilder> & java.io.Serializable & Serializable)(accBuilder, modelName) -> accBuilder.addBullet(MODULE$.createLink((String)modelName, (String)modelName)));
    }

    private MarkdownBuilder exportModel(ExportableModel model, MarkdownBuilder builder2) {
        MarkdownBuilder tempBuilder = builder2.addHeader(2, model.name()).addText(model.doc()).addText("Types:").addBullet(model.types().map((Function1<String, String> & java.io.Serializable & Serializable)value -> MODULE$.formatToCode((String)value), List$.MODULE$.canBuildFrom())).startTable(new $colon$colon<Nothing$>((Nothing$)((Object)"Name"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"Value"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"Sorted"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"Documentation"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"Namespace"), Nil$.MODULE$))))));
        return model.fields().foldLeft(tempBuilder, (Function2<MarkdownBuilder, ExportableField, MarkdownBuilder> & java.io.Serializable & Serializable)(builder, field2) -> builder.addRow(new $colon$colon<Nothing$>((Nothing$)((Object)field2.name()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)MODULE$.formatFieldValue((ExportableField)field2)), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)MODULE$.formatFieldSorted((ExportableField)field2)), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)field2.doc()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)MODULE$.formatToCode(field2.namespace())), Nil$.MODULE$))))))).addText("");
    }

    private String createLink(String linkName, String linkTo) {
        return new StringBuilder(5).append("[").append(linkName).append("](#").append(this.formatToAnchor(linkTo)).append(")").toString();
    }

    /*
     * WARNING - void declaration
     */
    private String formatFieldValue(ExportableField field2) {
        void var2_2;
        block1: {
            String value = field2.value();
            if (field2.linkToValue()) {
                value = new StringBuilder(5).append("[").append(value).append("](#").append(this.formatToAnchor(value)).append(")").toString();
            }
            if (!field2.isArray()) break block1;
            value = new StringBuilder(2).append("[").append(value).append("]").toString();
        }
        return var2_2;
    }

    private String formatFieldSorted(ExportableField field2) {
        return field2.isArray() ? Boolean.toString(field2.isSorted()) : "-";
    }

    private String formatToCode(String value) {
        return new StringBuilder(2).append("`").append(value).append("`").toString();
    }

    private String formatToAnchor(String value) {
        return value.replace(" ", "-").toLowerCase();
    }

    private MarkdownExporter$() {
        MODULE$ = this;
    }
}

