/*
 * Decompiled with CFR 0.152.
 */
package amf.shapes.internal.spec.jsonschema.ref;

import amf.core.client.scala.errorhandling.AMFErrorHandler;
import amf.core.client.scala.model.document.BaseUnit;
import amf.core.client.scala.parse.document.ParsedDocument;
import amf.core.client.scala.parse.document.SyamlParsedDocument;
import amf.core.internal.parser.Root;
import amf.shapes.internal.spec.common.parser.ShapeParserContext;
import amf.shapes.internal.spec.common.parser.YMapEntryLike;
import amf.shapes.internal.spec.common.parser.YMapEntryLike$;
import amf.shapes.internal.spec.jsonschema.ref.JsonReference;
import amf.shapes.internal.spec.jsonschema.ref.JsonReference$;
import amf.shapes.internal.spec.jsonschema.ref.JsonSchemaRootCreator$;
import amf.shapes.internal.validation.definitions.ShapeParserSideValidations$;
import java.io.Serializable;
import org.yaml.model.IllegalTypeHandler;
import org.yaml.model.IllegalTypeHandler$;
import org.yaml.model.YNode;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;

public final class AstFinder$ {
    public static AstFinder$ MODULE$;

    static {
        new AstFinder$();
    }

    public Option<YNode> findAst(BaseUnit inputFragment, Option<String> pointer, ShapeParserContext ctx) {
        Root doc = JsonSchemaRootCreator$.MODULE$.createRootFrom(inputFragment, pointer, ctx);
        return this.findAst(doc, ctx);
    }

    private Option<YNode> findAst(Root doc, ShapeParserContext context) {
        Option option;
        ParsedDocument parsedDocument = doc.parsed();
        if (parsedDocument instanceof SyamlParsedDocument) {
            SyamlParsedDocument syamlParsedDocument = (SyamlParsedDocument)parsedDocument;
            String shapeId = doc.location().contains("#") ? doc.location() : new StringBuilder(2).append(doc.location()).append("#/").toString();
            JsonReference jsonReference = JsonReference$.MODULE$.buildReference(doc.location());
            if (jsonReference == null) {
                throw new MatchError(jsonReference);
            }
            String url = jsonReference.url();
            Option<String> hashFragment = jsonReference.fragment();
            Tuple2<String, Option<String>> tuple2 = new Tuple2<String, Option<String>>(url, hashFragment);
            Tuple2<String, Option<String>> tuple22 = tuple2;
            String url2 = tuple22._1();
            Option<String> hashFragment2 = tuple22._2();
            YMapEntryLike rootAst = this.getPointedAstOrNode(syamlParsedDocument.document().node(), shapeId, hashFragment2, url2, context);
            option = new Some<YNode>(rootAst.value());
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    public YMapEntryLike getPointedAstOrNode(YNode node, String shapeId, Option<String> hashFragment, String url, ShapeParserContext ctx) {
        Option<YMapEntryLike> option;
        AMFErrorHandler errorHandler = ctx.eh();
        ctx.setJsonSchemaAST(node);
        Option<String> option2 = hashFragment;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String fragment = (String)some.value();
            option = this.findNodeInIndex(fragment, ctx);
        } else if (None$.MODULE$.equals(option2)) {
            option = new Some<YMapEntryLike>(YMapEntryLike$.MODULE$.apply(node, (IllegalTypeHandler)ctx));
        } else {
            throw new MatchError(option2);
        }
        Option<YMapEntryLike> rootAst = option;
        return (YMapEntryLike)rootAst.getOrElse((Function0<YMapEntryLike> & Serializable & scala.Serializable)() -> {
            ctx.eh().violation(ShapeParserSideValidations$.MODULE$.UnableToParseJsonSchema(), shapeId, new StringBuilder(33).append("Cannot find path ").append(hashFragment.getOrElse((Function0<String> & Serializable & scala.Serializable)() -> "")).append(" in JSON schema ").append(url).toString(), node.location());
            return YMapEntryLike$.MODULE$.apply(node, IllegalTypeHandler$.MODULE$.illegalValueHandler());
        });
    }

    private Option<YMapEntryLike> findNodeInIndex(String path, ShapeParserContext ctx) {
        return ctx.findLocalJSONPath(path);
    }

    private AstFinder$() {
        MODULE$ = this;
    }
}

