/*
 * Decompiled with CFR 0.152.
 */
package amf.apicontract.internal.spec.oas.parser.domain;

import amf.apicontract.client.scala.model.domain.security.ApiKeySettings;
import amf.apicontract.client.scala.model.domain.security.HttpSettings;
import amf.apicontract.client.scala.model.domain.security.OAuth1Settings;
import amf.apicontract.client.scala.model.domain.security.OAuth2Flow;
import amf.apicontract.client.scala.model.domain.security.OAuth2Flow$;
import amf.apicontract.client.scala.model.domain.security.OAuth2Settings;
import amf.apicontract.client.scala.model.domain.security.OpenIdConnectSettings;
import amf.apicontract.client.scala.model.domain.security.SecurityScheme;
import amf.apicontract.client.scala.model.domain.security.Settings;
import amf.apicontract.internal.metamodel.domain.security.HttpSettingsModel$;
import amf.apicontract.internal.metamodel.domain.security.OAuth2FlowModel$;
import amf.apicontract.internal.metamodel.domain.security.OAuth2SettingsModel$;
import amf.apicontract.internal.metamodel.domain.security.OpenIdConnectSettingsModel$;
import amf.apicontract.internal.spec.common.parser.Oas3SettingsProducers$;
import amf.apicontract.internal.spec.common.parser.SettingsProducers;
import amf.apicontract.internal.spec.oas.parser.context.OasWebApiContext;
import amf.apicontract.internal.spec.oas.parser.domain.OAuth2FlowValidations$;
import amf.apicontract.internal.spec.oas.parser.domain.OasLikeSecuritySettingsParser;
import amf.core.client.scala.model.domain.AmfArray;
import amf.core.client.scala.model.domain.AmfElement;
import amf.core.client.scala.model.domain.AmfScalar;
import amf.core.internal.parser.domain.Annotations$;
import amf.core.internal.parser.domain.ScalarNode$;
import amf.core.internal.utils.package$;
import amf.shapes.internal.spec.common.parser.AnnotationParser;
import amf.shapes.internal.spec.common.parser.AnnotationParser$;
import java.io.Serializable;
import org.yaml.convert.YRead$YMapYRead$;
import org.yaml.model.YMap;
import org.yaml.model.YMapEntry;
import org.yaml.model.YNode$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001B\u0007\u000f\u0001uA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\t[\u0001\u0011\t\u0011)A\u0005]!A!\b\u0001B\u0001B\u0003-1\bC\u0003B\u0001\u0011\u0005!\tC\u0003I\u0001\u0011\u0005\u0013\nC\u0003S\u0001\u0011\u00051\u000bC\u0003Z\u0001\u0011\u0005!\fC\u0003`\u0001\u0011\u0005\u0003\rC\u0003f\u0001\u0011%a\rC\u0003q\u0001\u0011%\u0011\u000fC\u0004\u0002\n\u0001!I!a\u0003\t\u000f\u0005]\u0001\u0001\"\u0011\u0002\u001a\tQr*Y:4'\u0016\u001cWO]5usN+G\u000f^5oON\u0004\u0016M]:fe*\u0011q\u0002E\u0001\u0007I>l\u0017-\u001b8\u000b\u0005E\u0011\u0012A\u00029beN,'O\u0003\u0002\u0014)\u0005\u0019q.Y:\u000b\u0005U1\u0012\u0001B:qK\u000eT!a\u0006\r\u0002\u0011%tG/\u001a:oC2T!!\u0007\u000e\u0002\u0017\u0005\u0004\u0018nY8oiJ\f7\r\u001e\u0006\u00027\u0005\u0019\u0011-\u001c4\u0004\u0001M\u0011\u0001A\b\t\u0003?\u0001j\u0011AD\u0005\u0003C9\u0011QdT1t\u0019&\\WmU3dkJLG/_*fiRLgnZ:QCJ\u001cXM]\u0001\u0004[\u0006\u0004\bC\u0001\u0013,\u001b\u0005)#B\u0001\u0014(\u0003\u0015iw\u000eZ3m\u0015\tA\u0013&\u0001\u0003zC6d'\"\u0001\u0016\u0002\u0007=\u0014x-\u0003\u0002-K\t!\u0011,T1q\u0003\u0019\u00198\r[3nKB\u0011q\u0006O\u0007\u0002a)\u0011\u0011GM\u0001\tg\u0016\u001cWO]5us*\u0011qb\r\u0006\u0003MQR!!\u000e\u001c\u0002\u000bM\u001c\u0017\r\\1\u000b\u0005]B\u0012AB2mS\u0016tG/\u0003\u0002:a\tq1+Z2ve&$\u0018pU2iK6,\u0017aA2uqB\u0011AhP\u0007\u0002{)\u0011a\bE\u0001\bG>tG/\u001a=u\u0013\t\u0001UH\u0001\tPCN<VMY!qS\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"2a\u0011$H)\t!U\t\u0005\u0002 \u0001!)!\b\u0002a\u0002w!)!\u0005\u0002a\u0001G!)Q\u0006\u0002a\u0001]\u0005)\u0001/\u0019:tKR\t!\nE\u0002L\u001b>k\u0011\u0001\u0014\u0006\u0002k%\u0011a\n\u0014\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005=\u0002\u0016BA)1\u0005!\u0019V\r\u001e;j]\u001e\u001c\u0018A\u00079beN,w\n]3o\u0013\u0012\u001cuN\u001c8fGR\u001cV\r\u001e;j]\u001e\u001cHC\u0001+X!\tyS+\u0003\u0002Wa\t)r\n]3o\u0013\u0012\u001cuN\u001c8fGR\u001cV\r\u001e;j]\u001e\u001c\b\"\u0002-\u0007\u0001\u0004!\u0016\u0001C:fiRLgnZ:\u0002#A\f'o]3IiR\u00048+\u001a;uS:<7\u000f\u0006\u0002\\=B\u0011q\u0006X\u0005\u0003;B\u0012A\u0002\u0013;uaN+G\u000f^5oONDQ\u0001W\u0004A\u0002m\u000b1\u0003]1sg\u0016|\u0015-\u001e;ieM+G\u000f^5oON$\"!\u00193\u0011\u0005=\u0012\u0017BA21\u00059y\u0015)\u001e;ieM+G\u000f^5oONDQ\u0001\u0017\u0005A\u0002\u0005\f!\u0002]1sg\u00164En\\<t)\r9'n\u001c\t\u0003\u0017\"L!!\u001b'\u0003\tUs\u0017\u000e\u001e\u0005\u0006W&\u0001\r\u0001\\\u0001\u0006K:$(/\u001f\t\u0003I5L!A\\\u0013\u0003\u0013ek\u0015\r]#oiJL\b\"\u0002-\n\u0001\u0004\t\u0017!\u00039beN,g\t\\8x)\u0011\u0011X/!\u0002\u0011\u0005=\u001a\u0018B\u0001;1\u0005)y\u0015)\u001e;ie\u0019cwn\u001e\u0005\u0006m*\u0001\ra^\u0001\u0007a\u0006\u0014XM\u001c;\u0011\u0005a|hBA=~!\tQH*D\u0001|\u0015\taH$\u0001\u0004=e>|GOP\u0005\u0003}2\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0001\u0003\u0007\u0011aa\u0015;sS:<'B\u0001@M\u0011\u0019\t9A\u0003a\u0001Y\u0006Ia\r\\8x\u000b:$(/_\u0001\u0011SN,\u0005\u0010^3og&|gNR5fY\u0012$B!!\u0004\u0002\u0014A\u00191*a\u0004\n\u0007\u0005EAJA\u0004C_>dW-\u00198\t\r\u0005U1\u00021\u0001m\u0003\u00151\u0017.\u001a7e\u0003}1XM\u001c3peN\u0003XmY5gS\u000e\u001cV\r\u001e;j]\u001e\u001c\bK]8ek\u000e,'o\u001d\u000b\u0003\u00037\u0001B!!\b\u0002&5\u0011\u0011q\u0004\u0006\u0004#\u0005\u0005\"bAA\u0012)\u000511m\\7n_:LA!a\n\u0002 \t\t2+\u001a;uS:<7\u000f\u0015:pIV\u001cWM]:")
public class Oas3SecuritySettingsParser
extends OasLikeSecuritySettingsParser {
    private final YMap map;
    private final OasWebApiContext ctx;

    @Override
    public Option<Settings> parse() {
        return this.produceSettings().map((Function1<Settings, Settings> & Serializable & scala.Serializable)settings -> {
            Settings settings2;
            Settings settings3 = settings;
            if (settings3 instanceof OAuth1Settings) {
                OAuth1Settings oAuth1Settings = (OAuth1Settings)settings3;
                settings2 = this.parseOauth1Settings(oAuth1Settings);
            } else if (settings3 instanceof OAuth2Settings) {
                OAuth2Settings oAuth2Settings = (OAuth2Settings)settings3;
                settings2 = this.parseOauth2Settings(oAuth2Settings);
            } else if (settings3 instanceof ApiKeySettings) {
                ApiKeySettings apiKeySettings = (ApiKeySettings)settings3;
                settings2 = this.parseApiKeySettings(apiKeySettings);
            } else if (settings3 instanceof OpenIdConnectSettings) {
                OpenIdConnectSettings openIdConnectSettings = (OpenIdConnectSettings)settings3;
                settings2 = this.parseOpenIdConnectSettings(openIdConnectSettings);
            } else if (settings3 instanceof HttpSettings) {
                HttpSettings httpSettings = (HttpSettings)settings3;
                settings2 = this.parseHttpSettings(httpSettings);
            } else {
                settings2 = (Settings)amf.core.internal.parser.package$.MODULE$.YMapOps($this.map).key(package$.MODULE$.AmfStrings("settings").asOasExtension()).map((Function1<YMapEntry, Settings> & Serializable & scala.Serializable)entry -> this.parseDynamicSettings(entry.value().as(YRead$YMapYRead$.MODULE$, $this.ctx), settings3, Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).getOrElse((Function0<Settings> & Serializable & scala.Serializable)() -> settings3);
            }
            OAuth1Settings parsedSettings = settings2;
            return this.parseAnnotations(parsedSettings);
        });
    }

    public OpenIdConnectSettings parseOpenIdConnectSettings(OpenIdConnectSettings settings) {
        amf.core.internal.parser.package$.MODULE$.YMapOps(this.map).key("openIdConnectUrl", this.FieldOps(OpenIdConnectSettingsModel$.MODULE$.Url(), this.ctx).in(settings));
        amf.core.internal.parser.package$.MODULE$.YMapOps(this.map).key(package$.MODULE$.AmfStrings("settings").asOasExtension(), (Function1<YMapEntry, BoxedUnit>)(Function1<YMapEntry, Object> & Serializable & scala.Serializable)entry -> {
            this.parseDynamicSettings(entry.value().as(YRead$YMapYRead$.MODULE$, this.ctx), settings, Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            return BoxedUnit.UNIT;
        });
        return settings;
    }

    public HttpSettings parseHttpSettings(HttpSettings settings) {
        amf.core.internal.parser.package$.MODULE$.YMapOps(this.map).key("scheme", this.FieldOps(HttpSettingsModel$.MODULE$.Scheme(), this.ctx).in(settings));
        amf.core.internal.parser.package$.MODULE$.YMapOps(this.map).key("bearerFormat", this.FieldOps(HttpSettingsModel$.MODULE$.BearerFormat(), this.ctx).in(settings));
        return settings;
    }

    @Override
    public OAuth2Settings parseOauth2Settings(OAuth2Settings settings) {
        amf.core.internal.parser.package$.MODULE$.YMapOps(this.map).key("flows", (Function1<YMapEntry, BoxedUnit>)(Function1<YMapEntry, Object> & Serializable & scala.Serializable)x$1 -> {
            this.parseFlows(x$1, settings);
            return BoxedUnit.UNIT;
        });
        amf.core.internal.parser.package$.MODULE$.YMapOps(this.map).key(package$.MODULE$.AmfStrings("settings").asOasExtension(), (Function1<YMapEntry, BoxedUnit>)(Function1<YMapEntry, Object> & Serializable & scala.Serializable)entry -> {
            this.parseDynamicSettings(entry.value().as(YRead$YMapYRead$.MODULE$, this.ctx), settings, Predef$.MODULE$.wrapRefArray((Object[])new String[]{"authorizationGrants"}));
            return BoxedUnit.UNIT;
        });
        new AnnotationParser(settings, this.map, AnnotationParser$.MODULE$.apply$default$3(), this.ctx).parseOrphanNode("flows");
        return settings;
    }

    private void parseFlows(YMapEntry entry, OAuth2Settings settings) {
        IndexedSeq flowConfig = (IndexedSeq)entry.value().as(YRead$YMapYRead$.MODULE$, this.ctx).entries().filter((Function1<YMapEntry, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(Oas3SecuritySettingsParser.$anonfun$parseFlows$1(this, x$2)));
        IndexedSeq<AmfElement> flows = flowConfig.map((Function1<YMapEntry, OAuth2Flow> & Serializable & scala.Serializable)x$3 -> this.parseFlow(settings.id(), (YMapEntry)x$3), IndexedSeq$.MODULE$.canBuildFrom());
        settings.setWithoutId(OAuth2SettingsModel$.MODULE$.Flows(), new AmfArray(flows, Annotations$.MODULE$.apply(entry.value())), Annotations$.MODULE$.apply(entry));
    }

    /*
     * WARNING - void declaration
     */
    private OAuth2Flow parseFlow(String parent, YMapEntry flowEntry) {
        void var3_3;
        OAuth2Flow flow = OAuth2Flow$.MODULE$.apply(flowEntry);
        YMap flowMap = flowEntry.value().as(YRead$YMapYRead$.MODULE$, this.ctx);
        AmfScalar flowKey = (AmfScalar)ScalarNode$.MODULE$.apply(flowEntry.key(), this.ctx).string();
        flow.setWithoutId(OAuth2FlowModel$.MODULE$.Flow(), flowKey, Annotations$.MODULE$.apply(flowEntry.key()));
        amf.core.internal.parser.package$.MODULE$.YMapOps(flowMap).key("authorizationUrl", this.FieldOps(OAuth2FlowModel$.MODULE$.AuthorizationUri(), this.ctx).in(flow));
        amf.core.internal.parser.package$.MODULE$.YMapOps(flowMap).key("tokenUrl", this.FieldOps(OAuth2FlowModel$.MODULE$.AccessTokenUri(), this.ctx).in(flow));
        amf.core.internal.parser.package$.MODULE$.YMapOps(flowMap).key("refreshUrl", this.FieldOps(OAuth2FlowModel$.MODULE$.RefreshUri(), this.ctx).in(flow));
        this.parseScopes(flow, flowMap);
        new AnnotationParser(flow, flowMap, AnnotationParser$.MODULE$.apply$default$3(), this.ctx).parse();
        OAuth2FlowValidations$.MODULE$.validateFlowFields(flow, this.ctx.eh(), flowEntry);
        this.ctx.closedShape(flow, flowMap, flow.flow().value());
        return var3_3;
    }

    private boolean isExtensionField(YMapEntry field2) {
        return YNode$.MODULE$.toString(field2.key(), this.ctx).startsWith("x-");
    }

    @Override
    public SettingsProducers vendorSpecificSettingsProducers() {
        return Oas3SettingsProducers$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$parseFlows$1(Oas3SecuritySettingsParser $this, YMapEntry x$2) {
        return !$this.isExtensionField(x$2);
    }

    public Oas3SecuritySettingsParser(YMap map, SecurityScheme scheme, OasWebApiContext ctx) {
        this.map = map;
        this.ctx = ctx;
        super(map, scheme, ctx);
    }
}

