/*
 * Decompiled with CFR 0.152.
 */
package org.mulesoft.common.time;

import java.io.Serializable;
import org.mulesoft.common.core.package$Strings$;
import org.mulesoft.common.parse.ParseError;
import org.mulesoft.common.parse.ParseError$;
import org.mulesoft.common.parse.ParseException;
import org.mulesoft.common.parse.RangeError;
import org.mulesoft.common.time.SimpleDateTime;
import org.mulesoft.common.time.TimeOfDay;
import org.mulesoft.common.time.TimeOfDay$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Either;
import scala.util.matching.Regex;

public final class SimpleDateTime$
implements scala.Serializable {
    public static SimpleDateTime$ MODULE$;
    private final TimeOfDay ZeroTime;
    private final SimpleDateTime Epoch;
    private final String datePattern;
    private final String timePattern;
    private final String timeZonePattern;
    private final String timeSeparation;
    private final Regex dateRegex;
    private final Regex dateTimeRegex;
    private final Regex partialTimeRegex;
    private final Regex fullTimeRegex;

    static {
        new SimpleDateTime$();
    }

    public Option<TimeOfDay> $lessinit$greater$default$4() {
        return None$.MODULE$;
    }

    public Option<Object> $lessinit$greater$default$5() {
        return None$.MODULE$;
    }

    public TimeOfDay ZeroTime() {
        return this.ZeroTime;
    }

    public SimpleDateTime Epoch() {
        return this.Epoch;
    }

    private String datePattern() {
        return this.datePattern;
    }

    private String timePattern() {
        return this.timePattern;
    }

    private String timeZonePattern() {
        return this.timeZonePattern;
    }

    private String timeSeparation() {
        return this.timeSeparation;
    }

    private Regex dateRegex() {
        return this.dateRegex;
    }

    private Regex dateTimeRegex() {
        return this.dateTimeRegex;
    }

    private Regex partialTimeRegex() {
        return this.partialTimeRegex;
    }

    private Regex fullTimeRegex() {
        return this.fullTimeRegex;
    }

    private int toInt(String s) {
        if (package$Strings$.MODULE$.isNullOrEmpty$extension(org.mulesoft.common.core.package$.MODULE$.Strings(s))) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    public SimpleDateTime apply(int year, int month, int day) {
        return new SimpleDateTime(year, month, day, None$.MODULE$, None$.MODULE$);
    }

    public SimpleDateTime apply(int year, int month, int day, TimeOfDay timeOfDay) {
        return new SimpleDateTime(year, month, day, new Some<TimeOfDay>(timeOfDay), None$.MODULE$);
    }

    public SimpleDateTime apply(int year, int month, int day, TimeOfDay timeOfDay, int zoneOffset) {
        return new SimpleDateTime(year, month, day, new Some<TimeOfDay>(timeOfDay), new Some<Object>(BoxesRunTime.boxToInteger(zoneOffset * 60)));
    }

    public Option<TimeOfDay> apply$default$4() {
        return None$.MODULE$;
    }

    public Option<Object> apply$default$5() {
        return None$.MODULE$;
    }

    public Option<SimpleDateTime> unapply(String arg) {
        return this.parse(arg).toOption();
    }

    public Either<ParseError, SimpleDateTime> parse(String str) {
        String string = str;
        Option<List<String>> option = this.dateTimeRegex().unapplySeq(string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(10) == 0) {
            String year = (String)((LinearSeqOptimized)option.get()).apply(0);
            String month = (String)((LinearSeqOptimized)option.get()).apply(1);
            String day = (String)((LinearSeqOptimized)option.get()).apply(2);
            String hours = (String)((LinearSeqOptimized)option.get()).apply(3);
            String minutes = (String)((LinearSeqOptimized)option.get()).apply(4);
            String seconds = (String)((LinearSeqOptimized)option.get()).apply(5);
            String nanos = (String)((LinearSeqOptimized)option.get()).apply(6);
            String z = (String)((LinearSeqOptimized)option.get()).apply(7);
            String offsetHours = (String)((LinearSeqOptimized)option.get()).apply(8);
            String offsetMinutes = (String)((LinearSeqOptimized)option.get()).apply(9);
            return this.either((Function0<SimpleDateTime> & Serializable & scala.Serializable)() -> new SimpleDateTime(MODULE$.toInt(year), MODULE$.toInt(month), MODULE$.toInt(day), hours == null ? None$.MODULE$ : new Some<TimeOfDay>(MODULE$.buildTimeOfDay(hours, minutes, seconds, nanos)), MODULE$.buildTimeZone(z, offsetHours, offsetMinutes)));
        }
        return ParseError$.MODULE$.formatError(str, ParseError$.MODULE$.formatError$default$2());
    }

    public Either<ParseError, SimpleDateTime> parseDate(String str) {
        String string = str;
        Option<List<String>> option = this.dateRegex().unapplySeq(string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(3) == 0) {
            String year = (String)((LinearSeqOptimized)option.get()).apply(0);
            String month = (String)((LinearSeqOptimized)option.get()).apply(1);
            String day = (String)((LinearSeqOptimized)option.get()).apply(2);
            return this.either((Function0<SimpleDateTime> & Serializable & scala.Serializable)() -> MODULE$.apply(MODULE$.toInt(year), MODULE$.toInt(month), MODULE$.toInt(day)));
        }
        return ParseError$.MODULE$.formatError(str, ParseError$.MODULE$.formatError$default$2());
    }

    public Either<ParseError, Tuple2<TimeOfDay, Option<Object>>> parseFullTime(String str) {
        String string = str;
        Option<List<String>> option = this.fullTimeRegex().unapplySeq(string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(7) == 0) {
            String hours = (String)((LinearSeqOptimized)option.get()).apply(0);
            String minutes = (String)((LinearSeqOptimized)option.get()).apply(1);
            String seconds = (String)((LinearSeqOptimized)option.get()).apply(2);
            String nanos = (String)((LinearSeqOptimized)option.get()).apply(3);
            String z = (String)((LinearSeqOptimized)option.get()).apply(4);
            String offsetHours = (String)((LinearSeqOptimized)option.get()).apply(5);
            String offsetMinutes = (String)((LinearSeqOptimized)option.get()).apply(6);
            return this.either((Function0<Tuple2> & Serializable & scala.Serializable)() -> new Tuple2<TimeOfDay, Option<Object>>(MODULE$.buildTimeOfDay(hours, minutes, seconds, nanos), MODULE$.buildTimeZone(z, offsetHours, offsetMinutes)));
        }
        return ParseError$.MODULE$.formatError(str, ParseError$.MODULE$.formatError$default$2());
    }

    public Either<ParseError, TimeOfDay> parsePartialTime(String str) {
        String string = str;
        Option<List<String>> option = this.partialTimeRegex().unapplySeq(string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(4) == 0) {
            String hours = (String)((LinearSeqOptimized)option.get()).apply(0);
            String minutes = (String)((LinearSeqOptimized)option.get()).apply(1);
            String seconds = (String)((LinearSeqOptimized)option.get()).apply(2);
            String nanos = (String)((LinearSeqOptimized)option.get()).apply(3);
            return this.either((Function0<TimeOfDay> & Serializable & scala.Serializable)() -> MODULE$.buildTimeOfDay(hours, minutes, seconds, nanos));
        }
        return ParseError$.MODULE$.formatError(str, ParseError$.MODULE$.formatError$default$2());
    }

    public void org$mulesoft$common$time$SimpleDateTime$$validateDate(int year, int month, int day) {
        int n;
        if (year == 0) {
            n = year;
        } else if (month < 1 || month > 12) {
            n = month;
        } else if (day < 1 || day > 31) {
            n = day;
        } else if (day == 31 && (month == 4 || month == 6 || month == 9 || month == 11)) {
            n = day;
        } else if (month == 2 && (day > 29 || day == 29 && (year % 4 != 0 || year >= 1600 && year % 100 == 0 && year % 400 != 0))) {
            n = day;
        } else {
            return;
        }
        int offending = n;
        throw new ParseException(new RangeError(offending));
    }

    private TimeOfDay buildTimeOfDay(String hours, String minutes, String seconds, String nanos) {
        return new TimeOfDay(Integer.parseInt(hours), Integer.parseInt(minutes), this.toInt(seconds), nanos == null ? 0 : Integer.parseInt(new StringBuilder(0).append(nanos).append(new StringOps(Predef$.MODULE$.augmentString("0")).$times(9 - nanos.length())).toString()));
    }

    private Option<Object> buildTimeZone(String z, String offsetHours, String offsetMinutes) {
        if (z == null) {
            return None$.MODULE$;
        }
        if (offsetHours == null) {
            return new Some<Object>(BoxesRunTime.boxToInteger(0));
        }
        int oh = this.toInt(offsetHours);
        int om = this.toInt(offsetMinutes);
        if (oh < -24 || oh > 24) {
            throw new ParseException(new RangeError(oh));
        }
        if (om < 0 || om > 60) {
            throw new ParseException(new RangeError(om));
        }
        return new Some<Object>(BoxesRunTime.boxToInteger(oh * 3600 + (oh < 0 ? -om : om) * 60));
    }

    public String org$mulesoft$common$time$SimpleDateTime$$zoneOffsetToString(int zoneOffset) {
        String string;
        String sign;
        if (zoneOffset == 0) {
            return "Z";
        }
        int hours = zoneOffset / 3600;
        int minutes = zoneOffset / 60 % 60;
        String string2 = sign = zoneOffset > 0 ? "+" : "-";
        if (minutes == 0) {
            string = "";
        } else {
            int arg$macro$1 = RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(minutes));
            string = new StringOps(":%02d").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(arg$macro$1)}));
        }
        String mins = string;
        String arg$macro$2 = sign;
        int arg$macro$3 = RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(hours));
        String arg$macro$4 = mins;
        return new StringOps("%s%02d%s").format(Predef$.MODULE$.genericWrapArray(new Object[]{arg$macro$2, BoxesRunTime.boxToInteger(arg$macro$3), arg$macro$4}));
    }

    private <T> Either<ParseError, T> either(Function0<T> r) {
        Either either;
        try {
            either = package$.MODULE$.Right().apply(r.apply());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ParseException) {
                ParseException parseException = (ParseException)throwable2;
                ParseError e = parseException.parseError();
                either = package$.MODULE$.Left().apply(e);
            }
            throw throwable;
        }
        return either;
    }

    public SimpleDateTime apply(int year, int month, int day, Option<TimeOfDay> timeOfDay, Option<Object> zoneOffset) {
        return new SimpleDateTime(year, month, day, timeOfDay, zoneOffset);
    }

    public Option<Tuple5<Object, Object, Object, Option<TimeOfDay>, Option<Object>>> unapply(SimpleDateTime x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some<Tuple5<Object, Object, Object, Option<TimeOfDay>, Option<Object>>>(new Tuple5<Integer, Integer, Integer, Option<TimeOfDay>, Option<Object>>(BoxesRunTime.boxToInteger(x$0.year()), BoxesRunTime.boxToInteger(x$0.month()), BoxesRunTime.boxToInteger(x$0.day()), x$0.timeOfDay(), x$0.zoneOffset()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SimpleDateTime$() {
        MODULE$ = this;
        this.ZeroTime = new TimeOfDay(0, TimeOfDay$.MODULE$.apply$default$2(), TimeOfDay$.MODULE$.apply$default$3(), TimeOfDay$.MODULE$.apply$default$4());
        this.Epoch = new SimpleDateTime(1970, 1, 1, new Some<TimeOfDay>(this.ZeroTime()), new Some<Object>(BoxesRunTime.boxToInteger(0)));
        this.datePattern = "(\\d{4})-(\\d\\d?)-(\\d\\d?)";
        this.timePattern = "(\\d\\d?):(\\d\\d?)(?::(\\d\\d?))?(?:\\.(\\d{0,9}))?";
        this.timeZonePattern = "(?:(?:[\\ \\t]*)?(Z|([-+]\\d\\d?)(?::(\\d\\d?))?))?";
        this.timeSeparation = "(?:[Tt]|[\\ \\t]+)";
        this.dateRegex = new StringOps(Predef$.MODULE$.augmentString(this.datePattern())).r();
        this.dateTimeRegex = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(5).append(this.datePattern()).append("(?:").append(this.timeSeparation()).append(this.timePattern()).append(this.timeZonePattern()).append(")?").toString())).r();
        this.partialTimeRegex = new StringOps(Predef$.MODULE$.augmentString(this.timePattern())).r();
        this.fullTimeRegex = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(0).append(this.timePattern()).append(this.timeZonePattern()).toString())).r();
    }
}

