/*
 * Decompiled with CFR 0.152.
 */
package amf.cli.internal.commands;

import amf.aml.client.scala.AMLConfiguration;
import amf.aml.client.scala.model.document.Dialect;
import amf.aml.client.scala.model.document.DialectInstance;
import amf.cli.internal.commands.CommandHelper;
import amf.cli.internal.commands.ExitCodes$;
import amf.cli.internal.commands.ParserConfig;
import amf.cli.internal.commands.ValidateCommand$;
import amf.core.client.common.validation.ProfileName;
import amf.core.client.common.validation.ProfileName$;
import amf.core.client.scala.AMFGraphConfiguration;
import amf.core.client.scala.model.document.BaseUnit;
import amf.core.client.scala.validation.AMFValidationReport;
import amf.core.internal.remote.Platform;
import amf.core.internal.remote.Spec;
import amf.validation.internal.emitters.ValidationReportJSONLDEmitter$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001\u0002\u0007\u000e\u0001YA\u0001\"\t\u0001\u0003\u0006\u0004%\tE\t\u0005\tY\u0001\u0011\t\u0011)A\u0005G!)Q\u0006\u0001C\u0001]!)\u0011\u0007\u0001C\u0001e!)A\n\u0001C\u0001\u001b\")q\r\u0001C\u0001Q\")A\u0010\u0001C\u0001{\u001e9\u00111C\u0007\t\u0002\u0005UaA\u0002\u0007\u000e\u0011\u0003\t9\u0002\u0003\u0004.\u0013\u0011\u0005\u0011\u0011\u0004\u0005\b\u00037IA\u0011AA\u000f\u0005=1\u0016\r\\5eCR,7i\\7nC:$'B\u0001\b\u0010\u0003!\u0019w.\\7b]\u0012\u001c(B\u0001\t\u0012\u0003!Ig\u000e^3s]\u0006d'B\u0001\n\u0014\u0003\r\u0019G.\u001b\u0006\u0002)\u0005\u0019\u0011-\u001c4\u0004\u0001M\u0019\u0001aF\u000f\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\r\u0005s\u0017PU3g!\tqr$D\u0001\u000e\u0013\t\u0001SBA\u0007D_6l\u0017M\u001c3IK2\u0004XM]\u0001\ta2\fGOZ8s[V\t1\u0005\u0005\u0002%U5\tQE\u0003\u0002'O\u00051!/Z7pi\u0016T!\u0001\u0005\u0015\u000b\u0005%\u001a\u0012\u0001B2pe\u0016L!aK\u0013\u0003\u0011Ac\u0017\r\u001e4pe6\f\u0011\u0002\u001d7bi\u001a|'/\u001c\u0011\u0002\rqJg.\u001b;?)\ty\u0003\u0007\u0005\u0002\u001f\u0001!)\u0011e\u0001a\u0001G\u0005\u0019!/\u001e8\u0015\u0007Mb\u0014\tE\u00025oej\u0011!\u000e\u0006\u0003me\t!bY8oGV\u0014(/\u001a8u\u0013\tATG\u0001\u0004GkR,(/\u001a\t\u00031iJ!aO\r\u0003\u0007\u0005s\u0017\u0010C\u0003>\t\u0001\u0007a(\u0001\u0007qCJ\u001cXM]\"p]\u001aLw\r\u0005\u0002\u001f\u007f%\u0011\u0001)\u0004\u0002\r!\u0006\u00148/\u001a:D_:4\u0017n\u001a\u0005\u0006\u0005\u0012\u0001\raQ\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u0011\u0005\u0011SU\"A#\u000b\u0005i1%BA$I\u0003\u0019\u0019G.[3oi*\u0011\u0011jE\u0001\u0004C6d\u0017BA&F\u0005A\tU\nT\"p]\u001aLw-\u001e:bi&|g.A\u0006gS:$G)[1mK\u000e$Hc\u0001(Z5B\u0019\u0001dT)\n\u0005AK\"AB(qi&|g\u000e\u0005\u0002S/6\t1K\u0003\u0002U+\u0006AAm\\2v[\u0016tGO\u0003\u0002W\u000b\u0006)Qn\u001c3fY&\u0011\u0001l\u0015\u0002\b\t&\fG.Z2u\u0011\u0015\u0011U\u00011\u0001D\u0011\u0015YV\u00011\u0001]\u0003\tIG\r\u0005\u0002^I:\u0011aL\u0019\t\u0003?fi\u0011\u0001\u0019\u0006\u0003CV\ta\u0001\u0010:p_Rt\u0014BA2\u001a\u0003\u0019\u0001&/\u001a3fM&\u0011QM\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\rL\u0012A\u0002:fa>\u0014H\u000f\u0006\u0003jef\\\bc\u0001\u001b8UB\u00111\u000e]\u0007\u0002Y*\u0011QN\\\u0001\u000bm\u0006d\u0017\u000eZ1uS>t'B\u0001\u000ep\u0015\t9\u0005&\u0003\u0002rY\n\u0019\u0012)\u0014$WC2LG-\u0019;j_:\u0014V\r]8si\")aK\u0002a\u0001gB\u0011Ao^\u0007\u0002k*\u0011AK\u001e\u0006\u0003-:L!\u0001_;\u0003\u0011\t\u000b7/Z+oSRDQA\u001f\u0004A\u0002y\naaY8oM&<\u0007\"\u0002\"\u0007\u0001\u0004\u0019\u0015!\u00049s_\u000e,7o](viB,H\u000fF\u0003\u007f\u0003\u001f\t\t\u0002F\u0002\u0000\u0003\u000b\u00012\u0001GA\u0001\u0013\r\t\u0019!\u0007\u0002\u0005+:LG\u000fC\u0004\u0002\b\u001d\u0001\u001d!!\u0003\u0002\u0005\u0015\u001c\u0007c\u0001\u001b\u0002\f%\u0019\u0011QB\u001b\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\b\"B4\b\u0001\u0004Q\u0007\"\u0002>\b\u0001\u0004q\u0014a\u0004,bY&$\u0017\r^3D_6l\u0017M\u001c3\u0011\u0005yI1CA\u0005\u0018)\t\t)\"A\u0003baBd\u0017\u0010F\u00020\u0003?AQ!I\u0006A\u0002\r\u0002")
public class ValidateCommand
implements CommandHelper {
    private final Platform platform;

    public static ValidateCommand apply(Platform platform2) {
        return ValidateCommand$.MODULE$.apply(platform2);
    }

    @Override
    public Future<BoxedUnit> AMFInit(AMFGraphConfiguration configuration) {
        return CommandHelper.AMFInit$(this, configuration);
    }

    @Override
    public String ensureUrl(String inputFile) {
        return CommandHelper.ensureUrl$(this, inputFile);
    }

    @Override
    public Future<AMLConfiguration> processDialects(ParserConfig config, AMLConfiguration configuration) {
        return CommandHelper.processDialects$(this, config, configuration);
    }

    @Override
    public Future<Tuple2<BaseUnit, Spec>> parseInput(ParserConfig config, AMFGraphConfiguration configuration) {
        return CommandHelper.parseInput$(this, config, configuration);
    }

    @Override
    public Future<BaseUnit> resolve(ParserConfig config, BaseUnit unit, Spec specId, AMFGraphConfiguration configuration) {
        return CommandHelper.resolve$(this, config, unit, specId, configuration);
    }

    @Override
    public Future<BoxedUnit> generateOutput(ParserConfig config, BaseUnit unit, AMFGraphConfiguration configuration) {
        return CommandHelper.generateOutput$(this, config, unit, configuration);
    }

    @Override
    public String effectiveMediaType(Option<String> mediaType, Option<String> spec) {
        return CommandHelper.effectiveMediaType$(this, mediaType, spec);
    }

    @Override
    public Spec effectiveVendor(Option<String> spec) {
        return CommandHelper.effectiveVendor$(this, spec);
    }

    @Override
    public Platform platform() {
        return this.platform;
    }

    public Future<Object> run(ParserConfig parserConfig, AMLConfiguration configuration) {
        ExecutionContext context = configuration.getExecutionContext();
        Future<Object> res = this.processDialects(parserConfig, configuration).flatMap((Function1<AMLConfiguration, Future> & Serializable & scala.Serializable)newConfig -> this.parseInput(parserConfig, (AMFGraphConfiguration)newConfig).withFilter((Function1<Tuple2<BaseUnit, Spec>, Object>)(Function1<Tuple2, Object> & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(ValidateCommand.$anonfun$run$2(check$ifrefutable$1)), context).flatMap((Function1<Tuple2, Future> & Serializable & scala.Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                BaseUnit model = (BaseUnit)tuple2._1();
                return this.report(model, parserConfig, (AMLConfiguration)newConfig).map((Function1<AMFValidationReport, Object> & Serializable & scala.Serializable)report -> {
                    this.processOutput(report, parserConfig, context);
                    return BoxedUnit.UNIT;
                }, context);
            }
            throw new MatchError(tuple2);
        }, context), context);
        res.onComplete((Function1<Try, Object> & Serializable & scala.Serializable)x0$1 -> {
            ValidateCommand.$anonfun$run$5(parserConfig, x0$1);
            return BoxedUnit.UNIT;
        }, context);
        return res;
    }

    public Option<Dialect> findDialect(AMLConfiguration configuration, String id) {
        return configuration.configurationState().getDialects().find((Function1<Dialect, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(ValidateCommand.$anonfun$findDialect$1(id, x$2)));
    }

    public Future<AMFValidationReport> report(BaseUnit model, ParserConfig config, AMLConfiguration configuration) {
        ExecutionContext executionContext = configuration.getExecutionContext();
        Future customProfileLoaded = Future$.MODULE$.apply((Function0<Tuple2> & Serializable & scala.Serializable)() -> {
            BaseUnit baseUnit = model;
            if (baseUnit instanceof DialectInstance) {
                DialectInstance dialectInstance = (DialectInstance)baseUnit;
                String definedBy = (String)dialectInstance.processingData().definedBy().option().orElse((Function0<Option> & Serializable & scala.Serializable)() -> dialectInstance.processingData().definedBy().option()).orNull(Predef$.MODULE$.$conforms());
                Option<Dialect> option = this.findDialect(configuration, definedBy);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Dialect dialect = (Dialect)some.value();
                    return new Tuple2<ProfileName, AMLConfiguration>(ProfileName$.MODULE$.apply(dialect.nameAndVersion()), configuration);
                }
                return new Tuple2<ProfileName, AMLConfiguration>(config.profile(), configuration);
            }
            return new Tuple2<ProfileName, AMLConfiguration>(config.profile(), configuration);
        }, executionContext);
        return customProfileLoaded.flatMap((Function1<Tuple2, Future> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                AMLConfiguration conf = (AMLConfiguration)tuple2._2();
                return conf.baseUnitClient().validate(model);
            }
            throw new MatchError(tuple2);
        }, executionContext);
    }

    public void processOutput(AMFValidationReport report, ParserConfig config, ExecutionContext ec) {
        String json = ValidationReportJSONLDEmitter$.MODULE$.emitJSON(report);
        Option<String> option = config.output();
        if (option instanceof Some) {
            Some some = (Some)option;
            String f = (String)some.value();
            this.platform().write(f, json, ec);
        } else if (None$.MODULE$.equals(option)) {
            config.stdout().print(json);
        } else {
            throw new MatchError(option);
        }
        if (!report.conforms()) {
            config.proc().exit(ExitCodes$.MODULE$.FailingValidation());
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$run$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$run$5(ParserConfig parserConfig$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            parserConfig$1.stderr().print(ex);
            parserConfig$1.proc().exit(ExitCodes$.MODULE$.Exception());
            return;
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            BoxedUnit other = (BoxedUnit)success.value();
            return;
        }
        throw new MatchError(try_);
    }

    public static final /* synthetic */ boolean $anonfun$findDialect$1(String id$1, Dialect x$2) {
        String string = x$2.id();
        String string2 = id$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public ValidateCommand(Platform platform2) {
        this.platform = platform2;
        CommandHelper.$init$(this);
    }
}

