/*
 * Decompiled with CFR 0.152.
 */
package amf.agentnetwork.internal.plugins.parse.schema;

import amf.shapes.internal.plugins.parser.schema.JsonSchemaBasedSpecSchema;
import scala.Predef$;
import scala.collection.immutable.StringOps;

public final class AgentNetworkSchema$
extends JsonSchemaBasedSpecSchema {
    public static AgentNetworkSchema$ MODULE$;

    static {
        new AgentNetworkSchema$();
    }

    @Override
    public String schema() {
        return new StringOps(Predef$.MODULE$.augmentString("{\"$schema\":\"http://json-schema.org/draft-07/schema#\",\"title\":\"Agent Network Specification\",\"@context\":{\"@type\":[\"http://anypoint.com/vocabs/agents#Network\"],\"@base\":\"http://anypoint.com/vocabs/agents#\"},\"type\":\"object\",\"required\":[\"schemaVersion\"],\"properties\":{\"schemaVersion\":{\"type\":\"string\",\"const\":\"1.0.0\",\"description\":\"The schema version for this file\"},\"description\":{\"type\":\"string\",\"description\":\"The description of this network\"},\"label\":{\"type\":\"string\",\"description\":\"A human readable text for this network.\"},\"tags\":{\"type\":\"array\",\"items\":{\"type\":\"string\"}},\"brokers\":{\"$ref\":\"#/definitions/Brokers\",\"description\":\"The list of brokers defined as part of this network.\"},\"connections\":{\"$ref\":\"#/definitions/Connections\",\"description\":\"The list of connections defined as part of this network.\"},\"agents\":{\"$ref\":\"#/definitions/Agents\",\"description\":\"The list of agents defined as part of this network.\"},\"mcpServers\":{\"$ref\":\"#/definitions/MCPs\",\"description\":\"The list of MCP servers defined as part of this network.\"},\"llmProviders\":{\"$ref\":\"#/definitions/LLMs\",\"description\":\"The list of LLM providers defined as part of this network.\"}},\"additionalProperties\":false,\"definitions\":{\"Agents\":{\"@context\":{\"@type\":[\"http://anypoint.com/vocabs/agents#DeclarationDefinitions\",\"http://anypoint.com/vocabs/agents/reference/kind#agent\"]},\"type\":\"object\",\"additionalProperties\":false,\"description\":\"The agent elements\",\"patternProperties\":{\"^[a-zA-Z_][a-zA-Z0-9_.-]*$\":{\"$ref\":\"#/definitions/AgentEntity\"}}},\"Brokers\":{\"@context\":{\"@type\":[\"http://anypoint.com/vocabs/agents#DeclarationDefinitions\",\"http://anypoint.com/vocabs/agents/reference/kind#agent\"]},\"type\":\"object\",\"additionalProperties\":false,\"description\":\"The brokers defined as part of this group\",\"patternProperties\":{\"^[a-zA-Z_][a-zA-Z0-9_.-]*$\":{\"$ref\":\"#/definitions/Broker\"}},\"propertyNames\":{\"not\":{\"enum\":[\"default\",\"defaults\",\"system\",\"local\",\"null\"]}}},\"LLMs\":{\"@context\":{\"@type\":[\"http://anypoint.com/vocabs/agents#DeclarationDefinitions\",\"http://anypoint.com/vocabs/agents/reference/kind#llm\"]},\"type\":\"object\",\"additionalProperties\":false,\"description\":\"The llms defined.\",\"patternProperties\":{\"^[a-zA-Z_][a-zA-Z0-9_.-]*$\":{\"$ref\":\"#/definitions/LLMEntity\"}}},\"MCPs\":{\"@context\":{\"@type\":[\"http://anypoint.com/vocabs/agents#DeclarationDefinitions\",\"http://anypoint.com/vocabs/agents/reference/kind#mcp\"]},\"type\":\"object\",\"additionalProperties\":false,\"description\":\"The mcp elements\",\"patternProperties\":{\"^[a-zA-Z_][a-zA-Z0-9_.-]*$\":{\"$ref\":\"#/definitions/MCPServerEntity\"}}},\"BrokerLLM\":{\"type\":\"object\",\"additionalProperties\":false,\"required\":[\"ref\",\"configuration\"],\"properties\":{\"ref\":{\"description\":\"The reference to the LLM to be used by the orchestrator\",\"$ref\":\"#/definitions/LLMRef\"},\"connection\":{\"type\":\"object\",\"additionalProperties\":false,\"required\":[\"ref\"],\"properties\":{\"ref\":{\"$ref\":\"#/definitions/ConnectionRef\"}}},\"configuration\":{\"type\":\"object\",\"additionalProperties\":false,\"required\":[\"model\"],\"properties\":{\"model\":{\"type\":\"string\",\"description\":\"The name of the model to use\"}}}}},\"BrokerSpec\":{\"type\":\"object\",\"additionalProperties\":false,\"required\":[\"llm\",\"instructions\",\"links\"],\"properties\":{\"llm\":{\"$ref\":\"#/definitions/BrokerLLM\"},\"instructions\":{\"type\":\"array\",\"description\":\"Set of custom instructions that will inform the orchestration\",\"items\":{\"type\":\"string\"}},\"maxNumberOfLoops\":{\"type\":\"integer\",\"description\":\"The maximum number of steps that a task can take. Useful for keeping orchestrations from running too long and consuming too many tokens\",\"default\":25},\"maxConsecutiveErrors\":{\"type\":\"integer\",\"description\":\"The maximum number of errors that the orchestrator will attempt to recover from before returning a failed status.\",\"default\":3},\"taskTimeoutSecs\":{\"type\":\"integer\",\"description\":\"A timeout (in seconds) for how long should each orchestration task \",\"default\":60},\"tools\":{\"type\":\"array\",\"description\":\"The tools available to this broker\",\"items\":{\"type\":\"object\",\"additionalProperties\":false,\"required\":[\"mcp\"],\"properties\":{\"mcp\":{\"type\":\"object\",\"additionalProperties\":false,\"required\":[\"ref\"],\"properties\":{\"ref\":{\"$ref\":\"#/definitions/MCPRef\",\"description\":\"The reference to the MCP server to be available to this broker\"},\"connection\":{\"type\":\"object\",\"additionalProperties\":false,\"description\":\"The connection to be used by this mcp\",\"required\":[\"ref\"],\"properties\":{\"ref\":{\"$ref\":\"#/definitions/ConnectionRef\"}}},\"allowed\":{\"type\":\"array\",\"description\":\"Filters the list of tools advertised by the MCP server to only those in this list. Mutually exclusive with 'denied'\",\"items\":{\"type\":\"string\"}}}}}}},\"links\":{\"description\":\"Defines the list of agents this agent is connected with\",\"items\":{\"type\":\"object\",\"additionalProperties\":false,\"required\":[\"agent\"],\"properties\":{\"agent\":{\"type\":\"object\",\"additionalProperties\":false,\"required\":[\"ref\"],\"properties\":{\"ref\":{\"$ref\":\"#/definitions/AgentRef\"},\"connection\":{\"type\":\"object\",\"description\":\"The connection to be used by this agent\",\"additionalProperties\":false,\"required\":[\"ref\"],\"properties\":{\"ref\":{\"$ref\":\"#/definitions/ConnectionRef\"}}}}}}}},\"policies\":{\"type\":\"array\",\"items\":{\"$ref\":\"#/definitions/PolicyBinding\"}}}},\"Broker\":{\"@context\":{\"@type\":[\"http://anypoint.com/vocabs/agents#Agent\",\"http://anypoint.com/vocabs/agents#Broker\"],\"@base\":\"http://anypoint.com/vocabs/agents#\"},\"type\":\"object\",\"additionalProperties\":false,\"required\":[\"card\",\"spec\"],\"properties\":{\"card\":{\"$ref\":\"#/definitions/AgentCard\"},\"spec\":{\"$ref\":\"#/definitions/BrokerSpec\"}}},\"BasicAuth\":{\"@context\":{\"@type\":[\"http://anypoint.com/vocabs/agents#BasicAuth\",\"http://anypoint.com/vocabs/agents#Authentication\"],\"@base\":\"http://anypoint.com/vocabs/agents#\"},\"type\":\"object\",\"title\":\"Basic Authentication\",\"description\":\"Properties for Basic Authentication.\",\"additionalProperties\":false,\"required\":[\"kind\",\"username\",\"password\"],\"properties\":{\"kind\":{\"const\":\"basic\",\"type\":\"string\"},\"username\":{\"type\":\"string\",\"description\":\"The username for authentication.\"},\"password\":{\"type\":\"string\",\"description\":\"The password for authentication.\"},\"headerName\":{\"type\":\"string\",\"description\":\"The name of the header where to set the key. If not specified 'Authorization' is set by default.\"}}},\"ApiKeyClientCredentialsAuth\":{\"@context\":{\"@type\":[\"http://anypoint.com/vocabs/agents#ApiKeyClientCredentialsAuth\",\"http://anypoint.com/vocabs/agents#Authentication\"],\"@base\":\"http://anypoint.com/vocabs/agents#\"},\"type\":\"object\",\"additionalProperties\":false,\"required\":[\"kind\",\"clientId\",\"clientSecret\"],\"properties\":{\"kind\":{\"const\":\"apikey-client-credentials\",\"type\":\"string\"},\"clientId\":{\"type\":\"object\",\"description\":\"The client ID.\",\"additionalProperties\":false,\"required\":[\"value\"],\"properties\":{\"value\":{\"type\":\"string\",\"description\":\"The value for the clientId\"},\"name\":{\"type\":\"string\",\"description\":\"The name for the clientId by default is going to be 'client_id'\"}}},\"clientSecret\":{\"type\":\"object\",\"description\":\"The client secret.\",\"additionalProperties\":false,\"required\":[\"value\"],\"properties\":{\"value\":{\"type\":\"string\",\"description\":\"The value for the clientSecret\"},\"name\":{\"type\":\"string\",\"description\":\"The name for the clientSecret by default is going to be 'client_secret'\"}}}}},\"APIKeyAuth\":{\"@context\":{\"@type\":[\"http://anypoint.com/vocabs/agents#APIKeyAuth\",\"http://anypoint.com/vocabs/agents#Authentication\"],\"@base\":\"http://anypoint.com/vocabs/agents#\"},\"type\":\"object\",\"additionalProperties\":false,\"required\":[\"value\"],\"properties\":{\"kind\":{\"const\":\"apiKey\",\"type\":\"string\"},\"headerName\":{\"description\":\"The name of the header to be used. If not specified Authorization is used.\",\"type\":\"string\"},\"apiKey\":{\"type\":\"string\",\"description\":\"The value of the apiKey\"}}},\"OAuth2ClientCredentialsAuth\":{\"@context\":{\"@type\":[\"http://anypoint.com/vocabs/agents#OAuth2ClientCredentialsAuth\",\"http://anypoint.com/vocabs/agents#Authentication\"],\"@base\":\"http://anypoint.com/vocabs/agents#\"},\"type\":\"object\",\"additionalProperties\":false,\"required\":[\"kind\",\"clientId\",\"clientSecret\",\"token\"],\"title\":\"OAuth 2.0 Client Credentials Grant\",\"description\":\"Properties for the OAuth 2.0 Client Credentials Grant Type.\",\"properties\":{\"kind\":{\"const\":\"oauth2-client-credentials\",\"type\":\"string\"},\"clientId\":{\"type\":\"string\",\"description\":\"The client ID.\"},\"clientSecret\":{\"type\":\"string\",\"description\":\"The client secret.\"},\"token\":{\"type\":\"object\",\"description\":\"Configuration on how to fetch the token.\",\"required\":[\"url\"],\"properties\":{\"url\":{\"type\":\"string\",\"description\":\"The url of the token provider\"},\"timeout\":{\"type\":\"number\",\"description\":\"Time in seconds to wait for the service to return the token.\"},\"bodyEncoding\":{\"type\":\"string\",\"enum\":[\"form\",\"json\"]}}},\"scopes\":{\"type\":\"array\",\"items\":{\"type\":\"string\"},\"description\":\"An array of scopes to request.\"}}},\"Authentication\":{\"@context\":{\"@type\":[\"http://anypoint.com/vocabs/agents#Authentication\"],\"@base\":\"http://anypoint.com/vocabs/agents#\"},\"anyOf\":[{\"$ref\":\"#/definitions/OAuth2ClientCredentialsAuth\"},{\"$ref\":\"#/definitions/BasicAuth\"},{\"$ref\":\"#/definitions/ApiKeyClientCredentialsAuth\"},{\"$ref\":\"#/definitions/APIKeyAuth\"}]},\"AgentConnection\":{\"@context\":{\"@type\":[\"http://anypoint.com/vocabs/agents#Connection\",\"http://anypoint.com/vocabs/agents#AgentConnection\"],\"@base\":\"http://anypoint.com/vocabs/agents#\"},\"type\":\"object\",\"additionalProperties\":false,\"description\":\"Defines an agent that exists outside of this domain\",\"required\":[\"kind\",\"ref\",\"spec\"],\"properties\":{\"kind\":{\"const\":\"agent\",\"type\":\"string\"},\"ref\":{\"$ref\":\"#/definitions/AgentRef\"},\"spec\":{\"type\":\"object\",\"additionalProperties\":false,\"required\":[\"url\"],\"properties\":{\"url\":{\"type\":\"string\"},\"authentication\":{\"$ref\":\"#/definitions/Authentication\"},\"policies\":{\"type\":\"array\",\"items\":{\"$ref\":\"#/definitions/PolicyBinding\"}}}}}},\"LLMConnection\":{\"@context\":{\"@type\":[\"http://anypoint.com/vocabs/agents#Connection\",\"http://anypoint.com/vocabs/agents#LLMConnection\"],\"@base\":\"http://anypoint.com/vocabs/agents#\"},\"type\":\"object\",\"additionalProperties\":false,\"description\":\"Configuration for using Salesforce Einstein as the reasoning LLM\",\"required\":[\"kind\",\"ref\",\"spec\"],\"properties\":{\"kind\":{\"const\":\"llm\",\"type\":\"string\"},\"ref\":{\"$ref\":\"#/definitions/LLMRef\"},\"spec\":{\"type\":\"object\",\"additionalProperties\":false,\"required\":[\"url\",\"configuration\"],\"properties\":{\"url\":{\"type\":\"string\"},\"configuration\":{\"type\":\"object\"},\"policies\":{\"type\":\"array\",\"items\":{\"$ref\":\"#/definitions/PolicyBinding\"}}}}}},\"MCPServerConnection\":{\"@context\":{\"@type\":[\"http://anypoint.com/vocabs/agents#Connection\",\"http://anypoint.com/vocabs/agents#MCPServerConnection\"],\"@base\":\"http://anypoint.com/vocabs/agents#\"},\"type\":\"object\",\"additionalProperties\":false,\"required\":[\"spec\",\"ref\",\"kind\"],\"properties\":{\"kind\":{\"const\":\"mcp\",\"type\":\"string\"},\"ref\":{\"$ref\":\"#/definitions/MCPRef\"},\"spec\":{\"type\":\"object\",\"additionalProperties\":false,\"properties\":{\"url\":{\"type\":\"string\",\"description\":\"The base URL for the MCP server\"},\"authentication\":{\"$ref\":\"#/definitions/Authentication\",\"description\":\"The Authentication to use when connecting to the MCP server\"},\"policies\":{\"type\":\"array\",\"items\":{\"$ref\":\"#/definitions/PolicyBinding\"}}}}}},\"PolicyBinding\":{\"@context\":{\"@type\":[\"http://anypoint.com/vocabs/agents#PolicyBinding\"]},\"description\":\"The policy to be applied\",\"type\":\"object\",\"additionalProperties\":false,\"required\":[\"ref\",\"configuration\"],\"properties\":{\"ref\":{\"$ref\":\"#/definitions/PolicyRef\"},\"configuration\":{\"type\":\"object\"}}},\"ConnectionElement\":{\"@context\":{\"@type\":[\"http://anypoint.com/vocabs/agents#Connection\"],\"@base\":\"http://anypoint.com/vocabs/agents#\"},\"oneOf\":[{\"$ref\":\"#/definitions/LLMConnection\"},{\"$ref\":\"#/definitions/AgentConnection\"},{\"$ref\":\"#/definitions/MCPServerConnection\"}]},\"Connections\":{\"@context\":{\"@type\":[\"http://anypoint.com/vocabs/agents#DeclarationDefinitions\",\"http://anypoint.com/vocabs/agents/reference/kind#connection\"]},\"description\":\"The registry elements\",\"type\":\"object\",\"additionalProperties\":false,\"patternProperties\":{\"^[a-zA-Z_][a-zA-Z0-9_.-]*$\":{\"$ref\":\"#/definitions/ConnectionElement\"}}},\"AgentEntity\":{\"@context\":{\"@type\":[\"http://anypoint.com/vocabs/agents#Agent\"],\"@base\":\"http://anypoint.com/vocabs/agents#\"},\"type\":\"object\",\"additionalProperties\":false,\"required\":[\"metadata\"],\"properties\":{\"label\":{\"type\":\"string\",\"description\":\"A label for this agent\"},\"description\":{\"type\":\"string\",\"description\":\"A description for this agent\"},\"tags\":{\"type\":\"array\",\"items\":{\"type\":\"string\"}},\"card\":{\"$ref\":\"#/definitions/AgentCard\"},\"metadata\":{\"type\":\"object\",\"additionalProperties\":false,\"required\":[\"protocol\"],\"properties\":{\"platform\":{\"type\":\"string\",\"description\":\"The name of the platform this agent is running on. i.e Bedrock, AgentForce, etc.\"},\"protocol\":{\"type\":\"string\",\"enum\":[\"a2a\",\"other\"],\"description\":\"The name of the protocol. For example a2a\"},\"links\":{\"description\":\"Defines the list of agents this agent is connected with\",\"items\":{\"type\":\"object\",\"additionalProperties\":false,\"required\":[\"agent\"],\"properties\":{\"agent\":{\"type\":\"object\",\"additionalProperties\":false,\"required\":[\"ref\"],\"properties\":{\"ref\":{\"$ref\":\"#/definitions/AgentRef\"}}}}}},\"tools\":{\"description\":\"Defines the list of tools this agent is connected with\",\"items\":{\"type\":\"object\",\"additionalProperties\":false,\"required\":[\"mcp\"],\"properties\":{\"mcp\":{\"type\":\"object\",\"required\":[\"ref\"],\"additionalProperties\":false,\"properties\":{\"ref\":{\"$ref\":\"#/definitions/MCPRef\"},\"allowed\":{\"type\":\"array\",\"items\":{\"type\":\"string\"}}}}}}}}},\"additionalProperties\":false}},\"LLMMetadata\":{\"@context\":{\"@type\":[\"http://anypoint.com/vocabs/agents#LLMMetadata\"],\"@base\":\"http://anypoint.com/vocabs/agents#\"},\"oneOf\":[{\"$ref\":\"#/definitions/WellKnownLLM\"},{\"$ref\":\"#/definitions/CustomLLM\"}]},\"WellKnownLLM\":{\"@context\":{\"@type\":[\"http://anypoint.com/vocabs/agents#LLMMetadata\",\"http://anypoint.com/vocabs/agents#WellKnownLLMMetadata\"],\"@base\":\"http://anypoint.com/vocabs/agents#\"},\"type\":\"object\",\"additionalProperties\":false,\"required\":[\"platform\"],\"properties\":{\"platform\":{\"type\":\"string\",\"enum\":[\"OpenAI\",\"AzureOpenai\"]},\"models\":{\"type\":\"array\",\"items\":{\"type\":\"string\"}}}},\"CustomLLM\":{\"@context\":{\"@type\":[\"http://anypoint.com/vocabs/agents#LLMMetadata\",\"http://anypoint.com/vocabs/agents#CustomLLMMetadata\"],\"@base\":\"http://anypoint.com/vocabs/agents#\"},\"type\":\"object\",\"additionalProperties\":false,\"required\":[\"transcoder\",\"platform\"],\"properties\":{\"platform\":{\"type\":\"string\"},\"models\":{\"type\":\"array\",\"items\":{\"type\":\"string\"}},\"transcoder\":{\"type\":\"object\",\"additionalProperties\":false,\"properties\":{\"ref\":{\"$ref\":\"#/definitions/PolicyRef\"}}}}},\"LLMEntity\":{\"@context\":{\"@type\":[\"http://anypoint.com/vocabs/agents#LLM\"],\"@base\":\"http://anypoint.com/vocabs/agents#\"},\"type\":\"object\",\"additionalProperties\":false,\"required\":[\"metadata\"],\"properties\":{\"label\":{\"type\":\"string\",\"description\":\"A label for this MCP\"},\"description\":{\"type\":\"string\",\"description\":\"The description of this llm\"},\"metadata\":{\"$ref\":\"#/definitions/LLMMetadata\"}}},\"MCPServerEntity\":{\"@context\":{\"@type\":[\"http://anypoint.com/vocabs/agents#MCPServer\"],\"@base\":\"http://anypoint.com/vocabs/agents#\"},\"description\":\"The definition of the MCP Server entity\",\"type\":\"object\",\"additionalProperties\":false,\"required\":[\"metadata\"],\"properties\":{\"label\":{\"type\":\"string\",\"description\":\"A label for this MCP\"},\"description\":{\"type\":\"string\"},\"tags\":{\"type\":\"array\",\"items\":{\"type\":\"string\"}},\"metadata\":{\"$ref\":\"#/definitions/MCPServer\"}}},\"ToolAnnotations\":{\"description\":\"Additional properties describing a Tool to clients.\\n\\nNOTE: all properties in ToolAnnotations are **hints**.\\nThey are not guaranteed to provide a faithful description of\\ntool behavior (including descriptive properties like `title`).\\n\\nClients should never make tool use decisions based on ToolAnnotations\\nreceived from untrusted servers.\",\"properties\":{\"destructiveHint\":{\"description\":\"If true, the tool may perform destructive updates to its environment.\\nIf false, the tool performs only additive updates.\\n\\n(This property is meaningful only when `readOnlyHint == false`)\\n\\nDefault: true\",\"type\":\"boolean\"},\"idempotentHint\":{\"description\":\"If true, calling the tool repeatedly with the same arguments\\nwill have no additional effect on the its environment.\\n\\n(This property is meaningful only when `readOnlyHint == false`)\\n\\nDefault: false\",\"type\":\"boolean\"},\"openWorldHint\":{\"description\":\"If true, this tool may interact with an \\\"open world\\\" of external\\nentities. If false, the tool's domain of interaction is closed.\\nFor example, the world of a web search tool is open, whereas that\\nof a memory tool is not.\\n\\nDefault: true\",\"type\":\"boolean\"},\"readOnlyHint\":{\"description\":\"If true, the tool does not modify its environment.\\n\\nDefault: false\",\"type\":\"boolean\"},\"title\":{\"description\":\"A human-readable title for the tool.\",\"type\":\"string\"}},\"type\":\"object\"},\"Prompt\":{\"@context\":{\"@type\":[\"http://anypoint.com/vocabs/mcp#Prompt\"]},\"description\":\"A prompt or prompt template that the server offers.\",\"properties\":{\"arguments\":{\"description\":\"A list of arguments to use for templating the prompt.\",\"items\":{\"$ref\":\"#/definitions/PromptArgument\"},\"type\":\"array\"},\"description\":{\"description\":\"An optional description of what this prompt provides\",\"type\":\"string\"},\"name\":{\"description\":\"The name of the prompt or prompt template.\",\"type\":\"string\"}},\"required\":[\"name\"],\"type\":\"object\"},\"PromptArgument\":{\"@context\":{\"@type\":[\"http://anypoint.com/vocabs/mcp#PromptArgument\"]},\"description\":\"Describes an argument that a prompt can accept.\",\"properties\":{\"description\":{\"description\":\"A human-readable description of the argument.\",\"type\":\"string\"},\"name\":{\"description\":\"The name of the argument.\",\"type\":\"string\"},\"required\":{\"description\":\"Whether this argument must be provided.\",\"type\":\"boolean\"}},\"required\":[\"name\"],\"type\":\"object\"},\"Resource\":{\"@context\":{\"@type\":[\"http://anypoint.com/vocabs/mcp#Resource\"]},\"description\":\"A known resource that the server is capable of reading.\",\"properties\":{\"annotations\":{\"$ref\":\"#/definitions/Annotations\",\"description\":\"Optional annotations for the client.\"},\"description\":{\"description\":\"A description of what this resource represents.\\n\\nThis can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a \\\"hint\\\" to the model.\",\"type\":\"string\"},\"mimeType\":{\"description\":\"The MIME type of this resource, if known.\",\"type\":\"string\"},\"name\":{\"description\":\"A human-readable name for this resource.\\n\\nThis can be used by clients to populate UI elements.\",\"type\":\"string\"},\"size\":{\"description\":\"The size of the raw resource content, in bytes (i.e., before base64 encoding or any tokenization), if known.\\n\\nThis can be used by Hosts to display file sizes and estimate context window usage.\",\"type\":\"integer\"},\"uri\":{\"description\":\"The URI of this resource.\",\"format\":\"uri\",\"type\":\"string\"}},\"required\":[\"name\",\"uri\"],\"type\":\"object\"},\"Annotations\":{\"description\":\"Optional annotations for the client. The client can use annotations to inform how objects are used or displayed\",\"properties\":{\"audience\":{\"description\":\"Describes who the intended customer of this object or data is.\\n\\nIt can include multiple entries to indicate content useful for multiple audiences (e.g., `[\\\"user\\\", \\\"assistant\\\"]`).\",\"items\":{\"$ref\":\"#/definitions/Role\"},\"type\":\"array\"},\"priority\":{\"description\":\"Describes how important this data is for operating the server.\\n\\nA value of 1 means \\\"most important,\\\" and indicates that the data is\\neffectively required, while 0 means \\\"least important,\\\" and indicates that\\nthe data is entirely optional.\",\"maximum\":1,\"minimum\":0,\"type\":\"number\"}},\"type\":\"object\"},\"Role\":{\"description\":\"The sender or recipient of messages and data in a conversation.\",\"enum\":[\"assistant\",\"user\"],\"type\":\"string\"},\"Tool\":{\"@context\":{\"@type\":[\"http://anypoint.com/vocabs/mcp#Tool\"]},\"description\":\"Definition for a tool the client can call.\",\"properties\":{\"annotations\":{\"$ref\":\"#/definitions/ToolAnnotations\",\"description\":\"Optional additional tool information.\"},\"description\":{\"description\":\"A human-readable description of the tool.\\n\\nThis can be used by clients to improve the LLM's understanding of available tools. It can be thought of like a \\\"hint\\\" to the model.\",\"type\":\"string\"},\"inputSchema\":{\"@context\":{\"@type\":[\"http://anypoint.com/vocabs/mcp#ToolInputSchema\"]},\"description\":\"A JSON Schema object defining the expected parameters for the tool.\",\"properties\":{\"properties\":{\"additionalProperties\":{\"additionalProperties\":true,\"properties\":{},\"type\":\"object\"},\"type\":\"object\"},\"required\":{\"items\":{\"type\":\"string\"},\"type\":\"array\"},\"type\":{\"const\":\"object\",\"type\":\"string\"}},\"required\":[\"type\"],\"type\":\"object\"},\"name\":{\"description\":\"The name of the tool.\",\"type\":\"string\"}},\"required\":[\"inputSchema\",\"name\"],\"type\":\"object\"},\"SseTransport\":{\"@context\":{\"@type\":[\"http://anypoint.com/vocabs/mcp#Transport\",\"http://anypoint.com/vocabs/mcp#SseTransport\"],\"@base\":\"http://anypoint.com/vocabs/mcp#\"},\"required\":[\"kind\",\"ssePath\"],\"properties\":{\"kind\":{\"type\":\"string\",\"const\":\"sse\"},\"ssePath\":{\"type\":\"string\",\"description\":\"Path to the SSE endpoint\"},\"messagesPath\":{\"type\":\"string\",\"description\":\"Path to the messages endpoint\"}},\"additionalProperties\":false},\"StreamableHttpTransport\":{\"@context\":{\"@type\":[\"http://anypoint.com/vocabs/mcp#Transport\",\"http://anypoint.com/vocabs/mcp#StreamableHttpTransport\"],\"@base\":\"http://anypoint.com/vocabs/agents#\"},\"required\":[\"kind\"],\"properties\":{\"kind\":{\"type\":\"string\",\"const\":\"streamableHttp\"},\"path\":{\"type\":\"string\",\"description\":\"Path to the mcp endpoint\"}},\"additionalProperties\":false},\"MCPTransport\":{\"type\":\"object\",\"oneOf\":[{\"$ref\":\"#/definitions/SseTransport\"},{\"$ref\":\"#/definitions/StreamableHttpTransport\"}]},\"MCPProvider\":{\"description\":\"Represents the service provider of an MCP server.\",\"examples\":[{\"organization\":\"Google\",\"url\":\"https://ai.google.dev\"}],\"properties\":{\"organization\":{\"description\":\"MCP provider's organization name.\",\"type\":\"string\"},\"url\":{\"description\":\"MCP provider's URL.\",\"type\":\"string\"}},\"required\":[\"organization\",\"url\"],\"type\":\"object\"},\"MCPServer\":{\"@context\":{\"@type\":[\"http://anypoint.com/vocabs/mcp#Server\"]},\"type\":\"object\",\"required\":[\"transport\"],\"properties\":{\"protocolVersion\":{\"type\":\"string\",\"enum\":[\"2024-11-05\",\"2025-03-26\"],\"description\":\"The version of the protocol being used. This is used to determine the structure and capabilities of the data.\"},\"introspectedAt\":{\"type\":\"string\",\"description\":\"Timestamp when the introspection was performed\"},\"connectionStatus\":{\"type\":\"string\",\"description\":\"Status of the connection to the MCP server\",\"enum\":[\"success\",\"failed\",\"error\"]},\"transport\":{\"$ref\":\"#/definitions/MCPTransport\",\"description\":\"The transport protocol used for communication. This defines how the data is transmitted between the client and server.\"},\"provider\":{\"$ref\":\"#/definitions/MCPProvider\",\"description\":\"The service provider of the MCP server.\"},\"capabilities\":{\"type\":\"object\",\"description\":\"Boolean flags indicating which capabilities the server supports\",\"required\":[\"tools\",\"resources\",\"prompts\",\"logging\"],\"properties\":{\"tools\":{\"type\":\"boolean\",\"description\":\"Whether the server supports tools\"},\"resources\":{\"type\":\"boolean\",\"description\":\"Whether the server supports resources\"},\"prompts\":{\"type\":\"boolean\",\"description\":\"Whether the server supports prompts\"},\"logging\":{\"type\":\"boolean\",\"description\":\"Whether the server supports logging\"}},\"additionalProperties\":false},\"logging\":{\"type\":\"object\",\"properties\":{},\"description\":\"Present if the server supports sending log messages to the client.\",\"additionalProperties\":true},\"tools\":{\"type\":\"array\",\"items\":{\"$ref\":\"#/definitions/Tool\"},\"description\":\"A list of tools available in the mcp api. Each tool has a name, description, and input schema that defines the expected input format.\"},\"resources\":{\"type\":\"array\",\"items\":{\"$ref\":\"#/definitions/Resource\"},\"description\":\"A list of resources available in the mcp api. Each resource has a URI, name, description, MIME type, and annotations that provide additional metadata.\"},\"prompts\":{\"type\":\"array\",\"items\":{\"$ref\":\"#/definitions/Prompt\"},\"description\":\"A list of prompts available in the mcp api. Each prompt has a name, description, and arguments that define the expected input format for the prompt.\"},\"platform\":{\"type\":\"string\",\"description\":\"The platform the mcp server is running\"},\"securitySchemes\":{\"additionalProperties\":{\"$ref\":\"#/definitions/SecurityScheme\"},\"description\":\"Security scheme details used for authenticating with this agent.\",\"type\":\"object\"},\"additionalProperties\":false}},\"PolicyRef\":{\"@context\":{\"@type\":[\"http://anypoint.com/vocabs/agents#Reference\",\"http://anypoint.com/vocabs/agents/reference/kind#policy\"],\"@base\":\"http://anypoint.com/vocabs/agents#\"},\"type\":\"object\",\"additionalProperties\":false,\"required\":[\"name\"],\"properties\":{\"name\":{\"type\":\"string\"},\"namespace\":{\"type\":\"string\"}}},\"LLMRef\":{\"@context\":{\"@type\":[\"http://anypoint.com/vocabs/agents#Reference\",\"http://anypoint.com/vocabs/agents/reference/kind#llm\"],\"@base\":\"http://anypoint.com/vocabs/agents#\"},\"description\":\"A reference to an LLM Provider\",\"type\":\"object\",\"additionalProperties\":false,\"required\":[\"name\"],\"properties\":{\"name\":{\"type\":\"string\"},\"namespace\":{\"type\":\"string\"}}},\"AgentRef\":{\"description\":\"A Reference to an Agent\",\"@context\":{\"@type\":[\"http://anypoint.com/vocabs/agents#Reference\",\"http://anypoint.com/vocabs/agents/reference/kind#agent\"],\"@base\":\"http://anypoint.com/vocabs/agents#\"},\"type\":\"object\",\"additionalProperties\":false,\"required\":[\"name\"],\"properties\":{\"name\":{\"type\":\"string\"},\"namespace\":{\"type\":\"string\"}}},\"MCPRef\":{\"@context\":{\"@type\":[\"http://anypoint.com/vocabs/agents#Reference\",\"http://anypoint.com/vocabs/agents/reference/kind#mcp\"],\"@base\":\"http://anypoint.com/vocabs/agents#\"},\"description\":\"Reference to an MCP Server.\",\"type\":\"object\",\"additionalProperties\":false,\"required\":[\"name\"],\"properties\":{\"name\":{\"type\":\"string\"},\"namespace\":{\"type\":\"string\"}}},\"ConnectionRef\":{\"@context\":{\"@type\":[\"http://anypoint.com/vocabs/agents#Reference\",\"http://anypoint.com/vocabs/agents/reference/kind#connection\"],\"@base\":\"http://anypoint.com/vocabs/agents#\"},\"description\":\"The reference to a connection\",\"type\":\"object\",\"additionalProperties\":false,\"required\":[\"name\"],\"properties\":{\"name\":{\"type\":\"string\"}}},\"AgentCardSignature\":{\"description\":\"AgentCardSignature represents a JWS signature of an AgentCard.\\nThis follows the JSON format of an RFC 7515 JSON Web Signature (JWS).\",\"properties\":{\"header\":{\"additionalProperties\":{},\"description\":\"The unprotected JWS header values.\",\"type\":\"object\"},\"protected\":{\"description\":\"The protected JWS header for the signature. This is a Base64url-encoded\\nJSON object, as per RFC 7515.\",\"type\":\"string\"},\"signature\":{\"description\":\"The computed signature, Base64url-encoded.\",\"type\":\"string\"}},\"required\":[\"protected\",\"signature\"],\"type\":\"object\"},\"AgentProvider\":{\"description\":\"Represents the service provider of an agent.\",\"examples\":[{\"organization\":\"Google\",\"url\":\"https://ai.google.dev\"}],\"properties\":{\"organization\":{\"description\":\"The name of the agent provider's organization.\",\"type\":\"string\"},\"url\":{\"description\":\"A URL for the agent provider's website or relevant documentation.\",\"type\":\"string\"}},\"required\":[\"organization\",\"url\"],\"type\":\"object\"},\"AgentSkill\":{\"description\":\"Represents a distinct capability or function that an agent can perform.\",\"properties\":{\"description\":{\"description\":\"A detailed description of the skill, intended to help clients or users\\nunderstand its purpose and functionality.\",\"type\":\"string\"},\"examples\":{\"description\":\"Example prompts or scenarios that this skill can handle. Provides a hint to\\nthe client on how to use the skill.\",\"examples\":[[\"I need a recipe for bread\"]],\"items\":{\"type\":\"string\"},\"type\":\"array\"},\"id\":{\"description\":\"A unique identifier for the agent's skill.\",\"type\":\"string\"},\"inputModes\":{\"description\":\"The set of supported input MIME types for this skill, overriding the agent's defaults.\",\"items\":{\"type\":\"string\"},\"type\":\"array\"},\"name\":{\"description\":\"A human-readable name for the skill.\",\"type\":\"string\"},\"outputModes\":{\"description\":\"The set of supported output MIME types for this skill, overriding the agent's defaults.\",\"items\":{\"type\":\"string\"},\"type\":\"array\"},\"security\":{\"description\":\"Security schemes necessary for the agent to leverage this skill.\\nAs in the overall AgentCard.security, this list represents a logical OR of security\\nrequirement objects. Each object is a set of security schemes that must be used together\\n(a logical AND).\",\"examples\":[[{\"google\":[\"oidc\"]}]],\"items\":{\"additionalProperties\":{\"items\":{\"type\":\"string\"},\"type\":\"array\"},\"type\":\"object\"},\"type\":\"array\"},\"tags\":{\"description\":\"A set of keywords describing the skill's capabilities.\",\"examples\":[[\"cooking\",\"customer support\",\"billing\"]],\"items\":{\"type\":\"string\"},\"type\":\"array\"}},\"required\":[\"description\",\"id\",\"name\",\"tags\"],\"type\":\"object\"},\"AgentExtension\":{\"description\":\"A declaration of a protocol extension supported by an Agent.\",\"examples\":[{\"description\":\"Google OAuth 2.0 authentication\",\"required\":false,\"uri\":\"https://developers.google.com/identity/protocols/oauth2\"}],\"properties\":{\"description\":{\"description\":\"A human-readable description of how this agent uses the extension.\",\"type\":\"string\"},\"params\":{\"additionalProperties\":{},\"description\":\"Optional, extension-specific configuration parameters.\",\"type\":\"object\"},\"required\":{\"description\":\"If true, the client must understand and comply with the extension's requirements\\nto interact with the agent.\",\"type\":\"boolean\"},\"uri\":{\"description\":\"The unique URI identifying the extension.\",\"type\":\"string\"}},\"required\":[\"uri\"],\"type\":\"object\"},\"AgentCapabilities\":{\"description\":\"Defines optional capabilities supported by an agent.\",\"properties\":{\"extensions\":{\"description\":\"A list of protocol extensions supported by the agent.\",\"items\":{\"$ref\":\"#/definitions/AgentExtension\"},\"type\":\"array\"},\"pushNotifications\":{\"description\":\"Indicates if the agent supports sending push notifications for asynchronous task updates.\",\"type\":\"boolean\"},\"stateTransitionHistory\":{\"description\":\"Indicates if the agent provides a history of state transitions for a task.\",\"type\":\"boolean\"},\"streaming\":{\"description\":\"Indicates if the agent supports Server-Sent Events (SSE) for streaming responses.\",\"type\":\"boolean\"}},\"type\":\"object\"},\"AgentCard\":{\"description\":\"The AgentCard is a self-describing manifest for an agent. It provides essential\\nmetadata including the agent's identity, capabilities, skills, supported\\ncommunication methods, and security requirements.\",\"properties\":{\"additionalInterfaces\":{\"description\":\"A list of additional supported interfaces (transport and URL combinations).\\nThis allows agents to expose multiple transports, potentially at different URLs.\\n\\nBest practices:\\n- SHOULD include all supported transports for completeness\\n- SHOULD include an entry matching the main 'url' and 'preferredTransport'\\n- MAY reuse URLs if multiple transports are available at the same endpoint\\n- MUST accurately declare the transport available at each URL\\n\\nClients can select any interface from this list based on their transport capabilities\\nand preferences. This enables transport negotiation and fallback scenarios.\",\"items\":{\"$ref\":\"#/definitions/AgentInterface\"},\"type\":\"array\"},\"capabilities\":{\"$ref\":\"#/definitions/AgentCapabilities\",\"description\":\"A declaration of optional capabilities supported by the agent.\"},\"defaultInputModes\":{\"description\":\"Default set of supported input MIME types for all skills, which can be\\noverridden on a per-skill basis.\",\"items\":{\"type\":\"string\"},\"type\":\"array\"},\"defaultOutputModes\":{\"description\":\"Default set of supported output MIME types for all skills, which can be\\noverridden on a per-skill basis.\",\"items\":{\"type\":\"string\"},\"type\":\"array\"},\"description\":{\"description\":\"A human-readable description of the agent, assisting users and other agents\\nin understanding its purpose.\",\"examples\":[\"Agent that helps users with recipes and cooking.\"],\"type\":\"string\"},\"documentationUrl\":{\"description\":\"An optional URL to the agent's documentation.\",\"type\":\"string\"},\"iconUrl\":{\"description\":\"An optional URL to an icon for the agent.\",\"type\":\"string\"},\"name\":{\"description\":\"A human-readable name for the agent.\",\"examples\":[\"Recipe Agent\"],\"type\":\"string\"},\"preferredTransport\":{\"default\":\"JSONRPC\",\"description\":\"The transport protocol for the preferred endpoint (the main 'url' field).\\nIf not specified, defaults to 'JSONRPC'.\\n\\nIMPORTANT: The transport specified here MUST be available at the main 'url'.\\nThis creates a binding between the main URL and its supported transport protocol.\\nClients should prefer this transport and URL combination when both are supported.\",\"examples\":[\"JSONRPC\",\"GRPC\",\"HTTP+JSON\"],\"type\":\"string\"},\"protocolVersion\":{\"default\":\"0.3.0\",\"description\":\"The version of the A2A protocol this agent supports.\",\"type\":\"string\"},\"provider\":{\"$ref\":\"#/definitions/AgentProvider\",\"description\":\"Information about the agent's service provider.\"},\"security\":{\"description\":\"A list of security requirement objects that apply to all agent interactions. Each object\\nlists security schemes that can be used. Follows the OpenAPI 3.0 Security Requirement Object.\\nThis list can be seen as an OR of ANDs. Each object in the list describes one possible\\nset of security requirements that must be present on a request. This allows specifying,\\nfor example, \\\"callers must either use OAuth OR an API Key AND mTLS.\\\"\",\"examples\":[[{\"oauth\":[\"read\"]},{\"api-key\":[],\"mtls\":[]}]],\"items\":{\"additionalProperties\":{\"items\":{\"type\":\"string\"},\"type\":\"array\"},\"type\":\"object\"},\"type\":\"array\"},\"securitySchemes\":{\"additionalProperties\":{\"$ref\":\"#/definitions/SecurityScheme\"},\"description\":\"A declaration of the security schemes available to authorize requests. The key is the\\nscheme name. Follows the OpenAPI 3.0 Security Scheme Object.\",\"type\":\"object\"},\"signatures\":{\"description\":\"JSON Web Signatures computed for this AgentCard.\",\"items\":{\"$ref\":\"#/definitions/AgentCardSignature\"},\"type\":\"array\"},\"skills\":{\"description\":\"The set of skills, or distinct capabilities, that the agent can perform.\",\"items\":{\"$ref\":\"#/definitions/AgentSkill\"},\"type\":\"array\"},\"supportsAuthenticatedExtendedCard\":{\"description\":\"If true, the agent can provide an extended agent card with additional details\\nto authenticated users. Defaults to false.\",\"type\":\"boolean\"},\"url\":{\"description\":\"The preferred endpoint URL for interacting with the agent.\\nThis URL MUST support the transport specified by 'preferredTransport'.\",\"examples\":[\"https://api.example.com/a2a/v1\"],\"type\":\"string\"},\"version\":{\"description\":\"The agent's own version number. The format is defined by the provider.\",\"examples\":[\"1.0.0\"],\"type\":\"string\"}},\"required\":[\"capabilities\",\"defaultInputModes\",\"defaultOutputModes\",\"description\",\"name\",\"protocolVersion\",\"skills\",\"url\",\"version\"],\"type\":\"object\"},\"AgentInterface\":{\"description\":\"Declares a combination of a target URL and a transport protocol for interacting with the agent.\\nThis allows agents to expose the same functionality over multiple transport mechanisms.\",\"properties\":{\"transport\":{\"description\":\"The transport protocol supported at this URL.\",\"examples\":[\"JSONRPC\",\"GRPC\",\"HTTP+JSON\"],\"type\":\"string\"},\"url\":{\"description\":\"The URL where this interface is available. Must be a valid absolute HTTPS URL in production.\",\"examples\":[\"https://api.example.com/a2a/v1\",\"https://grpc.example.com/a2a\",\"https://rest.example.com/v1\"],\"type\":\"string\"}},\"required\":[\"transport\",\"url\"],\"type\":\"object\"},\"SecurityScheme\":{\"anyOf\":[{\"$ref\":\"#/definitions/APIKeySecurityScheme\"},{\"$ref\":\"#/definitions/HTTPAuthSecurityScheme\"},{\"$ref\":\"#/definitions/OAuth2SecurityScheme\"},{\"$ref\":\"#/definitions/OpenIdConnectSecurityScheme\"},{\"$ref\":\"#/definitions/MutualTLSSecurityScheme\"}],\"description\":\"Defines a security scheme that can be used to secure an agent's endpoints.\\nThis is a discriminated union type based on the OpenAPI 3.0 Security Scheme Object.\"},\"APIKeySecurityScheme\":{\"description\":\"Defines a security scheme using an API key.\",\"properties\":{\"description\":{\"description\":\"An optional description for the security scheme.\",\"type\":\"string\"},\"in\":{\"description\":\"The location of the API key.\",\"enum\":[\"cookie\",\"header\",\"query\"],\"type\":\"string\"},\"name\":{\"description\":\"The name of the header, query, or cookie parameter to be used.\",\"type\":\"string\"},\"type\":{\"const\":\"apiKey\",\"description\":\"The type of the security scheme. Must be 'apiKey'.\",\"type\":\"string\"}},\"required\":[\"in\",\"name\",\"type\"],\"type\":\"object\"},\"HTTPAuthSecurityScheme\":{\"description\":\"Defines a security scheme using HTTP authentication.\",\"properties\":{\"bearerFormat\":{\"description\":\"A hint to the client to identify how the bearer token is formatted (e.g., \\\"JWT\\\").\\nThis is primarily for documentation purposes.\",\"type\":\"string\"},\"description\":{\"description\":\"An optional description for the security scheme.\",\"type\":\"string\"},\"scheme\":{\"description\":\"The name of the HTTP Authentication scheme to be used in the Authorization header,\\nas defined in RFC7235 (e.g., \\\"Bearer\\\").\\nThis value should be registered in the IANA Authentication Scheme registry.\",\"type\":\"string\"},\"type\":{\"const\":\"http\",\"description\":\"The type of the security scheme. Must be 'http'.\",\"type\":\"string\"}},\"required\":[\"scheme\",\"type\"],\"type\":\"object\"},\"ImplicitOAuthFlow\":{\"description\":\"Defines configuration details for the OAuth 2.0 Implicit flow.\",\"properties\":{\"authorizationUrl\":{\"description\":\"The authorization URL to be used for this flow. This MUST be a URL.\",\"type\":\"string\"},\"refreshUrl\":{\"description\":\"The URL to be used for obtaining refresh tokens. This MUST be a URL.\",\"type\":\"string\"},\"scopes\":{\"additionalProperties\":{\"type\":\"string\"},\"description\":\"The available scopes for the OAuth2 security scheme. A map between the scope\\nname and a short description for it.\",\"type\":\"object\"}},\"required\":[\"authorizationUrl\",\"scopes\"],\"type\":\"object\"},\"MutualTLSSecurityScheme\":{\"description\":\"Defines a security scheme using mTLS authentication.\",\"properties\":{\"description\":{\"description\":\"An optional description for the security scheme.\",\"type\":\"string\"},\"type\":{\"const\":\"mutualTLS\",\"description\":\"The type of the security scheme. Must be 'mutualTLS'.\",\"type\":\"string\"}},\"required\":[\"type\"],\"type\":\"object\"},\"OAuth2SecurityScheme\":{\"description\":\"Defines a security scheme using OAuth 2.0.\",\"properties\":{\"description\":{\"description\":\"An optional description for the security scheme.\",\"type\":\"string\"},\"flows\":{\"$ref\":\"#/definitions/OAuthFlows\",\"description\":\"An object containing configuration information for the supported OAuth 2.0 flows.\"},\"oauth2MetadataUrl\":{\"description\":\"URL to the oauth2 authorization server metadata\\n[RFC8414](https://datatracker.ietf.org/doc/html/rfc8414). TLS is required.\",\"type\":\"string\"},\"type\":{\"const\":\"oauth2\",\"description\":\"The type of the security scheme. Must be 'oauth2'.\",\"type\":\"string\"}},\"required\":[\"flows\",\"type\"],\"type\":\"object\"},\"OAuthFlows\":{\"description\":\"Defines the configuration for the supported OAuth 2.0 flows.\",\"properties\":{\"authorizationCode\":{\"$ref\":\"#/definitions/AuthorizationCodeOAuthFlow\",\"description\":\"Configuration for the OAuth Authorization Code flow. Previously called accessCode in OpenAPI 2.0.\"},\"clientCredentials\":{\"$ref\":\"#/definitions/ClientCredentialsOAuthFlow\",\"description\":\"Configuration for the OAuth Client Credentials flow. Previously called application in OpenAPI 2.0.\"},\"implicit\":{\"$ref\":\"#/definitions/ImplicitOAuthFlow\",\"description\":\"Configuration for the OAuth Implicit flow.\"},\"password\":{\"$ref\":\"#/definitions/PasswordOAuthFlow\",\"description\":\"Configuration for the OAuth Resource Owner Password flow.\"}},\"type\":\"object\"},\"AuthorizationCodeOAuthFlow\":{\"description\":\"Defines configuration details for the OAuth 2.0 Authorization Code flow.\",\"properties\":{\"authorizationUrl\":{\"description\":\"The authorization URL to be used for this flow.\\nThis MUST be a URL and use TLS.\",\"type\":\"string\"},\"refreshUrl\":{\"description\":\"The URL to be used for obtaining refresh tokens.\\nThis MUST be a URL and use TLS.\",\"type\":\"string\"},\"scopes\":{\"additionalProperties\":{\"type\":\"string\"},\"description\":\"The available scopes for the OAuth2 security scheme. A map between the scope\\nname and a short description for it.\",\"type\":\"object\"},\"tokenUrl\":{\"description\":\"The token URL to be used for this flow.\\nThis MUST be a URL and use TLS.\",\"type\":\"string\"}},\"required\":[\"authorizationUrl\",\"scopes\",\"tokenUrl\"],\"type\":\"object\"},\"ClientCredentialsOAuthFlow\":{\"description\":\"Defines configuration details for the OAuth 2.0 Client Credentials flow.\",\"properties\":{\"refreshUrl\":{\"description\":\"The URL to be used for obtaining refresh tokens. This MUST be a URL.\",\"type\":\"string\"},\"scopes\":{\"additionalProperties\":{\"type\":\"string\"},\"description\":\"The available scopes for the OAuth2 security scheme. A map between the scope\\nname and a short description for it.\",\"type\":\"object\"},\"tokenUrl\":{\"description\":\"The token URL to be used for this flow. This MUST be a URL.\",\"type\":\"string\"}},\"required\":[\"scopes\",\"tokenUrl\"],\"type\":\"object\"},\"OpenIdConnectSecurityScheme\":{\"description\":\"Defines a security scheme using OpenID Connect.\",\"properties\":{\"description\":{\"description\":\"An optional description for the security scheme.\",\"type\":\"string\"},\"openIdConnectUrl\":{\"description\":\"The OpenID Connect Discovery URL for the OIDC provider's metadata.\",\"type\":\"string\"},\"type\":{\"const\":\"openIdConnect\",\"description\":\"The type of the security scheme. Must be 'openIdConnect'.\",\"type\":\"string\"}},\"required\":[\"openIdConnectUrl\",\"type\"],\"type\":\"object\"},\"PasswordOAuthFlow\":{\"description\":\"Defines configuration details for the OAuth 2.0 Resource Owner Password flow.\",\"properties\":{\"refreshUrl\":{\"description\":\"The URL to be used for obtaining refresh tokens. This MUST be a URL.\",\"type\":\"string\"},\"scopes\":{\"additionalProperties\":{\"type\":\"string\"},\"description\":\"The available scopes for the OAuth2 security scheme. A map between the scope\\nname and a short description for it.\",\"type\":\"object\"},\"tokenUrl\":{\"description\":\"The token URL to be used for this flow. This MUST be a URL.\",\"type\":\"string\"}},\"required\":[\"scopes\",\"tokenUrl\"],\"type\":\"object\"}}}")).stripMargin();
    }

    private AgentNetworkSchema$() {
        MODULE$ = this;
    }
}

