/*
 * Decompiled with CFR 0.152.
 */
package amf.core.internal.utils;

import amf.core.internal.remote.Platform;
import amf.core.internal.unsafe.PlatformSecrets;
import amf.core.internal.utils.Absolute$;
import amf.core.internal.utils.RelativeToIncludedFile$;
import java.net.URI;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;

public final class UriUtils$
implements PlatformSecrets {
    public static UriUtils$ MODULE$;
    private final Platform platform;

    static {
        new UriUtils$();
    }

    @Override
    public Platform platform() {
        return this.platform;
    }

    @Override
    public void amf$core$internal$unsafe$PlatformSecrets$_setter_$platform_$eq(Platform x$1) {
        this.platform = x$1;
    }

    public String resolveRelativeTo(String current, String rawUrl) {
        Option option;
        String string = rawUrl;
        Option<String> option2 = Absolute$.MODULE$.unapply(string);
        if (!option2.isEmpty()) {
            option = None$.MODULE$;
        } else {
            Option<String> option3 = RelativeToIncludedFile$.MODULE$.unapply(string);
            if (!option3.isEmpty()) {
                option = new Some<String>(current);
            } else {
                throw new MatchError((Object)string);
            }
        }
        None$ base = option;
        String encodedUrl = this.platform().encodeURI(rawUrl);
        return this.resolveWithBase(base, encodedUrl);
    }

    public String resolveWithBase(Option<String> base, String url) {
        String result = (String)base.map((Function1<String, String> & java.io.Serializable & Serializable)baseUri -> {
            if (url.startsWith("#")) {
                return new StringBuilder(0).append((String)baseUri).append(url).toString();
            }
            String baseDir = MODULE$.stripFileName((String)baseUri);
            return MODULE$.safeConcat(baseDir, url);
        }).getOrElse((Function0<String> & java.io.Serializable & Serializable)() -> url);
        return this.resolvePath(result);
    }

    private String safeConcat(String base, String url) {
        if (new StringOps(Predef$.MODULE$.augmentString(base)).nonEmpty() && BoxesRunTime.unboxToChar(new StringOps(Predef$.MODULE$.augmentString(base)).last()) == '/' && new StringOps(Predef$.MODULE$.augmentString(url)).nonEmpty() && BoxesRunTime.unboxToChar(new StringOps(Predef$.MODULE$.augmentString(url)).head()) == '/') {
            return new StringBuilder(0).append(base).append(new StringOps(Predef$.MODULE$.augmentString(url)).drop(1)).toString();
        }
        String string = base;
        String string2 = "file://";
        if (!(string != null ? !string.equals(string2) : string2 != null) && url.startsWith("./")) {
            return new StringBuilder(0).append(base).append(url.substring(2)).toString();
        }
        return new StringBuilder(0).append(base).append(url).toString();
    }

    public String stripFileName(String url) {
        return this.stripFileName(url, this.platform().operativeSystem());
    }

    /*
     * Unable to fully structure code
     */
    public String stripFileName(String url, String so) {
        v0 = withoutFrag = url.contains("#") != false ? (String)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])url.split("#"))).head() : url;
        if (!new StringOps(Predef$.MODULE$.augmentString(withoutFrag)).contains(BoxesRunTime.boxToCharacter('\\'))) ** GOTO lbl-1000
        v1 = so;
        var5_4 = "win";
        if (!(v1 != null ? v1.equals(var5_4) == false : var5_4 != null)) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        containsBackSlash = v2;
        containsForwardSlash = new StringOps(Predef$.MODULE$.augmentString(withoutFrag)).contains(BoxesRunTime.boxToCharacter('/'));
        if (!containsBackSlash && !containsForwardSlash) {
            return "";
        }
        sep = containsBackSlash != false ? '\\' : '/';
        lastPieceHasExtension = new StringOps(Predef$.MODULE$.augmentString((String)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(withoutFrag)).split(sep))).last())).contains(BoxesRunTime.boxToCharacter('.'));
        if (lastPieceHasExtension) {
            return withoutFrag.substring(0, withoutFrag.lastIndexOf(sep) + 1);
        }
        if (!withoutFrag.endsWith(Character.toString(sep))) {
            return new StringBuilder(0).append(withoutFrag).append(sep).toString();
        }
        return withoutFrag;
    }

    public String normalizePath(String url) {
        return this.fixFilePrefix(this.normalizeWithPrefixManagement(this.platform().encodeURI(url)));
    }

    public String resolvePath(String path) {
        String normalized = this.normalizeWithPrefixManagement(path);
        return this.fixFilePrefix(normalized);
    }

    private String normalizeWithPrefixManagement(String path) {
        String string = path;
        Option<String> option = Absolute$.MODULE$.unapply(string);
        if (!option.isEmpty()) {
            Tuple2<String, String> tuple2 = new StringOps(Predef$.MODULE$.augmentString(path)).splitAt(path.lastIndexOf(58) + 1);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String prefix = tuple2._1();
            String rawPath = tuple2._2();
            Tuple2<String, String> tuple22 = new Tuple2<String, String>(prefix, rawPath);
            String prefix2 = tuple22._1();
            String rawPath2 = tuple22._2();
            return new StringBuilder(0).append(prefix2).append(new URI(rawPath2).normalize().toString()).toString();
        }
        return new URI(path).normalize().toString();
    }

    private String fixFilePrefix(String res) {
        if (res.startsWith("file://") || res.startsWith("file:///")) {
            return res;
        }
        if (res.startsWith("file:/")) {
            return res.replace("file:/", "file:///");
        }
        return res;
    }

    private UriUtils$() {
        MODULE$ = this;
        PlatformSecrets.$init$(this);
    }
}

