/*
 * Decompiled with CFR 0.152.
 */
package org.mulesoft.common.net;

import org.mulesoft.common.net.DomainValidator$;
import org.mulesoft.common.net.Email;
import org.mulesoft.common.net.InetAddress$;
import org.mulesoft.common.parse.ParseError;
import org.mulesoft.common.parse.ParseError$;
import org.mulesoft.common.parse.package$;
import org.mulesoft.common.parse.package$ParseResult$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.util.Either;
import scala.util.matching.Regex;

public final class Email$
implements Serializable {
    public static Email$ MODULE$;
    private final Regex EmailRegex;
    private final Regex IpDomainRegex;
    private final String Word;
    private final Regex UserRegex;

    static {
        new Email$();
    }

    public Either<ParseError, Email> parse(String user, String domain) {
        if (!this.userIsValid(user)) {
            return ParseError$.MODULE$.formatError(user, "Invalid User");
        }
        if (!this.domainIsValid(domain)) {
            return ParseError$.MODULE$.formatError(domain, "Invalid domain");
        }
        return scala.package$.MODULE$.Right().apply(new Email(user, domain));
    }

    public Either<ParseError, Email> parse(String email) {
        if (email != null && !email.endsWith(".")) {
            String string = email;
            Option<List<String>> option = this.EmailRegex().unapplySeq(string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
                String user = (String)((LinearSeqOptimized)option.get()).apply(0);
                String domain = (String)((LinearSeqOptimized)option.get()).apply(1);
                return this.parse(user, domain);
            }
        }
        return ParseError$.MODULE$.formatError(email, ParseError$.MODULE$.formatError$default$2());
    }

    public Email apply(String user, String domain) {
        return package$ParseResult$.MODULE$.result$extension(package$.MODULE$.ParseResult(this.parse(user, domain)));
    }

    public Email apply(String email) {
        return package$ParseResult$.MODULE$.result$extension(package$.MODULE$.ParseResult(this.parse(email)));
    }

    public Option<Email> unapply(String arg) {
        return this.parse(arg).toOption();
    }

    private boolean domainIsValid(String domain) {
        String string = domain;
        Option<List<String>> option = this.IpDomainRegex().unapplySeq(string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String address = (String)((LinearSeqOptimized)option.get()).apply(0);
            return InetAddress$.MODULE$.parse(address).isRight();
        }
        return DomainValidator$.MODULE$.isValid(domain, DomainValidator$.MODULE$.isValid$default$2());
    }

    public boolean userIsValid(String user) {
        return user != null && user.length() <= 64 && this.UserRegex().pattern().matcher(user).matches();
    }

    private final Regex EmailRegex() {
        return this.EmailRegex;
    }

    private final Regex IpDomainRegex() {
        return this.IpDomainRegex;
    }

    private final String ValidChar() {
        return "(\\\\[^ \"\\\\])|[^\\s\\x00-\\x1F\\x7F\\(\\)<>@,;:'\\\\\\\"\\.\\[\\]]";
    }

    private final String QuotedUser() {
        return "\"(\\\\\"|[^\"])*\"";
    }

    private final String Word() {
        return this.Word;
    }

    private final Regex UserRegex() {
        return this.UserRegex;
    }

    private final int MaxUserLength() {
        return 64;
    }

    public Option<Tuple2<String, String>> unapply(Email x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some<Tuple2<String, String>>(new Tuple2<String, String>(x$0.user(), x$0.domain()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Email$() {
        MODULE$ = this;
        this.EmailRegex = new StringOps(Predef$.MODULE$.augmentString("^\\s*(.+)@(.+?)\\s*$")).r();
        this.IpDomainRegex = new StringOps(Predef$.MODULE$.augmentString("^\\[(.*)\\]$")).r();
        this.Word = new StringBuilder(72).append("((").append("(\\\\[^ \"\\\\])|[^\\s\\x00-\\x1F\\x7F\\(\\)<>@,;:'\\\\\\\"\\.\\[\\]]").append("|')+|").append("\"(\\\\\"|[^\"])*\"").append(")").toString();
        this.UserRegex = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(10).append("^\\s*").append(this.Word()).append("(\\.").append(this.Word()).append(")*$").toString())).r();
    }
}

