/*
 * Decompiled with CFR 0.152.
 */
package amf.core.internal.transform;

import amf.core.client.scala.model.domain.DataNode;
import amf.core.client.scala.model.domain.ScalarNode;
import amf.core.client.scala.model.domain.templates.Variable;
import amf.core.internal.annotations.ErrorRegistered;
import amf.core.internal.annotations.SourceYPart;
import amf.core.internal.transform.stages.helpers.ResolvedLinkNode;
import amf.core.internal.utils.InflectorBase;
import amf.core.internal.utils.InflectorBase$;
import java.io.Serializable;
import org.yaml.model.QuotedMark;
import org.yaml.model.YPart;
import org.yaml.model.YScalar;
import org.yaml.model.YScalar$;
import org.yaml.render.YamlRender$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;
import scala.util.matching.Regex$;

public final class VariableReplacer$ {
    public static VariableReplacer$ MODULE$;
    private final String Transformations;
    private final Regex TransformationsRegex;
    private final Regex VariableRegex;

    static {
        new VariableReplacer$();
    }

    private String Transformations() {
        return this.Transformations;
    }

    private Regex TransformationsRegex() {
        return this.TransformationsRegex;
    }

    public Regex VariableRegex() {
        return this.VariableRegex;
    }

    public DataNode replaceNodeVariables(ScalarNode s, Set<Variable> values, Function1<String, BoxedUnit> errorFunction) {
        String string = s.value().value().trim();
        Option<List<String>> option = this.VariableRegex().unapplySeq(string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            Variable variable;
            DataNode scalar;
            Variable variable2;
            String name = (String)((LinearSeqOptimized)option.get()).apply(0);
            String transformations = (String)((LinearSeqOptimized)option.get()).apply(1);
            boolean bl = false;
            Some some = null;
            Option option2 = values.find((Function1<Variable, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(VariableReplacer$.$anonfun$replaceNodeVariables$1(name, x$1)));
            if (option2 instanceof Some) {
                ScalarNode scalarNode;
                DataNode scalar2;
                bl = true;
                some = (Some)option2;
                Variable variable3 = (Variable)some.value();
                if (variable3 != null && (scalar2 = variable3.value()) instanceof ScalarNode && ((scalarNode = (ScalarNode)scalar2).dataType().option().isEmpty() || scalarNode.dataType().value().contains("#string"))) {
                    s.withValue(this.VariableRegex().replaceAllIn((CharSequence)s.value().value(), (Function1<Regex.Match, String> & Serializable & scala.Serializable)x$2 -> MODULE$.replaceMatch(((TraversableOnce)values.map((Function1<Variable, Tuple2> & Serializable & scala.Serializable)v -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(v.name()), v.value()), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()), false, false, (Regex.Match)x$2, errorFunction)));
                    return s;
                }
            }
            if (bl && new StringOps(Predef$.MODULE$.augmentString(transformations)).nonEmpty()) {
                errorFunction.apply(new StringBuilder(47).append("Cannot apply transformations '").append(transformations).append("' to variable '").append(name).append("'.").toString());
                return s;
            }
            if (bl && (variable2 = (Variable)some.value()) != null && (scalar = variable2.value()) instanceof ScalarNode) {
                ScalarNode scalarNode = (ScalarNode)scalar;
                return scalarNode;
            }
            if (bl && (variable = (Variable)some.value()) != null) {
                DataNode node = variable.value();
                return node;
            }
            if (None$.MODULE$.equals(option2)) {
                Object object;
                if (s.annotations().find(ErrorRegistered.class).isEmpty()) {
                    errorFunction.apply(new StringBuilder(24).append("Cannot find variable '").append(name).append("'.").toString());
                    object = s.annotations().$plus$eq(new ErrorRegistered());
                } else {
                    object = BoxedUnit.UNIT;
                }
                return s;
            }
            throw new MatchError(option2);
        }
        s.value().option().foreach((Function1<String, ScalarNode> & Serializable & scala.Serializable)v -> s.withValue(MODULE$.VariableRegex().replaceAllIn((CharSequence)v, (Function1<Regex.Match, String> & Serializable & scala.Serializable)x$3 -> MODULE$.replaceMatch(((TraversableOnce)values.map((Function1<Variable, Tuple2> & Serializable & scala.Serializable)v -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(v.name()), v.value()), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()), false, false, (Regex.Match)x$3, errorFunction))));
        return s;
    }

    public String replaceVariables(String s, Set<Variable> values, Function1<String, BoxedUnit> errorFunction) {
        return this.VariableRegex().replaceAllIn((CharSequence)s, (Function1<Regex.Match, String> & Serializable & scala.Serializable)x$4 -> MODULE$.replaceMatch(((TraversableOnce)values.map((Function1<Variable, Tuple2> & Serializable & scala.Serializable)v -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(v.name()), v.value()), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()), false, false, (Regex.Match)x$4, errorFunction));
    }

    public String replaceVariablesInKey(String key, Set<Variable> values, Function1<String, BoxedUnit> errorFunction) {
        return this.VariableRegex().replaceAllIn((CharSequence)key, (Function1<Regex.Match, String> & Serializable & scala.Serializable)x$5 -> MODULE$.replaceMatch(((TraversableOnce)values.map((Function1<Variable, Tuple2> & Serializable & scala.Serializable)v -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(v.name()), v.value()), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()), true, true, (Regex.Match)x$5, errorFunction));
    }

    private String replaceMatch(Map<String, DataNode> values, boolean strict, boolean isKey, Regex.Match m, Function1<String, BoxedUnit> errorFunction) {
        String nameWithChevrons = m.group(0);
        String name = m.group(1);
        BooleanRef emptyVariable = BooleanRef.create(false);
        Option textOption = values.get(name).flatMap((Function1<DataNode, Option> & Serializable & scala.Serializable)x0$1 -> {
            DataNode dataNode = x0$1;
            if (dataNode instanceof ScalarNode) {
                ScalarNode scalarNode = (ScalarNode)dataNode;
                return Option$.MODULE$.option2Iterable(scalarNode.annotations().find(SourceYPart.class).map((Function1<SourceYPart, YPart> & Serializable & scala.Serializable)x$6 -> x$6.ast())).collectFirst(new scala.Serializable(isKey, strict, errorFunction, name){
                    public static final long serialVersionUID = 0L;
                    private final boolean isKey$1;
                    private final boolean strict$1;
                    private final Function1 errorFunction$4;
                    private final String name$2;

                    public final <A1 extends YPart, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        YScalar yScalar;
                        A1 A1 = x1;
                        if (A1 instanceof YScalar && (yScalar = (YScalar)A1).mark() instanceof QuotedMark) {
                            Serializable serializable;
                            String variableValue = YamlRender$.MODULE$.render(YScalar$.MODULE$.apply(yScalar.text()));
                            if (variableValue.matches(" *") && this.isKey$1 && this.strict$1) {
                                this.errorFunction$4.apply(new StringBuilder(38).append("Variable '").append(this.name$2).append("' cannot have an empty value").toString());
                                serializable = None$.MODULE$;
                            } else {
                                serializable = BoxedUnit.UNIT;
                            }
                            return (B1)variableValue;
                        }
                        return function1.apply(x1);
                    }

                    public final boolean isDefinedAt(YPart x1) {
                        YScalar yScalar;
                        YPart yPart = x1;
                        return yPart instanceof YScalar && (yScalar = (YScalar)yPart).mark() instanceof QuotedMark;
                    }
                    {
                        this.isKey$1 = isKey$1;
                        this.strict$1 = strict$1;
                        this.errorFunction$4 = errorFunction$4;
                        this.name$2 = name$2;
                    }
                }).orElse((Function0<Option> & Serializable & scala.Serializable)() -> {
                    if (scalarNode.value().option().exists((Function1<String, Object> & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean(x$7.matches(" *"))) && isKey && strict) {
                        errorFunction.apply(new StringBuilder(38).append("Variable '").append(name).append("' cannot have an empty value").toString());
                        emptyVariable$1.elem = true;
                        return None$.MODULE$;
                    }
                    return scalarNode.value().option();
                });
            }
            if (dataNode instanceof ResolvedLinkNode) {
                ResolvedLinkNode resolvedLinkNode = (ResolvedLinkNode)dataNode;
                return resolvedLinkNode.source().alias().option();
            }
            errorFunction.apply(new StringBuilder(41).append("Variable '").append(name).append("' cannot be replaced with type ").append(dataNode.getClass().getName()).toString());
            return None$.MODULE$;
        });
        String replacement = ((String)textOption.flatMap((Function1<String, Option> & Serializable & scala.Serializable)text -> Option$.MODULE$.apply(m.group(2)).map((Function1<String, String> & Serializable & scala.Serializable)transformations -> MODULE$.TransformationsRegex().findAllIn((CharSequence)transformations).foldLeft(text, (Function2<String, String, String> & Serializable & scala.Serializable)(value, transformation) -> MODULE$.variableTransformation(errorFunction, (String)value, (String)transformation))).orElse((Function0<Some> & Serializable & scala.Serializable)() -> new Some<String>((String)text))).getOrElse((Function0<String> & Serializable & scala.Serializable)() -> {
            if (strict && !emptyVariable$1.elem) {
                errorFunction.apply(new StringBuilder(24).append("Cannot find variable '").append(name).append("'.").toString());
                return nameWithChevrons;
            }
            return nameWithChevrons;
        })).replace("$", "\\$");
        return Regex$.MODULE$.quoteReplacement(replacement);
    }

    public String variableTransformation(Function1<String, BoxedUnit> errorFunction, String value, String transformation) {
        String string = transformation;
        if ("singularize".equals(string)) {
            return InflectorBase$.MODULE$.Inflector(value).singularize();
        }
        if ("pluralize".equals(string)) {
            return InflectorBase$.MODULE$.Inflector(value).pluralize();
        }
        if ("uppercase".equals(string)) {
            return value.toUpperCase();
        }
        if ("lowercase".equals(string)) {
            return value.toLowerCase();
        }
        if ("lowercamelcase".equals(string)) {
            InflectorBase.Inflector qual$1 = InflectorBase$.MODULE$.Inflector(value);
            boolean x$1 = qual$1.camelize$default$1();
            return InflectorBase$.MODULE$.Inflector(qual$1.camelize(x$1)).decapitalize();
        }
        if ("uppercamelcase".equals(string)) {
            InflectorBase.Inflector qual$2 = InflectorBase$.MODULE$.Inflector(value);
            boolean x$2 = qual$2.camelize$default$1();
            return new StringOps(Predef$.MODULE$.augmentString(qual$2.camelize(x$2))).capitalize();
        }
        if ("lowerunderscorecase".equals(string)) {
            InflectorBase.Inflector qual$3 = InflectorBase$.MODULE$.Inflector(value);
            String x$3 = qual$3.camelToScoreSing$default$1();
            return qual$3.camelToScoreSing(x$3).toLowerCase();
        }
        if ("upperunderscorecase".equals(string)) {
            InflectorBase.Inflector qual$4 = InflectorBase$.MODULE$.Inflector(value);
            String x$4 = qual$4.camelToScoreSing$default$1();
            return qual$4.camelToScoreSing(x$4).toUpperCase();
        }
        if ("lowerhyphencase".equals(string)) {
            return InflectorBase$.MODULE$.Inflector(value).camelToScoreSing("-").toLowerCase();
        }
        if ("upperhyphencase".equals(string)) {
            return InflectorBase$.MODULE$.Inflector(value).camelToScoreSing("-").toUpperCase();
        }
        errorFunction.apply(new StringBuilder(37).append("Transformation '").append(transformation).append("' on '").append(value).append("' is not valid.").toString());
        return value;
    }

    public static final /* synthetic */ boolean $anonfun$replaceNodeVariables$1(String name$1, Variable x$1) {
        String string = x$1.name();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private VariableReplacer$() {
        MODULE$ = this;
        this.Transformations = "singularize|pluralize|uppercase|lowercase|lowercamelcase|uppercamelcase|lowerunderscorecase|upperunderscorecase|lowerhyphencase|upperhyphencase";
        this.TransformationsRegex = new StringOps(Predef$.MODULE$.augmentString(this.Transformations())).r();
        this.VariableRegex = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(43).append("<<\\s*([^<<>>|\\s]+)((?:\\s*\\|\\s*!(?:").append(this.Transformations()).append(")\\s*)*)>>").toString())).r();
    }
}

