/*
 * Decompiled with CFR 0.152.
 */
package amf.shapes.internal.spec.jsonschema.parser.document;

import amf.core.client.scala.model.document.BaseUnit;
import amf.core.client.scala.model.document.ExternalFragment;
import amf.core.client.scala.model.domain.DomainElement;
import amf.core.client.scala.model.domain.Shape;
import amf.core.internal.parser.domain.Annotations;
import amf.core.internal.parser.domain.Annotations$;
import amf.core.internal.remote.Platform;
import amf.core.internal.unsafe.PlatformSecrets;
import amf.core.internal.validation.core.ValidationSpecification;
import amf.shapes.client.scala.model.document.JsonSchemaDocument;
import amf.shapes.client.scala.model.domain.AnyShape;
import amf.shapes.internal.annotations.DocumentDeclarationKey;
import amf.shapes.internal.spec.common.JSONSchemaDraft201909SchemaVersion$;
import amf.shapes.internal.spec.common.JSONSchemaVersion;
import amf.shapes.internal.spec.common.parser.ShapeParserContext;
import amf.shapes.internal.spec.contexts.ReferenceFinder$;
import amf.shapes.internal.spec.jsonschema.JsonSchemaEntry$;
import amf.shapes.internal.spec.jsonschema.parser.document.Draft2019NameExtraction$;
import amf.shapes.internal.spec.jsonschema.parser.document.Draft4NameExtraction$;
import amf.shapes.internal.spec.jsonschema.parser.document.NameExtraction;
import amf.shapes.internal.validation.definitions.ShapeParserSideValidations$;
import java.io.Serializable;
import org.yaml.model.YNode;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class JsonSchemaLinker$
implements PlatformSecrets {
    public static JsonSchemaLinker$ MODULE$;
    private final Platform platform;

    static {
        new JsonSchemaLinker$();
    }

    @Override
    public Platform platform() {
        return this.platform;
    }

    @Override
    public void amf$core$internal$unsafe$PlatformSecrets$_setter_$platform_$eq(Platform x$1) {
        this.platform = x$1;
    }

    public Option<AnyShape> linkShapeIn(String ref, YNode ast, ShapeParserContext ctx) {
        Option<JsonSchemaDocument> maybeDoc = this.findJsonSchemaDocument(ref, ctx);
        return maybeDoc.flatMap((Function1<JsonSchemaDocument, Option> & Serializable & scala.Serializable)document -> {
            Option<String> maybeUriFragment = ReferenceFinder$.MODULE$.getJsonReferenceFragment(ref);
            return MODULE$.linkShapeFromDocument(ref, (JsonSchemaDocument)document, maybeUriFragment, Annotations$.MODULE$.apply(ast), ctx);
        });
    }

    public Option<AnyShape> linkShapeFromDocument(String ref, JsonSchemaDocument document, Option<String> maybeUriFragment, Annotations linkAnnotations, ShapeParserContext ctx) {
        return this.computeShape(ref, document, maybeUriFragment, linkAnnotations, ctx).collect(new scala.Serializable(ref, linkAnnotations){
            public static final long serialVersionUID = 0L;
            private final String ref$3;
            private final Annotations linkAnnotations$1;

            public final <A1 extends Shape, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof AnyShape) {
                    AnyShape anyShape = (AnyShape)A1;
                    return (B1)anyShape.link(this.ref$3, this.linkAnnotations$1);
                }
                return function1.apply(x1);
            }

            public final boolean isDefinedAt(Shape x1) {
                Shape shape = x1;
                return shape instanceof AnyShape;
            }
            {
                this.ref$3 = ref$3;
                this.linkAnnotations$1 = linkAnnotations$1;
            }
        });
    }

    private Option<Shape> computeShape(String ref, JsonSchemaDocument document, Option<String> maybeUriFragment, Annotations linkAnnotations, ShapeParserContext ctx) {
        Option<String> option = maybeUriFragment;
        if (option instanceof Some) {
            Some some = (Some)option;
            String fragment = (String)some.value();
            String baseRef = (String)maybeUriFragment.map((Function1<String, String> & Serializable & scala.Serializable)x$2 -> (String)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])ref.split("#"))).head()).getOrElse((Function0<String> & Serializable & scala.Serializable)() -> ref);
            Either<Tuple2<ValidationSpecification, String>, AnyShape> maybeShape = this.findShapeForReference(baseRef, document, fragment, ctx);
            this.throwErrors(maybeShape, linkAnnotations, ctx);
            return maybeShape.right().toOption();
        }
        if (None$.MODULE$.equals(option)) {
            return new Some<Shape>(document.encodes());
        }
        throw new MatchError(option);
    }

    private void throwErrors(Either<Tuple2<ValidationSpecification, String>, AnyShape> maybeShape, Annotations linkAnnotations, ShapeParserContext ctx) {
        maybeShape.left().foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> {
            JsonSchemaLinker$.$anonfun$throwErrors$1(ctx, linkAnnotations, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private Option<JsonSchemaDocument> findJsonSchemaDocument(String ref, ShapeParserContext ctx) {
        return ReferenceFinder$.MODULE$.findJsonReferencedUnit(ref, ref, ctx.refs()).collect(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends BaseUnit, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof JsonSchemaDocument) {
                    JsonSchemaDocument jsonSchemaDocument = (JsonSchemaDocument)A1;
                    return (B1)jsonSchemaDocument;
                }
                return function1.apply(x1);
            }

            public final boolean isDefinedAt(BaseUnit x1) {
                BaseUnit baseUnit = x1;
                return baseUnit instanceof JsonSchemaDocument;
            }
        });
    }

    private Either<Tuple2<ValidationSpecification, String>, AnyShape> findShapeForReference(String ref, JsonSchemaDocument document, String uriFragment, ShapeParserContext ctx) {
        JSONSchemaVersion version = JsonSchemaEntry$.MODULE$.apply(document.schemaVersion().value()).get();
        Option<String> declarationKey = document.annotations().find(DocumentDeclarationKey.class).map((Function1<DocumentDeclarationKey, String> & Serializable & scala.Serializable)x$3 -> x$3.key());
        NameExtraction extractor = this.nameExtractorFor(version);
        Either<String, String> either = extractor.extract(uriFragment);
        if (either instanceof Left) {
            Left left = (Left)either;
            String error = (String)left.value();
            return package$.MODULE$.Left().apply(new Tuple2<ValidationSpecification, String>(ShapeParserSideValidations$.MODULE$.InvalidJsonSchemaReference(), error));
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            String name = (String)right.value();
            Either<Tuple2<ValidationSpecification, String>, BoxedUnit> either2 = this.validateDeclarationKey(declarationKey, uriFragment);
            if (either2 instanceof Left) {
                Left left = (Left)either2;
                Tuple2 errorTuple = (Tuple2)left.value();
                return package$.MODULE$.Left().apply(errorTuple);
            }
            if (either2 instanceof Right) {
                return this.findShapeWithName(ref, document, name, uriFragment, ctx);
            }
            throw new MatchError(either2);
        }
        throw new MatchError(either);
    }

    private Either<Tuple2<ValidationSpecification, String>, BoxedUnit> validateDeclarationKey(Option<String> declarationKey, String ref) {
        Some some;
        String dk;
        Option<String> option = declarationKey;
        if (option instanceof Some && !ref.contains(dk = (String)(some = (Some)option).value())) {
            return package$.MODULE$.Left().apply(new Tuple2<ValidationSpecification, String>(ShapeParserSideValidations$.MODULE$.IncorrectDefinitionKey(), new StringBuilder(48).append("The definition key present in the ref must be '").append(dk).append("'").toString()));
        }
        return package$.MODULE$.Right().apply(BoxedUnit.UNIT);
    }

    private Either<Tuple2<ValidationSpecification, String>, AnyShape> findShapeWithName(String ref, JsonSchemaDocument doc, String name, String uriFragment, ShapeParserContext ctx) {
        return this.findShape(ref, doc, name, ctx).toRight((Function0<Tuple2> & Serializable & scala.Serializable)() -> new Tuple2<ValidationSpecification, String>(ShapeParserSideValidations$.MODULE$.JsonSchemaDefinitionNotFound(), new StringBuilder(39).append("Couldn't find schema identified by ").append(uriFragment).append(" in ").append(doc.location().getOrElse((Function0<String> & Serializable & scala.Serializable)() -> "")).toString()));
    }

    private Option<AnyShape> findShape(String ref, JsonSchemaDocument doc, String name, ShapeParserContext ctx) {
        Some some;
        Option<BaseUnit> option = ctx.getJsonSchemaRefGuide().currentUnit();
        if (option instanceof Some && (some = (Some)option).value() instanceof ExternalFragment) {
            return this.findShapeInDoc(doc, name, ctx);
        }
        return this.collectAnyShape(ctx.findDeclaredTypeInDocFragment(ref, name).orElse((Function0<Option> & Serializable & scala.Serializable)() -> ctx.findDeclaredTypeInDocFragment(ref, MODULE$.platform().decodeURI(name))));
    }

    private Option<AnyShape> collectAnyShape(Option<Shape> shape) {
        return shape.collect(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Shape, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof AnyShape) {
                    AnyShape anyShape = (AnyShape)A1;
                    return (B1)anyShape;
                }
                return function1.apply(x1);
            }

            public final boolean isDefinedAt(Shape x1) {
                Shape shape = x1;
                return shape instanceof AnyShape;
            }
        });
    }

    private Option<AnyShape> findShapeInDoc(JsonSchemaDocument doc, String name, ShapeParserContext ctx) {
        return doc.declares().collectFirst(new scala.Serializable(name){
            public static final long serialVersionUID = 0L;
            private final String name$2;

            public final <A1 extends DomainElement, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                AnyShape anyShape;
                A1 A1 = x1;
                if (A1 instanceof AnyShape && (anyShape = (AnyShape)A1).name().option().contains(this.name$2)) {
                    return (B1)anyShape;
                }
                return function1.apply(x1);
            }

            public final boolean isDefinedAt(DomainElement x1) {
                AnyShape anyShape;
                DomainElement domainElement = x1;
                return domainElement instanceof AnyShape && (anyShape = (AnyShape)domainElement).name().option().contains(this.name$2);
            }
            {
                this.name$2 = name$2;
            }
        });
    }

    private NameExtraction nameExtractorFor(JSONSchemaVersion version) {
        if (version.$greater$eq(JSONSchemaDraft201909SchemaVersion$.MODULE$)) {
            return Draft2019NameExtraction$.MODULE$;
        }
        return Draft4NameExtraction$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$throwErrors$1(ShapeParserContext ctx$2, Annotations linkAnnotations$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            ValidationSpecification spec = (ValidationSpecification)tuple2._1();
            String error = (String)tuple2._2();
            ctx$2.eh().violation(spec, "", error, linkAnnotations$2);
            return;
        }
        throw new MatchError(tuple2);
    }

    private JsonSchemaLinker$() {
        MODULE$ = this;
        PlatformSecrets.$init$(this);
    }
}

