package amf.grpc.internal.spec.parser.context

import amf.apicontract.client.scala.model.domain.security.SecurityScheme
import amf.apicontract.internal.spec.common.WebApiDeclarations
import amf.apicontract.internal.spec.common.emitter.SpecVersionFactory
import amf.apicontract.internal.spec.common.parser.{SecuritySchemeParser, WebApiContext}
import amf.core.client.scala.config.ParsingOptions
import amf.core.client.scala.model.domain.Shape
import amf.core.client.scala.parse.document.{ParsedReference, ParserContext}
import amf.core.internal.plugins.syntax.SyamlAMFErrorHandler
import amf.core.internal.remote.{Grpc, Spec}
import amf.shapes.internal.spec.raml.parser.RamlWebApiContextType.RamlWebApiContextType
import amf.shapes.internal.spec.common.{JSONSchemaDraft4SchemaVersion, SchemaVersion}
import amf.shapes.internal.spec.common.parser.{
  AnnotationSchemaValidatorBuilder,
  DontIgnoreCriteria,
  IgnoreAnnotationSchemaValidatorBuilder,
  IgnoreCriteria,
  SpecSettings,
  SpecSyntax,
  YMapEntryLike
}
import org.yaml.model.{YNode, YPart}

object GrpcVersionFactory extends SpecVersionFactory {
  override def securitySchemeParser: (YMapEntryLike, SecurityScheme => SecurityScheme) => SecuritySchemeParser =
    throw new Exception("GRPC specs don't support security schemes")
}

class GrpcWebApiContext(
    override val loc: String,
    override val refs: Seq[ParsedReference],
    override val options: ParsingOptions,
    private val wrapped: ParserContext,
    private val ds: Option[WebApiDeclarations] = None,
    val messagePath: Seq[String] = Seq("")
) extends WebApiContext(loc, refs, options, wrapped, ds, specSettings = GrpcSettings) {

  override def autoGeneratedAnnotation(s: Shape): Unit = {}

  override val factory: SpecVersionFactory = GrpcVersionFactory

  def nestedMessage(messageName: String) =
    new GrpcWebApiContext(loc, refs, options, wrapped, ds, messagePath ++ Seq(messageName))

  def fullMessagePath(messageName: String): String = messagePath match {
    case _ if messageName.startsWith(".") => messageName // fully qualified path
    case _ if messagePath.length > 1 && messageName.startsWith(messagePath(1)) =>
      "." + messageName // reference from package
    case _ => (messagePath :+ messageName).mkString(".") // relative to the current path
  }

  def topLevelPackageRef(messageName: String): Option[String] = {
    if (messageName.startsWith(".")) { // fully qualified path
      None
    } else if (messageName.startsWith(messagePath(1))) { // reference from package
      Some("." + messageName)
    } else { // relative to current path
      Some((messagePath.take(2) ++ Seq(messageName)).mkString("."))
    }
  }
}

object GrpcSettings extends SpecSettings {
  override val spec: Spec         = Grpc
  override val syntax: SpecSyntax = SpecSyntax.empty

  override def link(node: YNode)(implicit eh: SyamlAMFErrorHandler): Either[String, YNode] = throw new Exception(
    "GrpcContext cannot be used with a SYaml parser"
  )

  override def ignoreCriteria: IgnoreCriteria = DontIgnoreCriteria

  override def ramlContextType: Option[RamlWebApiContextType] = None

  override val defaultSchemaVersion: SchemaVersion                          = JSONSchemaDraft4SchemaVersion
  override val annotationValidatorBuilder: AnnotationSchemaValidatorBuilder = IgnoreAnnotationSchemaValidatorBuilder
}
