package amf.mcp.internal.plugins.parse.entry

import amf.core.client.scala.parse.document.SyamlParsedDocument
import amf.core.internal.parser.Root
import amf.shapes.internal.plugins.parser.entry.{IdEntry, IdEntryVersion, IdVersion}
import org.yaml.model.YMap

object MCPProtocolEntry extends IdEntry {
  override protected def versionHandler: IdEntryVersion = MCPProtocolVersion

  override def apply(root: Root): Option[IdVersion] =
    root.parsed match {
      case parsed: SyamlParsedDocument =>
        parsed.document.to[YMap] match {
          case Right(map) =>
            versionHandler
              .parseIdVersion(map)
              .orElse(Some(MCP20250326ProtocolVersion)) // VERSION COULD BE EMPTY HERE. TODO GENERALIZE THIS
          case Left(_) => None
        }
      case _ => None
    }
}
