package amf.mcp.internal.plugins.parse.schema

import amf.shapes.internal.plugins.parser.schema.JsonSchemaBasedSpecSchema

object MCPSchema extends JsonSchemaBasedSpecSchema{
  // minified schema_broker_group.json with https://jsonformatter.org/json-minify
  override def schema: String =
    """{"$schema":"http://json-schema.org/draft-07/schema#","title":"MCP Asset Schema","$ref":"#/definitions/MCPServer","definitions":{"MCPServer":{"@context":{"@type":["http://anypoint.com/vocabs/mcp#Server"]},"type":"object","required":["transport"],"properties":{"protocolVersion":{"type":"string","enum":["2024-11-05","2025-03-26"],"description":"The version of the protocol being used. This is used to determine the structure and capabilities of the data."},"introspectedAt":{"type":"string","description":"Timestamp when the introspection was performed"},"connectionStatus":{"type":"string","description":"Status of the connection to the MCP server","enum":["success","failed","error"]},"transport":{"$ref":"#/definitions/MCPTransport","description":"The transport protocol used for communication. This defines how the data is transmitted between the client and server."},"capabilities":{"type":"object","description":"Boolean flags indicating which capabilities the server supports","required":["tools","resources","prompts","logging"],"properties":{"tools":{"type":"boolean","description":"Whether the server supports tools"},"resources":{"type":"boolean","description":"Whether the server supports resources"},"prompts":{"type":"boolean","description":"Whether the server supports prompts"},"logging":{"type":"boolean","description":"Whether the server supports logging"}},"additionalProperties":false},"logging":{"type":"object","properties":{},"description":"Present if the server supports sending log messages to the client.","additionalProperties":true},"tools":{"type":"array","items":{"$ref":"#/definitions/Tool"},"description":"A list of tools available in the mcp api. Each tool has a name, description, and input schema that defines the expected input format."},"resources":{"type":"array","items":{"$ref":"#/definitions/Resource"},"description":"A list of resources available in the mcp api. Each resource has a URI, name, description, MIME type, and annotations that provide additional metadata."},"prompts":{"type":"array","items":{"$ref":"#/definitions/Prompt"},"description":"A list of prompts available in the mcp api. Each prompt has a name, description, and arguments that define the expected input format for the prompt."},"securitySchemes":{"additionalProperties":{"$ref":"#/definitions/SecurityScheme"},"description":"Security scheme details used for authenticating with this agent.","type":"object"},"additionalProperties":false}},"SseTransport":{"@context":{"@type":["http://anypoint.com/vocabs/mcp#Transport","http://anypoint.com/vocabs/mcp#SseTransport"],"@base":"http://anypoint.com/vocabs/mcp#"},"required":["kind","ssePath"],"properties":{"kind":{"type":"string","const":"sse"},"ssePath":{"type":"string","description":"Path to the SSE endpoint"},"messagesPath":{"type":"string","description":"Path to the messages endpoint"}},"additionalProperties":false},"StreamableHttpTransport":{"@context":{"@type":["http://anypoint.com/vocabs/mcp#Transport","http://anypoint.com/vocabs/mcp#StreamableHttpTransport"],"@base":"http://anypoint.com/vocabs/agents#"},"required":["kind"],"properties":{"kind":{"type":"string","const":"streamableHttp"},"path":{"type":"string","description":"Path to the mcp endpoint"}},"additionalProperties":false},"MCPTransport":{"type":"object","oneOf":[{"$ref":"#/definitions/SseTransport"},{"$ref":"#/definitions/StreamableHttpTransport"}]},"Tool":{"@context":{"@type":["http://anypoint.com/vocabs/mcp#Tool"]},"description":"Definition for a tool the client can call.","properties":{"annotations":{"$ref":"#/definitions/ToolAnnotations","description":"Optional additional tool information."},"description":{"description":"A human-readable description of the tool.\n\nThis can be used by clients to improve the LLM's understanding of available tools. It can be thought of like a \"hint\" to the model.","type":"string"},"inputSchema":{"@context":{"@type":["http://anypoint.com/vocabs/mcp#ToolInputSchema"]},"description":"A JSON Schema object defining the expected parameters for the tool.","properties":{"properties":{"additionalProperties":{"additionalProperties":true,"properties":{},"type":"object"},"type":"object"},"required":{"items":{"type":"string"},"type":"array"},"type":{"const":"object","type":"string"}},"required":["type"],"type":"object"},"name":{"description":"The name of the tool.","type":"string"}},"required":["inputSchema","name"],"type":"object"},"ToolAnnotations":{"description":"Additional properties describing a Tool to clients.\n\nNOTE: all properties in ToolAnnotations are **hints**.\nThey are not guaranteed to provide a faithful description of\ntool behavior (including descriptive properties like `title`).\n\nClients should never make tool use decisions based on ToolAnnotations\nreceived from untrusted servers.","properties":{"destructiveHint":{"description":"If true, the tool may perform destructive updates to its environment.\nIf false, the tool performs only additive updates.\n\n(This property is meaningful only when `readOnlyHint == false`)\n\nDefault: true","type":"boolean"},"idempotentHint":{"description":"If true, calling the tool repeatedly with the same arguments\nwill have no additional effect on the its environment.\n\n(This property is meaningful only when `readOnlyHint == false`)\n\nDefault: false","type":"boolean"},"openWorldHint":{"description":"If true, this tool may interact with an \"open world\" of external\nentities. If false, the tool's domain of interaction is closed.\nFor example, the world of a web search tool is open, whereas that\nof a memory tool is not.\n\nDefault: true","type":"boolean"},"readOnlyHint":{"description":"If true, the tool does not modify its environment.\n\nDefault: false","type":"boolean"},"title":{"description":"A human-readable title for the tool.","type":"string"}},"type":"object"},"Prompt":{"@context":{"@type":["http://anypoint.com/vocabs/mcp#Prompt"]},"description":"A prompt or prompt template that the server offers.","properties":{"arguments":{"description":"A list of arguments to use for templating the prompt.","items":{"$ref":"#/definitions/PromptArgument"},"type":"array"},"description":{"description":"An optional description of what this prompt provides","type":"string"},"name":{"description":"The name of the prompt or prompt template.","type":"string"}},"required":["name"],"type":"object"},"PromptArgument":{"@context":{"@type":["http://anypoint.com/vocabs/mcp#PromptArgument"]},"description":"Describes an argument that a prompt can accept.","properties":{"description":{"description":"A human-readable description of the argument.","type":"string"},"name":{"description":"The name of the argument.","type":"string"},"required":{"description":"Whether this argument must be provided.","type":"boolean"}},"required":["name"],"type":"object"},"Resource":{"@context":{"@type":["http://anypoint.com/vocabs/mcp#Resource"]},"description":"A known resource that the server is capable of reading.","properties":{"annotations":{"$ref":"#/definitions/Annotations","description":"Optional annotations for the client."},"description":{"description":"A description of what this resource represents.\n\nThis can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a \"hint\" to the model.","type":"string"},"mimeType":{"description":"The MIME type of this resource, if known.","type":"string"},"name":{"description":"A human-readable name for this resource.\n\nThis can be used by clients to populate UI elements.","type":"string"},"size":{"description":"The size of the raw resource content, in bytes (i.e., before base64 encoding or any tokenization), if known.\n\nThis can be used by Hosts to display file sizes and estimate context window usage.","type":"integer"},"uri":{"description":"The URI of this resource.","format":"uri","type":"string"}},"required":["name","uri"],"type":"object"},"Annotations":{"description":"Optional annotations for the client. The client can use annotations to inform how objects are used or displayed","properties":{"audience":{"description":"Describes who the intended customer of this object or data is.\n\nIt can include multiple entries to indicate content useful for multiple audiences (e.g., `[\"user\", \"assistant\"]`).","items":{"$ref":"#/definitions/Role"},"type":"array"},"priority":{"description":"Describes how important this data is for operating the server.\n\nA value of 1 means \"most important,\" and indicates that the data is\neffectively required, while 0 means \"least important,\" and indicates that\nthe data is entirely optional.","maximum":1,"minimum":0,"type":"number"}},"type":"object"},"Role":{"description":"The sender or recipient of messages and data in a conversation.","enum":["assistant","user"],"type":"string"},"SecurityScheme":{"anyOf":[{"$ref":"#/definitions/APIKeySecurityScheme"},{"$ref":"#/definitions/HTTPAuthSecurityScheme"},{"$ref":"#/definitions/OAuth2SecurityScheme"},{"$ref":"#/definitions/OpenIdConnectSecurityScheme"}],"description":"Mirrors the OpenAPI Security Scheme Object\n(https://swagger.io/specification/#security-scheme-object)"},"APIKeySecurityScheme":{"description":"API Key security scheme.","properties":{"description":{"description":"Description of this security scheme.","type":"string"},"in":{"description":"The location of the API key. Valid values are \"query\", \"header\", or \"cookie\".","enum":["cookie","header","query"],"type":"string"},"name":{"description":"The name of the header, query or cookie parameter to be used.","type":"string"},"type":{"const":"apiKey","type":"string"}},"required":["in","name","type"],"type":"object"},"HTTPAuthSecurityScheme":{"description":"HTTP Authentication security scheme.","properties":{"bearerFormat":{"description":"A hint to the client to identify how the bearer token is formatted. Bearer tokens are usually\ngenerated by an authorization server, so this information is primarily for documentation\npurposes.","type":"string"},"description":{"description":"Description of this security scheme.","type":"string"},"scheme":{"description":"The name of the HTTP Authentication scheme to be used in the Authorization header as defined\nin RFC7235. The values used SHOULD be registered in the IANA Authentication Scheme registry.\nThe value is case-insensitive, as defined in RFC7235.","type":"string"},"type":{"const":"http","type":"string"}},"required":["scheme","type"],"type":"object"},"OAuth2SecurityScheme":{"description":"OAuth2.0 security scheme configuration.","properties":{"description":{"description":"Description of this security scheme.","type":"string"},"flows":{"$ref":"#/definitions/OAuthFlows","description":"An object containing configuration information for the flow types supported."},"type":{"const":"oauth2","type":"string"}},"required":["flows","type"],"type":"object"},"OAuthFlows":{"description":"Allows configuration of the supported OAuth Flows","properties":{"authorizationCode":{"$ref":"#/definitions/AuthorizationCodeOAuthFlow","description":"Configuration for the OAuth Authorization Code flow. Previously called accessCode in OpenAPI 2.0."},"clientCredentials":{"$ref":"#/definitions/ClientCredentialsOAuthFlow","description":"Configuration for the OAuth Client Credentials flow. Previously called application in OpenAPI 2.0"},"implicit":{"$ref":"#/definitions/ImplicitOAuthFlow","description":"Configuration for the OAuth Implicit flow"},"password":{"$ref":"#/definitions/PasswordOAuthFlow","description":"Configuration for the OAuth Resource Owner Password flow"}},"type":"object"},"AuthorizationCodeOAuthFlow":{"description":"Configuration details for a supported OAuth Flow","properties":{"authorizationUrl":{"description":"The authorization URL to be used for this flow. This MUST be in the form of a URL. The OAuth2\nstandard requires the use of TLS","type":"string"},"refreshUrl":{"description":"The URL to be used for obtaining refresh tokens. This MUST be in the form of a URL. The OAuth2\nstandard requires the use of TLS.","type":"string"},"scopes":{"additionalProperties":{"type":"string"},"description":"The available scopes for the OAuth2 security scheme. A map between the scope name and a short\ndescription for it. The map MAY be empty.","type":"object"},"tokenUrl":{"description":"The token URL to be used for this flow. This MUST be in the form of a URL. The OAuth2 standard\nrequires the use of TLS.","type":"string"}},"required":["authorizationUrl","scopes","tokenUrl"],"type":"object"},"ClientCredentialsOAuthFlow":{"description":"Configuration details for a supported OAuth Flow","properties":{"refreshUrl":{"description":"The URL to be used for obtaining refresh tokens. This MUST be in the form of a URL. The OAuth2\nstandard requires the use of TLS.","type":"string"},"scopes":{"additionalProperties":{"type":"string"},"description":"The available scopes for the OAuth2 security scheme. A map between the scope name and a short\ndescription for it. The map MAY be empty.","type":"object"},"tokenUrl":{"description":"The token URL to be used for this flow. This MUST be in the form of a URL. The OAuth2 standard\nrequires the use of TLS.","type":"string"}},"required":["scopes","tokenUrl"],"type":"object"},"ImplicitOAuthFlow":{"description":"Configuration details for a supported OAuth Flow","properties":{"authorizationUrl":{"description":"The authorization URL to be used for this flow. This MUST be in the form of a URL. The OAuth2\nstandard requires the use of TLS","type":"string"},"refreshUrl":{"description":"The URL to be used for obtaining refresh tokens. This MUST be in the form of a URL. The OAuth2\nstandard requires the use of TLS.","type":"string"},"scopes":{"additionalProperties":{"type":"string"},"description":"The available scopes for the OAuth2 security scheme. A map between the scope name and a short\ndescription for it. The map MAY be empty.","type":"object"}},"required":["authorizationUrl","scopes"],"type":"object"},"PasswordOAuthFlow":{"description":"Configuration details for a supported OAuth Flow","properties":{"refreshUrl":{"description":"The URL to be used for obtaining refresh tokens. This MUST be in the form of a URL. The OAuth2\nstandard requires the use of TLS.","type":"string"},"scopes":{"additionalProperties":{"type":"string"},"description":"The available scopes for the OAuth2 security scheme. A map between the scope name and a short\ndescription for it. The map MAY be empty.","type":"object"},"tokenUrl":{"description":"The token URL to be used for this flow. This MUST be in the form of a URL. The OAuth2 standard\nrequires the use of TLS.","type":"string"}},"required":["scopes","tokenUrl"],"type":"object"},"OpenIdConnectSecurityScheme":{"description":"OpenID Connect security scheme configuration.","properties":{"description":{"description":"Description of this security scheme.","type":"string"},"openIdConnectUrl":{"description":"Well-known URL to discover the [[OpenID-Connect-Discovery]] provider metadata.","type":"string"},"type":{"const":"openIdConnect","type":"string"}},"required":["openIdConnectUrl","type"],"type":"object"}}}""".stripMargin

}
