package amf.mcp.client.scala

import amf.core.client.common.validation.{ProfileName, ProfileNames}
import amf.core.client.scala.model.domain.Shape
import amf.core.client.scala.parse.AMFParser
import amf.mcp.internal.plugins.parse.schema.MCPSchemaLoader
import amf.shapes.client.scala.JsonSchemaBasedSpecBaseUnitClient

/** The AMF Client contains common AMF operations associated to base unit and documents. For more complex uses see
  * [[AMFParser]] or [[amf.core.client.scala.render.AMFRenderer]]
  */
class MCPBaseUnitClient private[amf] (override protected val configuration: MCPConfiguration)
    extends JsonSchemaBasedSpecBaseUnitClient(configuration) {

  override protected def schemaShape: Shape = MCPSchemaLoader.schema

  override protected def profile: ProfileName = ProfileNames.MCP
}
