/*
 * Decompiled with CFR 0.152.
 */
package amf.shapes.internal.domain.resolution.shape_normalization.recursions.analysis;

import amf.core.client.scala.model.domain.AmfArray;
import amf.core.client.scala.model.domain.AmfElement;
import amf.core.client.scala.model.domain.RecursiveShape;
import amf.core.client.scala.model.domain.Shape;
import amf.core.client.scala.model.domain.extensions.PropertyShape;
import amf.core.internal.metamodel.Field;
import amf.core.internal.metamodel.domain.ShapeModel$;
import amf.core.internal.parser.domain.Value;
import amf.shapes.client.scala.model.domain.AnyShape;
import amf.shapes.client.scala.model.domain.ArrayShape;
import amf.shapes.client.scala.model.domain.FileShape;
import amf.shapes.client.scala.model.domain.MatrixShape;
import amf.shapes.client.scala.model.domain.NilShape;
import amf.shapes.client.scala.model.domain.NodeShape;
import amf.shapes.client.scala.model.domain.ScalarShape;
import amf.shapes.client.scala.model.domain.TupleShape;
import amf.shapes.client.scala.model.domain.UnionShape;
import amf.shapes.internal.domain.resolution.shape_normalization.recursions.analysis.Analysis$;
import amf.shapes.internal.domain.resolution.shape_normalization.recursions.analysis.listeners.AnalysisListener;
import amf.shapes.internal.domain.resolution.shape_normalization.recursions.stack.MutableStack;
import amf.shapes.internal.domain.resolution.shape_normalization.recursions.stack.frames.BottomFrame;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005}g\u0001\u0002\u0011\"\u0001IB\u0001\"\u000f\u0001\u0003\u0002\u0004%\tA\u000f\u0005\t\u0019\u0002\u0011\t\u0019!C\u0001\u001b\"A1\u000b\u0001B\u0001B\u0003&1\bC\u0003U\u0001\u0011\u0005Q\u000bC\u0004Z\u0001\t\u0007I\u0011\u0001.\t\r\u0001\u0004\u0001\u0015!\u0003\\\u0011\u001d\t\u0007\u00011A\u0005\n\tDqa\u001e\u0001A\u0002\u0013%\u0001\u0010\u0003\u0004{\u0001\u0001\u0006Ka\u0019\u0005\u0006w\u0002!\t\u0001 \u0005\u0006w\u0002!\ta \u0005\b\u0003+\u0001A\u0011BA\f\u0011\u001d\tI\u0002\u0001C\u0005\u00037Aq!!\n\u0001\t\u0013\t9\u0003C\u0004\u0002,\u0001!I!!\f\t\u000f\u0005u\u0002\u0001\"\u0003\u0002@!9\u00111\t\u0001\u0005\n\u0005\u0015\u0003bBA.\u0001\u0011%\u0011Q\f\u0005\b\u0003_\u0002A\u0011BA9\u0011\u001d\ti\b\u0001C\u0005\u0003\u007fBq!a#\u0001\t\u0013\ti\tC\u0004\u0002\u001a\u0002!I!a'\t\u000f\u0005\u001d\u0006\u0001\"\u0003\u0002*\"9\u0011Q\u0016\u0001\u0005\n\u0005=\u0006bBA\\\u0001\u0011%\u0011\u0011\u0018\u0005\b\u0003{\u0003A\u0011BA`\u0011\u001d\t\u0019\r\u0001C\u0001\u0003\u000b<q!a3\"\u0011\u0003\tiM\u0002\u0004!C!\u0005\u0011q\u001a\u0005\u0007)v!\t!!5\t\u000f\u0005MW\u0004\"\u0001\u0002V\nA\u0011I\\1msNL7O\u0003\u0002#G\u0005A\u0011M\\1msNL7O\u0003\u0002%K\u0005Q!/Z2veNLwN\\:\u000b\u0005\u0019:\u0013aE:iCB,wL\\8s[\u0006d\u0017N_1uS>t'B\u0001\u0015*\u0003)\u0011Xm]8mkRLwN\u001c\u0006\u0003U-\na\u0001Z8nC&t'B\u0001\u0017.\u0003!Ig\u000e^3s]\u0006d'B\u0001\u00180\u0003\u0019\u0019\b.\u00199fg*\t\u0001'A\u0002b[\u001a\u001c\u0001a\u0005\u0002\u0001gA\u0011AgN\u0007\u0002k)\ta'A\u0003tG\u0006d\u0017-\u0003\u00029k\t1\u0011I\\=SK\u001a\f\u0011\u0002\\5ti\u0016tWM]:\u0016\u0003m\u00022\u0001\u0010#H\u001d\ti$I\u0004\u0002?\u00036\tqH\u0003\u0002Ac\u00051AH]8pizJ\u0011AN\u0005\u0003\u0007V\nq\u0001]1dW\u0006<W-\u0003\u0002F\r\n\u00191+Z9\u000b\u0005\r+\u0004C\u0001%K\u001b\u0005I%BA\u001d\"\u0013\tY\u0015J\u0001\tB]\u0006d\u0017p]5t\u0019&\u001cH/\u001a8fe\u0006iA.[:uK:,'o]0%KF$\"AT)\u0011\u0005Qz\u0015B\u0001)6\u0005\u0011)f.\u001b;\t\u000fI\u0013\u0011\u0011!a\u0001w\u0005\u0019\u0001\u0010J\u0019\u0002\u00151L7\u000f^3oKJ\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0003-b\u0003\"a\u0016\u0001\u000e\u0003\u0005BQ!\u000f\u0003A\u0002m\nQa\u001d;bG.,\u0012a\u0017\t\u00039zk\u0011!\u0018\u0006\u00033\u000eJ!aX/\u0003\u00195+H/\u00192mKN#\u0018mY6\u0002\rM$\u0018mY6!\u0003=\tGN]3bIf\fe.\u00197zu\u0016$W#A2\u0011\u0007\u0011D7N\u0004\u0002fMB\u0011a(N\u0005\u0003OV\na\u0001\u0015:fI\u00164\u0017BA5k\u0005\r\u0019V\r\u001e\u0006\u0003OV\u0002\"\u0001\\;\u000e\u00035T!A\u000b8\u000b\u0005=\u0004\u0018!B7pI\u0016d'B\u0001\u001cr\u0015\t\u00118/\u0001\u0004dY&,g\u000e\u001e\u0006\u0003i>\nAaY8sK&\u0011a/\u001c\u0002\u0006'\"\f\u0007/Z\u0001\u0014C2\u0014X-\u00193z\u0003:\fG.\u001f>fI~#S-\u001d\u000b\u0003\u001dfDqA\u0015\u0005\u0002\u0002\u0003\u00071-\u0001\tbYJ,\u0017\rZ=B]\u0006d\u0017P_3eA\u00059\u0011M\\1msj,GC\u0001(~\u0011\u0015q(\u00021\u0001l\u0003\u0015\u0019\b.\u00199f)\u0015q\u0015\u0011AA\u0002\u0011\u0015q8\u00021\u0001l\u0011\u001d\t)a\u0003a\u0001\u0003\u000f\tQAZ5fY\u0012\u0004B!!\u0003\u0002\u00125\u0011\u00111\u0002\u0006\u0005\u0003\u001b\ty!A\u0005nKR\fWn\u001c3fY*\u0011Af]\u0005\u0005\u0003'\tYAA\u0003GS\u0016dG-A\bo_RLg-\u001f'jgR,g.\u001a:t)\u0005q\u0015!H5t\u00032dwn^3e\u001bVdG/\u001b9mKRKW.Z:J]N#\u0018mY6\u0015\t\u0005u\u00111\u0005\t\u0004i\u0005}\u0011bAA\u0011k\t9!i\\8mK\u0006t\u0007\"\u0002@\u000e\u0001\u0004Y\u0017aE1oC2L(0\u001a*fM\u0016\u0014XM\\2fg&sGc\u0001(\u0002*!)aP\u0004a\u0001W\u0006i\u0011N\u001a(pi\u0006s\u0017\r\\={K\u0012$B!a\f\u0002<Q\u0019a*!\r\t\u000f\u0005Mr\u00021\u0001\u00026\u0005\u0011aM\u001c\t\u0006i\u0005]2NT\u0005\u0004\u0003s)$!\u0003$v]\u000e$\u0018n\u001c82\u0011\u0015qx\u00021\u0001l\u0003a\tg.\u00197zu\u0016\u0014VMZ3sK:\u001cWm]%o'\"\f\u0007/\u001a\u000b\u0004\u001d\u0006\u0005\u0003\"\u0002@\u0011\u0001\u0004Y\u0017aF1oC2L(0\u001a*fM\u0016\u0014XM\\2fg&sgj\u001c3f)\rq\u0015q\t\u0005\b\u0003\u0013\n\u0002\u0019AA&\u0003\u0011qw\u000eZ3\u0011\t\u00055\u0013qK\u0007\u0003\u0003\u001fR1AKA)\u0015\ry\u00171\u000b\u0006\u0004m\u0005U#B\u0001:.\u0013\u0011\tI&a\u0014\u0003\u00139{G-Z*iCB,\u0017aG1oC2L(0\u001a*fM\u0016\u0014XM\\2fg&s\u0007K]8qKJ$\u0018\u0010F\u0002O\u0003?Bq!!\u0019\u0013\u0001\u0004\t\u0019'\u0001\u0005qe>\u0004XM\u001d;z!\u0011\t)'a\u001b\u000e\u0005\u0005\u001d$bAA5[\u0006QQ\r\u001f;f]NLwN\\:\n\t\u00055\u0014q\r\u0002\u000e!J|\u0007/\u001a:usNC\u0017\r]3\u00021\u0005t\u0017\r\\={KJ+g-\u001a:f]\u000e,7/\u00138BeJ\f\u0017\u0010F\u0002O\u0003gBq!!\u001e\u0014\u0001\u0004\t9(A\u0003beJ\f\u0017\u0010\u0005\u0003\u0002N\u0005e\u0014\u0002BA>\u0003\u001f\u0012!\"\u0011:sCf\u001c\u0006.\u00199f\u0003e\tg.\u00197zu\u0016\u0014VMZ3sK:\u001cWm]%o\u001b\u0006$(/\u001b=\u0015\u00079\u000b\t\tC\u0004\u0002\u0004R\u0001\r!!\"\u0002\r5\fGO]5y!\u0011\ti%a\"\n\t\u0005%\u0015q\n\u0002\f\u001b\u0006$(/\u001b=TQ\u0006\u0004X-\u0001\rb]\u0006d\u0017P_3SK\u001a,'/\u001a8dKNLe\u000eV;qY\u0016$2ATAH\u0011\u001d\t\t*\u0006a\u0001\u0003'\u000bQ\u0001^;qY\u0016\u0004B!!\u0014\u0002\u0016&!\u0011qSA(\u0005)!V\u000f\u001d7f'\"\f\u0007/Z\u0001\u0019C:\fG.\u001f>f%\u00164WM]3oG\u0016\u001c\u0018J\\+oS>tGc\u0001(\u0002\u001e\"9\u0011q\u0014\fA\u0002\u0005\u0005\u0016!B;oS>t\u0007\u0003BA'\u0003GKA!!*\u0002P\tQQK\\5p]NC\u0017\r]3\u0002K\u0005t\u0017\r\\={KJ+g-\u001a:f]\u000e,7/\u00138M_\u001eL7-\u00197D_:\u001cHO]1j]R\u001cHc\u0001(\u0002,\")ap\u0006a\u0001W\u0006!\u0013M\\1msj,'+\u001a4fe\u0016t7-Z:J]2{w-[2bY\u000e{gn\u001d;sC&tG\u000fF\u0003O\u0003c\u000b\u0019\fC\u0003\u007f1\u0001\u00071\u000eC\u0004\u00026b\u0001\r!a\u0002\u0002\u001f\r|gn\u001d;sC&tGOR5fY\u0012\fQ$\u00198bYfTXMU3gKJ,gnY3t\u0013:\u0004&o\u001c9feRLWm\u001d\u000b\u0004\u001d\u0006m\u0006bBA%3\u0001\u0007\u00111J\u0001.C:\fG.\u001f>f%\u00164WM]3oG\u0016\u001c\u0018J\\!eI&$\u0018n\u001c8bYB\u0013x\u000e]3si&,7oU2iK6\fGc\u0001(\u0002B\"9\u0011\u0011\n\u000eA\u0002\u0005-\u0013AB1qa\u0016tG\rF\u0002O\u0003\u000fDa!!3\u001c\u0001\u00049\u0015\u0001\u00037jgR,g.\u001a:\u0002\u0011\u0005s\u0017\r\\=tSN\u0004\"aV\u000f\u0014\u0005u\u0019DCAAg\u0003\u0015\t\u0007\u000f\u001d7z)\r1\u0016q\u001b\u0005\u0007s}\u0001\r!!7\u0011\tQ\nYnR\u0005\u0004\u0003;,$A\u0003\u001fsKB,\u0017\r^3e}\u0001")
public class Analysis {
    private Seq<AnalysisListener> listeners;
    private final MutableStack stack;
    private Set<Shape> alreadyAnalyzed;

    public static Analysis apply(Seq<AnalysisListener> seq) {
        return Analysis$.MODULE$.apply(seq);
    }

    public Seq<AnalysisListener> listeners() {
        return this.listeners;
    }

    public void listeners_$eq(Seq<AnalysisListener> x$1) {
        this.listeners = x$1;
    }

    public MutableStack stack() {
        return this.stack;
    }

    private Set<Shape> alreadyAnalyzed() {
        return this.alreadyAnalyzed;
    }

    private void alreadyAnalyzed_$eq(Set<Shape> x$1) {
        this.alreadyAnalyzed = x$1;
    }

    public void analyze(Shape shape) {
        this.stack().push(new BottomFrame(shape));
        this.analyzeReferencesIn(shape);
        this.stack().pop();
    }

    public void analyze(Shape shape, Field field) {
        boolean alreadyInStack = this.stack().contains(shape.id());
        this.stack().push(shape, field);
        if (alreadyInStack && !this.isAllowedMultipleTimesInStack(shape)) {
            this.notifyListeners();
        } else {
            this.analyzeReferencesIn(shape);
        }
        this.stack().pop();
    }

    private void notifyListeners() {
        this.listeners().foreach((Function1 & Serializable & scala.Serializable)listener -> {
            listener.onRecursion(this.stack().readOnly(), this);
            return BoxedUnit.UNIT;
        });
    }

    private boolean isAllowedMultipleTimesInStack(Shape shape) {
        Shape shape2 = shape;
        return shape2 instanceof PropertyShape;
    }

    private void analyzeReferencesIn(Shape shape) {
        this.ifNotAnalyzed(shape, (Function1<Shape, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x0$1 -> {
            Analysis.$anonfun$analyzeReferencesIn$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void ifNotAnalyzed(Shape shape, Function1<Shape, BoxedUnit> fn) {
        if (!this.alreadyAnalyzed().contains((Object)shape) || this.isAllowedMultipleTimesInStack(shape)) {
            fn.apply((Object)shape);
            this.alreadyAnalyzed_$eq((Set<Shape>)((Set)this.alreadyAnalyzed().$plus((Object)shape)));
            return;
        }
    }

    private void analyzeReferencesInShape(Shape shape) {
        this.analyzeReferencesInLogicalConstraints(shape);
    }

    private void analyzeReferencesInNode(NodeShape node) {
        this.analyzeReferencesInLogicalConstraints(node);
        this.analyzeReferencesInProperties(node);
        this.analyzeReferencesInAdditionalPropertiesSchema(node);
    }

    private void analyzeReferencesInProperty(PropertyShape property) {
        this.analyze(property.range(), property.meta().Range());
    }

    private void analyzeReferencesInArray(ArrayShape array) {
        this.analyzeReferencesInLogicalConstraints(array);
        Shape shape = array.items();
        if (shape != null) {
            Shape shape2 = shape;
            this.analyze(shape2, array.meta().Items());
            return;
        }
    }

    private void analyzeReferencesInMatrix(MatrixShape matrix) {
        this.analyzeReferencesInLogicalConstraints(matrix);
        Shape shape = matrix.items();
        if (shape != null) {
            Shape shape2 = shape;
            this.analyze(shape2, matrix.meta().Items());
            return;
        }
    }

    private void analyzeReferencesInTuple(TupleShape tuple) {
        this.analyzeReferencesInLogicalConstraints(tuple);
        tuple.items().foreach((Function1 & Serializable & scala.Serializable)shape -> {
            this.analyze(shape, tuple.meta().TupleItems());
            return BoxedUnit.UNIT;
        });
    }

    private void analyzeReferencesInUnion(UnionShape union) {
        union.anyOf().foreach((Function1 & Serializable & scala.Serializable)s -> {
            this.analyze(s, union.meta().AnyOf());
            return BoxedUnit.UNIT;
        });
    }

    private void analyzeReferencesInLogicalConstraints(Shape shape) {
        this.analyzeReferencesInLogicalConstraint(shape, ShapeModel$.MODULE$.And());
        this.analyzeReferencesInLogicalConstraint(shape, ShapeModel$.MODULE$.Or());
        this.analyzeReferencesInLogicalConstraint(shape, ShapeModel$.MODULE$.Xone());
        this.analyzeReferencesInLogicalConstraint(shape, ShapeModel$.MODULE$.Not());
    }

    private void analyzeReferencesInLogicalConstraint(Shape shape, Field constraintField) {
        Option option = shape.fields().getValueAsOption(constraintField);
        if (option instanceof Some) {
            Some some = (Some)option;
            Value constraint = (Value)some.value();
            AmfElement amfElement = constraint.value();
            if (amfElement instanceof AmfArray) {
                AmfArray amfArray = (AmfArray)amfElement;
                amfArray.values().foreach((Function1 & Serializable & scala.Serializable)e -> {
                    this.analyze((Shape)e, constraintField);
                    return BoxedUnit.UNIT;
                });
            } else if (amfElement instanceof Shape) {
                Shape shape2 = (Shape)amfElement;
                this.analyze(shape2, constraintField);
            }
            return;
        }
    }

    private void analyzeReferencesInProperties(NodeShape node) {
        node.properties().foreach((Function1 & Serializable & scala.Serializable)s -> {
            this.analyze((Shape)s, node.meta().Properties());
            return BoxedUnit.UNIT;
        });
    }

    private void analyzeReferencesInAdditionalPropertiesSchema(NodeShape node) {
        Option$.MODULE$.apply((Object)node.additionalPropertiesSchema()).foreach((Function1 & Serializable & scala.Serializable)s -> {
            this.analyze(s, node.meta().AdditionalPropertiesSchema());
            return BoxedUnit.UNIT;
        });
    }

    public void append(AnalysisListener listener) {
        this.listeners_$eq((Seq<AnalysisListener>)((Seq)this.listeners().$colon$plus((Object)listener, Seq$.MODULE$.canBuildFrom())));
    }

    public static final /* synthetic */ void $anonfun$analyzeReferencesIn$1(Analysis $this, Shape x0$1) {
        Shape shape = x0$1;
        if (shape instanceof UnionShape) {
            UnionShape unionShape = (UnionShape)shape;
            $this.analyzeReferencesInUnion(unionShape);
            return;
        }
        if (shape instanceof ScalarShape) {
            ScalarShape scalarShape = (ScalarShape)shape;
            $this.analyzeReferencesInShape(scalarShape);
            return;
        }
        if (shape instanceof ArrayShape) {
            ArrayShape arrayShape = (ArrayShape)shape;
            $this.analyzeReferencesInArray(arrayShape);
            return;
        }
        if (shape instanceof MatrixShape) {
            MatrixShape matrixShape = (MatrixShape)shape;
            $this.analyzeReferencesInMatrix(matrixShape);
            return;
        }
        if (shape instanceof TupleShape) {
            TupleShape tupleShape = (TupleShape)shape;
            $this.analyzeReferencesInTuple(tupleShape);
            return;
        }
        if (shape instanceof PropertyShape) {
            PropertyShape propertyShape = (PropertyShape)shape;
            $this.analyzeReferencesInProperty(propertyShape);
            return;
        }
        if (shape instanceof FileShape) {
            FileShape fileShape = (FileShape)shape;
            $this.analyzeReferencesInShape(fileShape);
            return;
        }
        if (shape instanceof NilShape) {
            NilShape nilShape = (NilShape)shape;
            $this.analyzeReferencesInShape(nilShape);
            return;
        }
        if (shape instanceof NodeShape) {
            NodeShape nodeShape = (NodeShape)shape;
            $this.analyzeReferencesInNode(nodeShape);
            return;
        }
        if (shape instanceof AnyShape) {
            AnyShape anyShape = (AnyShape)shape;
            $this.analyzeReferencesInShape(anyShape);
            return;
        }
        if (shape instanceof RecursiveShape) {
            return;
        }
        throw new MatchError((Object)shape);
    }

    public Analysis(Seq<AnalysisListener> listeners) {
        this.listeners = listeners;
        this.stack = new MutableStack();
        this.alreadyAnalyzed = Predef$.MODULE$.Set().empty();
    }
}

