package amf.shapes.internal.spec.raml.parser.expression

import amf.core.client.scala.model.domain.Shape
import amf.core.internal.annotations.LexicalInformation
import amf.core.internal.parser.domain.Annotations

private[expression] trait AnnotationHelper {
  val annotations: Annotations

  protected def fillAnnotationsFor(token: Token): Annotations = annotations.copy() += token.lexicalInformation

  protected def fillAnnotationsFor(startToken: Token, endToken: Token): Annotations =
    annotations.copy() += computeLexical(startToken, endToken)

  protected def setShapeAnnotation(shape: Shape, startToken: Token, maybeEndToken: Option[Token]): Shape = {
    maybeEndToken.foreach { endToken =>
      shape.annotations ++= fillAnnotationsFor(startToken, endToken)
    }
    shape
  }

  protected def setShapeAnnotation(shapeToAnnotate: Shape, leftShape: Shape, rightShape: Shape): Shape = {
    val leftLexical     = leftShape.annotations.lexical()
    val rightLexical    = rightShape.annotations.lexical()
    val nextAnnotations = annotations.copy() += LexicalInformation(leftLexical.start, rightLexical.`end`)
    shapeToAnnotate.annotations ++= nextAnnotations
    shapeToAnnotate
  }

  protected def computeLexical(startToken: Token, endToken: Token): LexicalInformation = {
    LexicalInformation(startToken.lexicalInformation.range.start, endToken.lexicalInformation.range.end)
  }
}
