/*
 * Decompiled with CFR 0.152.
 */
package amf.shapes.internal.spec.jsonschema.semanticjsonschema;

import amf.aml.client.scala.model.document.Dialect;
import amf.aml.client.scala.model.document.Dialect$;
import amf.aml.client.scala.model.document.Vocabulary;
import amf.core.client.common.HighPriority$;
import amf.core.client.common.PluginPriority;
import amf.core.client.scala.config.ParsingOptions;
import amf.core.client.scala.errorhandling.AMFErrorHandler;
import amf.core.client.scala.model.document.BaseUnit;
import amf.core.client.scala.model.domain.AmfObject;
import amf.core.client.scala.parse.AMFParsePlugin;
import amf.core.client.scala.parse.document.ParsedDocument;
import amf.core.client.scala.parse.document.ParserContext;
import amf.core.client.scala.parse.document.ReferenceHandler;
import amf.core.client.scala.parse.document.ReferenceKind;
import amf.core.client.scala.parse.document.SyamlParsedDocument;
import amf.core.client.scala.parse.document.UnspecifiedReference$;
import amf.core.internal.parser.ParseConfiguration;
import amf.core.internal.parser.Root;
import amf.core.internal.parser.domain.FutureDeclarations;
import amf.core.internal.plugins.AMFPlugin;
import amf.core.internal.remote.JsonSchemaDialect$;
import amf.core.internal.remote.Mimes$;
import amf.core.internal.remote.Spec;
import amf.shapes.client.scala.model.domain.AnyShape;
import amf.shapes.client.scala.model.domain.SemanticContext;
import amf.shapes.client.scala.model.domain.SemanticContext$;
import amf.shapes.internal.spec.common.JSONSchemaDraft201909SchemaVersion$;
import amf.shapes.internal.spec.common.JSONSchemaVersion;
import amf.shapes.internal.spec.common.parser.ShapeParserContext;
import amf.shapes.internal.spec.jsonschema.ref.JsonSchemaParser;
import amf.shapes.internal.spec.jsonschema.semanticjsonschema.CombiningComplexityCalculator;
import amf.shapes.internal.spec.jsonschema.semanticjsonschema.SemanticJsonSchemaValidations$;
import amf.shapes.internal.spec.jsonschema.semanticjsonschema.context.JsonLdSchemaContext$;
import amf.shapes.internal.spec.jsonschema.semanticjsonschema.reference.SemanticContextReferenceHandler;
import amf.shapes.internal.spec.jsonschema.semanticjsonschema.transform.DialectWrapper$;
import amf.shapes.internal.spec.jsonschema.semanticjsonschema.transform.SchemaTransformer;
import amf.shapes.internal.spec.jsonschema.semanticjsonschema.transform.SchemaTransformerOptions;
import amf.shapes.internal.spec.jsonschema.semanticjsonschema.transform.SchemaTransformerOptions$;
import amf.shapes.internal.spec.jsonschema.semanticjsonschema.transform.TransformationResult;
import amf.shapes.internal.spec.jsonschema.semanticjsonschema.transform.VocabularyGenerator$;
import amf.shapes.internal.transformation.stages.SemanticContextResolver;
import java.io.Serializable;
import org.yaml.convert.YRead;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

public final class JsonSchemaDialectParsePlugin$
implements AMFParsePlugin {
    public static JsonSchemaDialectParsePlugin$ MODULE$;
    private final String id;

    static {
        new JsonSchemaDialectParsePlugin$();
    }

    public boolean equals(Object obj) {
        return AMFPlugin.equals$((AMFPlugin)this, (Object)obj);
    }

    public void amf$core$client$scala$parse$AMFParsePlugin$_setter_$id_$eq(String x$1) {
    }

    public String id() {
        return this.id;
    }

    public boolean applies(Root element) {
        ParsedDocument parsedDocument = element.parsed();
        if (parsedDocument instanceof SyamlParsedDocument) {
            SyamlParsedDocument syamlParsedDocument = (SyamlParsedDocument)parsedDocument;
            ReferenceKind referenceKind = element.referenceKind();
            UnspecifiedReference$ unspecifiedReference$ = UnspecifiedReference$.MODULE$;
            return !(referenceKind != null ? !referenceKind.equals(unspecifiedReference$) : unspecifiedReference$ != null) && syamlParsedDocument.document().node().asOption((YRead)YRead.YMapYRead$.MODULE$).isDefined();
        }
        return false;
    }

    public PluginPriority priority() {
        return HighPriority$.MODULE$;
    }

    public boolean withIdAdoption() {
        return false;
    }

    public BaseUnit parse(Root document, ParserContext ctx) {
        SchemaTransformerOptions options = SchemaTransformerOptions$.MODULE$.DEFAULT();
        ParserContext qual$1 = ctx.copyWithSonsReferences();
        Seq x$1 = document.references();
        String x$2 = qual$1.copy$default$1();
        FutureDeclarations x$3 = qual$1.copy$default$3();
        ParseConfiguration x$4 = qual$1.copy$default$4();
        ShapeParserContext newCtx = this.context(qual$1.copy(x$2, x$1, x$3, x$4));
        JsonSchemaParser qual$2 = new JsonSchemaParser();
        Root x$5 = document;
        ShapeParserContext x$6 = newCtx;
        ParsingOptions x$7 = ctx.parsingOptions();
        Option<JSONSchemaVersion> x$8 = qual$2.parse$default$4();
        AnyShape parsed = qual$2.parse(x$5, x$6, x$7, x$8);
        ctx.config().idAdopterProvider().idAdopter(document.location()).adoptFromRelative((AmfObject)parsed);
        if (this.evaluateCombiningComplexity(parsed, ctx)) {
            return this.transformSchemaToDialect(document, ctx, options, parsed);
        }
        return this.dummyDialect(document, options);
    }

    private Dialect transformSchemaToDialect(Root document, ParserContext ctx, SchemaTransformerOptions options, AnyShape parsed) {
        SemanticContextResolver qual$1 = new SemanticContextResolver(ctx.eh());
        AnyShape x$1 = parsed;
        SemanticContext x$2 = SemanticContext$.MODULE$.apply();
        boolean x$3 = qual$1.computeContext$default$3();
        qual$1.computeContext(x$1, x$2, x$3);
        TransformationResult transformed = new SchemaTransformer(parsed, options, ctx.eh()).transform();
        Dialect dialect = DialectWrapper$.MODULE$.apply(transformed, options, document.location()).wrapTransformationResult();
        Option<Vocabulary> vocabulary = VocabularyGenerator$.MODULE$.apply(dialect, transformed.terms(), options).generateVocabulary();
        vocabulary.foreach((Function1 & Serializable & scala.Serializable)vocab -> (Dialect)dialect.withReferences((Seq)new .colon.colon(vocab, (List)Nil$.MODULE$)));
        return dialect;
    }

    private Dialect dummyDialect(Root document, SchemaTransformerOptions options) {
        return (Dialect)((Dialect)Dialect$.MODULE$.apply().withId(document.location())).withName(options.dialectName()).withVersion(options.dialectVersion()).withRoot(true);
    }

    private boolean evaluateCombiningComplexity(AnyShape parsed, ParserContext ctx) {
        Option option = ctx.parsingOptions().maxJSONComplexity();
        if (option instanceof Some) {
            Some some = (Some)option;
            int max = BoxesRunTime.unboxToInt((Object)some.value());
            int shapeComplexity = new CombiningComplexityCalculator().calculateComplexity(parsed);
            if (shapeComplexity > max) {
                ctx.violation(SemanticJsonSchemaValidations$.MODULE$.ExceededMaxCombiningComplexity(), (AmfObject)parsed, new StringBuilder(86).append("The JSON Schema is too complex: it has a combining complexity of ").append(shapeComplexity).append(" when the maximum is ").append(max).toString());
                return false;
            }
            return true;
        }
        if (None$.MODULE$.equals(option)) {
            return true;
        }
        throw new MatchError((Object)option);
    }

    private ShapeParserContext context(ParserContext wrapped) {
        return JsonLdSchemaContext$.MODULE$.apply(wrapped, (Option<JSONSchemaVersion>)new Some((Object)JSONSchemaDraft201909SchemaVersion$.MODULE$));
    }

    public Seq<String> mediaTypes() {
        return (Seq)new .colon.colon((Object)Mimes$.MODULE$.application$divsemantics$plusschema$plusjson(), (List)new .colon.colon((Object)Mimes$.MODULE$.application$divjson(), (List)Nil$.MODULE$));
    }

    public Seq<Spec> validSpecsToReference() {
        return Nil$.MODULE$;
    }

    public ReferenceHandler referenceHandler(AMFErrorHandler eh) {
        return new SemanticContextReferenceHandler(eh);
    }

    public boolean allowRecursiveReferences() {
        return true;
    }

    public Spec spec() {
        return JsonSchemaDialect$.MODULE$;
    }

    private JsonSchemaDialectParsePlugin$() {
        MODULE$ = this;
        AMFPlugin.$init$((AMFPlugin)this);
        AMFParsePlugin.$init$((AMFParsePlugin)this);
        this.id = "JSON Schema Dialect";
    }
}

