package amf.shapes.internal.annotations

import amf.core.client.scala.model.domain._
import org.yaml.model.{YMapEntry, YPart}

case class InlineDefinition() extends Annotation

case class ParsedJSONSchema(rawText: String) extends EternalSerializedAnnotation {
  override val name: String  = "parsed-json-schema"
  override val value: String = rawText
}

object ParsedJSONSchema extends AnnotationGraphLoader {
  override def unparse(value: String, objects: Map[String, AmfElement]): Option[Annotation] =
    Some(ParsedJSONSchema(value))
}

case class AVROSchemaType(avroType: String) extends EternalSerializedAnnotation {
  override val name: String  = "avro-schema"
  override val value: String = avroType
}

object AVROSchemaType {
  def unparse(avroType: String): Option[Annotation] = Some(AVROSchemaType(avroType))
}

case class AVRORawSchema(avroRawSchema: String) extends EternalSerializedAnnotation {
  override val name: String  = "avro-raw-schema"
  override val value: String = avroRawSchema
}

object AVRORawSchema {
  def unparse(avroRawSchema: String): Option[Annotation] = Some(AVRORawSchema(avroRawSchema))
}

case class DocumentDeclarationKey(key: String) extends EternalSerializedAnnotation {
  override val name: String  = "document-declaration-key"
  override val value: String = key
}

object DocumentDeclarationKey extends AnnotationGraphLoader {
  override def unparse(value: String, objects: Map[String, AmfElement]): Option[Annotation] =
    Some(DocumentDeclarationKey(value))
}

/** Represents parsed RAML Data Type from any type of RAML document. */
case class ParsedRamlDatatype(rawText: String) extends SerializableAnnotation with PerpetualAnnotation {
  override val name: String  = "parsed-raml-datatype"
  override val value: String = rawText
}

object ParsedRamlDatatype extends AnnotationGraphLoader {
  override def unparse(value: String, objects: Map[String, AmfElement]): Option[Annotation] =
    Some(ParsedRamlDatatype(value))
}

case class ParsedJSONExample(rawText: String) extends SerializableAnnotation with PerpetualAnnotation {
  override val name: String  = "parsed-json-example"
  override val value: String = rawText
}

object ParsedJSONExample extends AnnotationGraphLoader {
  override def unparse(value: String, objects: Map[String, AmfElement]): Option[Annotation] =
    Some(ParsedJSONExample(value))
}

case class SchemaIsJsonSchema() extends Annotation

case class ExternalSchemaWrapper() extends Annotation

case class GeneratedJSONSchema(rawText: String) extends Annotation

/** Represents generated RAML Data Type. */
case class GeneratedRamlDatatype(rawText: String) extends Annotation

/** Mark the declaration as the root of the JSON schema. */
case class JSONSchemaRoot() extends Annotation

case class JSONSchemaId(id: String) extends SerializableAnnotation with PerpetualAnnotation {
  override val name: String  = "json-schema-id"
  override val value: String = id
}

object JSONSchemaId extends AnnotationGraphLoader {
  override def unparse(value: String, objects: Map[String, AmfElement]): Option[Annotation] = Some(JSONSchemaId(value))
}

case class ExternalJsonSchemaShape(original: YMapEntry) extends Annotation

// used internally for emission of links that have been inlined. This annotation is removed in resolution
case class ExternalReferenceUrl(url: String) extends Annotation

case class CollectionFormatFromItems() extends Annotation

case class ForceEntry() extends Annotation

case class BooleanSchema() extends Annotation

case class DirectiveArguments() extends Annotation

case class BaseVirtualNode(ast: YPart) extends Annotation

case class InputTypeField() extends Annotation

/** When getting a schema from and external file, it's original name may be replaced by a new one. That original name is
  * the one stored by this Annotation. Used by ALS to link.
  */
case class TargetName(name: YPart) extends Annotation

/**
 * Annotation needed by ALS to have the definition original definition of the schema in a JsonLdElement
 */
case class SourceSchemaDef(definition: Shape) extends Annotation
