package amf.shapes.internal.spec.jsonldschema

import amf.core.client.scala.model.document.Document
import amf.core.client.scala.model.domain.Shape
import amf.core.client.scala.model.domain.context.EntityContextBuilder
import amf.core.client.scala.parse.document.{ParserContext, SyamlParsedDocument}
import amf.core.internal.parser.Root
import amf.shapes.client.scala.model.document.JsonLDInstanceDocument
import amf.shapes.client.scala.model.domain.AnyShape
import amf.shapes.client.scala.model.domain.jsonldinstance.{JsonLDArray, JsonLDObject}
import amf.shapes.internal.spec.jsonldschema.parser.builder.JsonLDElementBuilder
import amf.shapes.internal.spec.jsonldschema.parser.{
  ConfigValidatorFactory,
  JsonLDParserContext,
  JsonLDSchemaNodeParser,
  JsonPath
}
import amf.shapes.internal.spec.jsonldschema.validation.JsonLDSchemaValidations.IncompatibleDomainElement
import org.yaml.model.YNode

class JsonLDSchemaNativeParser(ctx: ParserContext) {

  def parse(root: Root, jsonSchema: Document): JsonLDInstanceDocument = {
    val node    = root.parsed.asInstanceOf[SyamlParsedDocument].document.node
    val builder = getRootBuilder(node, jsonSchema)

    val ctxBuilder = new EntityContextBuilder()
    val element    = builder.build(ctxBuilder)._1
    val instance   = JsonLDInstanceDocument(ctxBuilder.build())
    element match {
      case obj: JsonLDObject  => instance.withEncodes(Seq(obj))
      case array: JsonLDArray => instance.withEncodes(array.jsonLDElements)
      case _                  => // ignore
    }
    instance
  }

  private def getRootBuilder(node: YNode, jsonSchema: Document): JsonLDElementBuilder = {
    val shape: Shape = jsonSchema.encodes match {
      case s: Shape => s
      case other =>
        ctx.eh.violation(IncompatibleDomainElement, other.id, IncompatibleDomainElement.message)
        AnyShape()
    }

    JsonLDSchemaNodeParser(shape, node, "encodes", JsonPath.empty, isRoot = true)(
      new JsonLDParserContext(ctx.eh, validatorFactory = ConfigValidatorFactory, options = ctx.parsingOptions)
    ).parse()
  }
}
