/*
 * Decompiled with CFR 0.152.
 */
package amf.plugins.features.validation;

import amf.ProfileNames;
import amf.core.benchmark.ExecutionLog$;
import amf.core.emitter.RenderOptions;
import amf.core.emitter.RenderOptions$;
import amf.core.model.document.BaseUnit;
import amf.core.rdf.RdfFramework;
import amf.core.rdf.RdfModel;
import amf.core.rdf.RdfModelEmitter;
import amf.core.validation.core.ValidationReport;
import amf.core.validation.core.ValidationSpecification;
import amf.plugins.features.validation.CachedScriptEngine;
import amf.plugins.features.validation.JVMValidationReport;
import amf.plugins.features.validation.JenaRdfModel;
import amf.plugins.features.validation.JenaRdfModel$;
import amf.plugins.features.validation.RDFPrinter$;
import amf.plugins.features.validation.SHACL$;
import amf.plugins.features.validation.emitters.ValidationRdfModelEmitter;
import amf.plugins.features.validation.emitters.ValidationRdfModelEmitter$;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.js.JSScriptEngine;
import org.topbraid.shacl.js.JSScriptEngineFactory;
import org.topbraid.shacl.js.SHACLScriptEngineManager;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001B\u0001\u0003\u0001-\u0011ab\u0015%B\u000723\u0016\r\\5eCR|'O\u0003\u0002\u0004\t\u0005Qa/\u00197jI\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011\u0001\u00034fCR,(/Z:\u000b\u0005\u001dA\u0011a\u00029mk\u001eLgn\u001d\u0006\u0002\u0013\u0005\u0019\u0011-\u001c4\u0004\u0001M\u0019\u0001\u0001\u0004\n\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g!\t\u0019\u0002$D\u0001\u0015\u0015\t)b#\u0001\u0003d_J,'BA\u0002\u0018\u0015\t)\u0002\"\u0003\u0002\u0002)!)!\u0004\u0001C\u00017\u00051A(\u001b8jiz\"\u0012\u0001\b\t\u0003;\u0001i\u0011A\u0001\u0005\b?\u0001\u0001\r\u0011\"\u0001!\u0003-1WO\\2uS>tWK\u001d7\u0016\u0003\u0005\u00022!\u0004\u0012%\u0013\t\u0019cB\u0001\u0004PaRLwN\u001c\t\u0003K1r!A\n\u0016\u0011\u0005\u001drQ\"\u0001\u0015\u000b\u0005%R\u0011A\u0002\u001fs_>$h(\u0003\u0002,\u001d\u00051\u0001K]3eK\u001aL!!\f\u0018\u0003\rM#(/\u001b8h\u0015\tYc\u0002C\u00041\u0001\u0001\u0007I\u0011A\u0019\u0002\u001f\u0019,hn\u0019;j_:,&\u000f\\0%KF$\"AM\u001b\u0011\u00055\u0019\u0014B\u0001\u001b\u000f\u0005\u0011)f.\u001b;\t\u000fYz\u0013\u0011!a\u0001C\u0005\u0019\u0001\u0010J\u0019\t\ra\u0002\u0001\u0015)\u0003\"\u000311WO\\2uS>tWK\u001d7!\u0011\u001dQ\u0004\u00011A\u0005\u0002\u0001\nABZ;oGRLwN\\\"pI\u0016Dq\u0001\u0010\u0001A\u0002\u0013\u0005Q(\u0001\tgk:\u001cG/[8o\u0007>$Wm\u0018\u0013fcR\u0011!G\u0010\u0005\bmm\n\t\u00111\u0001\"\u0011\u0019\u0001\u0005\u0001)Q\u0005C\u0005ia-\u001e8di&|gnQ8eK\u0002BqA\u0011\u0001C\u0002\u0013\u00051)A\u0004g_Jl\u0017\r^:\u0016\u0003\u0011\u0003B!\u0012&M\u00196\taI\u0003\u0002H\u0011\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003\u0013:\t!bY8mY\u0016\u001cG/[8o\u0013\tYeIA\u0002NCB\u0004\"!\u0014*\u000e\u00039S!a\u0014)\u0002\t1\fgn\u001a\u0006\u0002#\u0006!!.\u0019<b\u0013\tic\n\u0003\u0004U\u0001\u0001\u0006I\u0001R\u0001\tM>\u0014X.\u0019;tA!)a\u000b\u0001C!/\u0006Aa/\u00197jI\u0006$X\rF\u0003Y=\u0002\u0014G\rE\u0002Z9\u0012j\u0011A\u0017\u0006\u00037:\t!bY8oGV\u0014(/\u001a8u\u0013\ti&L\u0001\u0004GkR,(/\u001a\u0005\u0006?V\u0003\r\u0001J\u0001\u0005I\u0006$\u0018\rC\u0003b+\u0002\u0007A%A\u0007eCR\fW*\u001a3jCRK\b/\u001a\u0005\u0006GV\u0003\r\u0001J\u0001\u0007g\"\f\u0007/Z:\t\u000b\u0015,\u0006\u0019\u0001\u0013\u0002\u001fMD\u0017\r]3t\u001b\u0016$\u0017.\u0019+za\u0016DQa\u001a\u0001\u0005\n!\f\u0011\u0002\\8bI6{G-\u001a7\u0015\u0007%<\b\u0010\u0005\u0002kk6\t1N\u0003\u0002m[\u0006)Qn\u001c3fY*\u0011an\\\u0001\u0004e\u00124'B\u00019r\u0003\u0011QWM\\1\u000b\u0005I\u001c\u0018AB1qC\u000eDWMC\u0001u\u0003\ry'oZ\u0005\u0003m.\u0014Q!T8eK2DQa\u00184A\u0002\u0011BQ!\u001f4A\u0002\u0011\n\u0011\"\\3eS\u0006$\u0016\u0010]3\t\u000bm\u0004A\u0011\t?\u0002\rI,\u0007o\u001c:u)%i\u00181AA\u0003\u0003\u000f\tI\u0001E\u0002Z9z\u0004\"aE@\n\u0007\u0005\u0005AC\u0001\tWC2LG-\u0019;j_:\u0014V\r]8si\")qL\u001fa\u0001I!)\u0011M\u001fa\u0001I!)1M\u001fa\u0001I!)QM\u001fa\u0001I!9\u0011Q\u0002\u0001\u0005B\u0005=\u0011a\u0004:fO&\u001cH/\u001a:MS\n\u0014\u0018M]=\u0015\u000bI\n\t\"!\u0006\t\u000f\u0005M\u00111\u0002a\u0001I\u0005\u0019QO\u001d7\t\u000f\u0005]\u00111\u0002a\u0001I\u0005!1m\u001c3f\u0011\u001d\tY\u0002\u0001C\t\u0003;\t1\u0002\\8bI2K'M]1ssR\t!\u0007\u0003\u0004W\u0001\u0011\u0005\u0013\u0011\u0005\u000b\b1\u0006\r\u00121GA'\u0011\u001dy\u0016q\u0004a\u0001\u0003K\u0001B!a\n\u000205\u0011\u0011\u0011\u0006\u0006\u0005\u0003W\ti#\u0001\u0005e_\u000e,X.\u001a8u\u0015\taw#\u0003\u0003\u00022\u0005%\"\u0001\u0003\"bg\u0016,f.\u001b;\t\u000f\r\fy\u00021\u0001\u00026A1\u0011qGA!\u0003\u000frA!!\u000f\u0002>9\u0019q%a\u000f\n\u0003=I1!a\u0010\u000f\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0011\u0002F\t\u00191+Z9\u000b\u0007\u0005}b\u0002E\u0002\u0014\u0003\u0013J1!a\u0013\u0015\u0005]1\u0016\r\\5eCRLwN\\*qK\u000eLg-[2bi&|g\u000e\u0003\u0005\u0002P\u0005}\u0001\u0019AA)\u00031iWm]:bO\u0016\u001cF/\u001f7f!\u0011\t\u0019&!\u0018\u000f\t\u0005U\u0013\u0011\f\b\u0004O\u0005]\u0013\"A\u0005\n\u0007\u0005m\u0003\"\u0001\u0007Qe>4\u0017\u000e\\3OC6,7/\u0003\u0003\u0002`\u0005\u0005$\u0001D'fgN\fw-Z*us2,'bAA.\u0011!11\u0010\u0001C!\u0003K\"r!`A4\u0003S\nY\u0007C\u0004`\u0003G\u0002\r!!\n\t\u000f\r\f\u0019\u00071\u0001\u00026!A\u0011qJA2\u0001\u0004\t\t\u0006\u0003\u0004d\u0001\u0011\u0005\u0013q\u000e\u000b\u0007\u0003c\nY(! \u0011\t\u0005M\u0014qO\u0007\u0003\u0003kR!A\\\f\n\t\u0005e\u0014Q\u000f\u0002\t%\u00124Wj\u001c3fY\"91-!\u001cA\u0002\u0005U\u0002bBA@\u0003[\u0002\r\u0001J\u0001\rMVt7\r^5p]N,&\u000f\u001c\u0005\b\u0003\u0007\u0003A\u0011IAC\u00035)W\u000e\u001d;z%\u00124Wj\u001c3fYR\u0011\u0011\u0011\u000f")
public class SHACLValidator
implements amf.core.validation.core.SHACLValidator {
    private Option<String> functionUrl;
    private Option<String> functionCode;
    private final Map<String, String> formats;

    public RdfModel unitToRdfModel(BaseUnit unit, RenderOptions options) {
        return RdfFramework.unitToRdfModel$((RdfFramework)this, (BaseUnit)unit, (RenderOptions)options);
    }

    public Option<String> functionUrl() {
        return this.functionUrl;
    }

    public void functionUrl_$eq(Option<String> x$1) {
        this.functionUrl = x$1;
    }

    public Option<String> functionCode() {
        return this.functionCode;
    }

    public void functionCode_$eq(Option<String> x$1) {
        this.functionCode = x$1;
    }

    public Map<String, String> formats() {
        return this.formats;
    }

    public Future<String> validate(String data, String dataMediaType, String shapes, String shapesMediaType) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Model dataModel = this.loadModel(StringUtils.chomp((String)data), dataMediaType);
            Model shapesModel = this.loadModel(StringUtils.chomp((String)shapes), shapesMediaType);
            this.loadLibrary();
            boolean res = SHACLScriptEngineManager.begin();
            None$ report = None$.MODULE$;
            try {
                SHACLScriptEngineManager.getCurrentEngine().executeScriptFromURL("http://datashapes.org/js/rdfquery.js");
                report = new Some((Object)SHACL$.MODULE$.validate(dataModel, shapesModel));
            }
            finally {
                SHACLScriptEngineManager.end((boolean)res);
            }
            return RDFPrinter$.MODULE$.apply(((RDFNode)report.get()).getModel(), "JSON-LD");
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private Model loadModel(String data, String mediaType) {
        Option option = this.formats().get((Object)mediaType);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported media type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mediaType})));
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        String format = (String)some.value();
        Model dataModel = JenaUtil.createMemoryModel();
        dataModel.read(IOUtils.toInputStream((String)data, (Charset)Charset.defaultCharset()), "urn:dummy", format);
        Model model = dataModel;
        return model;
    }

    public Future<ValidationReport> report(String data, String dataMediaType, String shapes, String shapesMediaType) {
        return this.validate(data, dataMediaType, shapes, shapesMediaType).map((Function1 & Serializable & scala.Serializable)x$1 -> new JVMValidationReport((String)x$1), ExecutionContext.Implicits$.MODULE$.global());
    }

    public void registerLibrary(String url, String code) {
        this.functionUrl_$eq((Option<String>)new Some((Object)url));
        this.functionCode_$eq((Option<String>)new Some((Object)code));
    }

    public void loadLibrary() {
        JSScriptEngineFactory.set((JSScriptEngineFactory)new JSScriptEngineFactory(this){
            private final /* synthetic */ SHACLValidator $outer;

            public JSScriptEngine createScriptEngine() {
                return new CachedScriptEngine(this.$outer.functionUrl(), this.$outer.functionCode());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Future<String> validate(BaseUnit data, Seq<ValidationSpecification> shapes, ProfileNames.MessageStyle messageStyle) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            ExecutionLog$.MODULE$.log("SHACLValidator#validate: loading Jena data model");
            JenaRdfModel dataModel = new JenaRdfModel(JenaRdfModel$.MODULE$.$lessinit$greater$default$1());
            new RdfModelEmitter((RdfModel)dataModel).emit(data, RenderOptions$.MODULE$.apply().withValidation());
            ExecutionLog$.MODULE$.log("SHACLValidator#validate: loading Jena shapes model");
            JenaRdfModel shapesModel = new JenaRdfModel(JenaRdfModel$.MODULE$.$lessinit$greater$default$1());
            new ValidationRdfModelEmitter(messageStyle.profileName(), shapesModel, ValidationRdfModelEmitter$.MODULE$.$lessinit$greater$default$3()).emit(shapes);
            ExecutionLog$.MODULE$.log("SHACLValidator#validate: loading library");
            this.loadLibrary();
            ExecutionLog$.MODULE$.log("SHACLValidator#validate: starting script engine");
            boolean res = SHACLScriptEngineManager.begin();
            None$ report = None$.MODULE$;
            try {
                SHACLScriptEngineManager.getCurrentEngine().executeScriptFromURL("http://datashapes.org/js/rdfquery.js");
                ExecutionLog$.MODULE$.log(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SHACLValidator#validate: Number of data triples -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)dataModel.model().listStatements().toList().size())})));
                ExecutionLog$.MODULE$.log(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SHACLValidator#validate: Number of shapes triples -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)shapesModel.model().listStatements().toList().size())})));
                ExecutionLog$.MODULE$.log(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SHACLValidator#validate: validating..."})).s((Seq)Nil$.MODULE$));
                report = new Some((Object)SHACL$.MODULE$.validate(dataModel.model(), shapesModel.model()));
            }
            catch (Throwable throwable) {
                ExecutionLog$.MODULE$.log(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SHACLValidator#validate: releasing script manager resources"})).s((Seq)Nil$.MODULE$));
                SHACLScriptEngineManager.end((boolean)res);
                throw throwable;
            }
            ExecutionLog$.MODULE$.log(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SHACLValidator#validate: releasing script manager resources"})).s((Seq)Nil$.MODULE$));
            SHACLScriptEngineManager.end((boolean)res);
            ExecutionLog$.MODULE$.log(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SHACLValidator#validate: Generating JSON-LD report"})).s((Seq)Nil$.MODULE$));
            String output = RDFPrinter$.MODULE$.apply(((RDFNode)report.get()).getModel(), "JSON-LD");
            ExecutionLog$.MODULE$.log(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SHACLValidator#validate: finishing"})).s((Seq)Nil$.MODULE$));
            return output;
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    public Future<ValidationReport> report(BaseUnit data, Seq<ValidationSpecification> shapes, ProfileNames.MessageStyle messageStyle) {
        return this.validate(data, shapes, messageStyle).map((Function1 & Serializable & scala.Serializable)x$2 -> new JVMValidationReport((String)x$2), ExecutionContext.Implicits$.MODULE$.global());
    }

    /*
     * WARNING - void declaration
     */
    public RdfModel shapes(Seq<ValidationSpecification> shapes, String functionsUrl) {
        void var3_3;
        JenaRdfModel shapesModel = new JenaRdfModel(JenaRdfModel$.MODULE$.$lessinit$greater$default$1());
        new ValidationRdfModelEmitter((ProfileNames.ProfileName)ProfileNames.AMF$.MODULE$, shapesModel, ValidationRdfModelEmitter$.MODULE$.$lessinit$greater$default$3()).emit(shapes);
        return var3_3;
    }

    public RdfModel emptyRdfModel() {
        return new JenaRdfModel(JenaRdfModel$.MODULE$.$lessinit$greater$default$1());
    }

    public SHACLValidator() {
        RdfFramework.$init$((RdfFramework)this);
        this.functionUrl = None$.MODULE$;
        this.functionCode = None$.MODULE$;
        this.formats = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"application/ld+json"), (Object)"JSON-LD"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"application/json"), (Object)"JSON-LD"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"JSON-LD"), (Object)"JSON-LD"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"text/n3"), (Object)"N3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test/turtle"), (Object)"TURTLE")}));
    }
}

