/*
 * Decompiled with CFR 0.152.
 */
package amf.plugins.features.validation;

import amf.AmfProfile$;
import amf.ProfileName;
import amf.core.benchmark.ExecutionLog$;
import amf.core.emitter.RenderOptions;
import amf.core.model.document.BaseUnit;
import amf.core.rdf.RdfFramework;
import amf.core.rdf.RdfModel;
import amf.core.rdf.RdfModelDocument;
import amf.core.rdf.RdfModelEmitter;
import amf.core.remote.Platform;
import amf.core.services.ValidationOptions;
import amf.core.unsafe.PlatformSecrets;
import amf.core.validation.core.ValidationReport;
import amf.core.validation.core.ValidationSpecification;
import amf.plugins.features.validation.CachedScriptEngine;
import amf.plugins.features.validation.JVMValidationReport;
import amf.plugins.features.validation.JenaRdfModel;
import amf.plugins.features.validation.JenaRdfModel$;
import amf.plugins.features.validation.RDFPrinter$;
import amf.plugins.features.validation.SHACL$;
import amf.plugins.features.validation.emitters.ValidationRdfModelEmitter;
import amf.plugins.features.validation.emitters.ValidationRdfModelEmitter$;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.mulesoft.common.io.Output;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.js.JSScriptEngine;
import org.topbraid.shacl.js.JSScriptEngineFactory;
import org.topbraid.shacl.js.SHACLScriptEngineManager;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015f\u0001B\n\u0015\u0001uAQ!\r\u0001\u0005\u0002IBq!\u000e\u0001A\u0002\u0013\u0005a\u0007C\u0004F\u0001\u0001\u0007I\u0011\u0001$\t\r1\u0003\u0001\u0015)\u00038\u0011\u001di\u0005\u00011A\u0005\u0002YBqA\u0014\u0001A\u0002\u0013\u0005q\n\u0003\u0004R\u0001\u0001\u0006Ka\u000e\u0005\b%\u0002\u0011\r\u0011\"\u0001T\u0011\u0019\u0019\u0007\u0001)A\u0005)\")A\r\u0001C!K\")!\u0010\u0001C\u0005w\"9\u00111\u0004\u0001\u0005B\u0005u\u0001bBA\u001a\u0001\u0011\u0005\u0013Q\u0007\u0005\b\u0003\u007f\u0001A\u0011CA!\u0011\u0019!\u0007\u0001\"\u0011\u0002D!9\u00111\u0004\u0001\u0005B\u0005\r\u0005BB<\u0001\t\u0003\ny\tC\u0004\u0002\"\u0002!\t%a)\u0003\u001dMC\u0015i\u0011'WC2LG-\u0019;pe*\u0011QCF\u0001\u000bm\u0006d\u0017\u000eZ1uS>t'BA\f\u0019\u0003!1W-\u0019;ve\u0016\u001c(BA\r\u001b\u0003\u001d\u0001H.^4j]NT\u0011aG\u0001\u0004C647\u0001A\n\u0005\u0001y!3\u0006\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003E\u0001\u0004B]f\u0014VM\u001a\t\u0003K)j\u0011A\n\u0006\u0003O!\nAaY8sK*\u0011Q#\u000b\u0006\u0003OiI!a\u0005\u0014\u0011\u00051zS\"A\u0017\u000b\u00059J\u0013AB;og\u00064W-\u0003\u00021[\ty\u0001\u000b\\1uM>\u0014XnU3de\u0016$8/\u0001\u0004=S:LGO\u0010\u000b\u0002gA\u0011A\u0007A\u0007\u0002)\u0005Ya-\u001e8di&|g.\u0016:m+\u00059\u0004cA\u00109u%\u0011\u0011\b\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005m\u0012eB\u0001\u001fA!\ti\u0004%D\u0001?\u0015\tyD$\u0001\u0004=e>|GOP\u0005\u0003\u0003\u0002\na\u0001\u0015:fI\u00164\u0017BA\"E\u0005\u0019\u0019FO]5oO*\u0011\u0011\tI\u0001\u0010MVt7\r^5p]V\u0013Hn\u0018\u0013fcR\u0011qI\u0013\t\u0003?!K!!\u0013\u0011\u0003\tUs\u0017\u000e\u001e\u0005\b\u0017\u000e\t\t\u00111\u00018\u0003\rAH%M\u0001\rMVt7\r^5p]V\u0013H\u000eI\u0001\rMVt7\r^5p]\u000e{G-Z\u0001\u0011MVt7\r^5p]\u000e{G-Z0%KF$\"a\u0012)\t\u000f-3\u0011\u0011!a\u0001o\u0005ia-\u001e8di&|gnQ8eK\u0002\nqAZ8s[\u0006$8/F\u0001U!\u0011)&\f\u0018/\u000e\u0003YS!a\u0016-\u0002\u0013%lW.\u001e;bE2,'BA-!\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u00037Z\u00131!T1q!\ti&-D\u0001_\u0015\ty\u0006-\u0001\u0003mC:<'\"A1\u0002\t)\fg/Y\u0005\u0003\u0007z\u000b\u0001BZ8s[\u0006$8\u000fI\u0001\tm\u0006d\u0017\u000eZ1uKR)aM\u001d;wqR\u0011q-\u001c\t\u0004Q.TT\"A5\u000b\u0005)\u0004\u0013AC2p]\u000e,(O]3oi&\u0011A.\u001b\u0002\u0007\rV$XO]3\t\u000b9T\u00019A8\u0002!\u0015DXmY;uS>t7i\u001c8uKb$\bC\u00015q\u0013\t\t\u0018N\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\")1O\u0003a\u0001u\u0005!A-\u0019;b\u0011\u0015)(\u00021\u0001;\u00035!\u0017\r^1NK\u0012L\u0017\rV=qK\")qO\u0003a\u0001u\u000511\u000f[1qKNDQ!\u001f\u0006A\u0002i\nqb\u001d5ba\u0016\u001cX*\u001a3jCRK\b/Z\u0001\nY>\fG-T8eK2$R\u0001`A\u000b\u0003/\u00012!`A\t\u001b\u0005q(bA@\u0002\u0002\u0005)Qn\u001c3fY*!\u00111AA\u0003\u0003\r\u0011HM\u001a\u0006\u0005\u0003\u000f\tI!\u0001\u0003kK:\f'\u0002BA\u0006\u0003\u001b\ta!\u00199bG\",'BAA\b\u0003\ry'oZ\u0005\u0004\u0003'q(!B'pI\u0016d\u0007\"B:\f\u0001\u0004Q\u0004BBA\r\u0017\u0001\u0007!(A\u0005nK\u0012L\u0017\rV=qK\u00061!/\u001a9peR$\"\"a\b\u0002,\u00055\u0012qFA\u0019)\u0011\t\t#!\u000b\u0011\t!\\\u00171\u0005\t\u0004K\u0005\u0015\u0012bAA\u0014M\t\u0001b+\u00197jI\u0006$\u0018n\u001c8SKB|'\u000f\u001e\u0005\u0006]2\u0001\u001da\u001c\u0005\u0006g2\u0001\rA\u000f\u0005\u0006k2\u0001\rA\u000f\u0005\u0006o2\u0001\rA\u000f\u0005\u0006s2\u0001\rAO\u0001\u0010e\u0016<\u0017n\u001d;fe2K'M]1ssR)q)a\u000e\u0002<!1\u0011\u0011H\u0007A\u0002i\n1!\u001e:m\u0011\u0019\ti$\u0004a\u0001u\u0005!1m\u001c3f\u0003-aw.\u00193MS\n\u0014\u0018M]=\u0015\u0003\u001d#\u0002\"!\u0012\u0002J\u0005e\u00131\u000f\u000b\u0004O\u0006\u001d\u0003\"\u00028\u0010\u0001\by\u0007BB:\u0010\u0001\u0004\tY\u0005\u0005\u0003\u0002N\u0005USBAA(\u0015\u0011\t\t&a\u0015\u0002\u0011\u0011|7-^7f]RT!a`\u0015\n\t\u0005]\u0013q\n\u0002\t\u0005\u0006\u001cX-\u00168ji\"1qo\u0004a\u0001\u00037\u0002b!!\u0018\u0002h\u00055d\u0002BA0\u0003Gr1!PA1\u0013\u0005\t\u0013bAA3A\u00059\u0001/Y2lC\u001e,\u0017\u0002BA5\u0003W\u00121aU3r\u0015\r\t)\u0007\t\t\u0004K\u0005=\u0014bAA9M\t9b+\u00197jI\u0006$\u0018n\u001c8Ta\u0016\u001c\u0017NZ5dCRLwN\u001c\u0005\b\u0003kz\u0001\u0019AA<\u0003\u001dy\u0007\u000f^5p]N\u0004B!!\u001f\u0002\u00005\u0011\u00111\u0010\u0006\u0004\u0003{J\u0013\u0001C:feZL7-Z:\n\t\u0005\u0005\u00151\u0010\u0002\u0012-\u0006d\u0017\u000eZ1uS>tw\n\u001d;j_:\u001cH\u0003CAC\u0003\u0013\u000bY)!$\u0015\t\u0005\u0005\u0012q\u0011\u0005\u0006]B\u0001\u001da\u001c\u0005\u0007gB\u0001\r!a\u0013\t\r]\u0004\u0002\u0019AA.\u0011\u001d\t)\b\u0005a\u0001\u0003o\"b!!%\u0002\u001c\u0006u\u0005\u0003BAJ\u0003/k!!!&\u000b\u0007\u0005\r\u0011&\u0003\u0003\u0002\u001a\u0006U%\u0001\u0003*eM6{G-\u001a7\t\r]\f\u0002\u0019AA.\u0011\u0019\ty*\u0005a\u0001u\u0005aa-\u001e8di&|gn]+sY\u0006iQ-\u001c9usJ#g-T8eK2$\"!!%")
public class SHACLValidator
implements amf.core.validation.core.SHACLValidator,
PlatformSecrets {
    private Option<String> functionUrl;
    private Option<String> functionCode;
    private final Map<String, String> formats;
    private final Platform platform;

    public RdfModel unitToRdfModel(BaseUnit unit, RenderOptions options) {
        return RdfFramework.unitToRdfModel$((RdfFramework)this, (BaseUnit)unit, (RenderOptions)options);
    }

    public Option<RdfModelDocument> syntaxToRdfModel(String mediaType, CharSequence text) {
        return RdfFramework.syntaxToRdfModel$((RdfFramework)this, (String)mediaType, (CharSequence)text);
    }

    public Option<String> rdfModelToSyntax(String mediaType, RdfModelDocument rdfModelDocument) {
        return RdfFramework.rdfModelToSyntax$((RdfFramework)this, (String)mediaType, (RdfModelDocument)rdfModelDocument);
    }

    public <W> Option<W> rdfModelToSyntaxWriter(String mediaType, RdfModelDocument rdfModelDocument, W writer, Output<W> evidence$1) {
        return RdfFramework.rdfModelToSyntaxWriter$((RdfFramework)this, (String)mediaType, (RdfModelDocument)rdfModelDocument, writer, evidence$1);
    }

    public Platform platform() {
        return this.platform;
    }

    public void amf$core$unsafe$PlatformSecrets$_setter_$platform_$eq(Platform x$1) {
        this.platform = x$1;
    }

    public Option<String> functionUrl() {
        return this.functionUrl;
    }

    public void functionUrl_$eq(Option<String> x$1) {
        this.functionUrl = x$1;
    }

    public Option<String> functionCode() {
        return this.functionCode;
    }

    public void functionCode_$eq(Option<String> x$1) {
        this.functionCode = x$1;
    }

    public Map<String, String> formats() {
        return this.formats;
    }

    public Future<String> validate(String data, String dataMediaType, String shapes, String shapesMediaType, ExecutionContext executionContext) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Model dataModel = this.loadModel(StringUtils.chomp((String)data), dataMediaType);
            Model shapesModel = this.loadModel(StringUtils.chomp((String)shapes), shapesMediaType);
            this.loadLibrary();
            boolean res = SHACLScriptEngineManager.begin();
            None$ report = None$.MODULE$;
            try {
                SHACLScriptEngineManager.getCurrentEngine().executeScriptFromURL("http://datashapes.org/js/rdfquery.js");
                report = new Some((Object)SHACL$.MODULE$.validate(dataModel, shapesModel));
            }
            finally {
                SHACLScriptEngineManager.end((boolean)res);
            }
            return RDFPrinter$.MODULE$.apply(((RDFNode)report.get()).getModel(), "JSON-LD");
        }, executionContext);
    }

    private Model loadModel(String data, String mediaType) {
        Option option = this.formats().get((Object)mediaType);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new Exception(new StringBuilder(23).append("Unsupported media type ").append(mediaType).toString());
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        String format = (String)some.value();
        Model dataModel = JenaUtil.createMemoryModel();
        dataModel.read(IOUtils.toInputStream((String)data, (Charset)Charset.defaultCharset()), "urn:dummy", format);
        Model model = dataModel;
        return model;
    }

    public Future<ValidationReport> report(String data, String dataMediaType, String shapes, String shapesMediaType, ExecutionContext executionContext) {
        return this.validate(data, dataMediaType, shapes, shapesMediaType, executionContext).map((Function1 & Serializable & scala.Serializable)x$1 -> new JVMValidationReport((String)x$1), executionContext);
    }

    public void registerLibrary(String url, String code) {
        this.functionUrl_$eq((Option<String>)new Some((Object)url));
        this.functionCode_$eq((Option<String>)new Some((Object)code));
    }

    public void loadLibrary() {
        JSScriptEngineFactory.set((JSScriptEngineFactory)new JSScriptEngineFactory(this){
            private final /* synthetic */ SHACLValidator $outer;

            public JSScriptEngine createScriptEngine() {
                return new CachedScriptEngine(this.$outer.functionUrl(), this.$outer.functionCode());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Future<String> validate(BaseUnit data, Seq<ValidationSpecification> shapes, ValidationOptions options, ExecutionContext executionContext) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            ExecutionLog$.MODULE$.log("SHACLValidator#validate: loading Jena data model");
            JenaRdfModel dataModel = new JenaRdfModel(JenaRdfModel$.MODULE$.$lessinit$greater$default$1());
            new RdfModelEmitter((RdfModel)dataModel).emit(data, options.toRenderOptions());
            ExecutionLog$.MODULE$.log("SHACLValidator#validate: loading Jena shapes model");
            JenaRdfModel shapesModel = new JenaRdfModel(JenaRdfModel$.MODULE$.$lessinit$greater$default$1());
            new ValidationRdfModelEmitter(options.messageStyle().profileName(), shapesModel, ValidationRdfModelEmitter$.MODULE$.$lessinit$greater$default$3()).emit(shapes);
            ExecutionLog$.MODULE$.log("SHACLValidator#validate: loading library");
            this.loadLibrary();
            ExecutionLog$.MODULE$.log("SHACLValidator#validate: starting script engine");
            boolean res = SHACLScriptEngineManager.begin();
            None$ report = None$.MODULE$;
            try {
                SHACLScriptEngineManager.getCurrentEngine().executeScriptFromURL("http://datashapes.org/js/rdfquery.js");
                ExecutionLog$.MODULE$.log(new StringBuilder(51).append("SHACLValidator#validate: Number of data triples -> ").append(dataModel.model().listStatements().toList().size()).toString());
                ExecutionLog$.MODULE$.log(new StringBuilder(53).append("SHACLValidator#validate: Number of shapes triples -> ").append(shapesModel.model().listStatements().toList().size()).toString());
                ExecutionLog$.MODULE$.log("SHACLValidator#validate: validating...");
                report = new Some((Object)SHACL$.MODULE$.validate(dataModel.model(), shapesModel.model()));
            }
            finally {
                ExecutionLog$.MODULE$.log("SHACLValidator#validate: releasing script manager resources");
                SHACLScriptEngineManager.end((boolean)res);
            }
            ExecutionLog$.MODULE$.log("SHACLValidator#validate: Generating JSON-LD report");
            String output = RDFPrinter$.MODULE$.apply(((RDFNode)report.get()).getModel(), "JSON-LD");
            ExecutionLog$.MODULE$.log("SHACLValidator#validate: finishing");
            return output;
        }, executionContext);
    }

    public Future<ValidationReport> report(BaseUnit data, Seq<ValidationSpecification> shapes, ValidationOptions options, ExecutionContext executionContext) {
        return this.validate(data, shapes, options, executionContext).map((Function1 & Serializable & scala.Serializable)x$2 -> new JVMValidationReport((String)x$2), executionContext);
    }

    /*
     * WARNING - void declaration
     */
    public RdfModel shapes(Seq<ValidationSpecification> shapes, String functionsUrl) {
        void var3_3;
        JenaRdfModel shapesModel = new JenaRdfModel(JenaRdfModel$.MODULE$.$lessinit$greater$default$1());
        new ValidationRdfModelEmitter((ProfileName)AmfProfile$.MODULE$, shapesModel, ValidationRdfModelEmitter$.MODULE$.$lessinit$greater$default$3()).emit(shapes);
        return var3_3;
    }

    public RdfModel emptyRdfModel() {
        return new JenaRdfModel(JenaRdfModel$.MODULE$.$lessinit$greater$default$1());
    }

    public SHACLValidator() {
        RdfFramework.$init$((RdfFramework)this);
        PlatformSecrets.$init$((PlatformSecrets)this);
        this.functionUrl = None$.MODULE$;
        this.functionCode = None$.MODULE$;
        this.formats = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"application/ld+json"), (Object)"JSON-LD"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"application/json"), (Object)"JSON-LD"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"JSON-LD"), (Object)"JSON-LD"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"text/n3"), (Object)"N3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test/turtle"), (Object)"TURTLE")}));
    }
}

