/*
 * Decompiled with CFR 0.152.
 */
package amf.validation.internal;

import amf.core.client.common.validation.AmfProfile$;
import amf.core.client.common.validation.ProfileName;
import amf.core.client.scala.config.RenderOptions;
import amf.core.client.scala.model.document.BaseUnit;
import amf.core.client.scala.rdf.RdfModel;
import amf.core.internal.benchmark.ExecutionLog$;
import amf.core.internal.rdf.RdfFramework;
import amf.core.internal.rdf.RdfModelDocument;
import amf.core.internal.rdf.RdfModelEmitter;
import amf.core.internal.remote.Platform;
import amf.core.internal.unsafe.PlatformSecrets;
import amf.core.internal.validation.core.ShaclValidationOptions;
import amf.core.internal.validation.core.ValidationReport;
import amf.core.internal.validation.core.ValidationSpecification;
import amf.validation.internal.JVMValidationReport;
import amf.validation.internal.JenaRdfModel;
import amf.validation.internal.JenaRdfModel$;
import amf.validation.internal.RDFPrinter$;
import amf.validation.internal.emitters.ValidationRdfModelEmitter;
import amf.validation.internal.emitters.ValidationRdfModelEmitter$;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.shacl.ShaclValidator;
import org.apache.jena.shacl.Shapes;
import org.mulesoft.common.io.Output;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001B\n\u0015\u0001mAQ\u0001\r\u0001\u0005\u0002EBq\u0001\u000e\u0001A\u0002\u0013\u0005Q\u0007C\u0004E\u0001\u0001\u0007I\u0011A#\t\r-\u0003\u0001\u0015)\u00037\u0011\u001da\u0005\u00011A\u0005\u0002UBq!\u0014\u0001A\u0002\u0013\u0005a\n\u0003\u0004Q\u0001\u0001\u0006KA\u000e\u0005\b#\u0002\u0011\r\u0011\"\u0001S\u0011\u0019\u0011\u0007\u0001)A\u0005'\")1\r\u0001C!I\")\u0011\u0010\u0001C\u0005u\"9\u0011\u0011\u0004\u0001\u0005B\u0005m\u0001bBA\u0019\u0001\u0011\u0005\u00131\u0007\u0005\u0007G\u0002!\t%!\u0010\t\u000f\u0005e\u0001\u0001\"\u0011\u0002~!1a\u000f\u0001C!\u0003\u0013Cq!a'\u0001\t\u0003\ni\nC\u0004\u0002 \u0002!\t%!)\u0003\u001dMC\u0015i\u0011'WC2LG-\u0019;pe*\u0011QCF\u0001\tS:$XM\u001d8bY*\u0011q\u0003G\u0001\u000bm\u0006d\u0017\u000eZ1uS>t'\"A\r\u0002\u0007\u0005lgm\u0001\u0001\u0014\t\u0001a\"E\u000b\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\rJS\"\u0001\u0013\u000b\u0005\u00152\u0013\u0001B2pe\u0016T!aF\u0014\u000b\u0005UA#BA\u0013\u0019\u0013\t\u0019B\u0005\u0005\u0002,]5\tAF\u0003\u0002.O\u00051QO\\:bM\u0016L!a\f\u0017\u0003\u001fAc\u0017\r\u001e4pe6\u001cVm\u0019:fiN\fa\u0001P5oSRtD#\u0001\u001a\u0011\u0005M\u0002Q\"\u0001\u000b\u0002\u0017\u0019,hn\u0019;j_:,&\u000f\\\u000b\u0002mA\u0019QdN\u001d\n\u0005ar\"AB(qi&|g\u000e\u0005\u0002;\u0003:\u00111h\u0010\t\u0003yyi\u0011!\u0010\u0006\u0003}i\ta\u0001\u0010:p_Rt\u0014B\u0001!\u001f\u0003\u0019\u0001&/\u001a3fM&\u0011!i\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0001s\u0012a\u00044v]\u000e$\u0018n\u001c8Ve2|F%Z9\u0015\u0005\u0019K\u0005CA\u000fH\u0013\tAeD\u0001\u0003V]&$\bb\u0002&\u0004\u0003\u0003\u0005\rAN\u0001\u0004q\u0012\n\u0014\u0001\u00044v]\u000e$\u0018n\u001c8Ve2\u0004\u0013\u0001\u00044v]\u000e$\u0018n\u001c8D_\u0012,\u0017\u0001\u00054v]\u000e$\u0018n\u001c8D_\u0012,w\fJ3r)\t1u\nC\u0004K\r\u0005\u0005\t\u0019\u0001\u001c\u0002\u001b\u0019,hn\u0019;j_:\u001cu\u000eZ3!\u0003\u001d1wN]7biN,\u0012a\u0015\t\u0005)f[6,D\u0001V\u0015\t1v+A\u0005j[6,H/\u00192mK*\u0011\u0001LH\u0001\u000bG>dG.Z2uS>t\u0017B\u0001.V\u0005\ri\u0015\r\u001d\t\u00039\u0006l\u0011!\u0018\u0006\u0003=~\u000bA\u0001\\1oO*\t\u0001-\u0001\u0003kCZ\f\u0017B\u0001\"^\u0003!1wN]7biN\u0004\u0013\u0001\u0003<bY&$\u0017\r^3\u0015\u000b\u0015\f8/^<\u0015\u0005\u0019d\u0007cA4ks5\t\u0001N\u0003\u0002j=\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005-D'A\u0002$viV\u0014X\rC\u0003n\u0015\u0001\u000fa.\u0001\tfq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yiB\u0011qm\\\u0005\u0003a\"\u0014\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\t\u000bIT\u0001\u0019A\u001d\u0002\t\u0011\fG/\u0019\u0005\u0006i*\u0001\r!O\u0001\u000eI\u0006$\u0018-T3eS\u0006$\u0016\u0010]3\t\u000bYT\u0001\u0019A\u001d\u0002\rMD\u0017\r]3t\u0011\u0015A(\u00021\u0001:\u0003=\u0019\b.\u00199fg6+G-[1UsB,\u0017!\u00037pC\u0012lu\u000eZ3m)\u0015Y\u00181CA\u000b!\ra\u0018qB\u0007\u0002{*\u0011ap`\u0001\u0006[>$W\r\u001c\u0006\u0005\u0003\u0003\t\u0019!A\u0002sI\u001aTA!!\u0002\u0002\b\u0005!!.\u001a8b\u0015\u0011\tI!a\u0003\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\ti!A\u0002pe\u001eL1!!\u0005~\u0005\u0015iu\u000eZ3m\u0011\u0015\u00118\u00021\u0001:\u0011\u0019\t9b\u0003a\u0001s\u0005IQ.\u001a3jCRK\b/Z\u0001\u0007e\u0016\u0004xN\u001d;\u0015\u0015\u0005u\u0011\u0011FA\u0016\u0003[\ty\u0003\u0006\u0003\u0002 \u0005\u001d\u0002\u0003B4k\u0003C\u00012aIA\u0012\u0013\r\t)\u0003\n\u0002\u0011-\u0006d\u0017\u000eZ1uS>t'+\u001a9peRDQ!\u001c\u0007A\u00049DQA\u001d\u0007A\u0002eBQ\u0001\u001e\u0007A\u0002eBQA\u001e\u0007A\u0002eBQ\u0001\u001f\u0007A\u0002e\nqB]3hSN$XM\u001d'jEJ\f'/\u001f\u000b\u0006\r\u0006U\u0012\u0011\b\u0005\u0007\u0003oi\u0001\u0019A\u001d\u0002\u0007U\u0014H\u000e\u0003\u0004\u0002<5\u0001\r!O\u0001\u0005G>$W\r\u0006\u0005\u0002@\u0005\r\u0013\u0011LA:)\r1\u0017\u0011\t\u0005\u0006[:\u0001\u001dA\u001c\u0005\u0007e:\u0001\r!!\u0012\u0011\t\u0005\u001d\u0013QK\u0007\u0003\u0003\u0013RA!a\u0013\u0002N\u0005AAm\\2v[\u0016tGOC\u0002\u007f\u0003\u001fR1aHA)\u0015\r\t\u0019\u0006K\u0001\u0007G2LWM\u001c;\n\t\u0005]\u0013\u0011\n\u0002\t\u0005\u0006\u001cX-\u00168ji\"1aO\u0004a\u0001\u00037\u0002b!!\u0018\u0002h\u00055d\u0002BA0\u0003Gr1\u0001PA1\u0013\u0005y\u0012bAA3=\u00059\u0001/Y2lC\u001e,\u0017\u0002BA5\u0003W\u00121aU3r\u0015\r\t)G\b\t\u0004G\u0005=\u0014bAA9I\t9b+\u00197jI\u0006$\u0018n\u001c8Ta\u0016\u001c\u0017NZ5dCRLwN\u001c\u0005\b\u0003kr\u0001\u0019AA<\u0003\u001dy\u0007\u000f^5p]N\u00042aIA=\u0013\r\tY\b\n\u0002\u0017'\"\f7\r\u001c,bY&$\u0017\r^5p]>\u0003H/[8ogRA\u0011qPAB\u0003\u000b\u000b9\t\u0006\u0003\u0002 \u0005\u0005\u0005\"B7\u0010\u0001\bq\u0007B\u0002:\u0010\u0001\u0004\t)\u0005\u0003\u0004w\u001f\u0001\u0007\u00111\f\u0005\b\u0003kz\u0001\u0019AA<)\u0019\tY)!&\u0002\u0018B!\u0011QRAI\u001b\t\tyI\u0003\u0003\u0002\u0002\u0005=\u0013\u0002BAJ\u0003\u001f\u0013\u0001B\u00153g\u001b>$W\r\u001c\u0005\u0007mB\u0001\r!a\u0017\t\r\u0005e\u0005\u00031\u0001:\u000311WO\\2uS>t7/\u0016:m\u00035)W\u000e\u001d;z%\u00124Wj\u001c3fYR\u0011\u00111R\u0001\u0014gV\u0004\bo\u001c:ug*\u001bf)\u001e8di&|gn]\u000b\u0003\u0003G\u00032!HAS\u0013\r\t9K\b\u0002\b\u0005>|G.Z1o\u0001")
public class SHACLValidator
implements amf.core.internal.validation.core.SHACLValidator,
PlatformSecrets {
    private Option<String> functionUrl;
    private Option<String> functionCode;
    private final Map<String, String> formats;
    private final Platform platform;

    public RdfModel unitToRdfModel(BaseUnit unit, RenderOptions options) {
        return RdfFramework.unitToRdfModel$((RdfFramework)this, (BaseUnit)unit, (RenderOptions)options);
    }

    public RdfModelDocument syntaxToRdfModel(String mediaType, CharSequence text) {
        return RdfFramework.syntaxToRdfModel$((RdfFramework)this, (String)mediaType, (CharSequence)text);
    }

    public Option<String> rdfModelToSyntax(String mediaType, RdfModelDocument rdfModelDocument) {
        return RdfFramework.rdfModelToSyntax$((RdfFramework)this, (String)mediaType, (RdfModelDocument)rdfModelDocument);
    }

    public <W> Option<W> rdfModelToSyntaxWriter(String mediaType, RdfModelDocument rdfModelDocument, W writer, Output<W> evidence$1) {
        return RdfFramework.rdfModelToSyntaxWriter$((RdfFramework)this, (String)mediaType, (RdfModelDocument)rdfModelDocument, writer, evidence$1);
    }

    public Platform platform() {
        return this.platform;
    }

    public void amf$core$internal$unsafe$PlatformSecrets$_setter_$platform_$eq(Platform x$1) {
        this.platform = x$1;
    }

    public Option<String> functionUrl() {
        return this.functionUrl;
    }

    public void functionUrl_$eq(Option<String> x$1) {
        this.functionUrl = x$1;
    }

    public Option<String> functionCode() {
        return this.functionCode;
    }

    public void functionCode_$eq(Option<String> x$1) {
        this.functionCode = x$1;
    }

    public Map<String, String> formats() {
        return this.formats;
    }

    public Future<String> validate(String data, String dataMediaType, String shapes, String shapesMediaType, ExecutionContext executionContext) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Model dataModel = this.loadModel(StringUtils.chomp((String)data), dataMediaType);
            Model shapesModel = this.loadModel(StringUtils.chomp((String)shapes), shapesMediaType);
            Shapes shaclShapes = Shapes.parse((Model)shapesModel);
            org.apache.jena.shacl.ValidationReport report = ShaclValidator.get().validate(shaclShapes, dataModel.getGraph());
            return RDFPrinter$.MODULE$.apply(report.getModel(), "JSON-LD");
        }, executionContext);
    }

    private Model loadModel(String data, String mediaType) {
        Option option = this.formats().get((Object)mediaType);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new Exception(new StringBuilder(23).append("Unsupported media type ").append(mediaType).toString());
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        String format = (String)some.value();
        Model dataModel = ModelFactory.createDefaultModel();
        dataModel.read(IOUtils.toInputStream((String)data, (Charset)Charset.defaultCharset()), "urn:dummy", format);
        Model model = dataModel;
        return model;
    }

    public Future<ValidationReport> report(String data, String dataMediaType, String shapes, String shapesMediaType, ExecutionContext executionContext) {
        return this.validate(data, dataMediaType, shapes, shapesMediaType, executionContext).map((Function1 & Serializable & scala.Serializable)x$1 -> new JVMValidationReport((String)x$1), executionContext);
    }

    public void registerLibrary(String url, String code) {
        this.functionUrl_$eq((Option<String>)new Some((Object)url));
        this.functionCode_$eq((Option<String>)new Some((Object)code));
    }

    public Future<String> validate(BaseUnit data, Seq<ValidationSpecification> shapes, ShaclValidationOptions options, ExecutionContext executionContext) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            ExecutionLog$.MODULE$.log("SHACLValidator#validate: loading Jena data model");
            JenaRdfModel dataModel = new JenaRdfModel(JenaRdfModel$.MODULE$.$lessinit$greater$default$1());
            new RdfModelEmitter((RdfModel)dataModel).emit(data, options.toRenderOptions());
            ExecutionLog$.MODULE$.log("SHACLValidator#validate: loading Jena shapes model");
            JenaRdfModel shapesModel = new JenaRdfModel(JenaRdfModel$.MODULE$.$lessinit$greater$default$1());
            new ValidationRdfModelEmitter(options.messageStyle().profileName(), shapesModel, ValidationRdfModelEmitter$.MODULE$.$lessinit$greater$default$3()).emit(shapes);
            ExecutionLog$.MODULE$.log(new StringBuilder(51).append("SHACLValidator#validate: Number of data triples -> ").append(dataModel.model().listStatements().toList().size()).toString());
            ExecutionLog$.MODULE$.log(new StringBuilder(53).append("SHACLValidator#validate: Number of shapes triples -> ").append(shapesModel.model().listStatements().toList().size()).toString());
            ExecutionLog$.MODULE$.log("SHACLValidator#validate: validating...");
            ExecutionLog$.MODULE$.log("SHACLValidator#validate: starting script engine");
            Shapes shaclShapes = Shapes.parse((Model)((Model)shapesModel.native()));
            org.apache.jena.shacl.ValidationReport report = ShaclValidator.get().validate(shaclShapes, ((Model)dataModel.native()).getGraph());
            ExecutionLog$.MODULE$.log("SHACLValidator#validate: Generating JSON-LD report");
            String output = RDFPrinter$.MODULE$.apply(report.getModel(), "JSON-LD");
            ExecutionLog$.MODULE$.log("SHACLValidator#validate: finishing");
            return output;
        }, executionContext);
    }

    public Future<ValidationReport> report(BaseUnit data, Seq<ValidationSpecification> shapes, ShaclValidationOptions options, ExecutionContext executionContext) {
        return this.validate(data, shapes, options, executionContext).map((Function1 & Serializable & scala.Serializable)x$2 -> new JVMValidationReport((String)x$2), executionContext);
    }

    /*
     * WARNING - void declaration
     */
    public RdfModel shapes(Seq<ValidationSpecification> shapes, String functionsUrl) {
        void var3_3;
        JenaRdfModel shapesModel = new JenaRdfModel(JenaRdfModel$.MODULE$.$lessinit$greater$default$1());
        new ValidationRdfModelEmitter((ProfileName)AmfProfile$.MODULE$, shapesModel, ValidationRdfModelEmitter$.MODULE$.$lessinit$greater$default$3()).emit(shapes);
        return var3_3;
    }

    public RdfModel emptyRdfModel() {
        return new JenaRdfModel(JenaRdfModel$.MODULE$.$lessinit$greater$default$1());
    }

    public boolean supportsJSFunctions() {
        return false;
    }

    public SHACLValidator() {
        RdfFramework.$init$((RdfFramework)this);
        PlatformSecrets.$init$((PlatformSecrets)this);
        this.functionUrl = None$.MODULE$;
        this.functionCode = None$.MODULE$;
        this.formats = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"application/ld+json"), (Object)"JSON-LD"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"application/json"), (Object)"JSON-LD"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"JSON-LD"), (Object)"JSON-LD"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"text/n3"), (Object)"N3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test/turtle"), (Object)"TURTLE")}));
    }
}

