/*
 * Decompiled with CFR 0.152.
 */
package amf.plugins.document.webapi.resolution.pipelines.compatibility.oas;

import amf.core.model.ValueField;
import amf.core.model.document.BaseUnit;
import amf.core.model.document.DeclaresModel;
import amf.core.model.domain.DomainElement;
import amf.core.model.domain.NamedDomainElement;
import amf.core.parser.ErrorHandler;
import amf.core.parser.Fields;
import amf.core.resolution.stages.ResolutionStage;
import amf.plugins.domain.webapi.metamodel.security.OAuth2SettingsModel$;
import amf.plugins.domain.webapi.models.security.ApiKeySettings;
import amf.plugins.domain.webapi.models.security.OAuth1Settings;
import amf.plugins.domain.webapi.models.security.OAuth2Settings;
import amf.plugins.domain.webapi.models.security.OpenIdConnectSettings;
import amf.plugins.domain.webapi.models.security.Scope;
import amf.plugins.domain.webapi.models.security.Scope$;
import amf.plugins.domain.webapi.models.security.SecurityScheme;
import amf.plugins.domain.webapi.models.security.Settings;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U4A!\u0001\u0002\u0001'\t12+Z2ve&$\u0018pU3ui&twm]'baB,'O\u0003\u0002\u0004\t\u0005\u0019q.Y:\u000b\u0005\u00151\u0011!D2p[B\fG/\u001b2jY&$\u0018P\u0003\u0002\b\u0011\u0005I\u0001/\u001b9fY&tWm\u001d\u0006\u0003\u0013)\t!B]3t_2,H/[8o\u0015\tYA\"\u0001\u0004xK\n\f\u0007/\u001b\u0006\u0003\u001b9\t\u0001\u0002Z8dk6,g\u000e\u001e\u0006\u0003\u001fA\tq\u0001\u001d7vO&t7OC\u0001\u0012\u0003\r\tWNZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001675\taC\u0003\u0002\u00181\u000511\u000f^1hKNT!!C\r\u000b\u0005i\u0001\u0012\u0001B2pe\u0016L!\u0001\b\f\u0003\u001fI+7o\u001c7vi&|gn\u0015;bO\u0016D\u0001B\b\u0001\u0003\u0006\u0004%\u0019eH\u0001\rKJ\u0014xN\u001d%b]\u0012dWM]\u000b\u0002AA\u0011\u0011\u0005J\u0007\u0002E)\u00111%G\u0001\u0007a\u0006\u00148/\u001a:\n\u0005\u0015\u0012#\u0001D#se>\u0014\b*\u00198eY\u0016\u0014\b\"C\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0011)\u00035)'O]8s\u0011\u0006tG\r\\3sA%\u0011ad\u0007\u0005\u0006U\u0001!\taK\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00031\"\"!L\u0018\u0011\u00059\u0002Q\"\u0001\u0002\t\u000byI\u00039\u0001\u0011\t\u000bE\u0002A\u0011\u0001\u001a\u0002\u0013\u0019L\u0007pT1vi\"\u0014DCA\u001a:!\t!t'D\u00016\u0015\u00051\u0014!B:dC2\f\u0017B\u0001\u001d6\u0005\u0011)f.\u001b;\t\u000bi\u0002\u0004\u0019A\u001e\u0002\r=\fW\u000f\u001e53!\taD)D\u0001>\u0015\tqt(\u0001\u0005tK\u000e,(/\u001b;z\u0015\t\u0001\u0015)\u0001\u0004n_\u0012,Gn\u001d\u0006\u0003\u0017\tS!a\u0011\b\u0002\r\u0011|W.Y5o\u0013\t)UH\u0001\bP\u0003V$\bNM*fiRLgnZ:\t\u000b\u001d\u0003A\u0011\u0001%\u0002\u0013\u0019L\u00070\u00119j\u0017\u0016LHcA\u001aJ\u001b\")aH\u0012a\u0001\u0015B\u0011AhS\u0005\u0003\u0019v\u0012abU3dkJLG/_*dQ\u0016lW\rC\u0003O\r\u0002\u0007q*\u0001\u0004ba&\\U-\u001f\t\u0003yAK!!U\u001f\u0003\u001d\u0005\u0003\u0018nS3z'\u0016$H/\u001b8hg\")1\u000b\u0001C\u0005)\u0006Ya-\u001b=TKR$\u0018N\\4t)\t\u0019T\u000bC\u0003?%\u0002\u0007!\nC\u0003T\u0001\u0011%q\u000b\u0006\u000241\")\u0011L\u0016a\u00015\u0006\tA\r\u0005\u0002\\?6\tAL\u0003\u0002\u000e;*\u0011a,G\u0001\u0006[>$W\r\\\u0005\u0003Ar\u0013Q\u0002R3dY\u0006\u0014Xm]'pI\u0016d\u0007\"\u00022\u0001\t\u0003\u0019\u0017\u0001\u0007:f[>4X-\u00168tkB\u0004xN\u001d;fIN\u001b\u0007.Z7fgR\u0011!\f\u001a\u0005\u00063\u0006\u0004\rA\u0017\u0005\u0006M\u0002!\teZ\u0001\be\u0016\u001cx\u000e\u001c<f+\tA7\u000e\u0006\u0002jiB\u0011!n\u001b\u0007\u0001\t\u0015aWM1\u0001n\u0005\u0005!\u0016C\u00018r!\t!t.\u0003\u0002qk\t9aj\u001c;iS:<\u0007CA.s\u0013\t\u0019HL\u0001\u0005CCN,WK\\5u\u0011\u0015qV\r1\u0001j\u0001")
public class SecuritySettingsMapper
extends ResolutionStage {
    public ErrorHandler errorHandler() {
        return super.errorHandler();
    }

    public void fixOauth2(OAuth2Settings oauth2) {
        block10: {
            Fields fields;
            Object object;
            if (oauth2.flow().option().isEmpty()) {
                String string = (String)((ValueField)oauth2.authorizationGrants().head()).option().getOrElse((Function0 & Serializable & scala.Serializable)() -> "implicit");
                String string2 = "authorization_code".equals(string) ? "accessCode" : ("password".equals(string) ? "password" : ("implicit".equals(string) ? "implicit" : ("client_credentials".equals(string) ? "application" : "implicit")));
                String flow = string2;
                object = oauth2.withFlow(flow);
            } else {
                object = BoxedUnit.UNIT;
            }
            String string = oauth2.flow().value();
            if ("implicit".equals(string)) {
                Object object2 = oauth2.authorizationUri().option().isEmpty() ? oauth2.withAuthorizationUri("http://") : BoxedUnit.UNIT;
                fields = oauth2.fields().removeField(OAuth2SettingsModel$.MODULE$.AccessTokenUri());
            } else if ("accessCode".equals(string)) {
                Object object3 = oauth2.authorizationUri().option().isEmpty() ? oauth2.withAuthorizationUri("http://") : BoxedUnit.UNIT;
                fields = oauth2.accessTokenUri().option().isEmpty() ? oauth2.withAccessTokenUri("http://") : BoxedUnit.UNIT;
            } else if ("password".equals(string)) {
                Object object4 = oauth2.accessTokenUri().option().isEmpty() ? oauth2.withAccessTokenUri("http://") : BoxedUnit.UNIT;
                fields = oauth2.fields().removeField(OAuth2SettingsModel$.MODULE$.AuthorizationUri());
            } else if ("application".equals(string)) {
                Object object5 = oauth2.accessTokenUri().option().isEmpty() ? oauth2.withAccessTokenUri("http://") : BoxedUnit.UNIT;
                fields = oauth2.fields().removeField(OAuth2SettingsModel$.MODULE$.AuthorizationUri());
            } else {
                fields = BoxedUnit.UNIT;
            }
            if (!oauth2.scopes().isEmpty()) break block10;
            oauth2.withScopes((Seq<Scope>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Scope[]{Scope$.MODULE$.apply().withName("*").withDescription("")}))));
        }
    }

    public void fixApiKey(SecurityScheme security, ApiKeySettings apiKey) {
        if (security.queryParameters().nonEmpty()) {
            apiKey.withIn("query");
            apiKey.withName(((NamedDomainElement)security.queryParameters().head()).name().value());
        } else if (security.headers().nonEmpty()) {
            apiKey.withIn("header");
            apiKey.withName(((NamedDomainElement)security.headers().head()).name().value());
        } else {
            apiKey.withIn("query");
            apiKey.withName("");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void fixSettings(SecurityScheme security) {
        Settings settings = security.settings();
        if (settings instanceof OAuth2Settings) {
            OAuth2Settings oAuth2Settings = (OAuth2Settings)settings;
            this.fixOauth2(oAuth2Settings);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (settings instanceof ApiKeySettings) {
            ApiKeySettings apiKeySettings = (ApiKeySettings)settings;
            this.fixApiKey(security, apiKeySettings);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (settings == null) {
            Object object = security.type().option().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            String string = "x-amf-apiKey";
            if (!(object != null ? !object.equals(string) : string != null)) {
                this.fixApiKey(security, security.withApiKeySettings());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void fixSettings(DeclaresModel d) {
        d.declares().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SecuritySettingsMapper.$anonfun$fixSettings$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public DeclaresModel removeUnsupportedSchemes(DeclaresModel d) {
        Seq filteredDeclarations = (Seq)d.declares().filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)SecuritySettingsMapper.$anonfun$removeUnsupportedSchemes$1(x0$2)));
        return d.withDeclares(filteredDeclarations);
    }

    public <T extends BaseUnit> T resolve(T model) {
        T t;
        T t2 = model;
        if (t2 instanceof DeclaresModel) {
            T t3 = t2;
            try {
                this.fixSettings((DeclaresModel)t3);
            }
            catch (Throwable throwable) {}
            t = model;
        } else {
            t = model;
        }
        return t;
    }

    public static final /* synthetic */ void $anonfun$fixSettings$2(SecuritySettingsMapper $this, DomainElement x0$1) {
        DomainElement domainElement = x0$1;
        if (domainElement instanceof SecurityScheme) {
            SecurityScheme securityScheme = (SecurityScheme)domainElement;
            $this.fixSettings(securityScheme);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$removeUnsupportedSchemes$1(DomainElement x0$2) {
        boolean bl;
        DomainElement domainElement = x0$2;
        if (domainElement instanceof SecurityScheme) {
            SecurityScheme securityScheme = (SecurityScheme)domainElement;
            Settings settings = securityScheme.settings();
            boolean bl2 = settings instanceof OAuth1Settings ? false : !(settings instanceof OpenIdConnectSettings);
            bl = bl2;
        } else {
            bl = true;
        }
        return bl;
    }

    public SecuritySettingsMapper(ErrorHandler errorHandler) {
        super(errorHandler);
    }
}

