/*
 * Decompiled with CFR 0.152.
 */
package amf.plugins.document.webapi.parser.spec.declaration;

import amf.core.model.domain.AmfElement;
import amf.core.model.domain.AmfScalar;
import amf.core.parser.ScalarNode$;
import amf.core.parser.package$;
import amf.plugins.document.webapi.contexts.parser.oas.OasWebApiContext;
import amf.plugins.document.webapi.parser.spec.common.AnnotationParser;
import amf.plugins.document.webapi.parser.spec.common.AnnotationParser$;
import amf.plugins.document.webapi.parser.spec.declaration.Oas3SettingsProducers$;
import amf.plugins.document.webapi.parser.spec.declaration.OasLikeSecuritySettingsParser;
import amf.plugins.document.webapi.parser.spec.declaration.SettingsProducers;
import amf.plugins.domain.webapi.metamodel.security.HttpSettingsModel$;
import amf.plugins.domain.webapi.metamodel.security.OAuth2FlowModel$;
import amf.plugins.domain.webapi.metamodel.security.OAuth2SettingsModel$;
import amf.plugins.domain.webapi.metamodel.security.OpenIdConnectSettingsModel$;
import amf.plugins.domain.webapi.models.security.ApiKeySettings;
import amf.plugins.domain.webapi.models.security.HttpSettings;
import amf.plugins.domain.webapi.models.security.OAuth1Settings;
import amf.plugins.domain.webapi.models.security.OAuth2Flow;
import amf.plugins.domain.webapi.models.security.OAuth2Flow$;
import amf.plugins.domain.webapi.models.security.OAuth2Settings;
import amf.plugins.domain.webapi.models.security.OpenIdConnectSettings;
import amf.plugins.domain.webapi.models.security.SecurityScheme;
import amf.plugins.domain.webapi.models.security.Settings;
import java.io.Serializable;
import org.yaml.convert.YRead;
import org.yaml.model.IllegalTypeHandler;
import org.yaml.model.YMap;
import org.yaml.model.YMapEntry;
import org.yaml.model.YPart;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001q4A\u0001D\u0007\u00019!A\u0011\u0005\u0001B\u0001B\u0003%!\u0005\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003.\u0011!A\u0004A!A!\u0002\u0017I\u0004\"\u0002\"\u0001\t\u0003\u0019\u0005\"B%\u0001\t\u0003R\u0005\"\u0002+\u0001\t\u0003)\u0006\"B.\u0001\t\u0003a\u0006\"B1\u0001\t\u0003\u0012\u0007\"B4\u0001\t\u0013A\u0007\"\u0002:\u0001\t\u0013\u0019\b\"B<\u0001\t\u0003B(AG(bgN\u001aVmY;sSRL8+\u001a;uS:<7\u000fU1sg\u0016\u0014(B\u0001\b\u0010\u0003-!Wm\u00197be\u0006$\u0018n\u001c8\u000b\u0005A\t\u0012\u0001B:qK\u000eT!AE\n\u0002\rA\f'o]3s\u0015\t!R#\u0001\u0004xK\n\f\u0007/\u001b\u0006\u0003-]\t\u0001\u0002Z8dk6,g\u000e\u001e\u0006\u00031e\tq\u0001\u001d7vO&t7OC\u0001\u001b\u0003\r\tWNZ\u0002\u0001'\t\u0001Q\u0004\u0005\u0002\u001f?5\tQ\"\u0003\u0002!\u001b\tir*Y:MS.,7+Z2ve&$\u0018pU3ui&twm\u001d)beN,'/A\u0002nCB\u0004\"a\t\u0016\u000e\u0003\u0011R!!\n\u0014\u0002\u000b5|G-\u001a7\u000b\u0005\u001dB\u0013\u0001B=b[2T\u0011!K\u0001\u0004_J<\u0017BA\u0016%\u0005\u0011IV*\u00199\u0002\rM\u001c\u0007.Z7f!\tqc'D\u00010\u0015\t\u0001\u0014'\u0001\u0005tK\u000e,(/\u001b;z\u0015\t\u00114'\u0001\u0004n_\u0012,Gn\u001d\u0006\u0003)QR!!N\f\u0002\r\u0011|W.Y5o\u0013\t9tF\u0001\bTK\u000e,(/\u001b;z'\u000eDW-\\3\u0002\u0007\r$\b\u0010\u0005\u0002;\u00016\t1H\u0003\u0002={\u0005\u0019q.Y:\u000b\u0005Iq$BA \u0014\u0003!\u0019wN\u001c;fqR\u001c\u0018BA!<\u0005Ay\u0015m],fE\u0006\u0003\u0018nQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u0004\t\u001eCECA#G!\tq\u0002\u0001C\u00039\t\u0001\u000f\u0011\bC\u0003\"\t\u0001\u0007!\u0005C\u0003-\t\u0001\u0007Q&A\u0003qCJ\u001cX\rF\u0001L!\rau*U\u0007\u0002\u001b*\ta*A\u0003tG\u0006d\u0017-\u0003\u0002Q\u001b\n1q\n\u001d;j_:\u0004\"A\f*\n\u0005M{#\u0001C*fiRLgnZ:\u00025A\f'o]3Pa\u0016t\u0017\nZ\"p]:,7\r^*fiRLgnZ:\u0015\u0005YK\u0006C\u0001\u0018X\u0013\tAvFA\u000bPa\u0016t\u0017\nZ\"p]:,7\r^*fiRLgnZ:\t\u000bi3\u0001\u0019\u0001,\u0002\u0011M,G\u000f^5oON\f\u0011\u0003]1sg\u0016DE\u000f\u001e9TKR$\u0018N\\4t)\ti\u0006\r\u0005\u0002/=&\u0011ql\f\u0002\r\u0011R$\boU3ui&twm\u001d\u0005\u00065\u001e\u0001\r!X\u0001\u0014a\u0006\u00148/Z(bkRD'gU3ui&twm\u001d\u000b\u0003G\u001a\u0004\"A\f3\n\u0005\u0015|#AD(BkRD'gU3ui&twm\u001d\u0005\u00065\"\u0001\raY\u0001\u000ba\u0006\u00148/\u001a$m_^\u001cHcA5mcB\u0011AJ[\u0005\u0003W6\u0013A!\u00168ji\")Q.\u0003a\u0001]\u0006)QM\u001c;ssB\u00111e\\\u0005\u0003a\u0012\u0012\u0011\"W'ba\u0016sGO]=\t\u000biK\u0001\u0019A2\u0002\u0013A\f'o]3GY><HcA2uk\")!L\u0003a\u0001G\")aO\u0003a\u0001]\u0006Ia\r\\8x\u000b:$(/_\u0001 m\u0016tGm\u001c:Ta\u0016\u001c\u0017NZ5d'\u0016$H/\u001b8hgB\u0013x\u000eZ;dKJ\u001cH#A=\u0011\u0005yQ\u0018BA>\u000e\u0005E\u0019V\r\u001e;j]\u001e\u001c\bK]8ek\u000e,'o\u001d")
public class Oas3SecuritySettingsParser
extends OasLikeSecuritySettingsParser {
    private final YMap map;
    private final OasWebApiContext ctx;

    @Override
    public Option<Settings> parse() {
        return this.produceSettings().map((Function1 & Serializable & scala.Serializable)settings -> {
            Settings settings2;
            Settings settings3 = settings;
            if (settings3 instanceof OAuth1Settings) {
                OAuth1Settings oAuth1Settings = (OAuth1Settings)settings3;
                settings2 = this.parseOauth1Settings(oAuth1Settings);
            } else if (settings3 instanceof OAuth2Settings) {
                OAuth2Settings oAuth2Settings = (OAuth2Settings)settings3;
                settings2 = this.parseOauth2Settings(oAuth2Settings);
            } else if (settings3 instanceof ApiKeySettings) {
                ApiKeySettings apiKeySettings = (ApiKeySettings)settings3;
                settings2 = this.parseApiKeySettings(apiKeySettings);
            } else if (settings3 instanceof OpenIdConnectSettings) {
                OpenIdConnectSettings openIdConnectSettings = (OpenIdConnectSettings)settings3;
                settings2 = this.parseOpenIdConnectSettings(openIdConnectSettings);
            } else if (settings3 instanceof HttpSettings) {
                HttpSettings httpSettings = (HttpSettings)settings3;
                settings2 = this.parseHttpSettings(httpSettings);
            } else {
                settings2 = (Settings)package$.MODULE$.YMapOps($this.map).key(amf.core.utils.package$.MODULE$.AmfStrings("settings").asOasExtension()).map((Function1 & Serializable & scala.Serializable)entry -> this.parseDynamicSettings((YMap)entry.value().as((YRead)YRead.YMapYRead$.MODULE$, (IllegalTypeHandler)$this.ctx), settings3, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).getOrElse((Function0 & Serializable & scala.Serializable)() -> settings3);
            }
            OAuth1Settings parsedSettings = settings2;
            return this.parseAnnotations(parsedSettings);
        });
    }

    public OpenIdConnectSettings parseOpenIdConnectSettings(OpenIdConnectSettings settings) {
        package$.MODULE$.YMapOps(this.map).key("openIdConnectUrl", (Function1)this.FieldOps(OpenIdConnectSettingsModel$.MODULE$.Url(), this.ctx).in(settings));
        package$.MODULE$.YMapOps(this.map).key(amf.core.utils.package$.MODULE$.AmfStrings("settings").asOasExtension(), (Function1 & Serializable & scala.Serializable)entry -> {
            this.parseDynamicSettings((YMap)entry.value().as((YRead)YRead.YMapYRead$.MODULE$, (IllegalTypeHandler)this.ctx), settings, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            return BoxedUnit.UNIT;
        });
        return settings;
    }

    public HttpSettings parseHttpSettings(HttpSettings settings) {
        package$.MODULE$.YMapOps(this.map).key("scheme", (Function1)this.FieldOps(HttpSettingsModel$.MODULE$.Scheme(), this.ctx).in(settings));
        package$.MODULE$.YMapOps(this.map).key("bearerFormat", (Function1)this.FieldOps(HttpSettingsModel$.MODULE$.BearerFormat(), this.ctx).in(settings));
        return settings;
    }

    @Override
    public OAuth2Settings parseOauth2Settings(OAuth2Settings settings) {
        package$.MODULE$.YMapOps(this.map).key("flows", (Function1 & Serializable & scala.Serializable)x$1 -> {
            this.parseFlows(x$1, settings);
            return BoxedUnit.UNIT;
        });
        package$.MODULE$.YMapOps(this.map).key(amf.core.utils.package$.MODULE$.AmfStrings("settings").asOasExtension(), (Function1 & Serializable & scala.Serializable)entry -> {
            this.parseDynamicSettings((YMap)entry.value().as((YRead)YRead.YMapYRead$.MODULE$, (IllegalTypeHandler)this.ctx), settings, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"authorizationGrants"}));
            return BoxedUnit.UNIT;
        });
        new AnnotationParser(settings, this.map, AnnotationParser$.MODULE$.apply$default$3(), this.ctx).parseOrphanNode("flows");
        return settings;
    }

    private void parseFlows(YMapEntry entry, OAuth2Settings settings) {
        ((YMap)entry.value().as((YRead)YRead.YMapYRead$.MODULE$, (IllegalTypeHandler)this.ctx)).entries().foreach((Function1 & Serializable & scala.Serializable)x$2 -> this.parseFlow(settings, (YMapEntry)x$2));
    }

    private OAuth2Settings parseFlow(OAuth2Settings settings, YMapEntry flowEntry) {
        OAuth2Flow flow = OAuth2Flow$.MODULE$.apply((YPart)flowEntry);
        YMap flowMap = (YMap)flowEntry.value().as((YRead)YRead.YMapYRead$.MODULE$, (IllegalTypeHandler)this.ctx);
        AmfScalar flowKey = (AmfScalar)ScalarNode$.MODULE$.apply(flowEntry.key(), (IllegalTypeHandler)this.ctx).string();
        flow.set(OAuth2FlowModel$.MODULE$.Flow(), (AmfElement)flowKey);
        flow.adopted(settings.id(), flow.adopted$default$2());
        package$.MODULE$.YMapOps(flowMap).key("authorizationUrl", (Function1)this.FieldOps(OAuth2FlowModel$.MODULE$.AuthorizationUri(), this.ctx).in(flow));
        package$.MODULE$.YMapOps(flowMap).key("tokenUrl", (Function1)this.FieldOps(OAuth2FlowModel$.MODULE$.AccessTokenUri(), this.ctx).in(flow));
        package$.MODULE$.YMapOps(flowMap).key("refreshUrl", (Function1)this.FieldOps(OAuth2FlowModel$.MODULE$.RefreshUri(), this.ctx).in(flow));
        this.parseScopes(flow, flowMap);
        return (OAuth2Settings)settings.add(OAuth2SettingsModel$.MODULE$.Flows(), (AmfElement)flow);
    }

    @Override
    public SettingsProducers vendorSpecificSettingsProducers() {
        return Oas3SettingsProducers$.MODULE$;
    }

    public Oas3SecuritySettingsParser(YMap map, SecurityScheme scheme, OasWebApiContext ctx) {
        this.map = map;
        this.ctx = ctx;
        super(map, scheme, ctx);
    }
}

